/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.Pattern;
import edu.stanford.nlp.patterns.surface.PatternFactory;
import edu.stanford.nlp.patterns.surface.PatternsAnnotations;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ApplyPatterns<E extends Pattern>
implements Callable<Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>> {
    String label;
    Map<TokenSequencePattern, E> patterns;
    List<String> sentids;
    boolean removeStopWordsFromSelectedPhrases;
    boolean removePhrasesWithStopWords;
    ConstantsAndVariables<E> constVars;
    Map<String, List<CoreLabel>> sents = null;

    public ApplyPatterns(Map<String, List<CoreLabel>> sents, List<String> sentids, Map<TokenSequencePattern, E> patterns, String label, boolean removeStopWordsFromSelectedPhrases, boolean removePhrasesWithStopWords, ConstantsAndVariables cv) {
        this.sents = sents;
        this.patterns = patterns;
        this.sentids = sentids;
        this.label = label;
        this.removeStopWordsFromSelectedPhrases = removeStopWordsFromSelectedPhrases;
        this.removePhrasesWithStopWords = removePhrasesWithStopWords;
        this.constVars = cv;
    }

    @Override
    public Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>> call() throws Exception {
        TwoDimensionalCounter<Pair<String, String>, E> allFreq = new TwoDimensionalCounter<Pair<String, String>, E>();
        CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat = new CollectionValuedMap<E, Triple<String, Integer, Integer>>();
        for (String sentid : this.sentids) {
            List<CoreLabel> sent = this.sents.get(sentid);
            for (Map.Entry<TokenSequencePattern, E> pEn : this.patterns.entrySet()) {
                if (pEn.getKey() == null) {
                    throw new RuntimeException("why is the pattern " + pEn + " null?");
                }
                SequenceMatcher m = pEn.getKey().getMatcher(sent);
                m.setBranchLimit(5);
                while (m.find()) {
                    int i;
                    int s = m.start("$term");
                    int e = m.end("$term");
                    String phrase = "";
                    String phraseLemma = "";
                    boolean useWordNotLabeled = false;
                    boolean doNotUse = false;
                    if (this.constVars.clubNeighboringLabeledWords) {
                        int i2;
                        for (i2 = s - 1; i2 >= 0; --i2) {
                            if (sent.get(i2).get(this.constVars.getAnswerClass().get(this.label)).equals(this.label)) continue;
                            s = i2 + 1;
                            break;
                        }
                        for (i2 = e; i2 < sent.size(); ++i2) {
                            if (sent.get(i2).get(this.constVars.getAnswerClass().get(this.label)).equals(this.label)) continue;
                            e = i2;
                            break;
                        }
                    }
                    boolean[] addedindices = new boolean[e - s];
                    Arrays.fill(addedindices, false);
                    for (i = s; i < e; ++i) {
                        CoreLabel l = sent.get(i);
                        l.set(PatternsAnnotations.MatchedPattern.class, true);
                        if (!l.containsKey(PatternsAnnotations.MatchedPatterns.class) || l.get(PatternsAnnotations.MatchedPatterns.class) == null) {
                            l.set(PatternsAnnotations.MatchedPatterns.class, new HashSet());
                        }
                        SurfacePattern pSur = (SurfacePattern)pEn.getValue();
                        assert (pSur != null) : "Why is " + pEn.getValue() + " not present in the index?!";
                        assert (l.get(PatternsAnnotations.MatchedPatterns.class) != null) : "How come MatchedPatterns class is null for the token. The classes in the key set are " + l.keySet();
                        ((Set)l.get(PatternsAnnotations.MatchedPatterns.class)).add(pSur);
                        for (Map.Entry<Class, Object> ig : this.constVars.getIgnoreWordswithClassesDuringSelection().get(this.label).entrySet()) {
                            if (!l.containsKey(ig.getKey()) || !l.get(ig.getKey()).equals(ig.getValue())) continue;
                            doNotUse = true;
                        }
                        boolean containsStop = this.containsStopWord(l, this.constVars.getCommonEngWords(), PatternFactory.ignoreWordRegex);
                        if (this.removePhrasesWithStopWords && containsStop) {
                            doNotUse = true;
                            continue;
                        }
                        if (containsStop && this.removeStopWordsFromSelectedPhrases) continue;
                        if (this.label == null || l.get(this.constVars.getAnswerClass().get(this.label)) == null || !l.get(this.constVars.getAnswerClass().get(this.label)).equals(this.label.toString())) {
                            useWordNotLabeled = true;
                        }
                        phrase = phrase + " " + l.word();
                        phraseLemma = phraseLemma + " " + l.lemma();
                        addedindices[i - s] = true;
                    }
                    for (i = 0; i < addedindices.length; ++i) {
                        if (i <= 0 || i >= addedindices.length - 1 || !addedindices[i - 1] || addedindices[i] || !addedindices[i + 1]) continue;
                        doNotUse = true;
                        break;
                    }
                    if (doNotUse || !useWordNotLabeled) continue;
                    matchedTokensByPat.add(pEn.getValue(), new Triple<String, Integer, Integer>(sentid, s, e - 1));
                    if (!useWordNotLabeled) continue;
                    phrase = phrase.trim();
                    phraseLemma = phraseLemma.trim();
                    allFreq.incrementCount(new Pair<String, String>(phrase, phraseLemma), pEn.getValue(), 1.0);
                }
            }
        }
        return new Pair<TwoDimensionalCounter<Pair<String, String>, E>, CollectionValuedMap<E, Triple<String, Integer, Integer>>>(allFreq, matchedTokensByPat);
    }

    boolean containsStopWord(CoreLabel l, Set<String> commonEngWords, java.util.regex.Pattern ignoreWordRegex) {
        return commonEngWords.contains(l.lemma()) || commonEngWords.contains(l.word()) || ignoreWordRegex != null && ignoreWordRegex.matcher(l.lemma()).matches();
    }
}

