/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.util.CoreMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

class Util {
    private static Random random;

    private Util() {
    }

    public static List<String> generateDict(List<String> str, int cutOff) {
        IntCounter<String> freq = new IntCounter<String>();
        for (String aStr : str) {
            freq.incrementCount(aStr);
        }
        List<String> keys = Counters.toSortedList(freq, false);
        ArrayList<String> dict = new ArrayList<String>();
        for (String word : keys) {
            if (!(freq.getCount(word) >= (double)cutOff)) continue;
            dict.add(word);
        }
        return dict;
    }

    public static List<String> generateDict(List<String> str) {
        return Util.generateDict(str, 1);
    }

    static Random getRandom() {
        if (random != null) {
            return random;
        }
        return Util.getRandom(System.currentTimeMillis());
    }

    static Random getRandom(long seed) {
        random = new Random(seed);
        System.err.printf("Random generator initialized with seed %d%n", seed);
        return random;
    }

    public static <T> List<T> getRandomSubList(List<T> input, int subsetSize) {
        int inputSize = input.size();
        if (subsetSize > inputSize) {
            subsetSize = inputSize;
        }
        Random random = Util.getRandom();
        for (int i = 0; i < subsetSize; ++i) {
            int indexToSwap = i + random.nextInt(inputSize - i);
            T temp = input.get(i);
            input.set(i, input.get(indexToSwap));
            input.set(indexToSwap, temp);
        }
        return input.subList(0, subsetSize);
    }

    public static void loadConllFile(String inFile, List<CoreMap> sents, List<DependencyTree> trees, boolean labeled) {
        CoreLabelTokenFactory tf = new CoreLabelTokenFactory(false);
        BufferedReader reader = null;
        try {
            reader = IOUtils.readerFromString(inFile);
            CoreLabel sentence = new CoreLabel();
            ArrayList<CoreLabel> sentenceTokens = new ArrayList<CoreLabel>();
            DependencyTree tree = new DependencyTree();
            for (String line : IOUtils.getLineIterable(reader, false)) {
                String[] splits = line.split("\t");
                if (splits.length < 10) {
                    trees.add(tree);
                    sentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
                    sents.add(sentence);
                    tree = new DependencyTree();
                    sentence = new CoreLabel();
                    sentenceTokens = new ArrayList();
                    continue;
                }
                String word = splits[1];
                String pos = splits[4];
                String depType = splits[7];
                int head = Integer.parseInt(splits[6]);
                CoreLabel token = tf.makeToken(word, 0, 0);
                token.setTag(pos);
                token.set(CoreAnnotations.CoNLLDepParentIndexAnnotation.class, head);
                token.set(CoreAnnotations.CoNLLDepTypeAnnotation.class, depType);
                sentenceTokens.add(token);
                if (labeled) {
                    tree.add(head, depType);
                    continue;
                }
                tree.add(head, "-UNKNOWN-");
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(reader);
        }
    }

    public static void loadConllFile(String inFile, List<CoreMap> sents, List<DependencyTree> trees) {
        Util.loadConllFile(inFile, sents, trees, true);
    }

    public static void writeConllFile(String outFile, List<CoreMap> sentences, List<DependencyTree> trees) {
        try {
            PrintWriter output = IOUtils.getPrintWriter(outFile);
            for (CoreMap sentence : sentences) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                int size = tokens.size();
                for (int j = 1; j <= size; ++j) {
                    CoreLabel token = (CoreLabel)tokens.get(j - 1);
                    output.printf("%d\t%s\t_\t%s\t%s\t_\t%d\t%s\t_\t_%n", j, token.word(), token.tag(), token.tag(), token.get(CoreAnnotations.CoNLLDepParentIndexAnnotation.class), token.get(CoreAnnotations.CoNLLDepTypeAnnotation.class));
                }
                output.println();
            }
            output.close();
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void printTreeStats(String str, List<DependencyTree> trees) {
        System.err.println("################### " + str);
        System.err.println("#Trees: " + trees.size());
        int nonTrees = 0;
        int nonProjective = 0;
        for (DependencyTree tree : trees) {
            if (!tree.isTree()) {
                ++nonTrees;
                continue;
            }
            if (tree.isProjective()) continue;
            ++nonProjective;
        }
        System.err.println(nonTrees + " tree(s) are illegal.");
        System.err.println(nonProjective + " tree(s) are legal but not projective.");
    }

    public static void printTreeStats(List<DependencyTree> trees) {
        Util.printTreeStats("", trees);
    }
}

