/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.BasicRelationExtractor;
import edu.stanford.nlp.ie.machinereading.Extractor;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtractorMerger
implements Extractor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ExtractorMerger.class.getName());
    private Extractor[] extractors;

    public ExtractorMerger(Extractor[] extractors) {
        if (extractors.length < 2) {
            throw new IllegalArgumentException("We need at least 2 extractors for ExtractorMerger to make sense.");
        }
        this.extractors = extractors;
    }

    @Override
    public void annotate(Annotation dataset) {
        Object uniqueRelationMentions;
        logger.info("Extractor 0 annotating dataset.");
        this.extractors[0].annotate(dataset);
        ArrayList allRelationMentions = new ArrayList();
        for (CoreMap sentence : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
            List relationMentions = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
            uniqueRelationMentions = new HashSet(relationMentions);
            allRelationMentions.add(uniqueRelationMentions);
        }
        for (int extractorIndex = 1; extractorIndex < this.extractors.length; ++extractorIndex) {
            logger.info("Extractor " + extractorIndex + " annotating dataset.");
            Extractor extractor = this.extractors[extractorIndex];
            extractor.annotate(dataset);
            int sentenceIndex = 0;
            for (CoreMap sentence : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
                List relationMentions = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                ((Set)allRelationMentions.get(sentenceIndex)).addAll(relationMentions);
            }
        }
        int sentenceIndex = 0;
        for (CoreMap sentence : (List)dataset.get(CoreAnnotations.SentencesAnnotation.class)) {
            uniqueRelationMentions = (Set)allRelationMentions.get(sentenceIndex);
            ArrayList relationMentions = new ArrayList(uniqueRelationMentions);
            sentence.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, relationMentions);
            ++sentenceIndex;
        }
    }

    public static Extractor buildRelationExtractorMerger(String[] extractorModelNames) {
        Extractor[] relationExtractorComponents = new BasicRelationExtractor[extractorModelNames.length];
        for (int i = 0; i < extractorModelNames.length; ++i) {
            String modelName = extractorModelNames[i];
            logger.info("Loading model " + i + " for model merging from " + modelName);
            try {
                relationExtractorComponents[i] = BasicRelationExtractor.load(modelName);
                continue;
            }
            catch (IOException e) {
                logger.severe("Error loading model:");
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.severe("Error loading model:");
                e.printStackTrace();
            }
        }
        ExtractorMerger relationExtractor = new ExtractorMerger(relationExtractorComponents);
        return relationExtractor;
    }

    @Override
    public void setLoggerLevel(Level level) {
        logger.setLevel(level);
    }

    @Override
    public void save(String path) throws IOException {
    }

    @Override
    public void train(Annotation dataset) {
    }
}

