/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpressionExtractorImpl;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TimeAnnotator
implements Annotator {
    private final TimeExpressionExtractorImpl timexExtractor;

    public TimeAnnotator() {
        this.timexExtractor = new TimeExpressionExtractorImpl();
    }

    public TimeAnnotator(String name, Properties props) {
        this.timexExtractor = new TimeExpressionExtractorImpl(name, props);
    }

    @Override
    public void annotate(Annotation annotation) {
        List<Object> allTimeExpressions;
        List sentences;
        SUTime.TimeIndex timeIndex = new SUTime.TimeIndex();
        String docDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class);
        if (docDate == null) {
            Calendar cal = (Calendar)annotation.get(CoreAnnotations.CalendarAnnotation.class);
            if (cal == null) {
                Redwood.log(new Object[]{Redwood.WARN, "No document date specified"});
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd:hh:mm:ss");
                docDate = dateFormat.format(cal.getTime());
            }
        }
        if ((sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) != null) {
            allTimeExpressions = new ArrayList();
            ArrayList allNumerics = new ArrayList();
            for (CoreMap sentence : sentences) {
                List numbers;
                CoreMap alignedSentence = NumberSequenceClassifier.alignSentence(sentence);
                List<CoreMap> timeExpressions = this.timexExtractor.extractTimeExpressionCoreMaps(alignedSentence, docDate, timeIndex);
                if (timeExpressions != null) {
                    allTimeExpressions.addAll(timeExpressions);
                    sentence.set(TimeAnnotations.TimexAnnotations.class, timeExpressions);
                    for (CoreMap timeExpression : timeExpressions) {
                        timeExpression.set(CoreAnnotations.SentenceIndexAnnotation.class, sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
                    }
                }
                if ((numbers = (List)alignedSentence.get(CoreAnnotations.NumerizedTokensAnnotation.class)) == null) continue;
                sentence.set(CoreAnnotations.NumerizedTokensAnnotation.class, numbers);
                allNumerics.addAll(numbers);
            }
            annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, allNumerics);
        } else {
            allTimeExpressions = this.annotateSingleSentence(annotation, docDate, timeIndex);
        }
        annotation.set(TimeAnnotations.TimexAnnotations.class, allTimeExpressions);
    }

    public List<CoreMap> annotateSingleSentence(CoreMap sentence, String docDate, SUTime.TimeIndex timeIndex) {
        CoreMap annotationCopy = NumberSequenceClassifier.alignSentence(sentence);
        if (docDate.equals("")) {
            docDate = null;
        }
        return this.timexExtractor.extractTimeExpressionCoreMaps(annotationCopy, docDate, timeIndex);
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.singleton(TOKENIZE_REQUIREMENT);
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(SUTIME_REQUIREMENT);
    }
}

