/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextOutputter {
    private TextOutputter() {
    }

    public static void prettyPrint(Annotation annotation, OutputStream stream, StanfordCoreNLP pipeline) {
        try {
            PrintWriter os = new PrintWriter(IOUtils.encodedOutputStreamWriter(stream, pipeline.getEncoding()));
            TextOutputter.prettyPrint(annotation, os, pipeline);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void prettyPrint(Annotation annotation, PrintWriter os, StanfordCoreNLP pipeline) {
        Map corefChains;
        String docSourceType;
        String docType;
        String docDate;
        String docTitle;
        double beam = pipeline.getBeamPrintingOption();
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int nSentences = sentences != null ? sentences.size() : 0;
            int nTokens = tokens != null ? tokens.size() : 0;
            os.printf("Document: ID=%s (%d sentences, %d tokens)%n", docId, nSentences, nTokens);
        }
        if ((docTitle = (String)annotation.get(CoreAnnotations.DocTitleAnnotation.class)) != null) {
            os.printf("Document Title: %s%n", docTitle);
        }
        if ((docDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class)) != null) {
            os.printf("Document Date: %s%n", docDate);
        }
        if ((docType = (String)annotation.get(CoreAnnotations.DocTypeAnnotation.class)) != null) {
            os.printf("Document Type: %s%n", docType);
        }
        if ((docSourceType = (String)annotation.get(CoreAnnotations.DocSourceTypeAnnotation.class)) != null) {
            os.printf("Document Source Type: %s%n", docSourceType);
        }
        if (sentences != null) {
            int sz = sentences.size();
            for (int i = 0; i < sz; ++i) {
                List relations;
                List entities;
                CoreMap sentence = (CoreMap)sentences.get(i);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                os.printf("Sentence #%d (%d tokens):%n", i + 1, tokens.size());
                String text = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                os.println(text);
                String[] tokenAnnotations = new String[]{"Text", "PartOfSpeech", "Lemma", "Answer", "NamedEntityTag", "CharacterOffsetBegin", "CharacterOffsetEnd", "NormalizedNamedEntityTag", "Timex", "TrueCase", "TrueCaseText"};
                for (CoreLabel token : tokens) {
                    os.print(token.toShorterString(tokenAnnotations));
                    os.print(' ');
                }
                os.println();
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    pipeline.getConstituentTreePrinter().printTree(tree, os);
                    if (sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class) != null) {
                        os.print(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)).toList());
                        os.printf("%n", new Object[0]);
                    }
                }
                if ((entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) != null) {
                    System.err.println("Extracted the following MachineReading entity mentions:");
                    for (EntityMention e : entities) {
                        System.err.println("\t" + e);
                    }
                }
                if ((relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class)) == null) continue;
                System.err.println("Extracted the following MachineReading relation mentions:");
                for (RelationMention r : relations) {
                    if (!r.printableObject(beam)) continue;
                    System.err.println(r);
                }
            }
        }
        if ((corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null && sentences != null) {
            ArrayList<List> sents = new ArrayList<List>();
            for (CoreMap sentence : sentences) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                sents.add(tokens);
            }
            for (CorefChain chain : corefChains.values()) {
                CorefChain.CorefMention representative = chain.getRepresentativeMention();
                boolean outputHeading = false;
                for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                    if (mention == representative) continue;
                    if (!outputHeading) {
                        outputHeading = true;
                        os.println("Coreference set:");
                    }
                    os.println("\t(" + mention.sentNum + "," + mention.headIndex + ",[" + mention.startIndex + "," + mention.endIndex + "]) -> (" + representative.sentNum + "," + representative.headIndex + ",[" + representative.startIndex + "," + representative.endIndex + "]), that is: \"" + mention.mentionSpan + "\" -> \"" + representative.mentionSpan + "\"");
                }
            }
        }
        os.flush();
    }
}

