/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CharniakParserAnnotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.PTBTokenizerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.RelationExtractorAnnotator;
import edu.stanford.nlp.pipeline.SentimentAnnotator;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.WhitespaceTokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class StanfordCoreNLP
extends AnnotationPipeline {
    public static final String CUSTOM_ANNOTATOR_PREFIX = "customAnnotatorClass.";
    private static final String PROPS_SUFFIX = ".properties";
    public static final String NEWLINE_SPLITTER_PROPERTY = "ssplit.eolonly";
    public static final String NEWLINE_IS_SENTENCE_BREAK_PROPERTY = "ssplit.newlineIsSentenceBreak";
    public static final String DEFAULT_NEWLINE_IS_SENTENCE_BREAK = "two";
    public static final String DEFAULT_OUTPUT_FORMAT = StanfordCoreNLP.isXMLOutputPresent() ? "xml" : "text";
    private TreePrint constituentTreePrinter;
    private TreePrint dependencyTreePrinter;
    private int numWords;
    private static AnnotatorPool pool = null;
    private Properties properties;

    public StanfordCoreNLP() {
        this((Properties)null);
    }

    public StanfordCoreNLP(Properties props) {
        this(props, props == null || PropertiesUtils.getBool(props, "enforceRequirements", true));
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements) {
        this.construct(props, enforceRequirements);
    }

    public StanfordCoreNLP(String propsFileNamePrefix) {
        this(propsFileNamePrefix, true);
    }

    public StanfordCoreNLP(String propsFileNamePrefix, boolean enforceRequirements) {
        Properties props = StanfordCoreNLP.loadProperties(propsFileNamePrefix);
        if (props == null) {
            throw new RuntimeIOException("ERROR: cannot find properties file \"" + propsFileNamePrefix + "\" in the classpath!");
        }
        this.construct(props, enforceRequirements);
    }

    private static String getRequiredProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            System.err.println("Missing property \"" + name + "\"!");
            StanfordCoreNLP.printRequiredProperties(System.err);
            throw new RuntimeException("Missing property: \"" + name + '\"');
        }
        return val;
    }

    private static Properties loadPropertiesFromClasspath() {
        List<String> validNames = Arrays.asList("StanfordCoreNLP", "edu.stanford.nlp.pipeline.StanfordCoreNLP");
        for (String name : validNames) {
            Properties props = StanfordCoreNLP.loadProperties(name);
            if (props == null) continue;
            return props;
        }
        throw new RuntimeException("ERROR: Could not find properties file in the classpath!");
    }

    private static Properties loadProperties(String name) {
        return StanfordCoreNLP.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name, ClassLoader loader) {
        if (name.endsWith(PROPS_SUFFIX)) {
            name = name.substring(0, name.length() - PROPS_SUFFIX.length());
        }
        name = name.replace('.', '/');
        name = name + PROPS_SUFFIX;
        Properties result = null;
        System.err.println("Searching for resource: " + name);
        InputStream in = loader.getResourceAsStream(name);
        try {
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in, "utf-8");
                result = new Properties();
                result.load(reader);
            }
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            IOUtils.closeIgnoringExceptions(in);
        }
        return result;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TreePrint getConstituentTreePrinter() {
        return this.constituentTreePrinter;
    }

    public TreePrint getDependencyTreePrinter() {
        return this.dependencyTreePrinter;
    }

    public double getBeamPrintingOption() {
        return PropertiesUtils.getDouble(this.properties, "printable.relation.beam", 0.0);
    }

    public String getEncoding() {
        return this.properties.getProperty("encoding", "UTF-8");
    }

    public boolean getPrintSingletons() {
        return PropertiesUtils.getBool(this.properties, "output.printSingletonEntities", false);
    }

    public static boolean isXMLOutputPresent() {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
        return true;
    }

    private void construct(Properties props, boolean enforceRequirements) {
        this.numWords = 0;
        this.constituentTreePrinter = new TreePrint("penn");
        this.dependencyTreePrinter = new TreePrint("typedDependenciesCollapsed");
        if (props == null) {
            props = StanfordCoreNLP.loadPropertiesFromClasspath();
        } else if (props.getProperty("annotators") == null) {
            Properties fromClassPath = StanfordCoreNLP.loadPropertiesFromClasspath();
            fromClassPath.putAll((Map<?, ?>)props);
            props = fromClassPath;
        }
        this.properties = props;
        AnnotatorPool pool = StanfordCoreNLP.getDefaultAnnotatorPool(props);
        List<String> annoNames = Arrays.asList(StanfordCoreNLP.getRequiredProperty(props, "annotators").split("[, \t]+"));
        Set<String> alreadyAddedAnnoNames = Generics.newHashSet();
        Set<Annotator.Requirement> requirementsSatisfied = Generics.newHashSet();
        for (String name : annoNames) {
            if ((name = name.trim()).isEmpty()) continue;
            System.err.println("Adding annotator " + name);
            Annotator an = pool.get(name);
            this.addAnnotator(an);
            if (enforceRequirements) {
                Set<Annotator.Requirement> allRequirements = an.requires();
                for (Annotator.Requirement requirement : allRequirements) {
                    if (requirementsSatisfied.contains(requirement)) continue;
                    String fmt = "annotator \"%s\" requires annotator \"%s\"";
                    throw new IllegalArgumentException(String.format(fmt, name, requirement));
                }
                requirementsSatisfied.addAll(an.requirementsSatisfied());
            }
            alreadyAddedAnnoNames.add(name);
        }
        if (!alreadyAddedAnnoNames.contains("ssplit")) {
            System.setProperty(NEWLINE_SPLITTER_PROPERTY, "false");
        }
    }

    public static synchronized void clearAnnotatorPool() {
        pool = null;
    }

    private static synchronized AnnotatorPool getDefaultAnnotatorPool(final Properties inputProps) {
        if (pool == null) {
            pool = new AnnotatorPool();
        }
        pool.register("tokenize", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    return new WhitespaceTokenizerAnnotator(this.properties);
                }
                String options = this.properties.getProperty("tokenize.options", "invertible,ptb3Escaping=true");
                boolean keepNewline = Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                if (this.properties.getProperty(StanfordCoreNLP.NEWLINE_IS_SENTENCE_BREAK_PROPERTY) != null) {
                    keepNewline = true;
                }
                if (keepNewline) {
                    options = "tokenizeNLs," + options;
                }
                return new PTBTokenizerAnnotator(false, options);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("tokenize.whitespace:" + this.properties.getProperty("tokenize.whitespace", "false"));
                if (this.properties.getProperty("tokenize.options") != null) {
                    os.append(":tokenize.options:" + this.properties.getProperty("tokenize.options"));
                }
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    os.append("tokenize.keepeol:" + this.properties.getProperty("tokenize.keepeol", "false"));
                    os.append("ssplit.eolonly:" + this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                    return os.toString();
                }
                os.append("ssplit.eolonly:" + Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false")));
                os.append("ssplit.newlineIsSentenceBreak:" + this.properties.getProperty(StanfordCoreNLP.NEWLINE_IS_SENTENCE_BREAK_PROPERTY, StanfordCoreNLP.DEFAULT_NEWLINE_IS_SENTENCE_BREAK));
                return os.toString();
            }
        });
        pool.register("cleanxml", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String xmlTags = this.properties.getProperty("clean.xmltags", ".*");
                String sentenceEndingTags = this.properties.getProperty("clean.sentenceendingtags", "");
                String singleSentenceTags = this.properties.getProperty("clean.singlesentencetags", CleanXmlAnnotator.DEFAULT_SINGLE_SENTENCE_TAGS);
                String allowFlawedString = this.properties.getProperty("clean.allowflawedxml");
                boolean allowFlawed = true;
                if (allowFlawedString != null) {
                    allowFlawed = Boolean.valueOf(allowFlawedString);
                }
                String dateTags = this.properties.getProperty("clean.datetags", "datetime|date");
                String docIdTags = this.properties.getProperty("clean.docIdtags", "docid");
                String docTypeTags = this.properties.getProperty("clean.docTypetags", "doctype");
                String utteranceTurnTags = this.properties.getProperty("clean.turntags", "turn");
                String speakerTags = this.properties.getProperty("clean.speakertags", "speaker");
                String docAnnotations = this.properties.getProperty("clean.docAnnotations", "docID=doc[id],doctype=doc[type],docsourcetype=doctype[source]");
                String tokenAnnotations = this.properties.getProperty("clean.tokenAnnotations", CleanXmlAnnotator.DEFAULT_TOKEN_ANNOTATIONS_PATTERNS);
                String sectionTags = this.properties.getProperty("clean.sectiontags", CleanXmlAnnotator.DEFAULT_SECTION_TAGS);
                String sectionAnnotations = this.properties.getProperty("clean.sectionAnnotations", CleanXmlAnnotator.DEFAULT_SECTION_ANNOTATIONS_PATTERNS);
                String ssplitDiscardTokens = this.properties.getProperty("clean.ssplitDiscardTokens");
                CleanXmlAnnotator annotator = new CleanXmlAnnotator(xmlTags, sentenceEndingTags, dateTags, allowFlawed);
                annotator.setSingleSentenceTagMatcher(singleSentenceTags);
                annotator.setDocIdTagMatcher(docIdTags);
                annotator.setDocTypeTagMatcher(docTypeTags);
                annotator.setDiscourseTags(utteranceTurnTags, speakerTags);
                annotator.setDocAnnotationPatterns(docAnnotations);
                annotator.setTokenAnnotationPatterns(tokenAnnotations);
                annotator.setSectionTagMatcher(sectionTags);
                annotator.setSectionAnnotationPatterns(sectionAnnotations);
                annotator.setSsplitDiscardTokensMatcher(ssplitDiscardTokens);
                return annotator;
            }

            @Override
            public String signature() {
                return "clean.xmltags:" + this.properties.getProperty("clean.xmltags", ".*") + "clean.sentenceendingtags:" + this.properties.getProperty("clean.sentenceendingtags", "") + "clean.sentenceendingtags:" + this.properties.getProperty("clean.singlesentencetags", CleanXmlAnnotator.DEFAULT_SINGLE_SENTENCE_TAGS) + "clean.allowflawedxml:" + this.properties.getProperty("clean.allowflawedxml", "") + "clean.datetags:" + this.properties.getProperty("clean.datetags", "datetime|date") + "clean.docidtags:" + this.properties.getProperty("clean.docid", "docid") + "clean.doctypetags:" + this.properties.getProperty("clean.doctype", "doctype") + "clean.turntags:" + this.properties.getProperty("clean.turntags", "turn") + "clean.speakertags:" + this.properties.getProperty("clean.speakertags", "speaker") + "clean.docAnnotations:" + this.properties.getProperty("clean.docAnnotations", "docID=doc[id],doctype=doc[type],docsourcetype=doctype[source]") + "clean.tokenAnnotations:" + this.properties.getProperty("clean.tokenAnnotations", CleanXmlAnnotator.DEFAULT_TOKEN_ANNOTATIONS_PATTERNS) + "clean.sectiontags:" + this.properties.getProperty("clean.sectiontags", CleanXmlAnnotator.DEFAULT_SECTION_TAGS) + "clean.sectionAnnotations:" + this.properties.getProperty("clean.sectionAnnotations", CleanXmlAnnotator.DEFAULT_SECTION_ANNOTATIONS_PATTERNS);
            }
        });
        pool.register("ssplit", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                System.err.println(this.signature());
                boolean nlSplitting = Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                if (nlSplitting) {
                    boolean whitespaceTokenization = Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false"));
                    if (whitespaceTokenization) {
                        if (System.getProperty("line.separator").equals("\n")) {
                            return WordsToSentencesAnnotator.newlineSplitter(false, "\n");
                        }
                        return WordsToSentencesAnnotator.newlineSplitter(false, System.getProperty("line.separator"), "\n");
                    }
                    return WordsToSentencesAnnotator.newlineSplitter(false, PTBTokenizer.getNewlineToken());
                }
                String isOneSentence = this.properties.getProperty("ssplit.isOneSentence");
                if (Boolean.parseBoolean(isOneSentence)) {
                    return WordsToSentencesAnnotator.nonSplitter(false);
                }
                String boundaryMultiTokenRegex = this.properties.getProperty("ssplit.boundaryMultiTokenRegex");
                String tokenPatternsToDiscardProp = this.properties.getProperty("ssplit.tokenPatternsToDiscard");
                Set<String> tokenRegexesToDiscard = null;
                if (tokenPatternsToDiscardProp != null) {
                    String[] toks = tokenPatternsToDiscardProp.split(",");
                    tokenRegexesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                String boundaryTokenRegex = this.properties.getProperty("ssplit.boundaryTokenRegex");
                Set<String> boundariesToDiscard = null;
                String bounds = this.properties.getProperty("ssplit.boundariesToDiscard");
                if (bounds != null) {
                    String[] toks = bounds.split(",");
                    boundariesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                Set<String> htmlElementsToDiscard = null;
                bounds = this.properties.getProperty("ssplit.htmlBoundariesToDiscard");
                if (bounds != null) {
                    String[] elements = bounds.split(",");
                    htmlElementsToDiscard = Generics.newHashSet(Arrays.asList(elements));
                }
                String nlsb = this.properties.getProperty(StanfordCoreNLP.NEWLINE_IS_SENTENCE_BREAK_PROPERTY, StanfordCoreNLP.DEFAULT_NEWLINE_IS_SENTENCE_BREAK);
                return new WordsToSentencesAnnotator(false, boundaryTokenRegex, boundariesToDiscard, htmlElementsToDiscard, nlsb, boundaryMultiTokenRegex, tokenRegexesToDiscard);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                if (Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false")).booleanValue()) {
                    os.append("ssplit.eolonly=" + this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false") + "\n");
                    os.append("tokenize.whitespace=" + this.properties.getProperty("tokenize.whitespace", "false") + "\n");
                } else {
                    os.append(3.baseSignature(this.properties, "ssplit"));
                }
                return os.toString();
            }
        });
        pool.register("pos", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    return new POSTaggerAnnotator("pos", this.properties);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String signature() {
                return POSTaggerAnnotator.signature(this.properties);
            }
        });
        pool.register("lemma", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new MorphaAnnotator(false);
            }

            @Override
            public String signature() {
                return "";
            }
        });
        pool.register("ner", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                NERClassifierCombiner nerCombiner;
                ArrayList<String> models = new ArrayList<String>();
                String modelNames = this.properties.getProperty("ner.model");
                if (modelNames == null) {
                    modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
                }
                if (modelNames.length() > 0) {
                    models.addAll(Arrays.asList(modelNames.split(",")));
                }
                if (models.isEmpty()) {
                    System.err.println("WARNING: no NER models specified");
                }
                try {
                    boolean applyNumericClassifiers = PropertiesUtils.getBool(this.properties, "ner.applyNumericClassifiers", true);
                    boolean useSUTime = PropertiesUtils.getBool(this.properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
                    nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, useSUTime, this.properties, models.toArray(new String[models.size()]));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeIOException(e);
                }
                return new NERCombinerAnnotator(nerCombiner, false);
            }

            @Override
            public String signature() {
                return "ner.model:" + this.properties.getProperty("ner.model", "") + "ner.model.3class:" + this.properties.getProperty("ner.model.3class", "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz") + "ner.model.7class:" + this.properties.getProperty("ner.model.7class", "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz") + "ner.model.MISCclass:" + this.properties.getProperty("ner.model.MISCclass", "edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz") + "ner.applyNumericClassifiers" + ":" + this.properties.getProperty("ner.applyNumericClassifiers", Boolean.toString(true)) + "ner.useSUTime" + ":" + this.properties.getProperty("ner.useSUTime", Boolean.toString(NumberSequenceClassifier.USE_SUTIME_DEFAULT));
            }
        });
        pool.register("regexner", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new TokensRegexNERAnnotator("regexner", this.properties);
            }

            @Override
            public String signature() {
                return PropertiesUtils.getSignature("regexner", this.properties, TokensRegexNERAnnotator.SUPPORTED_PROPERTIES);
            }
        });
        pool.register("gender", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new GenderAnnotator(false, this.properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small"));
            }

            @Override
            public String signature() {
                return "gender.firstnames:" + this.properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small");
            }
        });
        pool.register("truecase", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String model = this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz");
                String bias = this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0");
                String mixed = this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
                return new TrueCaseAnnotator(model, bias, mixed, false);
            }

            @Override
            public String signature() {
                return "truecase.model:" + this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz") + "truecase.bias:" + this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0") + "truecase.mixedcasefile:" + this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
            }
        });
        pool.register("parse", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String parserType = this.properties.getProperty("parse.type", "stanford");
                String maxLenStr = this.properties.getProperty("parse.maxlen");
                if (parserType.equalsIgnoreCase("stanford")) {
                    ParserAnnotator anno = new ParserAnnotator("parse", this.properties);
                    return anno;
                }
                if (parserType.equalsIgnoreCase("charniak")) {
                    String model = this.properties.getProperty("parse.model");
                    String parserExecutable = this.properties.getProperty("parse.executable");
                    if (model == null || parserExecutable == null) {
                        throw new RuntimeException("Both parse.model and parse.executable properties must be specified if parse.type=charniak");
                    }
                    int maxLen = 399;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    CharniakParserAnnotator anno = new CharniakParserAnnotator(model, parserExecutable, false, maxLen);
                    return anno;
                }
                throw new RuntimeException("Unknown parser type: " + parserType + " (currently supported: stanford and charniak)");
            }

            @Override
            public String signature() {
                String type = this.properties.getProperty("parse.type", "stanford");
                if (type.equalsIgnoreCase("stanford")) {
                    return ParserAnnotator.signature("parse", this.properties);
                }
                if (type.equalsIgnoreCase("charniak")) {
                    return "parse.model:" + this.properties.getProperty("parse.model", "") + "parse.executable:" + this.properties.getProperty("parse.executable", "") + "parse.maxlen:" + this.properties.getProperty("parse.maxlen", "");
                }
                throw new RuntimeException("Unknown parser type: " + type + " (currently supported: stanford and charniak)");
            }
        });
        pool.register("dcoref", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new DeterministicCorefAnnotator(this.properties);
            }

            @Override
            public String signature() {
                return DeterministicCorefAnnotator.signature(this.properties);
            }
        });
        for (String property : inputProps.stringPropertyNames()) {
            if (!property.startsWith(CUSTOM_ANNOTATOR_PREFIX)) continue;
            final String customName = property.substring(CUSTOM_ANNOTATOR_PREFIX.length());
            final String customClassName = inputProps.getProperty(property);
            System.err.println("Registering annotator " + customName + " with class " + customClassName);
            pool.register(customName, new AnnotatorFactory(inputProps){
                private static final long serialVersionUID = 1L;
                private final String name;
                private final String className;
                {
                    super(x0);
                    this.name = customName;
                    this.className = customClassName;
                }

                @Override
                public Annotator create() {
                    return (Annotator)ReflectionLoading.loadByReflection(this.className, this.name, this.properties);
                }

                @Override
                public String signature() {
                    StringBuilder os = new StringBuilder();
                    for (Object key : this.properties.keySet()) {
                        String skey = (String)key;
                        os.append(skey + ":" + this.properties.getProperty(skey));
                    }
                    return os.toString();
                }
            });
        }
        pool.register("relation", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new RelationExtractorAnnotator(this.properties);
            }

            @Override
            public String signature() {
                return "sup.relation.verbose:" + this.properties.getProperty("sup.relation.verbose", "false") + this.properties.getProperty("sup.relation.model", "edu/stanford/nlp/models/supervised_relation_extractor/roth_relation_model.ser");
            }
        });
        pool.register("sentiment", new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new SentimentAnnotator("sentiment", this.properties);
            }

            @Override
            public String signature() {
                return "sentiment.model=" + inputProps.get("sentiment.model");
            }
        });
        return pool;
    }

    public static synchronized Annotator getExistingAnnotator(String name) {
        if (pool == null) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" before the annotator pool was created!");
            return null;
        }
        try {
            Annotator a = pool.get(name);
            return a;
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" but the annotator pool does not store any such type!");
            return null;
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        super.annotate(annotation);
        List words = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (words != null) {
            this.numWords += words.size();
        }
    }

    public static boolean usesBinaryTrees(Properties props) {
        String annotators = props.getProperty("annotators");
        Set<String> annoNames = Generics.newHashSet(Arrays.asList(StanfordCoreNLP.getRequiredProperty(props, "annotators").split("[, \t]+")));
        return annoNames.contains("sentiment");
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    public void prettyPrint(Annotation annotation, OutputStream os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void prettyPrint(Annotation annotation, PrintWriter os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void xmlPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.xmlPrint(annotation, os);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void xmlPrint(Annotation annotation, OutputStream os) throws IOException {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
            Method method = clazz.getMethod("xmlPrint", Annotation.class, OutputStream.class, StanfordCoreNLP.class);
            method.invoke(null, annotation, os, this);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printHelp(PrintStream os, String helpTopic) {
        if (helpTopic.toLowerCase().startsWith("pars")) {
            os.println("StanfordCoreNLP currently supports the following parsers:");
            os.println("\tstanford - Stanford lexicalized parser (default)");
            os.println("\tcharniak - Charniak and Johnson reranking parser (sold separately)");
            os.println();
            os.println("General options: (all parsers)");
            os.println("\tparse.type - selects the parser to use");
            os.println("\tparse.model - path to model file for parser");
            os.println("\tparse.maxlen - maximum sentence length");
            os.println();
            os.println("Stanford Parser-specific options:");
            os.println("(In general, you shouldn't need to set this flags)");
            os.println("\tparse.flags - extra flags to the parser (default: -retainTmpSubcategories)");
            os.println("\tparse.debug - set to true to make the parser slightly more verbose");
            os.println();
            os.println("Charniak and Johnson parser-specific options:");
            os.println("\tparse.executable - path to the parseIt binary or parse.sh script");
        } else if (!helpTopic.equalsIgnoreCase("true")) {
            os.println("Unknown help topic: " + helpTopic);
            os.println("See -help for a list of all help topics.");
        } else {
            StanfordCoreNLP.printRequiredProperties(os);
        }
    }

    private static void printRequiredProperties(PrintStream os) {
        os.println("The following properties can be defined:");
        os.println("(if -props or -annotators is not passed in, default properties will be loaded via the classpath)");
        os.println("\t\"props\" - path to file with configuration properties");
        os.println("\t\"annotators\" - comma separated list of annotators");
        os.println("\tThe following annotators are supported: cleanxml, tokenize, ssplit, pos, lemma, ner, truecase, parse, coref, dcoref, relation");
        os.println();
        os.println("\tIf annotator \"tokenize\" is defined:");
        os.println("\t\"tokenize.options\" - PTBTokenizer options (see edu.stanford.nlp.process.PTBTokenizer for details)");
        os.println("\t\"tokenize.whitespace\" - If true, just use whitespace tokenization");
        os.println();
        os.println("\tIf annotator \"cleanxml\" is defined:");
        os.println("\t\"clean.xmltags\" - regex of tags to extract text from");
        os.println("\t\"clean.sentenceendingtags\" - regex of tags which mark sentence endings");
        os.println("\t\"clean.allowflawedxml\" - if set to true, don't complain about XML errors");
        os.println();
        os.println("\tIf annotator \"pos\" is defined:");
        os.println("\t\"pos.maxlen\" - maximum length of sentence to POS tag");
        os.println("\t\"pos.model\" - path towards the POS tagger model");
        os.println();
        os.println("\tIf annotator \"ner\" is defined:");
        os.println("\t\"ner.model.3class\" - path towards the three-class NER model");
        os.println("\t\"ner.model.7class\" - path towards the seven-class NER model");
        os.println("\t\"ner.model.MISCclass\" - path towards the NER model with a MISC class");
        os.println();
        os.println("\tIf annotator \"truecase\" is defined:");
        os.println("\t\"truecase.model\" - path towards the true-casing model; default: edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz");
        os.println("\t\"truecase.bias\" - class bias of the true case model; default: INIT_UPPER:-0.7,UPPER:-0.7,O:0");
        os.println("\t\"truecase.mixedcasefile\" - path towards the mixed case file; default: edu/stanford/nlp/models/truecase/MixDisambiguation.list");
        os.println();
        os.println("\tIf annotator \"relation\" is defined:");
        os.println("\t\"sup.relation.verbose\" - whether verbose or not");
        os.println("\t\"sup.relation.model\" - path towards the relation extraction model");
        os.println();
        os.println("\tIf annotator \"parse\" is defined:");
        os.println("\t\"parse.model\" - path towards the PCFG parser model");
        os.println();
        os.println("Command line properties:");
        os.println("\t\"file\" - run the pipeline on the content of this file, or on the content of the files in this directory");
        os.println("\t         XML output is generated for every input file \"file\" as file.xml");
        os.println("\t\"extension\" - if -file used with a directory, process only the files with this extension");
        os.println("\t\"filelist\" - run the pipeline on the list of files given in this file");
        os.println("\t             output is generated for every input file as file.outputExtension");
        os.println("\t\"outputDirectory\" - where to put output (defaults to the current directory)");
        os.println("\t\"outputExtension\" - extension to use for the output file (defaults to \".xml\" for XML, \".ser.gz\" for serialized).  Don't forget the dot!");
        os.println("\t\"outputFormat\" - \"xml\" to output XML (default), \"serialized\" to output serialized Java objects, \"text\" to output text");
        os.println("\t\"serializer\" - Class of annotation serializer to use when outputFormat is \"serialized\".  By default, uses Java serialization.");
        os.println("\t\"replaceExtension\" - flag to chop off the last extension before adding outputExtension to file");
        os.println("\t\"noClobber\" - don't automatically override (clobber) output files that already exist");
        os.println("\t\"threads\" - multithread on this number of threads");
        os.println();
        os.println("If none of the above are present, run the pipeline in an interactive shell (default properties will be loaded from the classpath).");
        os.println("The shell accepts input from stdin and displays the output at stdout.");
        os.println();
        os.println("Run with -help [topic] for more help on a specific topic.");
        os.println("Current topics include: parser");
        os.println();
    }

    @Override
    public String timingInformation() {
        StringBuilder sb = new StringBuilder(super.timingInformation());
        if (this.numWords >= 0) {
            long total = this.getTotalTime();
            sb.append(" for ").append(this.numWords).append(" tokens at ");
            sb.append(String.format("%.1f", (double)this.numWords / ((double)total / 1000.0)));
            sb.append(" tokens/sec.");
        }
        return sb.toString();
    }

    private static void shell(StanfordCoreNLP pipeline) throws IOException {
        block5: {
            String encoding = pipeline.getEncoding();
            BufferedReader r = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, encoding));
            System.err.println("Entering interactive shell. Type q RETURN or EOF to quit.");
            OutputFormat outputFormat = OutputFormat.valueOf(pipeline.properties.getProperty("outputFormat", "text").toUpperCase());
            block4: while (true) {
                System.err.print("NLP> ");
                String line = r.readLine();
                if (line == null || line.equalsIgnoreCase("q")) break block5;
                if (line.length() <= 0) continue;
                Annotation anno = pipeline.process(line);
                switch (outputFormat) {
                    case XML: {
                        pipeline.xmlPrint(anno, System.out);
                        continue block4;
                    }
                    case TEXT: {
                        pipeline.prettyPrint(anno, System.out);
                        continue block4;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Cannot output in format " + (Object)((Object)outputFormat) + " from the interactive shell");
        }
    }

    private static Collection<File> readFileList(String fileName) throws IOException {
        return ObjectBank.getLineIterator(fileName, new ObjectBank.PathToFileFunction());
    }

    private AnnotationSerializer loadSerializer(String serializerClass, String name, Properties properties) {
        AnnotationSerializer serializer = null;
        try {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, name, properties);
        }
        catch (ReflectionLoading.ReflectionLoadingException ex) {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, new Object[0]);
        }
        return serializer;
    }

    public void processFiles(String base, Collection<File> files, int numThreads) throws IOException {
        String defaultExtension;
        LinkedList<Runnable> toRun = new LinkedList<Runnable>();
        String baseOutputDir = this.properties.getProperty("outputDirectory", ".");
        String baseInputDir = this.properties.getProperty("inputDirectory", base);
        String excludeFilesParam = this.properties.getProperty("excludeFiles");
        HashSet<String> excludeFiles = new HashSet<String>();
        if (excludeFilesParam != null) {
            Iterable<String> lines = IOUtils.readLines(excludeFilesParam);
            for (String line : lines) {
                String name = line.trim();
                if (name.isEmpty()) continue;
                excludeFiles.add(name);
            }
        }
        final OutputFormat outputFormat = OutputFormat.valueOf(this.properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT).toUpperCase());
        switch (outputFormat) {
            case XML: {
                defaultExtension = ".xml";
                break;
            }
            case TEXT: {
                defaultExtension = ".out";
                break;
            }
            case SERIALIZED: {
                defaultExtension = ".ser.gz";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
            }
        }
        String serializerClass = this.properties.getProperty("serializer");
        final String inputSerializerClass = this.properties.getProperty("inputSerializer", serializerClass);
        final String inputSerializerName = serializerClass == inputSerializerClass ? "serializer" : "inputSerializer";
        final String outputSerializerClass = this.properties.getProperty("outputSerializer", serializerClass);
        final String outputSerializerName = serializerClass == outputSerializerClass ? "serializer" : "outputSerializer";
        String extension = this.properties.getProperty("outputExtension", defaultExtension);
        boolean replaceExtension = Boolean.parseBoolean(this.properties.getProperty("replaceExtension", "false"));
        final boolean continueOnAnnotateError = Boolean.parseBoolean(this.properties.getProperty("continueOnAnnotateError", "false"));
        final boolean noClobber = Boolean.parseBoolean(this.properties.getProperty("noClobber", "false"));
        boolean randomize = Boolean.parseBoolean(this.properties.getProperty("randomize", "false"));
        final MutableInteger totalProcessed = new MutableInteger(0);
        final MutableInteger totalSkipped = new MutableInteger(0);
        final MutableInteger totalErrorAnnotating = new MutableInteger(0);
        int nFiles = 0;
        for (final File file : files) {
            int lastDot;
            ++nFiles;
            if (excludeFiles.contains(file.getName())) {
                Redwood.Util.err("Skipping excluded file " + file.getName());
                totalSkipped.incValue(1);
                continue;
            }
            String outputDir = baseOutputDir;
            if (baseInputDir != null) {
                String relDir = file.getParent().replaceFirst(Pattern.quote(baseInputDir), "");
                outputDir = outputDir + File.separator + relDir;
            }
            new File(outputDir).mkdirs();
            String outputFilename = new File(outputDir, file.getName()).getPath();
            if (replaceExtension && (lastDot = outputFilename.lastIndexOf(46)) > 0) {
                outputFilename = outputFilename.substring(0, lastDot);
            }
            if (!outputFilename.endsWith(extension)) {
                outputFilename = outputFilename + extension;
            }
            if ((outputFilename = new File(outputFilename).getCanonicalPath()).equals(file.getCanonicalPath())) {
                Redwood.Util.err("Skipping " + file.getName() + ": output file " + outputFilename + " has the same filename as the input file -- assuming you don't actually want to do this.");
                totalSkipped.incValue(1);
                continue;
            }
            if (noClobber && new File(outputFilename).exists()) {
                Redwood.Util.err("Skipping " + file.getName() + ": output file " + outputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                totalSkipped.incValue(1);
                continue;
            }
            final String finalOutputFilename = outputFilename;
            toRun.add(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        boolean annotationOkay;
                        Annotation annotation;
                        block34: {
                            Comparable pair;
                            if (noClobber && new File(finalOutputFilename).exists()) {
                                Redwood.Util.err("Skipping " + file.getName() + ": output file " + finalOutputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                                MutableInteger mutableInteger = totalSkipped;
                                synchronized (mutableInteger) {
                                    totalSkipped.incValue(1);
                                }
                                return;
                            }
                            Redwood.Util.forceTrack("Processing file " + file.getAbsolutePath() + " ... writing to " + finalOutputFilename);
                            annotation = null;
                            if (file.getAbsolutePath().endsWith(".ser.gz")) {
                                try {
                                    if (inputSerializerClass != null) {
                                        AnnotationSerializer inputSerializer = StanfordCoreNLP.this.loadSerializer(inputSerializerClass, inputSerializerName, StanfordCoreNLP.this.properties);
                                        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                                        pair = inputSerializer.read(is);
                                        ((InputStream)pair.second).close();
                                        annotation = (Annotation)pair.first;
                                        IOUtils.closeIgnoringExceptions(is);
                                    } else {
                                        annotation = (Annotation)IOUtils.readObjectFromFile(file);
                                    }
                                }
                                catch (IOException e) {
                                }
                                catch (ClassNotFoundException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (annotation == null) {
                                String encoding = StanfordCoreNLP.this.getEncoding();
                                String text = IOUtils.slurpFile(file, encoding);
                                annotation = new Annotation(text);
                            }
                            annotationOkay = false;
                            Redwood.Util.forceTrack("Annotating file " + file.getAbsoluteFile());
                            try {
                                StanfordCoreNLP.this.annotate(annotation);
                                annotationOkay = true;
                            }
                            catch (Exception ex) {
                                if (continueOnAnnotateError) {
                                    Redwood.Util.err("Error annotating " + file.getAbsoluteFile(), ex);
                                    annotationOkay = false;
                                    pair = totalErrorAnnotating;
                                    synchronized (pair) {
                                        totalErrorAnnotating.incValue(1);
                                        break block34;
                                    }
                                }
                                throw new RuntimeException("Error annotating " + file.getAbsoluteFile(), ex);
                            }
                            finally {
                                Redwood.Util.endTrack("Annotating file " + file.getAbsoluteFile());
                            }
                        }
                        if (annotationOkay) {
                            switch (outputFormat) {
                                case XML: {
                                    BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(finalOutputFilename));
                                    StanfordCoreNLP.this.xmlPrint(annotation, fos);
                                    ((OutputStream)fos).close();
                                    break;
                                }
                                case TEXT: {
                                    BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(finalOutputFilename));
                                    StanfordCoreNLP.this.prettyPrint(annotation, fos);
                                    ((OutputStream)fos).close();
                                    break;
                                }
                                case SERIALIZED: {
                                    if (outputSerializerClass != null) {
                                        AnnotationSerializer outputSerializer = StanfordCoreNLP.this.loadSerializer(outputSerializerClass, outputSerializerName, StanfordCoreNLP.this.properties);
                                        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(finalOutputFilename));
                                        outputSerializer.write(annotation, fos).close();
                                        break;
                                    }
                                    IOUtils.writeObjectToFile((Object)annotation, finalOutputFilename);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
                                }
                            }
                            MutableInteger mutableInteger = totalProcessed;
                            synchronized (mutableInteger) {
                                totalProcessed.incValue(1);
                                if (totalProcessed.intValue() % 1000 == 0) {
                                    Redwood.Util.log("Processed " + totalProcessed + " documents");
                                }
                            }
                        } else {
                            Redwood.Util.warn("Error annotating " + file.getAbsoluteFile() + " not saved to " + finalOutputFilename);
                        }
                        Redwood.Util.endTrack("Processing file " + file.getAbsolutePath() + " ... writing to " + finalOutputFilename);
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
            });
        }
        if (randomize) {
            Redwood.Util.log("Randomly shuffling input");
            Collections.shuffle(toRun);
        }
        Redwood.Util.log("Ready to process: " + toRun.size() + " files, skipped " + totalSkipped + ", total " + nFiles);
        if (numThreads == 1) {
            for (Runnable r : toRun) {
                r.run();
            }
        } else {
            Redwood.Util.threadAndRun("StanfordCoreNLP <" + numThreads + " threads>", toRun, numThreads);
        }
        Redwood.Util.log("Processed " + totalProcessed + " documents");
        Redwood.Util.log("Skipped " + totalSkipped + " documents, error annotating " + totalErrorAnnotating + " documents");
    }

    public void processFiles(Collection<File> files, int numThreads) throws IOException {
        this.processFiles(null, files, numThreads);
    }

    public void processFiles(Collection<File> files) throws IOException {
        this.processFiles(files, 1);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Timing tim = new Timing();
        StanfordRedwoodConfiguration.minimalSetup();
        Properties props = null;
        if (args.length > 0) {
            props = StringUtils.argsToProperties(args);
            boolean hasH = props.containsKey("h");
            boolean hasHelp = props.containsKey("help");
            if (hasH || hasHelp) {
                String helpValue = hasH ? props.getProperty("h") : props.getProperty("help");
                StanfordCoreNLP.printHelp(System.err, helpValue);
                return;
            }
        }
        String numThreadsString = props == null ? null : props.getProperty("threads");
        int numThreads = 1;
        try {
            if (numThreadsString != null) {
                numThreads = Integer.parseInt(numThreadsString);
            }
        }
        catch (NumberFormatException e) {
            Redwood.Util.err("-threads [number]: was not given a valid number: " + numThreadsString);
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        props = pipeline.getProperties();
        long setupTime = tim.report();
        Redwood.Util.log("");
        if (props.containsKey("file")) {
            String fileName = props.getProperty("file");
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), props.getProperty("extension"), true);
            pipeline.processFiles(null, files, numThreads);
        } else if (props.containsKey("filelist")) {
            String fileName = props.getProperty("filelist");
            Collection<File> inputfiles = StanfordCoreNLP.readFileList(fileName);
            ArrayList<File> files = new ArrayList<File>(inputfiles.size());
            for (File file : inputfiles) {
                if (file.isDirectory()) {
                    files.addAll(new FileSequentialCollection(new File(fileName), props.getProperty("extension"), true));
                    continue;
                }
                files.add(file);
            }
            pipeline.processFiles(null, files, numThreads);
        } else {
            StanfordCoreNLP.shell(pipeline);
        }
        Redwood.Util.log(new Object[0]);
        Redwood.Util.log(pipeline.timingInformation());
        Redwood.Util.log("Pipeline setup: " + Timing.toSecondsString(setupTime) + " sec.");
        Redwood.Util.log("Total time for StanfordCoreNLP pipeline: " + tim.toSecondsString() + " sec.");
    }

    static enum OutputFormat {
        TEXT,
        XML,
        SERIALIZED;

    }
}

