/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.common.NoSuchParseException;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.common.ParserGrammar;
import edu.stanford.nlp.parser.common.ParserQuery;
import edu.stanford.nlp.parser.common.ParserUtils;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ParserAnnotator
implements Annotator {
    private final boolean VERBOSE;
    private final boolean BUILD_GRAPHS;
    private final ParserGrammar parser;
    private final Function<Tree, Tree> treeMap;
    private final int maxSentenceLength;
    private final long maxParseTime;
    private final GrammaticalStructureFactory gsf;
    private final int nThreads;
    private final boolean saveBinaryTrees;

    public ParserAnnotator(boolean verbose, int maxSent) {
        this(System.getProperty("parse.model", LexicalizedParser.DEFAULT_PARSER_LOC), verbose, maxSent, StringUtils.EMPTY_STRING_ARRAY);
    }

    public ParserAnnotator(String parserLoc, boolean verbose, int maxSent, String[] flags) {
        this(ParserAnnotator.loadModel(parserLoc, verbose, flags), verbose, maxSent);
    }

    public ParserAnnotator(ParserGrammar parser, boolean verbose, int maxSent) {
        this(parser, verbose, maxSent, null);
    }

    public ParserAnnotator(ParserGrammar parser, boolean verbose, int maxSent, Function<Tree, Tree> treeMap) {
        this.VERBOSE = verbose;
        this.BUILD_GRAPHS = parser.getTLPParams().supportsBasicDependencies();
        this.parser = parser;
        this.maxSentenceLength = maxSent;
        this.treeMap = treeMap;
        this.maxParseTime = 0L;
        if (this.BUILD_GRAPHS) {
            TreebankLanguagePack tlp = parser.getTLPParams().treebankLanguagePack();
            this.gsf = tlp.grammaticalStructureFactory(tlp.punctuationWordRejectFilter(), parser.getTLPParams().typedDependencyHeadFinder());
        } else {
            this.gsf = null;
        }
        this.nThreads = 1;
        this.saveBinaryTrees = false;
    }

    public ParserAnnotator(String annotatorName, Properties props) {
        String model = props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC);
        if (model == null) {
            throw new IllegalArgumentException("No model specified for Parser annotator " + annotatorName);
        }
        this.VERBOSE = PropertiesUtils.getBool(props, annotatorName + ".debug", false);
        String[] flags = ParserAnnotator.convertFlagsToArray(props.getProperty(annotatorName + ".flags"));
        this.parser = ParserAnnotator.loadModel(model, this.VERBOSE, flags);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", -1);
        String treeMapClass = props.getProperty(annotatorName + ".treemap");
        this.treeMap = treeMapClass == null ? null : (Function)ReflectionLoading.loadByReflection(treeMapClass, props);
        this.maxParseTime = PropertiesUtils.getLong(props, annotatorName + ".maxtime", 0L);
        String buildGraphsProperty = annotatorName + ".buildgraphs";
        if (!this.parser.getTLPParams().supportsBasicDependencies()) {
            if (props.getProperty(buildGraphsProperty) != null && PropertiesUtils.getBool(props, buildGraphsProperty)) {
                System.err.println("WARNING: " + buildGraphsProperty + " set to true, but " + this.parser.getTLPParams().getClass() + " does not support dependencies");
            }
            this.BUILD_GRAPHS = false;
        } else {
            this.BUILD_GRAPHS = PropertiesUtils.getBool(props, buildGraphsProperty, true);
        }
        if (this.BUILD_GRAPHS) {
            TreebankLanguagePack tlp = this.parser.getTLPParams().treebankLanguagePack();
            this.gsf = tlp.grammaticalStructureFactory(tlp.punctuationWordRejectFilter(), this.parser.getTLPParams().typedDependencyHeadFinder());
        } else {
            this.gsf = null;
        }
        this.nThreads = PropertiesUtils.getInt(props, annotatorName + ".nthreads", PropertiesUtils.getInt(props, "nthreads", 1));
        boolean usesBinary = StanfordCoreNLP.usesBinaryTrees(props);
        this.saveBinaryTrees = PropertiesUtils.getBool(props, annotatorName + ".binaryTrees", usesBinary);
    }

    public static String signature(String annotatorName, Properties props) {
        StringBuilder os = new StringBuilder();
        os.append(annotatorName + ".model:" + props.getProperty(annotatorName + ".model", LexicalizedParser.DEFAULT_PARSER_LOC));
        os.append(annotatorName + ".debug:" + props.getProperty(annotatorName + ".debug", "false"));
        os.append(annotatorName + ".flags:" + props.getProperty(annotatorName + ".flags", ""));
        os.append(annotatorName + ".maxlen:" + props.getProperty(annotatorName + ".maxlen", "-1"));
        os.append(annotatorName + ".treemap:" + props.getProperty(annotatorName + ".treemap", ""));
        os.append(annotatorName + ".maxtime:" + props.getProperty(annotatorName + ".maxtime", "0"));
        os.append(annotatorName + ".buildgraphs:" + props.getProperty(annotatorName + ".buildgraphs", "true"));
        os.append(annotatorName + ".nthreads:" + props.getProperty(annotatorName + ".nthreads", props.getProperty("nthreads", "")));
        boolean usesBinary = StanfordCoreNLP.usesBinaryTrees(props);
        boolean saveBinaryTrees = PropertiesUtils.getBool(props, annotatorName + ".binaryTrees", usesBinary);
        os.append(annotatorName + ".binaryTrees:" + saveBinaryTrees);
        return os.toString();
    }

    public static String[] convertFlagsToArray(String parserFlags) {
        if (parserFlags == null || parserFlags.trim().equals("")) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return parserFlags.trim().split("\\s+");
    }

    private static ParserGrammar loadModel(String parserLoc, boolean verbose, String[] flags) {
        if (verbose) {
            System.err.println("Loading Parser Model [" + parserLoc + "] ...");
            System.err.print("  Flags:");
            for (String flag : flags) {
                System.err.print("  " + flag);
            }
            System.err.println();
        }
        ParserGrammar result = ParserGrammar.loadModel(parserLoc, new String[0]);
        result.setOptionFlags(result.defaultCoreNLPFlags());
        result.setOptionFlags(flags);
        return result;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            if (this.nThreads != 1 || this.maxParseTime > 0L) {
                MulticoreWrapper<CoreMap, CoreMap> wrapper = new MulticoreWrapper<CoreMap, CoreMap>(this.nThreads, new ParserAnnotatorProcessor());
                if (this.maxParseTime > 0L) {
                    wrapper.setMaxBlockTime(this.maxParseTime);
                }
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    wrapper.put(sentence);
                    while (wrapper.peek()) {
                        wrapper.poll();
                    }
                }
                wrapper.join();
                while (wrapper.peek()) {
                    wrapper.poll();
                }
            } else {
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    this.doOneSentence(sentence);
                }
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void doOneSentence(CoreMap sentence) {
        List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (this.VERBOSE) {
            System.err.println("Parsing: " + words);
        }
        Tree tree = null;
        if (this.maxSentenceLength <= 0 || words.size() < this.maxSentenceLength) {
            try {
                List constraints = (List)sentence.get(ParserAnnotations.ConstraintAnnotation.class);
                tree = this.doOneSentence(constraints, words);
            }
            catch (RuntimeInterruptedException e) {
                if (this.VERBOSE) {
                    System.err.println("Took too long parsing: " + words);
                }
                tree = null;
            }
        }
        if (tree == null) {
            tree = ParserUtils.xTree(words);
        }
        if (this.treeMap != null) {
            tree = this.treeMap.apply(tree);
        }
        ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, this.BUILD_GRAPHS, this.gsf, sentence, tree);
        if (this.saveBinaryTrees) {
            TreeBinarizer binarizer = new TreeBinarizer(this.parser.getTLPParams().headFinder(), this.parser.treebankLanguagePack(), false, false, 0, false, false, 0.0, false, true, true);
            Tree binarized = binarizer.transformTree(tree);
            Trees.convertToCoreLabels(binarized);
            sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, binarized);
        }
    }

    private Tree doOneSentence(List<ParserConstraint> constraints, List<CoreLabel> words) {
        ParserQuery pq = this.parser.parserQuery();
        pq.setConstraints(constraints);
        pq.parse(words);
        Tree tree = null;
        try {
            tree = pq.getBestParse();
            tree.setScore(pq.getPCFGScore() % -10000.0);
        }
        catch (OutOfMemoryError e) {
            System.err.println("WARNING: Parsing of sentence ran out of memory.  Will ignore and continue: " + Sentence.listToString(words));
        }
        catch (NoSuchParseException e) {
            System.err.println("WARNING: Parsing of sentence failed, possibly because of out of memory.  Will ignore and continue: " + Sentence.listToString(words));
        }
        return tree;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return this.parser.requiresTags() ? TOKENIZE_SSPLIT_POS : TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        if (this.saveBinaryTrees) {
            return PARSE_TAG_BINARIZED_TREES;
        }
        return PARSE_AND_TAG;
    }

    private class ParserAnnotatorProcessor
    implements ThreadsafeProcessor<CoreMap, CoreMap> {
        private ParserAnnotatorProcessor() {
        }

        @Override
        public CoreMap process(CoreMap sentence) {
            ParserAnnotator.this.doOneSentence(sentence);
            return sentence;
        }

        @Override
        public ThreadsafeProcessor<CoreMap, CoreMap> newInstance() {
            return this;
        }
    }
}

