/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PatternToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tag;
    boolean useTag;
    int numWordsCompound;
    boolean useNER = false;
    String nerTag = null;
    boolean useTargetParserParentRestriction = false;
    String grandparentParseTag;

    public PatternToken(String tag, boolean useTag, boolean getCompoundPhrases, int numWordsCompound, String nerTag, boolean useNER, boolean useTargetParserParentRestriction, String grandparentParseTag) {
        this.tag = tag;
        this.useTag = useTag;
        this.numWordsCompound = numWordsCompound;
        if (!getCompoundPhrases) {
            numWordsCompound = 1;
        }
        this.nerTag = nerTag;
        this.useNER = useNER;
        this.useTargetParserParentRestriction = useTargetParserParentRestriction;
        if (useTargetParserParentRestriction) {
            if (grandparentParseTag == null) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Grand parent parse tag null ");
                this.grandparentParseTag = "null";
            } else {
                this.grandparentParseTag = grandparentParseTag;
            }
        }
    }

    public String toStringToWrite() {
        String s = "X";
        if (this.useTag) {
            s = s + ":" + this.tag;
        }
        if (this.useNER) {
            s = s + ":" + this.nerTag;
        }
        if (this.useTargetParserParentRestriction) {
            s = s + ":" + this.grandparentParseTag;
        }
        if (this.numWordsCompound > 1) {
            s = s + "{" + this.numWordsCompound + "}";
        }
        return s;
    }

    String getTokenStr(List<String> notAllowedClasses) {
        String str = " (?$term ";
        ArrayList<String> restrictions = new ArrayList<String>();
        if (this.useTag) {
            restrictions.add("{tag:/" + this.tag + ".*/}");
        }
        if (this.useNER) {
            restrictions.add("{ner:" + this.nerTag + "}");
        }
        if (this.useTargetParserParentRestriction) {
            restrictions.add("{grandparentparsetag:" + this.grandparentParseTag + "}");
        }
        if (notAllowedClasses != null && notAllowedClasses.size() > 0) {
            for (String na : notAllowedClasses) {
                restrictions.add("!{" + na + "}");
            }
        }
        str = str + "[" + StringUtils.join(restrictions, " & ") + "]{1," + this.numWordsCompound + "}";
        str = str + ")";
        str = StringUtils.toAscii(str);
        return str;
    }

    public boolean equals(Object b) {
        if (!(b instanceof PatternToken)) {
            return false;
        }
        PatternToken t = (PatternToken)b;
        if (this.useNER != t.useNER || this.useTag != t.useTag || this.useTargetParserParentRestriction != t.useTargetParserParentRestriction || this.numWordsCompound != t.numWordsCompound) {
            return false;
        }
        if (this.useTag && !this.tag.equals(t.tag)) {
            return false;
        }
        if (this.useNER && !this.nerTag.equals(t.nerTag)) {
            return false;
        }
        return !this.useTargetParserParentRestriction || this.grandparentParseTag.equals(t.grandparentParseTag);
    }

    public int hashCode() {
        return this.getTokenStr(null).hashCode();
    }
}

