/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.CompoundUnaryTransition;
import edu.stanford.nlp.parser.shiftreduce.FinalizeTransition;
import edu.stanford.nlp.parser.shiftreduce.IdleTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftTransition;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.UnaryTransition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;

public class CreateTransitionSequence {
    private CreateTransitionSequence() {
    }

    public static List<Transition> createTransitionSequence(Tree tree, boolean compoundUnary) {
        ArrayList<Transition> transitions = Generics.newArrayList();
        CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree, compoundUnary, true);
        transitions.add(new FinalizeTransition());
        transitions.add(new IdleTransition());
        return transitions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createTransitionSequenceHelper(List<Transition> transitions, Tree tree, boolean compoundUnary, boolean isRoot) {
        if (tree.isLeaf()) return;
        if (tree.isPreTerminal()) {
            transitions.add(new ShiftTransition());
            return;
        } else if (tree.children().length == 1) {
            if (compoundUnary) {
                ArrayList<String> labels = Generics.newArrayList();
                while (tree.children().length == 1 && !tree.isPreTerminal()) {
                    labels.add(tree.label().value());
                    tree = tree.children()[0];
                }
                CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree, compoundUnary, false);
                transitions.add(new CompoundUnaryTransition(labels, isRoot));
                return;
            } else {
                CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[0], compoundUnary, false);
                transitions.add(new UnaryTransition(tree.label().value(), isRoot));
            }
            return;
        } else {
            if (tree.children().length != 2) throw new IllegalArgumentException("Expected a binarized tree");
            CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[0], compoundUnary, false);
            CreateTransitionSequence.createTransitionSequenceHelper(transitions, tree.children()[1], compoundUnary, false);
            if (!(tree.label() instanceof CoreLabel && tree.children()[0].label() instanceof CoreLabel && tree.children()[1].label() instanceof CoreLabel)) {
                throw new IllegalArgumentException("Expected tree labels to be CoreLabel");
            }
            CoreLabel label = (CoreLabel)tree.label();
            CoreLabel leftLabel = (CoreLabel)tree.children()[0].label();
            CoreLabel rightLabel = (CoreLabel)tree.children()[1].label();
            Tree head = (Tree)label.get(TreeCoreAnnotations.HeadWordAnnotation.class);
            Tree leftHead = (Tree)leftLabel.get(TreeCoreAnnotations.HeadWordAnnotation.class);
            Tree rightHead = (Tree)rightLabel.get(TreeCoreAnnotations.HeadWordAnnotation.class);
            if (head == null || leftHead == null || rightHead == null) {
                throw new IllegalArgumentException("Expected tree labels to have their heads assigned");
            }
            if (head == leftHead) {
                transitions.add(new BinaryTransition(tree.label().value(), BinaryTransition.Side.LEFT));
                return;
            } else {
                if (head != rightHead) throw new IllegalArgumentException("Heads were incorrectly assigned: tree's head is not matched to either the right or left head");
                transitions.add(new BinaryTransition(tree.label().value(), BinaryTransition.Side.RIGHT));
            }
        }
    }
}

