/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Span
implements Serializable,
Iterable<Integer> {
    private static final long serialVersionUID = -3861451490217976693L;
    private int start;
    private int end;

    private Span() {
    }

    public Span(int s, int e) {
        this.start = s;
        this.end = e;
    }

    public Span(Span ... spans) {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
        for (Span span : spans) {
            this.expandToInclude(span);
        }
    }

    public static Span fromValues(int val1, int val2) {
        if (val1 <= val2) {
            return new Span(val1, val2);
        }
        return new Span(val2, val1);
    }

    public static Span fromValues(Object ... values) {
        int val2;
        int val1;
        if (values.length == 1) {
            return Span.fromValues(values[0], values[0] instanceof Number ? ((Number)values[0]).intValue() + 1 : Integer.parseInt(values[0].toString()) + 1);
        }
        if (values.length != 2) {
            throw new IllegalArgumentException("fromValues() must take an array with 2 elements");
        }
        if (values[0] instanceof Number) {
            val1 = ((Number)values[0]).intValue();
        } else if (values[0] instanceof String) {
            val1 = Integer.parseInt((String)values[0]);
        } else {
            throw new IllegalArgumentException("Unknown value for span: " + values[0]);
        }
        if (values[1] instanceof Number) {
            val2 = ((Number)values[1]).intValue();
        } else if (values[0] instanceof String) {
            val2 = Integer.parseInt((String)values[1]);
        } else {
            throw new IllegalArgumentException("Unknown value for span: " + values[1]);
        }
        return Span.fromValues(val1, val2);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public void setEnd(int e) {
        this.end = e;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Span)) {
            return false;
        }
        Span otherSpan = (Span)other;
        return this.start == otherSpan.start && this.end == otherSpan.end;
    }

    public int hashCode() {
        return new Pair<Integer, Integer>(this.start, this.end).hashCode();
    }

    public String toString() {
        return "[" + this.start + "," + this.end + ")";
    }

    public void expandToInclude(Span otherSpan) {
        if (otherSpan.start() < this.start) {
            this.setStart(otherSpan.start());
        }
        if (otherSpan.end() > this.end) {
            this.setEnd(otherSpan.end());
        }
    }

    public boolean contains(Span otherSpan) {
        return this.start <= otherSpan.start && otherSpan.end <= this.end;
    }

    public boolean contains(int i) {
        return this.start <= i && i < this.end;
    }

    public boolean isBefore(Span otherSpan) {
        if (this.contains(otherSpan) || otherSpan.contains(this)) {
            throw new IllegalArgumentException("Span " + this.toString() + " contains otherSpan " + otherSpan + " (or vice versa)");
        }
        return this.end <= otherSpan.start;
    }

    public boolean isAfter(Span otherSpan) {
        if (this.contains(otherSpan) || otherSpan.contains(this)) {
            throw new IllegalArgumentException("Span " + this.toString() + " contains otherSpan " + otherSpan + " (or vice versa)");
        }
        return this.start >= otherSpan.end;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int nextIndex;
            {
                this.nextIndex = Span.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < Span.this.end;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.nextIndex;
                return this.nextIndex - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.end - this.start;
    }

    public static boolean overlaps(Span spanA, Span spanB) {
        return spanA.contains(spanB) || spanB.contains(spanA) || spanA.end > spanB.end && spanA.start < spanB.end || spanB.end > spanA.end && spanB.start < spanA.end || spanA.equals(spanB);
    }

    public static int overlap(Span spanA, Span spanB) {
        if (spanA.contains(spanB)) {
            return Math.min(spanA.end - spanA.start, spanB.end - spanB.start);
        }
        if (spanA.equals(spanB)) {
            return spanA.end - spanA.start;
        }
        if (spanA.end > spanB.end && spanA.start < spanB.end || spanB.end > spanA.end && spanB.start < spanA.end) {
            return Math.min(spanA.end, spanB.end) - Math.max(spanA.start, spanB.start);
        }
        return 0;
    }

    public static boolean overlaps(Span spanA, Collection<Span> spanB) {
        for (Span candidate : spanB) {
            if (!Span.overlaps(spanA, candidate)) continue;
            return true;
        }
        return false;
    }
}

