/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref.sievepasses;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.Rules;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.dcoref.SieveOptions;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public abstract class DeterministicCorefSieve {
    public final SieveOptions flags = new SieveOptions();

    public void init(Properties props) {
    }

    public String flagsToString() {
        return this.flags.toString();
    }

    public boolean useRoleSkip() {
        return this.flags.USE_ROLE_SKIP;
    }

    public boolean skipThisMention(Document document, Mention m1, CorefCluster c, Dictionaries dict) {
        boolean skip = false;
        if (!(this.flags.USE_EXACTSTRINGMATCH || this.flags.USE_ROLEAPPOSITION || this.flags.USE_PREDICATENOMINATIVES || this.flags.USE_ACRONYM || this.flags.USE_APPOSITION || this.flags.USE_RELATIVEPRONOUN || c.getFirstMention().equals(m1))) {
            return true;
        }
        SieveCoreferenceSystem.logger.finest("DOING COREF FOR:\t" + m1.spanToString());
        if (m1.appositions == null && m1.predicateNominatives == null && (m1.lowercaseNormalizedSpanString().startsWith("a ") || m1.lowercaseNormalizedSpanString().startsWith("an ")) && !this.flags.USE_EXACTSTRINGMATCH) {
            skip = true;
        }
        if (dict.indefinitePronouns.contains(m1.lowercaseNormalizedSpanString())) {
            skip = true;
        }
        for (String indef : dict.indefinitePronouns) {
            if (!m1.lowercaseNormalizedSpanString().startsWith(indef + " ")) continue;
            skip = true;
            break;
        }
        if (skip) {
            SieveCoreferenceSystem.logger.finest("MENTION SKIPPED:\t" + m1.spanToString() + "(" + m1.sentNum + ")" + "\toriginalRef: " + m1.originalRef + " in discourse " + m1.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
        }
        return skip;
    }

    public boolean checkEntityMatch(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict, Set<Mention> roleSet) {
        return false;
    }

    public boolean coreferent(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention2, Mention ant, Dictionaries dict, Set<Mention> roleSet, Semantics semantics) throws Exception {
        Mention m;
        Method meth;
        boolean ret = false;
        Mention mention = mentionCluster.getRepresentativeMention();
        if (this.flags.USE_INCOMPATIBLES && document.isIncompatible(mentionCluster, potentialAntecedent)) {
            SieveCoreferenceSystem.logger.finest("INCOMPATIBLE clusters: not match: " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
            return false;
        }
        if (this.flags.DO_PRONOUN && Math.abs(mention2.sentNum - ant.sentNum) > 3 && mention2.person != Dictionaries.Person.I && mention2.person != Dictionaries.Person.YOU) {
            return false;
        }
        if (mention2.lowercaseNormalizedSpanString().equals("this") && Math.abs(mention2.sentNum - ant.sentNum) > 3) {
            return false;
        }
        if (mention2.person == Dictionaries.Person.YOU && document.docType == Document.DocType.ARTICLE && ((String)mention2.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).equals("PER0")) {
            return false;
        }
        if (document.conllDoc != null) {
            if (ant.generic && ant.person == Dictionaries.Person.YOU) {
                return false;
            }
            if (mention2.generic) {
                return false;
            }
        }
        if (mention2.insideIn(ant) || ant.insideIn(mention2)) {
            return false;
        }
        if (this.flags.USE_DISCOURSEMATCH) {
            String mString = mention.lowercaseNormalizedSpanString();
            String antString = ant.lowercaseNormalizedSpanString();
            if (mention.speakerInfo != null && mention.speakerInfo == ant.speakerInfo) {
                SieveCoreferenceSystem.logger.finest("discourse match: maps to same speaker: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                return true;
            }
            if (mention.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && ant.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && Rules.entitySameSpeaker(document, mention, ant)) {
                SieveCoreferenceSystem.logger.finest("discourse match: 1st person same speaker: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                return true;
            }
            if (mention.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && Rules.antecedentIsMentionSpeaker(document, mention, ant, dict)) {
                SieveCoreferenceSystem.logger.finest("discourse match: 1st person mention speaker match antecedent: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                if (mention.speakerInfo == null && ant.speakerInfo != null) {
                    mention.speakerInfo = ant.speakerInfo;
                }
                return true;
            }
            if (ant.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && Rules.antecedentIsMentionSpeaker(document, ant, mention, dict)) {
                SieveCoreferenceSystem.logger.finest("discourse match: 1st person antecedent speaker match mention: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                if (ant.speakerInfo == null && mention.speakerInfo != null) {
                    ant.speakerInfo = mention.speakerInfo;
                }
                return true;
            }
            if (dict.secondPersonPronouns.contains(mString) && dict.secondPersonPronouns.contains(antString) && Rules.entitySameSpeaker(document, mention, ant)) {
                SieveCoreferenceSystem.logger.finest("discourse match: 2nd person same speaker: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                return true;
            }
            if ((mention.person == Dictionaries.Person.I && ant.person == Dictionaries.Person.YOU || mention.person == Dictionaries.Person.YOU && ant.person == Dictionaries.Person.I) && (Integer)mention.headWord.get(CoreAnnotations.UtteranceAnnotation.class) - (Integer)ant.headWord.get(CoreAnnotations.UtteranceAnnotation.class) == 1 && document.docType == Document.DocType.CONVERSATION) {
                SieveCoreferenceSystem.logger.finest("discourse match: between two person: " + mention.spanToString() + "\tmatched\t" + ant.spanToString());
                return true;
            }
            if (dict.reflexivePronouns.contains(mention.headString) && Rules.entitySubjectObject(mention, ant)) {
                SieveCoreferenceSystem.logger.finest("discourse match: reflexive pronoun: " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID == ant.goldCorefClusterID));
                return true;
            }
        }
        if (!(this.flags.USE_EXACTSTRINGMATCH || this.flags.USE_RELAXED_EXACTSTRINGMATCH || this.flags.USE_APPOSITION || this.flags.USE_WORDS_INCLUSION)) {
            for (Mention m2 : mentionCluster.getCorefMentions()) {
                for (Mention a : potentialAntecedent.getCorefMentions()) {
                    if (m2.person != Dictionaries.Person.I && a.person != Dictionaries.Person.I && (Rules.antecedentIsMentionSpeaker(document, m2, a, dict) || Rules.antecedentIsMentionSpeaker(document, a, m2, dict))) {
                        SieveCoreferenceSystem.logger.finest("Incompatibles: not match(speaker): " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                        document.addIncompatible(m2, a);
                        return false;
                    }
                    int dist = Math.abs((Integer)m2.headWord.get(CoreAnnotations.UtteranceAnnotation.class) - (Integer)a.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    if (document.docType == Document.DocType.ARTICLE || dist != 1 || Rules.entitySameSpeaker(document, m2, a)) continue;
                    String mSpeaker = document.speakers.get(m2.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    String aSpeaker = document.speakers.get(a.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    if (m2.person == Dictionaries.Person.I && a.person == Dictionaries.Person.I) {
                        SieveCoreferenceSystem.logger.finest("Incompatibles: neighbor I: " + ant.spanToString() + "(" + ant.mentionID + "," + aSpeaker + ") :: " + mention.spanToString() + "(" + mention.mentionID + "," + mSpeaker + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                        document.addIncompatible(m2, a);
                        return false;
                    }
                    if (m2.person == Dictionaries.Person.YOU && a.person == Dictionaries.Person.YOU) {
                        SieveCoreferenceSystem.logger.finest("Incompatibles: neighbor YOU: " + ant.spanToString() + "(" + ant.mentionID + "," + aSpeaker + ") :: " + mention.spanToString() + "(" + mention.mentionID + "," + mSpeaker + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                        document.addIncompatible(m2, a);
                        return false;
                    }
                    if (m2.person != Dictionaries.Person.WE || a.person != Dictionaries.Person.WE) continue;
                    SieveCoreferenceSystem.logger.finest("Incompatibles: neighbor WE: " + ant.spanToString() + "(" + ant.mentionID + "," + aSpeaker + ") :: " + mention.spanToString() + "(" + mention.mentionID + "," + mSpeaker + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                    document.addIncompatible(m2, a);
                    return false;
                }
            }
            if (document.docType == Document.DocType.ARTICLE) {
                for (Mention m2 : mentionCluster.getCorefMentions()) {
                    for (Mention a : potentialAntecedent.getCorefMentions()) {
                        if (!Rules.entitySubjectObject(m2, a)) continue;
                        SieveCoreferenceSystem.logger.finest("Incompatibles: subject-object: " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                        document.addIncompatible(m2, a);
                        return false;
                    }
                }
            }
        }
        if (this.flags.USE_iwithini && Rules.entityIWithinI(mention, ant, dict)) {
            SieveCoreferenceSystem.logger.finest("Incompatibles: iwithini: " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
            document.addIncompatible(mention, ant);
            return false;
        }
        if (this.flags.USE_EXACTSTRINGMATCH && Rules.entityExactStringMatch(mentionCluster, potentialAntecedent, dict, roleSet)) {
            return true;
        }
        if (this.flags.USE_NAME_MATCH && this.checkEntityMatch(document, mentionCluster, potentialAntecedent, dict, roleSet)) {
            ret = true;
        }
        if (this.flags.USE_RELAXED_EXACTSTRINGMATCH && Rules.entityRelaxedExactStringMatch(mentionCluster, potentialAntecedent, mention, ant, dict, roleSet)) {
            return true;
        }
        if (this.flags.USE_APPOSITION && Rules.entityIsApposition(mentionCluster, potentialAntecedent, mention, ant)) {
            SieveCoreferenceSystem.logger.finest("Apposition: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            return true;
        }
        if (this.flags.USE_PREDICATENOMINATIVES && Rules.entityIsPredicateNominatives(mentionCluster, potentialAntecedent, mention, ant)) {
            SieveCoreferenceSystem.logger.finest("Predicate nominatives: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            return true;
        }
        if (this.flags.USE_ACRONYM && Rules.entityIsAcronym(document, mentionCluster, potentialAntecedent)) {
            SieveCoreferenceSystem.logger.finest("Acronym: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            return true;
        }
        if (this.flags.USE_RELATIVEPRONOUN && Rules.entityIsRelativePronoun(mention, ant)) {
            SieveCoreferenceSystem.logger.finest("Relative pronoun: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            return true;
        }
        if (this.flags.USE_DEMONYM && mention.isDemonym(ant, dict)) {
            SieveCoreferenceSystem.logger.finest("Demonym: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            return true;
        }
        if (this.flags.USE_ROLEAPPOSITION && Rules.entityIsRoleAppositive(mentionCluster, potentialAntecedent, mention, ant, dict)) {
            SieveCoreferenceSystem.logger.finest("Role Appositive: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            ret = true;
        }
        if (this.flags.USE_INCLUSION_HEADMATCH && Rules.entityHeadsAgree(mentionCluster, potentialAntecedent, mention, ant, dict)) {
            SieveCoreferenceSystem.logger.finest("Entity heads agree: " + mention.spanToString() + "\tvs\t" + ant.spanToString());
            ret = true;
        }
        if (this.flags.USE_RELAXED_HEADMATCH && Rules.entityRelaxedHeadsAgreeBetweenMentions(mentionCluster, potentialAntecedent, mention, ant)) {
            ret = true;
        }
        if (this.flags.USE_WORDS_INCLUSION && ret && !Rules.entityWordsIncluded(mentionCluster, potentialAntecedent, mention, ant)) {
            return false;
        }
        if (this.flags.USE_INCOMPATIBLE_MODIFIER && ret && Rules.entityHaveIncompatibleModifier(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (this.flags.USE_PROPERHEAD_AT_LAST && ret && !Rules.entitySameProperHeadLastWord(mentionCluster, potentialAntecedent, mention, ant)) {
            return false;
        }
        if (this.flags.USE_ATTRIBUTES_AGREE && !Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (this.flags.USE_DIFFERENT_LOCATION && Rules.entityHaveDifferentLocation(mention, ant, dict)) {
            if (this.flags.USE_PROPERHEAD_AT_LAST && ret && mention.goldCorefClusterID != ant.goldCorefClusterID) {
                SieveCoreferenceSystem.logger.finest("DIFFERENT LOCATION: " + ant.spanToString() + " :: " + mention.spanToString());
            }
            return false;
        }
        if (this.flags.USE_NUMBER_IN_MENTION && Rules.entityNumberInLaterMention(mention, ant)) {
            if (this.flags.USE_PROPERHEAD_AT_LAST && ret && mention.goldCorefClusterID != ant.goldCorefClusterID) {
                SieveCoreferenceSystem.logger.finest("NEW NUMBER : " + ant.spanToString() + " :: " + mention.spanToString());
            }
            return false;
        }
        if (this.flags.USE_WN_HYPERNYM) {
            meth = semantics.wordnet.getClass().getMethod("checkHypernym", CorefCluster.class, CorefCluster.class, Mention.class, Mention.class);
            if (((Boolean)meth.invoke(semantics.wordnet, mentionCluster, potentialAntecedent, mention, ant)).booleanValue()) {
                ret = true;
            } else if (mention.goldCorefClusterID == ant.goldCorefClusterID && !mention.isPronominal() && !ant.isPronominal()) {
                SieveCoreferenceSystem.logger.finest("not hypernym in WN");
                SieveCoreferenceSystem.logger.finest("False Negatives:: " + ant.spanToString() + " <= " + mention.spanToString());
            }
        }
        if (this.flags.USE_WN_SYNONYM) {
            meth = semantics.wordnet.getClass().getMethod("checkSynonym", Mention.class, Mention.class);
            if (((Boolean)meth.invoke(semantics.wordnet, mention, ant)).booleanValue()) {
                ret = true;
            } else if (mention.goldCorefClusterID == ant.goldCorefClusterID && !mention.isPronominal() && !ant.isPronominal()) {
                SieveCoreferenceSystem.logger.finest("not synonym in WN");
                SieveCoreferenceSystem.logger.finest("False Negatives:: " + ant.spanToString() + " <= " + mention.spanToString());
            }
        }
        try {
            if (this.flags.USE_ALIAS && Rules.entityAlias(mentionCluster, potentialAntecedent, semantics, dict)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.flags.USE_DISTANCE && Rules.entityTokenDistance(mention2, ant)) {
            return false;
        }
        if (this.flags.USE_COREF_DICT) {
            if (ant.headWord.lemma().equals(mention2.headWord.lemma())) {
                return false;
            }
            if (ant.mentionType != Dictionaries.MentionType.PROPER && (((String)mention2.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") || !mention2.headWord.word().substring(1).equals(mention2.headWord.word().substring(1).toLowerCase()))) {
                return false;
            }
            if (((String)ant.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("NNS") && ((String)mention2.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("NNS")) {
                return false;
            }
            if (dict.indefinitePronouns.contains(ant.originalSpan.get(0).lemma()) || dict.indefinitePronouns.contains(mention2.originalSpan.get(0).lemma())) {
                return false;
            }
            if (ant.isCoordinated() || mention2.isCoordinated()) {
                return false;
            }
            if (Rules.contextIncompatible(mention2, ant, dict)) {
                return false;
            }
            if (Rules.sentenceContextIncompatible(mention2, ant, dict)) {
                return false;
            }
            if (Rules.entityClusterAllCorefDictionary(mentionCluster, potentialAntecedent, dict, 1, 8)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 2, 2)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 3, 2)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 4, 2)) {
                return true;
            }
        }
        if (this.flags.DO_PRONOUN && ((m = mention.predicateNominatives != null && mention.predicateNominatives.contains(mention2) ? mention2 : mention).isPronominal() || dict.allPronouns.contains(m.toString())) && Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            if (dict.demonymSet.contains(ant.lowercaseNormalizedSpanString()) && dict.notOrganizationPRP.contains(m.headString)) {
                document.addIncompatible(m, ant);
                return false;
            }
            if (Rules.entityPersonDisagree(document, mentionCluster, potentialAntecedent, dict)) {
                SieveCoreferenceSystem.logger.finest("Incompatibles: Person Disagree: " + ant.spanToString() + "(" + ant.mentionID + ") :: " + mention.spanToString() + "(" + mention.mentionID + ") -> " + (mention.goldCorefClusterID != ant.goldCorefClusterID));
                document.addIncompatible(m, ant);
                return false;
            }
            return true;
        }
        return ret;
    }

    public List<Mention> getOrderedAntecedents(int antecedentSentence, int mySentence, List<Mention> orderedMentions, List<List<Mention>> orderedMentionsBySentence, Mention m1, int m1Position, Map<Integer, CorefCluster> corefClusters, Dictionaries dict) {
        List<Mention> orderedAntecedents = new ArrayList<Mention>();
        if (antecedentSentence == mySentence) {
            orderedAntecedents.addAll(orderedMentions.subList(0, m1Position));
            if (this.flags.DO_PRONOUN && corefClusters.get(m1.corefClusterID).isSinglePronounCluster(dict)) {
                orderedAntecedents = DeterministicCorefSieve.sortMentionsForPronoun(orderedAntecedents, m1, true);
            }
            if (dict.relativePronouns.contains(m1.spanToString())) {
                Collections.reverse(orderedAntecedents);
            }
        } else {
            orderedAntecedents.addAll((Collection)orderedMentionsBySentence.get(antecedentSentence));
        }
        return orderedAntecedents;
    }

    private static List<Mention> sortMentionsForPronoun(List<Mention> l, Mention m1, boolean sameSentence) {
        List<Mention> sorted = new ArrayList<Mention>();
        if (sameSentence) {
            Tree tree = m1.contextParseTree;
            Tree current = m1.mentionSubTree;
            do {
                if (!(current = current.ancestor(1, tree)).label().value().startsWith("S")) continue;
                for (Mention m : l) {
                    if (sorted.contains(m) || !current.dominates(m.mentionSubTree)) continue;
                    sorted.add(m);
                }
            } while (!current.label().value().equals("ROOT") && current.ancestor(1, tree) != null);
            if (SieveCoreferenceSystem.logger.isLoggable(Level.FINEST)) {
                if (l.size() != sorted.size()) {
                    SieveCoreferenceSystem.logger.finest("sorting failed!!! -> parser error?? \tmentionID: " + m1.mentionID + " " + m1.spanToString());
                    sorted = l;
                } else if (!((Object)l).equals(sorted)) {
                    SieveCoreferenceSystem.logger.finest("sorting succeeded & changed !! \tmentionID: " + m1.mentionID + " " + m1.spanToString());
                    for (int i = 0; i < l.size(); ++i) {
                        Mention ml = l.get(i);
                        Mention msorted = sorted.get(i);
                        SieveCoreferenceSystem.logger.finest("\t[" + ml.spanToString() + "]\t[" + msorted.spanToString() + "]");
                    }
                } else {
                    SieveCoreferenceSystem.logger.finest("no changed !! \tmentionID: " + m1.mentionID + " " + m1.spanToString());
                }
            }
        }
        return sorted;
    }
}

