/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.wordseg;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.trees.international.pennchinese.RadicalMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.wordseg.CorpusDictionary;
import edu.stanford.nlp.wordseg.NonDict2;
import edu.stanford.nlp.wordseg.TagAffixDetector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gale2007ChineseSegmenterFeatureFactory<IN extends CoreLabel>
extends FeatureFactory<IN> {
    private static final int DEBUG = 0;
    private transient TagAffixDetector taDetector;
    private transient CorpusDictionary outDict;
    private static final Pattern patE = Pattern.compile("[a-z]");
    private static final Pattern patEC = Pattern.compile("[A-Z]");
    private static final Pattern patP = Pattern.compile("[-\u00b7.]");
    private static final long serialVersionUID = 8197648719208850960L;

    @Override
    public void init(SeqClassifierFlags flags) {
        super.init(flags);
    }

    private synchronized void createTADetector() {
        if (this.taDetector == null) {
            this.taDetector = new TagAffixDetector(this.flags);
        }
    }

    private synchronized void createOutDict() {
        if (this.outDict == null) {
            System.err.println("reading " + this.flags.outDict2 + " as a seen lexicon");
            this.outDict = new CorpusDictionary(this.flags.outDict2);
        }
    }

    @Override
    public Collection<String> getCliqueFeatures(PaddedList<IN> cInfo, int loc, Clique clique) {
        Set<String> features = Generics.newHashSet();
        if (clique == cliqueC) {
            this.addAllInterningAndSuffixing(features, this.featuresC(cInfo, loc), "C");
        } else if (clique == cliqueCpC) {
            this.addAllInterningAndSuffixing(features, this.featuresCpC(cInfo, loc), "CpC");
            this.addAllInterningAndSuffixing(features, this.featuresCnC(cInfo, loc - 1), "CnC");
        } else if (clique == cliqueCpCp2Cp3C) {
            this.addAllInterningAndSuffixing(features, this.featuresCpCp2Cp3C(cInfo, loc), "CpCp2Cp3C");
        }
        return features;
    }

    private static String isEnglish(String chp, String chc) {
        Matcher mp = patE.matcher(chp);
        Matcher mc = patE.matcher(chc);
        Matcher mpC = patEC.matcher(chp);
        Matcher mcC = patEC.matcher(chc);
        if (mp.matches() && mcC.matches()) {
            return "BND";
        }
        if (mp.matches() && mc.matches()) {
            return "ENG";
        }
        if (mpC.matches() && mcC.matches()) {
            return "BCC";
        }
        if (mp.matches() && !mc.matches() && !mcC.matches()) {
            return "e1";
        }
        if (mc.matches() && !mp.matches() && !mpC.matches()) {
            return "e2";
        }
        if (mpC.matches() && !mc.matches() && !mcC.matches()) {
            return "e3";
        }
        if (mcC.matches() && !mp.matches() && !mpC.matches()) {
            return "e4";
        }
        return "";
    }

    private static String isEngPU(String Ep) {
        Matcher mp = patP.matcher(Ep);
        if (mp.matches()) {
            return "1:EngPU";
        }
        return "";
    }

    private static void dictionaryFeaturesC(Class<? extends CoreAnnotation<String>> lbeginFieldName, Class<? extends CoreAnnotation<String>> lmiddleFieldName, Class<? extends CoreAnnotation<String>> lendFieldName, String dictSuffix, Collection<String> features, CoreLabel p, CoreLabel c, CoreLabel c2) {
        String lbegin = c.getString(lbeginFieldName);
        String lmiddle = c.getString(lmiddleFieldName);
        String lend = c.getString(lendFieldName);
        features.add(lbegin + dictSuffix + "-lb");
        features.add(lmiddle + dictSuffix + "-lm");
        features.add(lend + dictSuffix + "-le");
        lbegin = p.getString(lbeginFieldName);
        lmiddle = p.getString(lmiddleFieldName);
        lend = p.getString(lendFieldName);
        features.add(lbegin + dictSuffix + "-plb");
        features.add(lmiddle + dictSuffix + "-plm");
        features.add(lend + dictSuffix + "-ple");
        lbegin = c2.getString(lbeginFieldName);
        lmiddle = c2.getString(lmiddleFieldName);
        lend = c2.getString(lendFieldName);
        features.add(lbegin + dictSuffix + "-c2lb");
        features.add(lmiddle + dictSuffix + "-c2lm");
        features.add(lend + dictSuffix + "-c2le");
    }

    protected Collection<String> featuresC(PaddedList<? extends CoreLabel> cInfo, int loc) {
        String uTypep2;
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = cInfo.get(loc);
        CoreLabel c2 = cInfo.get(loc + 1);
        CoreLabel c3 = cInfo.get(loc + 2);
        CoreLabel p = cInfo.get(loc - 1);
        CoreLabel p2 = cInfo.get(loc - 2);
        CoreLabel p3 = cInfo.get(loc - 3);
        String charc = c.getString(CoreAnnotations.CharAnnotation.class);
        String charc2 = c2.getString(CoreAnnotations.CharAnnotation.class);
        String charc3 = c3.getString(CoreAnnotations.CharAnnotation.class);
        String charp = p.getString(CoreAnnotations.CharAnnotation.class);
        String charp2 = p2.getString(CoreAnnotations.CharAnnotation.class);
        String charp3 = p3.getString(CoreAnnotations.CharAnnotation.class);
        Integer cI = (Integer)c.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypec = cI != null ? cI.toString() : "";
        Integer c2I = (Integer)c2.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypec2 = c2I != null ? c2I.toString() : "";
        Integer c3I = (Integer)c3.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypec3 = c3I != null ? c3I.toString() : "";
        Integer pI = (Integer)p.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypep = pI != null ? pI.toString() : "";
        Integer p2I = (Integer)p2.get(CoreAnnotations.UTypeAnnotation.class);
        String string = uTypep2 = p2I != null ? p2I.toString() : "";
        if (this.flags.useWord1) {
            features.add(charc + "::c");
            features.add(charc2 + "::c2");
            features.add(charp + "::p");
            features.add(charp2 + "::p2");
            features.add(charc + charc2 + "::cn");
            features.add(charc + charc3 + "::cn2");
            features.add(charp + charc + "::pc");
            features.add(charp + charc2 + "::pn");
            features.add(charp2 + charp + "::p2p");
            features.add(charp2 + charc + "::p2c");
            features.add(charc2 + charc + "::n2c");
        }
        if (this.flags.dictionary != null || this.flags.serializedDictionary != null) {
            Gale2007ChineseSegmenterFeatureFactory.dictionaryFeaturesC(CoreAnnotations.LBeginAnnotation.class, CoreAnnotations.LMiddleAnnotation.class, CoreAnnotations.LEndAnnotation.class, "", features, p, c, c2);
        }
        if (this.flags.dictionary2 != null) {
            Gale2007ChineseSegmenterFeatureFactory.dictionaryFeaturesC(CoreAnnotations.D2_LBeginAnnotation.class, CoreAnnotations.D2_LMiddleAnnotation.class, CoreAnnotations.D2_LEndAnnotation.class, "-D2-", features, p, c, c2);
        }
        if (this.flags.useFeaturesC4gram || this.flags.useFeaturesC5gram || this.flags.useFeaturesC6gram) {
            features.add(charp2 + charp + "p2p");
            features.add(charp2 + "p2");
        }
        if (this.flags.useFeaturesC5gram || this.flags.useFeaturesC6gram) {
            features.add(charc3 + "c3");
            features.add(charc2 + charc3 + "c2c3");
        }
        if (this.flags.useFeaturesC6gram) {
            features.add(charp3 + "p3");
            features.add(charp3 + charp2 + "p3p2");
        }
        if (this.flags.useUnicodeType || this.flags.useUnicodeType4gram || this.flags.useUnicodeType5gram) {
            features.add(uTypep + "-" + uTypec + "-" + uTypec2 + "-uType3");
        }
        if (this.flags.useUnicodeType4gram || this.flags.useUnicodeType5gram) {
            features.add(uTypep2 + "-" + uTypep + "-" + uTypec + "-" + uTypec2 + "-uType4");
        }
        if (this.flags.useUnicodeType5gram) {
            features.add(uTypep2 + "-" + uTypep + "-" + uTypec + "-" + uTypec2 + "-" + uTypec3 + "-uType5");
        }
        if (this.flags.useUnicodeBlock) {
            features.add(p.getString(CoreAnnotations.UBlockAnnotation.class) + "-" + c.getString(CoreAnnotations.UBlockAnnotation.class) + "-" + c2.getString(CoreAnnotations.UBlockAnnotation.class) + "-uBlock");
        }
        if (this.flags.useShapeStrings) {
            if (this.flags.useShapeStrings1) {
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + "ps");
                features.add(c.getString(CoreAnnotations.ShapeAnnotation.class) + "cs");
                features.add(c2.getString(CoreAnnotations.ShapeAnnotation.class) + "c2s");
            }
            if (this.flags.useShapeStrings3) {
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + "pscsc2s");
            }
            if (this.flags.useShapeStrings4) {
                features.add(p2.getString(CoreAnnotations.ShapeAnnotation.class) + p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + "p2spscsc2s");
            }
            if (this.flags.useShapeStrings5) {
                features.add(p2.getString(CoreAnnotations.ShapeAnnotation.class) + p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + c3.getString(CoreAnnotations.ShapeAnnotation.class) + "p2spscsc2sc3s");
            }
        }
        features.add("cliqueC");
        return features;
    }

    private void dictionaryFeaturesCpC(Class<? extends CoreAnnotation<String>> lbeginFieldName, Class<? extends CoreAnnotation<String>> lmiddleFieldName, Class<? extends CoreAnnotation<String>> lendFieldName, String dictSuffix, Collection<String> features, CoreLabel p2, CoreLabel p, CoreLabel c, CoreLabel c2) {
        String lbegin = c.getString(lbeginFieldName);
        String lmiddle = c.getString(lmiddleFieldName);
        String lend = c.getString(lendFieldName);
        features.add(lbegin + dictSuffix + "-lb");
        features.add(lmiddle + dictSuffix + "-lm");
        features.add(lend + dictSuffix + "-le");
        lbegin = p.getString(lbeginFieldName);
        lmiddle = p.getString(lmiddleFieldName);
        lend = (String)p.get(lendFieldName);
        features.add(lbegin + dictSuffix + "-plb");
        features.add(lmiddle + dictSuffix + "-plm");
        features.add(lend + dictSuffix + "-ple");
        lbegin = c2.getString(lbeginFieldName);
        lmiddle = c2.getString(lmiddleFieldName);
        lend = c2.getString(lendFieldName);
        features.add(lbegin + dictSuffix + "-c2lb");
        features.add(lmiddle + dictSuffix + "-c2lm");
        features.add(lend + dictSuffix + "-c2le");
        if (this.flags.useDictionaryConjunctions) {
            String p2Lend = p2.getString(lendFieldName);
            String pLend = p.getString(lendFieldName);
            String pLbegin = p.getString(lbeginFieldName);
            String cLbegin = c.getString(lbeginFieldName);
            String cLmiddle = c.getString(lmiddleFieldName);
            if (this.flags.useDictionaryConjunctions3) {
                features.add(pLend + cLbegin + cLmiddle + dictSuffix + "-pcLconj1");
            }
            features.add(p2Lend + pLend + cLbegin + cLmiddle + dictSuffix + "-p2pcLconj1");
            features.add(p2Lend + pLend + pLbegin + cLbegin + cLmiddle + dictSuffix + "-p2pcLconj2");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection<String> featuresCpC(PaddedList<? extends CoreLabel> cInfo, int loc) {
        String uTypep2;
        Integer cI;
        String charp3;
        String charp2;
        String charp;
        String charc3;
        String charc2;
        ArrayList<String> features = new ArrayList<String>();
        CoreLabel c = cInfo.get(loc);
        CoreLabel c2 = cInfo.get(loc + 1);
        CoreLabel c3 = cInfo.get(loc + 2);
        CoreLabel p = cInfo.get(loc - 1);
        CoreLabel p2 = cInfo.get(loc - 2);
        CoreLabel p3 = cInfo.get(loc - 3);
        String charc = c.getString(CoreAnnotations.CharAnnotation.class);
        if (charc == null) {
            charc = "";
        }
        if ((charc2 = c2.getString(CoreAnnotations.CharAnnotation.class)) == null) {
            charc2 = "";
        }
        if ((charc3 = c3.getString(CoreAnnotations.CharAnnotation.class)) == null) {
            charc3 = "";
        }
        if ((charp = p.getString(CoreAnnotations.CharAnnotation.class)) == null) {
            charp = "";
        }
        if ((charp2 = p2.getString(CoreAnnotations.CharAnnotation.class)) == null) {
            charp2 = "";
        }
        if ((charp3 = p3.getString(CoreAnnotations.CharAnnotation.class)) == null) {
            charp3 = "";
        }
        String uTypec = (cI = (Integer)c.get(CoreAnnotations.UTypeAnnotation.class)) != null ? cI.toString() : "";
        Integer c2I = (Integer)c2.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypec2 = c2I != null ? c2I.toString() : "";
        Integer c3I = (Integer)c3.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypec3 = c3I != null ? c3I.toString() : "";
        Integer pI = (Integer)p.get(CoreAnnotations.UTypeAnnotation.class);
        String uTypep = pI != null ? pI.toString() : "";
        Integer p2I = (Integer)p2.get(CoreAnnotations.UTypeAnnotation.class);
        String string = uTypep2 = p2I != null ? p2I.toString() : "";
        if (this.flags.dictionary != null || this.flags.serializedDictionary != null) {
            this.dictionaryFeaturesCpC(CoreAnnotations.LBeginAnnotation.class, CoreAnnotations.LMiddleAnnotation.class, CoreAnnotations.LEndAnnotation.class, "", features, p2, p, c, c2);
        }
        if (this.flags.dictionary2 != null) {
            this.dictionaryFeaturesCpC(CoreAnnotations.D2_LBeginAnnotation.class, CoreAnnotations.D2_LMiddleAnnotation.class, CoreAnnotations.D2_LEndAnnotation.class, "-D2-", features, p2, p, c, c2);
        }
        if (this.flags.useWord2) {
            features.add(charc + "::c");
            features.add(charc2 + "::c1");
            features.add(charp + "::p");
            features.add(charp2 + "::p2");
            features.add(charc + charc2 + "::cn");
            features.add(charp + charc + "::pc");
            features.add(charp + charc2 + "::pn");
            features.add(charp2 + charp + "::p2p");
            features.add(charp2 + charc + "::p2c");
            features.add(charc2 + charc + "::n2c");
        }
        if (this.flags.useFeaturesCpC4gram || this.flags.useFeaturesCpC5gram || this.flags.useFeaturesCpC6gram) {
            features.add(charp2 + charp + "p2p");
            features.add(charp2 + "p2");
        }
        if (this.flags.useFeaturesCpC5gram || this.flags.useFeaturesCpC6gram) {
            features.add(charc3 + "c3");
            features.add(charc2 + charc3 + "c2c3");
        }
        if (this.flags.useFeaturesCpC6gram) {
            features.add(charp3 + "p3");
            features.add(charp3 + charp2 + "p3p2");
        }
        if (this.flags.useGoodForNamesCpC) {
            features.add(charp2 + "p2");
            features.add(charp3 + "p3");
        }
        if (this.flags.useUnicodeType || this.flags.useUnicodeType4gram || this.flags.useUnicodeType5gram) {
            features.add(uTypep + "-" + uTypec + "-" + uTypec2 + "-uType3");
        }
        if (this.flags.useUnicodeType4gram || this.flags.useUnicodeType5gram) {
            features.add(uTypep2 + "-" + uTypep + "-" + uTypec + "-" + uTypec2 + "-uType4");
        }
        if (this.flags.useUnicodeType5gram) {
            features.add(uTypep2 + "-" + uTypep + "-" + uTypec + "-" + uTypec2 + "-" + uTypec3 + "-uType5");
        }
        if (this.flags.useWordUTypeConjunctions2) {
            features.add(uTypep + charc + "putcc");
            features.add(charp + uTypec + "pccut");
        }
        if (this.flags.useWordUTypeConjunctions3) {
            features.add(uTypep2 + uTypep + charc + "p2utputcc");
            features.add(uTypep + charc + uTypec2 + "putccc2ut");
            features.add(charc + uTypec2 + uTypec3 + "ccc2utc3ut");
        }
        if (this.flags.useUnicodeBlock) {
            features.add(p.getString(CoreAnnotations.UBlockAnnotation.class) + "-" + c.getString(CoreAnnotations.UBlockAnnotation.class) + "-" + c2.getString(CoreAnnotations.UBlockAnnotation.class) + "-uBlock");
        }
        if (this.flags.useShapeStrings) {
            if (this.flags.useShapeStrings1) {
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + "ps");
                features.add(c.getString(CoreAnnotations.ShapeAnnotation.class) + "cs");
                features.add(c2.getString(CoreAnnotations.ShapeAnnotation.class) + "c2s");
            }
            if (this.flags.useShapeStrings3) {
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + "pscsc2s");
            }
            if (this.flags.useShapeStrings4) {
                features.add(p2.getString(CoreAnnotations.ShapeAnnotation.class) + p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + "p2spscsc2s");
            }
            if (this.flags.useShapeStrings5) {
                features.add(p2.getString(CoreAnnotations.ShapeAnnotation.class) + p.getString(CoreAnnotations.ShapeAnnotation.class) + c.getString(CoreAnnotations.ShapeAnnotation.class) + c2.getString(CoreAnnotations.ShapeAnnotation.class) + c3.getString(CoreAnnotations.ShapeAnnotation.class) + "p2spscsc2sc3s");
            }
            if (this.flags.useWordShapeConjunctions2) {
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + charc + "pscc");
                features.add(charp + c.getString(CoreAnnotations.ShapeAnnotation.class) + "pccs");
            }
            if (this.flags.useWordShapeConjunctions3) {
                features.add(p2.getString(CoreAnnotations.ShapeAnnotation.class) + p.getString(CoreAnnotations.ShapeAnnotation.class) + charc + "p2spscc");
                features.add(p.getString(CoreAnnotations.ShapeAnnotation.class) + charc + c2.getString(CoreAnnotations.ShapeAnnotation.class) + "psccc2s");
                features.add(charc + c2.getString(CoreAnnotations.ShapeAnnotation.class) + c3.getString(CoreAnnotations.ShapeAnnotation.class) + "ccc2sc3s");
            }
        }
        char rcharc = charc.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charc.charAt(0));
        char rcharc2 = charc2.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charc2.charAt(0));
        char rcharp = charp.length() == 0 ? (char)'n' : (char)RadicalMap.getRadical(charp.charAt(0));
        int rcharp2 = charp2.length() == 0 ? 110 : (int)RadicalMap.getRadical(charp2.charAt(0));
        if (this.flags.useRad2) {
            features.add(rcharc + "rc");
            features.add(rcharc2 + "rc2");
            features.add(rcharp + "rp");
            features.add(rcharp + rcharc + "rprc");
            features.add(rcharc + rcharc2 + "rcrc2");
            features.add(rcharp + rcharc + rcharc2 + "rprcrc2");
        }
        if (this.flags.useRad2b) {
            features.add(rcharc + "rc");
            features.add(rcharc2 + "rc2");
            features.add(rcharp + "rp");
            features.add(rcharp + rcharc + "rprc");
            features.add(rcharc + rcharc2 + "rcrc2");
            features.add(rcharp2 + rcharp + "rp2rp");
        }
        if (this.flags.useDict2) {
            NonDict2 nd = new NonDict2(this.flags);
            features.add(nd.checkDic(charp + charc, this.flags) + "nondict");
        }
        if (this.flags.useOutDict2) {
            if (this.outDict == null) {
                this.createOutDict();
            }
            features.add(this.outDict.getW(charp + charc) + "outdict");
            features.add(this.outDict.getW(charc + charc2) + "outdict");
            features.add(this.outDict.getW(charp2 + charp) + "outdict");
            features.add(this.outDict.getW(charp2 + charp + charc) + "outdict");
            features.add(this.outDict.getW(charp3 + charp2 + charp) + "outdict");
            features.add(this.outDict.getW(charp + charc + charc2) + "outdict");
            features.add(this.outDict.getW(charc + charc2 + charc3) + "outdict");
            features.add(this.outDict.getW(charp + charc + charc2 + charc3) + "outdict");
        }
        if (this.flags.useCTBChar2 || this.flags.useASBCChar2 || this.flags.useHKChar2 || this.flags.usePKChar2 || this.flags.useMSRChar2) {
            String[] tagsets;
            if (this.flags.useChPos) {
                if (this.flags.useCTBChar2) {
                    tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DE", "DT", "ETC", "IJ", "JJ", "LB", "LC", "M", "NN", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
                } else {
                    if (!this.flags.usePKChar2) throw new RuntimeException("only support settings for CTB and PK now.");
                    tagsets = new String[]{"2", "3", "4"};
                }
            } else {
                tagsets = new String[]{"2", "3", "4"};
            }
            if (this.taDetector == null) {
                this.createTADetector();
            }
            for (String tag : tagsets) {
                features.add(this.taDetector.checkDic(tag + "p", charp) + this.taDetector.checkDic(tag + "i", charp) + this.taDetector.checkDic(tag + "s", charc) + this.taDetector.checkInDic(charp) + this.taDetector.checkInDic(charc) + tag + "prep-sufc");
            }
        }
        if (this.flags.useRule2) {
            if (charp.equals(charc)) {
                features.add("11-R2");
            }
            if (charp.equals(charc2)) {
                features.add("22-R2");
            }
            if (!this.flags.usePk && !this.flags.useHk && charc.equals(charc2)) {
                features.add("33-R2");
            }
            int cur1 = 32;
            int cur2 = 32;
            int cur = 32;
            int pre = 32;
            if (charc2.length() > 0) {
                cur1 = charc2.charAt(0);
            }
            if (charc3.length() > 0) {
                cur2 = charc3.charAt(0);
            }
            if (charc.length() > 0) {
                cur = charc.charAt(0);
            }
            if (charp.length() > 0) {
                pre = charp.charAt(0);
            }
            String prer = String.valueOf(rcharp);
            Pattern E = Pattern.compile("[a-zA-Z]");
            Pattern N = Pattern.compile("[0-9]");
            Matcher m = E.matcher(charp);
            Matcher ce = E.matcher(charc);
            Matcher pe = E.matcher(charp2);
            Matcher cn = N.matcher(charc);
            Matcher pn = N.matcher(charp2);
            if (cur >= 48 && cur <= 57 && pre >= 48 && pre <= 57) {
                if (cur == 57 && pre == 49 && cur1 == 57 && cur2 >= 48 && cur2 <= 57) {
                    features.add("YR-R2");
                } else {
                    features.add("2N-R2");
                }
            } else if (pre >= 48 && pre <= 57) {
                features.add("1N-R2");
            } else if (m.matches()) {
                features.add("E-R2");
            } else if (prer.equals(".") && charp.length() == 1) {
                if (ce.matches()) {
                    features.add("PU+E-R2");
                }
                if (pe.matches()) {
                    features.add("E+PU-R2");
                }
                if (cn.matches()) {
                    features.add("PU+N-R2");
                }
                if (pn.matches()) {
                    features.add("N+PU-R2");
                }
                features.add("PU-R2");
            }
            String engType = Gale2007ChineseSegmenterFeatureFactory.isEnglish(charp, charc);
            String engPU = Gale2007ChineseSegmenterFeatureFactory.isEngPU(charp);
            if (!engType.equals("")) {
                features.add(engType);
            }
            if (!engPU.equals("") && !engType.equals("")) {
                StringBuilder sb = new StringBuilder();
                sb.append(engPU).append(engType).append("R2");
                features.add(sb.toString());
            }
        }
        String origS = c.getString(CoreAnnotations.OriginalCharAnnotation.class);
        char origC = ' ';
        if (origS.length() > 0) {
            origC = origS.charAt(0);
        }
        int type = Character.getType(origC);
        switch (type) {
            case 1: 
            case 2: {
                features.add("CHARTYPE-LETTER");
                break;
            }
            case 9: {
                features.add("CHARTYPE-DECIMAL_DIGIT_NUMBER");
                break;
            }
            case 5: {
                features.add("CHARTYPE-OTHER_LETTER");
                break;
            }
            default: {
                features.add("CHARTYPE-MISC");
            }
        }
        features.add("cliqueCpC");
        return features;
    }

    protected Collection<String> featuresCnC(PaddedList<? extends CoreLabel> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        if (this.flags.useWordn) {
            CoreLabel c = cInfo.get(loc);
            CoreLabel c2 = cInfo.get(loc + 1);
            CoreLabel p = cInfo.get(loc - 1);
            CoreLabel p2 = cInfo.get(loc - 2);
            String charc = c.getString(CoreAnnotations.CharAnnotation.class);
            String charc2 = c2.getString(CoreAnnotations.CharAnnotation.class);
            String charp = p.getString(CoreAnnotations.CharAnnotation.class);
            String charp2 = p2.getString(CoreAnnotations.CharAnnotation.class);
            features.add(charc + "c");
            features.add(charc2 + "c2");
            features.add(charp + "p");
            features.add(charp2 + "p2");
            features.add(charp2 + charp + "p2p");
            features.add(charp + charc + "pc");
            features.add(charc + charc2 + "cc2");
            features.add(charp + "-" + charc2 + "pc2");
            features.add("cliqueCnC");
        }
        return features;
    }

    protected Collection<String> featuresCpCp2Cp3C(PaddedList<? extends CoreLabel> cInfo, int loc) {
        ArrayList<String> features = new ArrayList<String>();
        if (this.flags.use4Clique && this.flags.maxLeft >= 3) {
            String uTypep3;
            CoreLabel c = cInfo.get(loc);
            CoreLabel c2 = cInfo.get(loc + 1);
            CoreLabel p = cInfo.get(loc - 1);
            CoreLabel p2 = cInfo.get(loc - 2);
            CoreLabel p3 = cInfo.get(loc - 3);
            String charc = c.getString(CoreAnnotations.CharAnnotation.class);
            String charp = p.getString(CoreAnnotations.CharAnnotation.class);
            String charp2 = p2.getString(CoreAnnotations.CharAnnotation.class);
            String charp3 = p3.getString(CoreAnnotations.CharAnnotation.class);
            Integer cI = (Integer)c.get(CoreAnnotations.UTypeAnnotation.class);
            String uTypec = cI != null ? cI.toString() : "";
            Integer c2I = (Integer)c2.get(CoreAnnotations.UTypeAnnotation.class);
            String uTypec2 = c2I != null ? c2I.toString() : "";
            Integer pI = (Integer)p.get(CoreAnnotations.UTypeAnnotation.class);
            String uTypep = pI != null ? pI.toString() : "";
            Integer p2I = (Integer)p2.get(CoreAnnotations.UTypeAnnotation.class);
            String uTypep2 = p2I != null ? p2I.toString() : "";
            Integer p3I = (Integer)p3.get(CoreAnnotations.UTypeAnnotation.class);
            String string = uTypep3 = p3I != null ? p3I.toString() : "";
            if (this.flags.useLongSequences) {
                features.add(charp3 + charp2 + charp + charc + "p3p2pc");
            }
            if (this.flags.useUnicodeType4gram || this.flags.useUnicodeType5gram) {
                features.add(uTypep3 + "-" + uTypep2 + "-" + uTypep + "-" + uTypec + "-uType4");
            }
            if (this.flags.useUnicodeType5gram) {
                features.add(uTypep3 + "-" + uTypep2 + "-" + uTypep + "-" + uTypec + "-" + uTypec2 + "-uType5");
            }
            features.add("cliqueCpCp2Cp3C");
        }
        return features;
    }
}

