/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.ejml.simple.SimpleMatrix;

public class SentimentPipeline {
    private static final NumberFormat NF = new DecimalFormat("0.0000");

    static void setSentimentLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentPipeline.setSentimentLabels(child);
        }
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("Required a tree with CoreLabels");
        }
        CoreLabel cl = (CoreLabel)label;
        cl.setValue(Integer.toString(RNNCoreAnnotations.getPredictedClass(tree)));
    }

    static int setIndexLabels(Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        tree.label().setValue(Integer.toString(index));
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.setIndexLabels(child, index);
        }
        return index;
    }

    static int outputTreeVectors(PrintStream out2, Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        out2.print("  " + index + ":");
        SimpleMatrix vector = RNNCoreAnnotations.getNodeVector(tree);
        for (int i = 0; i < vector.getNumElements(); ++i) {
            out2.print("  " + NF.format(vector.get(i)));
        }
        out2.println();
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.outputTreeVectors(out2, child, index);
        }
        return index;
    }

    static int outputTreeScores(PrintStream out2, Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        out2.print("  " + index + ":");
        SimpleMatrix vector = RNNCoreAnnotations.getPredictions(tree);
        for (int i = 0; i < vector.getNumElements(); ++i) {
            out2.print("  " + NF.format(vector.get(i)));
        }
        out2.println();
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.outputTreeScores(out2, child, index);
        }
        return index;
    }

    static void outputTree(PrintStream out2, CoreMap sentence, List<Output> outputFormats) {
        Tree tree = (Tree)sentence.get(SentimentCoreAnnotations.AnnotatedTree.class);
        block6: for (Output output : outputFormats) {
            switch (output) {
                case PENNTREES: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setSentimentLabels(copy);
                    out2.println(copy);
                    continue block6;
                }
                case VECTORS: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setIndexLabels(copy, 0);
                    out2.println(copy);
                    SentimentPipeline.outputTreeVectors(out2, tree, 0);
                    continue block6;
                }
                case ROOT: {
                    out2.println("  " + (String)sentence.get(SentimentCoreAnnotations.ClassName.class));
                    continue block6;
                }
                case PROBABILITIES: {
                    Tree copy = tree.deepCopy();
                    SentimentPipeline.setIndexLabels(copy, 0);
                    out2.println(copy);
                    SentimentPipeline.outputTreeScores(out2, tree, 0);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown output format " + (Object)((Object)output));
        }
    }

    public static void help() {
        System.err.println("Known command line arguments:");
        System.err.println("  -sentimentModel <model>: Which model to use");
        System.err.println("  -parserModel <model>: Which parser to use");
        System.err.println("  -file <filename>: Which file to process");
        System.err.println("  -fileList <file>,<file>,...: Comma separated list of files to process.  Output goes to file.out");
        System.err.println("  -stdin: Process stdin instead of a file");
        System.err.println("  -input <format>: Which format to input, TEXT or TREES.  Will not process stdin as trees.  Trees need to be binarized");
        System.err.println("  -output <format>: Which format to output, PENNTREES, VECTOR, PROBABILITIES, or ROOT.  Multiple formats can be specified as a comma separated list.");
        System.err.println("  -filterUnknown: remove neutral and unknown trees from the input.  Only applies to TREES input");
    }

    public static Annotation getAnnotation(Input inputFormat, String filename, boolean filterUnknown) {
        switch (inputFormat) {
            case TEXT: {
                String text = IOUtils.slurpFileNoExceptions(filename);
                Annotation annotation = new Annotation(text);
                return annotation;
            }
            case TREES: {
                List<Tree> trees = SentimentUtils.readTreesWithGoldLabels(filename);
                if (filterUnknown) {
                    trees = SentimentUtils.filterUnknownRoots(trees);
                }
                ArrayList<Annotation> sentences = Generics.newArrayList();
                for (Tree tree : trees) {
                    Annotation sentence = new Annotation(Sentence.listToString(tree.yield()));
                    sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, tree);
                    sentences.add(sentence);
                }
                Annotation annotation = new Annotation("");
                annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
                return annotation;
            }
        }
        throw new IllegalArgumentException("Unknown format " + (Object)((Object)inputFormat));
    }

    public static void main(String[] args) throws IOException {
        String parserModel = null;
        String sentimentModel = null;
        String filename = null;
        String fileList = null;
        boolean stdin = false;
        boolean filterUnknown = false;
        List<Output> outputFormats = Arrays.asList(Output.ROOT);
        Input inputFormat = Input.TEXT;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-sentimentModel")) {
                sentimentModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parserModel")) {
                parserModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-file")) {
                filename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-fileList")) {
                fileList = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-stdin")) {
                stdin = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-input")) {
                inputFormat = Input.valueOf(args[argIndex + 1].toUpperCase());
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                String[] formats = args[argIndex + 1].split(",");
                outputFormats = new ArrayList<Output>();
                for (String format : formats) {
                    outputFormats.add(Output.valueOf(format.toUpperCase()));
                }
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-filterUnknown")) {
                filterUnknown = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-help")) {
                SentimentPipeline.help();
                System.exit(0);
                continue;
            }
            System.err.println("Unknown argument " + args[argIndex + 1]);
            throw new IllegalArgumentException("Unknown argument " + args[argIndex + 1]);
        }
        Properties props = new Properties();
        if (sentimentModel != null) {
            props.setProperty("sentiment.model", sentimentModel);
        }
        if (parserModel != null) {
            props.setProperty("parse.model", parserModel);
        }
        if (stdin) {
            props.setProperty("ssplit.eolonly", "true");
        }
        if (inputFormat == Input.TREES) {
            props.setProperty("annotators", "sentiment");
            props.setProperty("enforceRequirements", "false");
        } else {
            props.setProperty("annotators", "tokenize, ssplit, parse, sentiment");
        }
        int count = 0;
        if (filename != null) {
            ++count;
        }
        if (fileList != null) {
            ++count;
        }
        if (stdin) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException("Please only specify one of -file, -fileList or -stdin");
        }
        if (count == 0) {
            throw new IllegalArgumentException("Please specify either -file, -fileList or -stdin");
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        if (filename != null) {
            Annotation annotation = SentimentPipeline.getAnnotation(inputFormat, filename, filterUnknown);
            pipeline.annotate(annotation);
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                System.out.println(sentence);
                SentimentPipeline.outputTree(System.out, sentence, outputFormats);
            }
        } else if (fileList != null) {
            for (String file : fileList.split(",")) {
                Annotation annotation = SentimentPipeline.getAnnotation(inputFormat, file, filterUnknown);
                pipeline.annotate(annotation);
                FileOutputStream fout = new FileOutputStream(file + ".out");
                PrintStream pout = new PrintStream(fout);
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    pout.println(sentence);
                    SentimentPipeline.outputTree(pout, sentence, outputFormats);
                }
                pout.flush();
                fout.close();
            }
        } else {
            String line;
            System.err.println("Reading in text from stdin.");
            System.err.println("Please enter one sentence per line.");
            System.err.println("Processing will end when EOF is reached.");
            BufferedReader reader = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, "utf-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    Annotation annotation = pipeline.process(line);
                    for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                        SentimentPipeline.outputTree(System.out, sentence, outputFormats);
                    }
                    continue;
                }
                System.out.println("");
            }
        }
    }

    static enum Input {
        TEXT,
        TREES;

    }

    static enum Output {
        PENNTREES,
        VECTORS,
        ROOT,
        PROBABILITIES;

    }
}

