/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.sentiment.RNNTrainOptions;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.util.Random;

public class RNNOptions
implements Serializable {
    public int randomSeed = new Random().nextInt();
    public String wordVectors;
    public String unkWord = "UNK";
    public boolean randomWordVectors = true;
    public int numHid = 25;
    public int numClasses = 5;
    public boolean lowercaseWordVectors = false;
    public boolean useTensors = true;
    public TreebankLanguagePack langpack = new PennTreebankLanguagePack();
    public boolean simplifiedModel = true;
    public boolean combineClassification = true;
    public RNNTrainOptions trainOptions = new RNNTrainOptions();
    public static final String[] DEFAULT_CLASS_NAMES = new String[]{"Very negative", "Negative", "Neutral", "Positive", "Very positive"};
    public static final String[] BINARY_DEFAULT_CLASS_NAMES = new String[]{"Negative", "Positive"};
    public String[] classNames = DEFAULT_CLASS_NAMES;
    public static final int[][] APPROXIMATE_EQUIVALENCE_CLASSES = new int[][]{{0, 1}, {3, 4}};
    public static final int[][] BINARY_APPROXIMATE_EQUIVALENCE_CLASSES = new int[][]{{0}, {1}};
    public int[][] equivalenceClasses = APPROXIMATE_EQUIVALENCE_CLASSES;
    public static final String[] DEFAULT_EQUIVALENCE_CLASS_NAMES = new String[]{"Negative", "Positive"};
    public String[] equivalenceClassNames = DEFAULT_EQUIVALENCE_CLASS_NAMES;
    private static final long serialVersionUID = 1L;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GENERAL OPTIONS\n");
        result.append("randomSeed=" + this.randomSeed + "\n");
        result.append("wordVectors=" + this.wordVectors + "\n");
        result.append("unkWord=" + this.unkWord + "\n");
        result.append("randomWordVectors=" + this.randomWordVectors + "\n");
        result.append("numHid=" + this.numHid + "\n");
        result.append("numClasses=" + this.numClasses + "\n");
        result.append("lowercaseWordVectors=" + this.lowercaseWordVectors + "\n");
        result.append("useTensors=" + this.useTensors + "\n");
        result.append("simplifiedModel=" + this.simplifiedModel + "\n");
        result.append("combineClassification=" + this.combineClassification + "\n");
        result.append(this.trainOptions.toString());
        result.append("classNames=" + StringUtils.join(this.classNames, ",") + "\n");
        result.append("equivalenceClasses=");
        if (this.equivalenceClasses != null) {
            for (int i = 0; i < this.equivalenceClasses.length; ++i) {
                if (i > 0) {
                    result.append(";");
                }
                for (int j = 0; j < this.equivalenceClasses[i].length; ++j) {
                    if (j > 0) {
                        result.append(",");
                    }
                    result.append(this.equivalenceClasses[i][j]);
                }
            }
        }
        result.append("\n");
        result.append("equivalenceClassNames=");
        if (this.equivalenceClassNames != null) {
            result.append(StringUtils.join(this.equivalenceClassNames, ","));
        }
        result.append("\n");
        return result.toString();
    }

    public int setOption(String[] args, int argIndex) {
        if (args[argIndex].equalsIgnoreCase("-randomSeed")) {
            this.randomSeed = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-wordVectors")) {
            this.wordVectors = args[argIndex + 1];
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-unkWord")) {
            this.unkWord = args[argIndex] + 1;
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-numHid")) {
            this.numHid = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-numClasses")) {
            this.numClasses = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-lowercaseWordVectors")) {
            this.lowercaseWordVectors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nolowercaseWordVectors")) {
            this.lowercaseWordVectors = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-randomWordVectors")) {
            this.randomWordVectors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-norandomWordVectors")) {
            this.randomWordVectors = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-simplifiedModel")) {
            this.simplifiedModel = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nosimplifiedModel")) {
            this.simplifiedModel = false;
            this.combineClassification = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-combineClassification")) {
            this.combineClassification = true;
            this.simplifiedModel = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nocombineClassification")) {
            this.combineClassification = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-useTensors")) {
            this.useTensors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nouseTensors")) {
            this.useTensors = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-classNames")) {
            this.classNames = args[argIndex + 1].split(",");
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-equivalenceClasses")) {
            if (args[argIndex + 1].trim().length() == 0) {
                this.equivalenceClasses = null;
                return argIndex + 2;
            }
            String[] pieces = args[argIndex + 1].split(";");
            this.equivalenceClasses = new int[pieces.length][];
            for (int i = 0; i < pieces.length; ++i) {
                String[] values = pieces[i].split(",");
                this.equivalenceClasses[i] = new int[values.length];
                for (int j = 0; j < values.length; ++j) {
                    this.equivalenceClasses[i][j] = Integer.valueOf(values[j]);
                }
            }
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-equivalenceClassNames")) {
            this.equivalenceClassNames = args[argIndex + 1].trim().length() > 0 ? args[argIndex + 1].split(",") : null;
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-binaryModel")) {
            this.numClasses = 2;
            this.classNames = BINARY_DEFAULT_CLASS_NAMES;
            this.equivalenceClasses = BINARY_APPROXIMATE_EQUIVALENCE_CLASSES;
            this.trainOptions.setOption(args, argIndex);
            return argIndex + 1;
        }
        return this.trainOptions.setOption(args, argIndex);
    }
}

