/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import java.io.Reader;
import java.util.Properties;

public class WhitespaceTokenizerAnnotator
extends TokenizerAnnotator {
    private final TokenizerFactory<CoreLabel> factory;
    public static final String EOL_PROPERTY = "tokenize.keepeol";

    public WhitespaceTokenizerAnnotator(Properties props) {
        super(false);
        boolean eolIsSignificant = Boolean.valueOf(props.getProperty(EOL_PROPERTY, "false"));
        eolIsSignificant = eolIsSignificant || Boolean.valueOf(props.getProperty("ssplit.eolonly", "false")) != false;
        this.factory = new WhitespaceTokenizer.WhitespaceTokenizerFactory<CoreLabel>(new CoreLabelTokenFactory(), eolIsSignificant);
    }

    @Override
    public Tokenizer<CoreLabel> getTokenizer(Reader r) {
        return this.factory.getTokenizer(r);
    }
}

