/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.EnvLookup;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchRules;
import edu.stanford.nlp.ling.tokensregex.types.Expression;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.time.JodaTimeUtils;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.Partial;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class TimeFormatter {
    private static final Comparator<String> STRING_LENGTH_REV_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    };
    private static final char[] SPECIAL_REGEX_CHARS = new char[]{'[', ']', '(', ')', '{', '}', '?', '*', '.', '|', '\\'};

    private static void parsePatternTo(FormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        block34: for (int i = 0; i < length; ++i) {
            indexRef[0] = i;
            String token = TimeFormatter.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'G': {
                    builder.appendEraText();
                    continue block34;
                }
                case 'C': {
                    builder.appendCenturyOfEra(tokenLen, tokenLen);
                    continue block34;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (tokenLen == 2) {
                        boolean lenientParse = true;
                        if (i + 1 < length) {
                            indexRef[0] = indexRef[0] + 1;
                            if (TimeFormatter.isNumericToken(TimeFormatter.parseToken(pattern, indexRef))) {
                                lenientParse = false;
                            }
                            indexRef[0] = indexRef[0] - 1;
                        }
                        switch (c) {
                            case 'x': {
                                builder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, lenientParse);
                                continue block34;
                            }
                        }
                        builder.appendTwoDigitYear(new DateTime().getYear() - 30, lenientParse);
                        continue block34;
                    }
                    int maxDigits = 4;
                    switch (c) {
                        case 'x': {
                            builder.appendWeekyear(tokenLen, maxDigits);
                            break;
                        }
                        case 'y': {
                            builder.appendYear(tokenLen, maxDigits);
                            break;
                        }
                        case 'Y': {
                            builder.appendYearOfEra(tokenLen, maxDigits);
                        }
                    }
                    continue block34;
                }
                case 'M': {
                    if (tokenLen >= 3) {
                        if (tokenLen >= 4) {
                            builder.appendMonthOfYearText();
                            continue block34;
                        }
                        builder.appendMonthOfYearShortText();
                        continue block34;
                    }
                    builder.appendMonthOfYear(tokenLen);
                    continue block34;
                }
                case 'd': {
                    builder.appendDayOfMonth(tokenLen);
                    continue block34;
                }
                case 'a': {
                    builder.appendHalfdayOfDayText();
                    continue block34;
                }
                case 'h': {
                    builder.appendClockhourOfHalfday(tokenLen);
                    continue block34;
                }
                case 'H': {
                    builder.appendHourOfDay(tokenLen);
                    continue block34;
                }
                case 'k': {
                    builder.appendClockhourOfDay(tokenLen);
                    continue block34;
                }
                case 'K': {
                    builder.appendHourOfHalfday(tokenLen);
                    continue block34;
                }
                case 'm': {
                    builder.appendMinuteOfHour(tokenLen);
                    continue block34;
                }
                case 's': {
                    builder.appendSecondOfMinute(tokenLen);
                    continue block34;
                }
                case 'S': {
                    builder.appendFractionOfSecond(tokenLen, tokenLen);
                    continue block34;
                }
                case 'e': {
                    builder.appendDayOfWeek(tokenLen);
                    continue block34;
                }
                case 'E': {
                    if (tokenLen >= 4) {
                        builder.appendDayOfWeekText();
                        continue block34;
                    }
                    builder.appendDayOfWeekShortText();
                    continue block34;
                }
                case 'D': {
                    builder.appendDayOfYear(tokenLen);
                    continue block34;
                }
                case 'w': {
                    builder.appendWeekOfWeekyear(tokenLen);
                    continue block34;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        builder.appendTimeZoneName();
                        continue block34;
                    }
                    builder.appendTimeZoneShortName();
                    continue block34;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        builder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block34;
                    }
                    if (tokenLen == 2) {
                        builder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block34;
                    }
                    builder.appendTimeZoneId();
                    continue block34;
                }
                case '(': {
                    builder.appendGroupStart();
                    continue block34;
                }
                case ')': {
                    builder.appendGroupEnd();
                    continue block34;
                }
                case '*': 
                case '?': 
                case '{': {
                    builder.appendQuantifier(token);
                    continue block34;
                }
                case '.': 
                case '[': 
                case '\\': 
                case '|': {
                    builder.appendRegexPart(token);
                    continue block34;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        builder.appendLiteral(sub.charAt(0));
                        continue block34;
                    }
                    builder.appendLiteral(new String(sub));
                    continue block34;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
        }
    }

    private static boolean isSpecialRegexChar(char c) {
        for (int i = 0; i < SPECIAL_REGEX_CHARS.length; ++i) {
            if (c != SPECIAL_REGEX_CHARS[i]) continue;
            return true;
        }
        return false;
    }

    private static String parseToken(String pattern, int[] indexRef) {
        int i;
        StringBuffer buf = new StringBuffer();
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char peek;
            buf.append(c);
            while (i + 1 < length && (peek = pattern.charAt(i + 1)) == c) {
                buf.append(c);
                ++i;
            }
        } else if (TimeFormatter.isSpecialRegexChar(c)) {
            buf.append(c);
            if (c == '[') {
                ++i;
                while (i < length) {
                    c = pattern.charAt(i);
                    buf.append(c);
                    if (c != ']') {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (c == '{') {
                ++i;
                while (i < length) {
                    c = pattern.charAt(i);
                    buf.append(c);
                    if (c != '}') {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (c == '\\' && ++i < length) {
                c = pattern.charAt(i);
                buf.append(c);
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i = indexRef[0]; i < length; ++i) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || !TimeFormatter.isSpecialRegexChar(c) && (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    buf.append(c);
                    continue;
                }
                break;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    private static boolean isNumericToken(String token) {
        int tokenLen = token.length();
        if (tokenLen > 0) {
            char c = token.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (tokenLen > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static class FormatterBuilder {
        boolean useRelaxedHour = true;
        Locale locale;
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        List<FormatComponent> pieces = new ArrayList<FormatComponent>();
        int curGroup = 0;

        private FormatterBuilder() {
        }

        public DateTimeFormatter toFormatter() {
            return this.builder.toFormatter();
        }

        public String toTextRegex() {
            StringBuilder sb = new StringBuilder();
            sb.append("\\b");
            for (FormatComponent fc : this.pieces) {
                fc.appendRegex(sb);
            }
            sb.append("\\b");
            return sb.toString();
        }

        public Pattern toTextPattern() {
            return Pattern.compile(this.toTextRegex(), 2);
        }

        private void appendNumericFields(DateTimeFieldType[] fieldTypes, int digits) {
            this.appendNumericFields(fieldTypes, digits, digits);
        }

        private void appendNumericFields(DateTimeFieldType[] fieldTypes, int minDigits, int maxDigits) {
            this.appendComponent(new RelaxedNumericDateComponent(fieldTypes, minDigits, maxDigits), true);
        }

        private void appendNumericField(DateTimeFieldType fieldType, int digits) {
            this.appendNumericField(fieldType, digits, digits);
        }

        private void appendNumericField(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
            this.appendComponent(new NumericDateComponent(fieldType, minDigits, maxDigits), true);
        }

        private void appendTextField(DateTimeFieldType fieldType, boolean isShort) {
            this.appendComponent(new TextDateComponent(fieldType, this.locale, isShort), true);
        }

        private void appendComponent(FormatComponent fc, boolean hasGroup) {
            if (hasGroup) {
                fc.group = ++this.curGroup;
            }
            this.pieces.add(fc);
        }

        private void appendLiteralField(String s) {
            this.appendComponent(new LiteralComponent(s), false);
        }

        private void appendRegexPart(String s) {
            this.appendComponent(new RegexComponent(s), false);
        }

        protected void appendEraText() {
            this.builder.appendEraText();
            this.appendTextField(DateTimeFieldType.era(), false);
        }

        protected void appendCenturyOfEra(int minDigits, int maxDigits) {
            this.builder.appendCenturyOfEra(minDigits, maxDigits);
            this.appendNumericField(DateTimeFieldType.centuryOfEra(), minDigits, maxDigits);
        }

        protected void appendYearOfEra(int minDigits, int maxDigits) {
            this.builder.appendYearOfEra(minDigits, maxDigits);
            this.appendNumericField(DateTimeFieldType.yearOfEra(), minDigits, maxDigits);
        }

        protected void appendYear(int minDigits, int maxDigits) {
            this.builder.appendYear(minDigits, maxDigits);
            this.appendNumericField(DateTimeFieldType.year(), minDigits, maxDigits);
        }

        protected void appendTwoDigitYear(int pivot, boolean lenient) {
            this.builder.appendTwoDigitYear(pivot, lenient);
            this.appendNumericField(DateTimeFieldType.yearOfCentury(), 2);
        }

        protected void appendWeekyear(int minDigits, int maxDigits) {
            this.builder.appendWeekyear(minDigits, maxDigits);
            this.appendNumericField(DateTimeFieldType.weekyear(), minDigits, maxDigits);
        }

        protected void appendTwoDigitWeekyear(int pivot, boolean lenient) {
            this.builder.appendTwoDigitYear(pivot, lenient);
            this.appendNumericField(DateTimeFieldType.yearOfCentury(), 2);
        }

        protected void appendWeekOfWeekyear(int digits) {
            this.builder.appendWeekOfWeekyear(digits);
            this.appendNumericField(DateTimeFieldType.weekOfWeekyear(), digits);
        }

        protected void appendMonthOfYear(int digits) {
            this.builder.appendMonthOfYear(digits);
            this.appendNumericField(DateTimeFieldType.monthOfYear(), digits);
        }

        protected void appendMonthOfYearShortText() {
            this.builder.appendMonthOfYearShortText();
            this.appendTextField(DateTimeFieldType.monthOfYear(), true);
        }

        protected void appendMonthOfYearText() {
            this.builder.appendMonthOfYearText();
            this.appendTextField(DateTimeFieldType.monthOfYear(), false);
        }

        protected void appendDayOfYear(int digits) {
            this.builder.appendDayOfYear(digits);
            this.appendNumericField(DateTimeFieldType.dayOfYear(), digits);
        }

        protected void appendDayOfMonth(int digits) {
            this.builder.appendDayOfMonth(digits);
            this.appendNumericField(DateTimeFieldType.dayOfMonth(), digits);
        }

        protected void appendDayOfWeek(int digits) {
            this.builder.appendDayOfWeek(digits);
            this.appendNumericField(DateTimeFieldType.dayOfWeek(), digits);
        }

        protected void appendDayOfWeekText() {
            this.builder.appendDayOfWeekText();
            this.appendTextField(DateTimeFieldType.dayOfWeek(), false);
        }

        protected void appendDayOfWeekShortText() {
            this.builder.appendDayOfWeekShortText();
            this.appendTextField(DateTimeFieldType.dayOfWeek(), true);
        }

        protected void appendHalfdayOfDayText() {
            this.builder.appendHalfdayOfDayText();
            this.appendTextField(DateTimeFieldType.halfdayOfDay(), false);
        }

        protected void appendClockhourOfDay(int digits) {
            this.builder.appendDayOfYear(digits);
            this.appendNumericField(DateTimeFieldType.clockhourOfDay(), digits);
        }

        protected void appendClockhourOfHalfday(int digits) {
            this.builder.appendClockhourOfHalfday(digits);
            this.appendNumericField(DateTimeFieldType.clockhourOfHalfday(), digits);
        }

        protected void appendHourOfDay(int digits) {
            if (this.useRelaxedHour) {
                this.builder.appendHourOfDay(digits);
                this.appendNumericFields(new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.clockhourOfDay()}, digits);
            } else {
                this.builder.appendHourOfDay(digits);
                this.appendNumericField(DateTimeFieldType.hourOfDay(), digits);
            }
        }

        protected void appendHourOfHalfday(int digits) {
            this.builder.appendHourOfHalfday(digits);
            this.appendNumericField(DateTimeFieldType.hourOfHalfday(), digits);
        }

        protected void appendMinuteOfHour(int digits) {
            this.builder.appendMinuteOfHour(digits);
            this.appendNumericField(DateTimeFieldType.minuteOfHour(), digits);
        }

        protected void appendSecondOfMinute(int digits) {
            this.builder.appendSecondOfMinute(digits);
            this.appendNumericField(DateTimeFieldType.secondOfMinute(), digits);
        }

        protected void appendFractionOfSecond(int minDigits, int maxDigits) {
            this.builder.appendFractionOfSecond(minDigits, maxDigits);
            this.appendNumericField(DateTimeFieldType.millisOfSecond(), minDigits, maxDigits);
        }

        protected void appendTimeZoneOffset(String zeroOffsetText, String zeroOffsetParseText, boolean showSeparators, int minFields, int maxFields) {
            this.builder.appendTimeZoneOffset(zeroOffsetText, zeroOffsetParseText, showSeparators, minFields, maxFields);
            this.appendComponent(new TimeZoneOffsetComponent(zeroOffsetParseText), true);
        }

        protected void appendTimeZoneId() {
            this.builder.appendTimeZoneId();
            this.appendComponent(new TimeZoneIdComponent(), true);
        }

        protected void appendTimeZoneName() {
            this.builder.appendTimeZoneName();
        }

        protected void appendTimeZoneShortName() {
            this.builder.appendTimeZoneShortName();
        }

        protected void appendQuantifier(String str) {
            if (this.pieces.size() <= 0) {
                throw new IllegalArgumentException("Illegal quantifier at beginning of pattern: " + str);
            }
            FormatComponent last = this.pieces.get(this.pieces.size() - 1);
            last.appendQuantifier(str);
        }

        protected void appendGroupStart() {
            this.appendRegexPart("(?:");
        }

        protected void appendGroupEnd() {
            this.appendRegexPart(")");
        }

        protected void appendLiteral(char c) {
            this.builder.appendLiteral(c);
            this.appendLiteralField("" + c);
        }

        protected void appendLiteral(String s) {
            this.builder.appendLiteral(s);
            this.appendLiteralField(s);
        }
    }

    private static class RegexComponent
    extends FormatComponent {
        String regex;

        public RegexComponent(String regex) {
            this.regex = regex;
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            sb.append(this.regex);
            return sb;
        }
    }

    private static class LiteralComponent
    extends FormatComponent {
        String text;

        public LiteralComponent(String str) {
            this.text = str;
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            sb.append(Pattern.quote(this.text));
            return sb;
        }
    }

    private static class TimeZoneIdComponent
    extends FormatComponent {
        static Map<String, DateTimeZone> valueMapping;
        static List<String> validValues;

        public DateTimeZone parseDateTimeZone(String str) {
            str = str.toLowerCase();
            DateTimeZone v = valueMapping.get(str);
            return v;
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            boolean first = true;
            for (String v : validValues) {
                if (first) {
                    first = false;
                } else {
                    sb.append("|");
                }
                sb.append(Pattern.quote(v));
            }
            return sb;
        }

        @Override
        public SUTime.Temporal updateTemporal(SUTime.Temporal t, String fieldValueStr) {
            if (fieldValueStr != null) {
                DateTimeZone dtz = this.parseDateTimeZone(fieldValueStr);
                return t.setTimeZone(dtz);
            }
            return t;
        }

        static {
            validValues = new ArrayList<String>(DateTimeZone.getAvailableIDs());
            valueMapping = Generics.newHashMap();
            for (String str : validValues) {
                valueMapping.put(str.toLowerCase(), DateTimeZone.forID((String)str));
            }
            Collections.sort(validValues, STRING_LENGTH_REV_COMPARATOR);
        }
    }

    private static class TimeZoneOffsetComponent
    extends FormatComponent {
        String zeroOffsetParseText;

        public TimeZoneOffsetComponent(String zeroOffsetParseText) {
            this.zeroOffsetParseText = zeroOffsetParseText;
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            sb.append("[+-]\\d\\d(?::?\\d\\d(?::?\\d\\d(?:[.,]?\\d{1,3})?)?)?");
            if (this.zeroOffsetParseText != null) {
                sb.append("|").append(Pattern.quote(this.zeroOffsetParseText));
            }
            return sb;
        }

        private int parseInteger(String str, int pos, int length) {
            return Integer.parseInt(str.substring(pos, pos + length));
        }

        public int parseOffsetMillis(String str) {
            int offset = 0;
            if (this.zeroOffsetParseText != null && str.equalsIgnoreCase(this.zeroOffsetParseText)) {
                return offset;
            }
            boolean negative = false;
            if (!str.startsWith("+")) {
                if (str.startsWith("-")) {
                    negative = true;
                } else {
                    throw new IllegalArgumentException("Invalid date time zone offset " + str);
                }
            }
            int pos = 1;
            offset += 3600000 * this.parseInteger(str, pos, 2);
            if ((pos += 2) < str.length()) {
                if (!Character.isDigit(str.charAt(pos))) {
                    ++pos;
                }
                offset += 60000 * this.parseInteger(str, pos, 2);
                if ((pos += 2) < str.length()) {
                    if (!Character.isDigit(str.charAt(pos))) {
                        ++pos;
                    }
                    offset += 1000 * this.parseInteger(str, pos, 2);
                    if ((pos += 2) < str.length()) {
                        int digits;
                        if (!Character.isDigit(str.charAt(pos))) {
                            ++pos;
                        }
                        if ((digits = str.length() - pos) > 0) {
                            if (digits <= 3) {
                                int frac = this.parseInteger(str, pos, digits);
                                if (digits == 1) {
                                    offset += frac * 100;
                                } else if (digits == 2) {
                                    offset += frac * 10;
                                } else if (digits == 3) {
                                    offset += frac;
                                }
                            } else {
                                throw new IllegalArgumentException("Invalid date time zone offset " + str);
                            }
                        }
                    }
                }
            }
            return offset;
        }

        @Override
        public SUTime.Temporal updateTemporal(SUTime.Temporal t, String fieldValueStr) {
            int offset = this.parseOffsetMillis(fieldValueStr);
            DateTimeZone dtz = DateTimeZone.forOffsetMillis((int)offset);
            return t.setTimeZone(dtz);
        }
    }

    private static class TextDateComponent
    extends DateTimeFieldComponent {
        Map<String, Integer> valueMapping;
        List<String> validValues;
        Locale locale;
        int minValue;
        int maxValue;
        Boolean isShort;

        public TextDateComponent() {
        }

        public TextDateComponent(DateTimeFieldType fieldType, Locale locale, Boolean isShort) {
            this.fieldType = fieldType;
            this.locale = locale;
            this.isShort = isShort;
            MutableDateTime dt = new MutableDateTime(0L, DateTimeZone.UTC);
            MutableDateTime.Property property = dt.property(fieldType);
            this.minValue = property.getMinimumValueOverall();
            this.maxValue = property.getMaximumValueOverall();
            this.validValues = new ArrayList<String>(this.maxValue - this.minValue + 1);
            this.valueMapping = Generics.newHashMap();
            for (int i = this.minValue; i <= this.maxValue; ++i) {
                property.set(i);
                if (isShort != null) {
                    if (isShort.booleanValue()) {
                        this.addValue(property.getAsShortText(locale), i);
                        continue;
                    }
                    this.addValue(property.getAsText(locale), i);
                    continue;
                }
                this.addValue(property.getAsShortText(locale), i);
                this.addValue(property.getAsText(locale), i);
            }
            Collections.sort(this.validValues, STRING_LENGTH_REV_COMPARATOR);
        }

        public void addValue(String str, int v) {
            this.validValues.add(str);
            this.valueMapping.put(str.toLowerCase(this.locale), v);
        }

        @Override
        public Integer parseValue(String str) {
            str = str.toLowerCase(this.locale);
            Integer v = this.valueMapping.get(str);
            return v;
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            boolean first = true;
            for (String v : this.validValues) {
                if (first) {
                    first = false;
                } else {
                    sb.append("|");
                }
                sb.append(Pattern.quote(v));
            }
            return sb;
        }
    }

    private static class RelaxedNumericDateComponent
    extends FormatComponent {
        NumericDateComponent[] possibleNumericDateComponents;
        int minDigits;
        int maxDigits;

        public RelaxedNumericDateComponent(DateTimeFieldType[] fieldTypes, int minDigits, int maxDigits) {
            this.minDigits = minDigits;
            this.maxDigits = maxDigits;
            this.possibleNumericDateComponents = new NumericDateComponent[fieldTypes.length];
            for (int i = 0; i < fieldTypes.length; ++i) {
                this.possibleNumericDateComponents[i] = new NumericDateComponent(fieldTypes[i], minDigits, maxDigits);
            }
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            if (this.maxDigits > 5 || this.minDigits != this.maxDigits) {
                sb.append("\\d{").append(this.minDigits).append(",").append(this.maxDigits).append("}");
            } else {
                for (int i = 0; i < this.minDigits; ++i) {
                    sb.append("\\d");
                }
            }
            return sb;
        }

        @Override
        public SUTime.Temporal updateTemporal(SUTime.Temporal t, String fieldValueStr) {
            if (fieldValueStr != null) {
                for (NumericDateComponent c : this.possibleNumericDateComponents) {
                    Integer v = c.parseValue(fieldValueStr);
                    if (v == null) continue;
                    t = c.updateTemporal(t, fieldValueStr);
                    return t;
                }
                throw new IllegalArgumentException("Cannot interpret " + fieldValueStr);
            }
            return t;
        }
    }

    private static class NumericDateComponent
    extends DateTimeFieldComponent {
        int minValue;
        int maxValue;
        int minDigits;
        int maxDigits;

        public NumericDateComponent(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
            this.fieldType = fieldType;
            this.minDigits = minDigits;
            this.maxDigits = maxDigits;
            MutableDateTime dt = new MutableDateTime(0L, DateTimeZone.UTC);
            MutableDateTime.Property property = dt.property(fieldType);
            this.minValue = property.getMinimumValueOverall();
            this.maxValue = property.getMaximumValueOverall();
        }

        @Override
        protected StringBuilder appendRegex0(StringBuilder sb) {
            if (this.maxDigits > 5 || this.minDigits != this.maxDigits) {
                sb.append("\\d{").append(this.minDigits).append(",").append(this.maxDigits).append("}");
            } else {
                for (int i = 0; i < this.minDigits; ++i) {
                    sb.append("\\d");
                }
            }
            return sb;
        }

        @Override
        public Integer parseValue(String str) {
            int v = Integer.valueOf(str);
            if (v >= this.minValue && v <= this.maxValue) {
                return v;
            }
            return null;
        }
    }

    private static abstract class DateTimeFieldComponent
    extends FormatComponent {
        DateTimeFieldType fieldType;

        private DateTimeFieldComponent() {
        }

        public Integer parseValue(String str) {
            return null;
        }

        public DateTimeFieldType getDateTimeFieldType() {
            return this.fieldType;
        }

        @Override
        public SUTime.Temporal updateTemporal(SUTime.Temporal t, String fieldValueStr) {
            DateTimeFieldType dt = this.getDateTimeFieldType();
            if (fieldValueStr != null && dt != null) {
                Integer v = this.parseValue(fieldValueStr);
                if (v != null) {
                    Partial pt = new Partial();
                    pt = JodaTimeUtils.setField(pt, dt, v);
                    t = t.intersect(new SUTime.PartialTime(pt));
                } else {
                    throw new IllegalArgumentException("Cannot interpret " + fieldValueStr + " for " + this.fieldType);
                }
            }
            return t;
        }
    }

    private static abstract class FormatComponent {
        int group = -1;
        String quantifier = null;

        private FormatComponent() {
        }

        public void appendQuantifier(String str) {
            this.quantifier = this.quantifier != null ? this.quantifier + str : str;
        }

        public StringBuilder appendRegex(StringBuilder sb) {
            if (this.group > 0) {
                sb.append("(");
            }
            this.appendRegex0(sb);
            if (this.quantifier != null) {
                sb.append(this.quantifier);
            }
            if (this.group > 0) {
                sb.append(")");
            }
            return sb;
        }

        protected abstract StringBuilder appendRegex0(StringBuilder var1);

        public SUTime.Temporal updateTemporal(SUTime.Temporal t, String fieldValueStr) {
            return t;
        }

        public int getGroup() {
            return this.group;
        }
    }

    public static class CustomDateFormatExtractor
    implements Function<String, Value> {
        FormatterBuilder builder;
        String timePattern;
        Pattern textPattern;

        public CustomDateFormatExtractor(String timePattern) {
            this.timePattern = timePattern;
            this.builder = new FormatterBuilder();
            TimeFormatter.parsePatternTo(this.builder, timePattern);
            this.textPattern = this.builder.toTextPattern();
        }

        public Pattern getTextPattern() {
            return this.textPattern;
        }

        @Override
        public Value apply(String str) {
            Value v = null;
            Matcher m = this.textPattern.matcher(str);
            if (m.matches()) {
                return this.apply(m);
            }
            return v;
        }

        @Override
        public Value apply(MatchResult m) {
            SUTime.Temporal t = new SUTime.PartialTime();
            for (FormatComponent fc : this.builder.pieces) {
                String fieldValueStr;
                int group = fc.getGroup();
                if (group <= 0 || (fieldValueStr = m.group(group)) == null) continue;
                try {
                    t = fc.updateTemporal(t, fieldValueStr);
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }
            return new Expressions.PrimitiveValue<SUTime.PartialTime>("Temporal", (SUTime.PartialTime)t, new String[0]);
        }
    }

    static class TimePatternExtractRuleCreator
    extends SequenceMatchRules.AnnotationExtractRuleCreator {
        TimePatternExtractRuleCreator() {
        }

        protected void updateExtractRule(SequenceMatchRules.AnnotationExtractRule r, Env env, Pattern pattern, Function<String, Value> extractor) {
            MatchedExpression.SingleAnnotationExtractor valueExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            valueExtractor.valueExtractor = new SequenceMatchRules.CoreMapFunctionApplier<String, Value>(r.annotationField, extractor);
            r.extractRule = new SequenceMatchRules.CoreMapExtractRule(r.annotationField, new SequenceMatchRules.StringPatternExtractRule<MatchedExpression>(pattern, new SequenceMatchRules.StringMatchedExpressionExtractor(valueExtractor, r.matchedExpressionGroup)));
            r.filterRule = new SequenceMatchRules.AnnotationMatchedFilter(valueExtractor);
        }

        protected void updateExtractRule(SequenceMatchRules.AnnotationExtractRule r, Env env, Function<CoreMap, Value> extractor) {
            MatchedExpression.SingleAnnotationExtractor valueExtractor = SequenceMatchRules.createAnnotationExtractor(env, r);
            valueExtractor.valueExtractor = extractor;
            r.extractRule = new SequenceMatchRules.CoreMapExtractRule<List<? extends CoreMap>, MatchedExpression>(r.annotationField, new SequenceMatchRules.BasicSequenceExtractRule(valueExtractor));
            r.filterRule = new SequenceMatchRules.AnnotationMatchedFilter(valueExtractor);
        }

        @Override
        public SequenceMatchRules.AnnotationExtractRule create(Env env, Map<String, Object> attributes) {
            SequenceMatchRules.AnnotationExtractRule r = super.create(env, attributes);
            if (r.ruleType == null) {
                r.ruleType = "time";
            }
            String expr = (String)Expressions.asObject(env, attributes.get("pattern"));
            String formatter = (String)Expressions.asObject(env, attributes.get("formatter"));
            Expression action = Expressions.asExpression(env, attributes.get("action"));
            if (formatter == null) {
                if (r.annotationField == null) {
                    r.annotationField = EnvLookup.getDefaultTextAnnotationKey(env);
                }
                CustomDateFormatExtractor formatExtractor = new CustomDateFormatExtractor(expr);
                this.updateExtractRule(r, env, formatExtractor.getTextPattern(), new ApplyActionWrapper<String, Value>(env, formatExtractor, action));
            } else if ("org.joda.time.format.DateTimeFormat".equals(formatter)) {
                if (r.annotationField == null) {
                    r.annotationField = r.tokensAnnotationField;
                }
                this.updateExtractRule(r, env, new ApplyActionWrapper<CoreMap, Value>(env, new JodaDateTimeFormatExtractor(expr), action));
            } else if ("org.joda.time.format.ISODateTimeFormat".equals(formatter)) {
                if (r.annotationField == null) {
                    r.annotationField = r.tokensAnnotationField;
                }
                try {
                    Method m = ISODateTimeFormat.class.getMethod(expr, new Class[0]);
                    DateTimeFormatter dtf = (DateTimeFormatter)m.invoke(null, new Object[0]);
                    this.updateExtractRule(r, env, new ApplyActionWrapper<CoreMap, Value>(env, new JodaDateTimeFormatExtractor(expr), action));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error creating DateTimeFormatter", ex);
                }
            } else if ("java.text.SimpleDateFormat".equals(formatter)) {
                if (r.annotationField == null) {
                    r.annotationField = r.tokensAnnotationField;
                }
                this.updateExtractRule(r, env, new ApplyActionWrapper<CoreMap, Value>(env, new JavaDateFormatExtractor(expr), action));
            } else {
                throw new IllegalArgumentException("Unsupported formatter: " + formatter);
            }
            return r;
        }
    }

    static class ApplyActionWrapper<I, O>
    implements Function<I, O> {
        Env env;
        Function<I, O> base;
        Expression action;

        ApplyActionWrapper(Env env, Function<I, O> base, Expression action) {
            this.env = env;
            this.base = base;
            this.action = action;
        }

        @Override
        public O apply(I in) {
            O v = this.base.apply(in);
            if (this.action != null) {
                this.action.evaluate(this.env, v);
            }
            return v;
        }
    }

    public static class JodaDateTimeFormatExtractor
    implements Function<CoreMap, Value> {
        static final Class<CoreAnnotations.TextAnnotation> textAnnotationField = CoreAnnotations.TextAnnotation.class;
        DateTimeFormatter formatter;

        public JodaDateTimeFormatExtractor(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public JodaDateTimeFormatExtractor(String pattern) {
            this.formatter = DateTimeFormat.forPattern((String)pattern);
        }

        @Override
        public Value apply(CoreMap m) {
            try {
                String str = (String)m.get(textAnnotationField);
                DateTime d = this.formatter.parseDateTime(str);
                return new Expressions.PrimitiveValue<SUTime.GroundedTime>("GroundedTime", new SUTime.GroundedTime((ReadableInstant)d), new String[0]);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }

    public static class JavaDateFormatExtractor
    implements Function<CoreMap, Value> {
        static final Class<CoreAnnotations.TextAnnotation> textAnnotationField = CoreAnnotations.TextAnnotation.class;
        SimpleDateFormat format;

        public JavaDateFormatExtractor(String pattern) {
            this.format = new SimpleDateFormat(pattern);
        }

        @Override
        public Value apply(CoreMap m) {
            try {
                String str = (String)m.get(textAnnotationField);
                Date d = this.format.parse(str);
                return new Expressions.PrimitiveValue<SUTime.GroundedTime>("GroundedTime", new SUTime.GroundedTime((ReadableInstant)new Instant(d.getTime())), new String[0]);
            }
            catch (ParseException ex) {
                return null;
            }
        }
    }
}

