/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.time.EnglishTimeExpressionPatterns;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Interval;
import java.util.Collections;
import java.util.List;

public class TimeExpression
extends MatchedExpression {
    SUTime.Temporal origTemporal;
    protected static final Function<MatchedExpression, TimeExpression> TimeExpressionConverter = new Function<MatchedExpression, TimeExpression>(){

        @Override
        public TimeExpression apply(MatchedExpression in) {
            if (in == null) {
                return null;
            }
            if (in instanceof TimeExpression) {
                return (TimeExpression)in;
            }
            TimeExpression newExpr = new TimeExpression(in);
            if (newExpr.getAnnotation().get(Annotation.class) == in) {
                newExpr.getAnnotation().set(Annotation.class, newExpr);
            }
            return newExpr;
        }
    };

    public TimeExpression(MatchedExpression expr) {
        super(expr);
    }

    public TimeExpression(Interval<Integer> charOffsets, Interval<Integer> tokenOffsets, Function<CoreMap, SUTime.Temporal> temporalFunc, double priority, double weight) {
        super(charOffsets, tokenOffsets, TimeExpression.getSingleAnnotationExtractor(temporalFunc), priority, weight);
    }

    private static MatchedExpression.SingleAnnotationExtractor getSingleAnnotationExtractor(final Function<CoreMap, SUTime.Temporal> temporalFunc) {
        MatchedExpression.SingleAnnotationExtractor extractFunc = new MatchedExpression.SingleAnnotationExtractor();
        extractFunc.valueExtractor = new Function<CoreMap, Value>(){

            @Override
            public Value apply(CoreMap in) {
                SUTime.Temporal t = (SUTime.Temporal)temporalFunc.apply(in);
                return new Expressions.PrimitiveValue<SUTime.Temporal>("Temporal", t, new String[0]);
            }
        };
        extractFunc.tokensAnnotationField = CoreAnnotations.NumerizedTokensAnnotation.class;
        extractFunc.resultAnnotationField = Collections.singletonList(Annotation.class);
        extractFunc.resultNestedAnnotationField = ChildrenAnnotation.class;
        extractFunc.resultAnnotationExtractor = TimeExpressionConverter;
        extractFunc.tokensAggregators = CoreMapAttributeAggregator.DEFAULT_NUMERIC_TOKENS_AGGREGATORS;
        return extractFunc;
    }

    public boolean addMod() {
        SUTime.Temporal t = this.getTemporal();
        if (t != null) {
            if (t != SUTime.TIME_NONE_OK) {
                this.setTemporal(EnglishTimeExpressionPatterns.addMod(this.text, t));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean extractAnnotation(Env env, CoreMap sourceAnnotation) {
        boolean okay = super.extractAnnotation(env, sourceAnnotation);
        if (okay) {
            return this.addMod();
        }
        return false;
    }

    @Override
    public boolean extractAnnotation(Env env, List<? extends CoreMap> source) {
        boolean okay = super.extractAnnotation(env, source);
        if (okay) {
            return this.addMod();
        }
        return false;
    }

    public SUTime.Temporal getTemporal() {
        if (this.value != null && this.value.get() instanceof SUTime.Temporal) {
            return (SUTime.Temporal)this.value.get();
        }
        return null;
    }

    public void setTemporal(SUTime.Temporal temporal) {
        this.value = new Expressions.PrimitiveValue<SUTime.Temporal>("Temporal", temporal, new String[0]);
    }

    public static class ChildrenAnnotation
    implements CoreAnnotation<List<? extends CoreMap>> {
        @Override
        public Class<List<? extends CoreMap>> getType() {
            return (Class)ErasureUtils.uncheckedCast(List.class);
        }
    }

    public static class Annotation
    implements CoreAnnotation<TimeExpression> {
        @Override
        public Class<TimeExpression> getType() {
            return TimeExpression.class;
        }
    }

    public static class TimeIndexAnnotation
    implements CoreAnnotation<SUTime.TimeIndex> {
        @Override
        public Class<SUTime.TimeIndex> getType() {
            return SUTime.TimeIndex.class;
        }
    }
}

