/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.CoreMapExpressionExtractor;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchRules;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.time.EnglishDateTimeUtils;
import edu.stanford.nlp.time.Options;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.time.TimeExpressionExtractors;
import edu.stanford.nlp.time.TimeExpressionPatterns;
import edu.stanford.nlp.time.TimeFormatter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public class EnglishTimeExpressionPatterns
implements TimeExpressionPatterns {
    private static final Logger logger = Logger.getLogger(EnglishTimeExpressionPatterns.class.getName());
    Env env;
    SequenceMatchRules.ExtractRule<CoreMap, TimeExpression> timeExtractionRule;
    SequenceMatchRules.ExtractRule<List<? extends CoreMap>, TimeExpression> compositeTimeExtractionRule;
    List<Filter<TimeExpression>> filterRules;
    Options options;
    private static final Pattern teUnit = Pattern.compile("(second|minute|hour|day|month|quarter|year|week|decade|centur(y|ie)|millenn?i(um|a))", 2);
    private static final Pattern numTerm = Pattern.compile("(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eighteen|nineteen|twenty|thirty|forty|fifty|sixty|seventy|eighty|ninety|hundred|thousand|million|billion|trillion|first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth|hundreth|thousandth|millionth|billionth|trillionth)", 2);
    private static final Pattern numOrdTerm = Pattern.compile("(first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth|hundreth|thousandth|millionth|billionth|trillionth)", 2);
    private static final Pattern numNoOrdTerm = Pattern.compile("(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eighteen|nineteen|twenty|thirty|forty|fifty|sixty|seventy|eighty|ninety|hundred|thousand|million|billion|trillion)", 2);
    private static final Pattern teDay = Pattern.compile("(monday|tuesday|wednesday|thursday|friday|saturday|sunday)", 2);
    private static final Pattern teDayAbbr = Pattern.compile("(mon\\.?|tue\\?|wed\\.?|thu\\.?|fri\\.?|sat\\.?|\\sun\\.?)", 2);
    private static final Pattern teMonth = Pattern.compile("(january|february|march|april|may|june|july|august|september|october|november|december)", 2);
    private static final Pattern teMonthAbbr = Pattern.compile("(jan|feb|mar|apr|may|jun|jul|aug|sep|sept|oct|nov|dec)", 2);
    private static final Pattern teOrdinalWords = Pattern.compile("(tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|twenty-first|twenty-second|twenty-third|twenty-fourth|twenty-fifth|twenty-sixth|twenty-seventh|twenty-eighth|twenty-ninth|thirtieth|thirty-first|first|second|third|fourth|fifth|sixth|seventh|eighth|ninth)", 2);
    private static final Pattern teNumOrds = Pattern.compile("([23]?1-?st|11-?th|[23]?2-?nd|12-?th|[12]?3-?rd|13-?th|[12]?[4-90]-?th|30-?th)", 2);
    List<TimeExpressionExtractors.DurationRule> durationRules = new ArrayList<TimeExpressionExtractors.DurationRule>();
    final List<SequenceMatchRules.ExtractRule<String, TimeExpression>> dateTimeStringRules = new ArrayList<SequenceMatchRules.ExtractRule<String, TimeExpression>>();
    final List<SequenceMatchRules.ExtractRule<List<? extends CoreMap>, TimeExpression>> dateTimeTokenSeqRules = new ArrayList<SequenceMatchRules.ExtractRule<List<? extends CoreMap>, TimeExpression>>();
    private final TokenSequencePattern VB_NODE_PATTERN1 = TokenSequencePattern.compile("[ { tag:/VBP|VBZ|VBD|MD/ } ]");
    private static final TokenSequencePattern VB_NODE_PATTERN2 = TokenSequencePattern.compile("[ { tag:/VB[A-Z]/ } ]");
    private static final TokenSequencePattern GOING_TO = TokenSequencePattern.compile("/(?i)going/ /(?i)to/");
    Map<String, SUTime.TemporalOp> wordToTemporalOp = Generics.newHashMap();
    Map<String, SUTime.Temporal> wordToTemporal = Generics.newHashMap();
    Map<String, SUTime.Duration> abbToTimeUnit = Generics.newHashMap();

    public EnglishTimeExpressionPatterns(Options options) {
        this.options = options;
        this.initTimeUnitsMap();
        this.initTemporalMap();
        this.initTemporalOpMap();
        this.initEnv();
        this.initRules();
    }

    @Override
    public CoreMapExpressionExtractor createExtractor() {
        CoreMapExpressionExtractor<TimeExpression> expressionExtractor = new CoreMapExpressionExtractor<TimeExpression>(this.env);
        expressionExtractor.setExtractRules(this.getTimeExtractionRule(), this.getCompositeTimeExtractionRule(), this.getFilterRule());
        return expressionExtractor;
    }

    private void initEnv() {
        this.env = TokenSequencePattern.getNewEnv();
        this.env.setDefaultResultsAnnotationExtractor(TimeExpression.TimeExpressionConverter);
        this.env.setDefaultTokensAnnotationKey(CoreAnnotations.NumerizedTokensAnnotation.class);
        this.env.setDefaultResultAnnotationKey(TimeExpression.Annotation.class);
        this.env.setDefaultNestedResultsAnnotationKey(TimeExpression.ChildrenAnnotation.class);
        this.env.bind("time", new TimeFormatter.TimePatternExtractRuleCreator());
        this.env.setDefaultStringPatternFlags(2);
        this.env.bind("numcomptype", CoreAnnotations.NumericCompositeTypeAnnotation.class);
        this.env.bind("numcompvalue", CoreAnnotations.NumericCompositeValueAnnotation.class);
        this.env.bind("temporal", TimeExpression.Annotation.class);
        this.env.bind("::IS_TIMEX_DATE", new TimexTypeMatchNodePattern(SUTime.TimexType.DATE));
        this.env.bind("::IS_TIMEX_DURATION", new TimexTypeMatchNodePattern(SUTime.TimexType.DURATION));
        this.env.bind("::IS_TIMEX_TIME", new TimexTypeMatchNodePattern(SUTime.TimexType.TIME));
        this.env.bind("::IS_TIMEX_SET", new TimexTypeMatchNodePattern(SUTime.TimexType.SET));
        this.env.bind("$RELDAY", "/today|yesterday|tomorrow|tonight|tonite/");
        this.env.bind("$SEASON", "/spring|summer|fall|autumn|winter/");
        this.env.bind("$TIMEOFDAY", "/morning|afternoon|evening|night|noon|midnight|teatime|lunchtime|dinnertime|suppertime|afternoon|midday|dusk|dawn|sunup|sunrise|sundown|twilight|daybreak/");
        this.env.bind("$TEDAY", "/" + teDay.pattern() + "|" + teDayAbbr.pattern() + "/");
        this.env.bind("$TEDAYS", "/" + teDay.pattern() + "s?|" + teDayAbbr.pattern() + "/");
        this.env.bind("$TEMONTH", "/" + teMonth.pattern() + "|" + teMonthAbbr.pattern() + "/");
        this.env.bind("$TEMONTHS", "/" + teMonth.pattern() + "s?|" + teMonthAbbr.pattern() + "\\.?s?/");
        this.env.bind("$TEUNITS", "/" + teUnit.pattern() + "s?/");
        this.env.bind("$TEUNIT", "/" + teUnit.pattern() + "/");
        this.env.bind("$NUM", TokenSequencePattern.compile(this.env, "[ { numcomptype:NUMBER } ]"));
        this.env.bind("$INT", TokenSequencePattern.compile(this.env, " [ { numcomptype:NUMBER } & !{ word:/.*\\.\\d+.*/} & !{ word:/.*,.*/ } ] "));
        this.env.bind("$INT1000TO3000", TokenSequencePattern.compile(this.env, "[ $INT & !{ word:/\\+.*/} & { numcompvalue>1000 } & { numcompvalue<3000 } ] "));
        this.env.bind("$INT1TO31", TokenSequencePattern.compile(this.env, "[ $INT & !{ word:/\\+.*/} & { numcompvalue>=1 } & { numcompvalue<=31 } ] "));
        this.env.bind("$NUM_ORD", TokenSequencePattern.compile(this.env, "[ { numcomptype:ORDINAL } ]"));
        this.env.bind("$INT_TIMES", TokenSequencePattern.compile(this.env, " $INT /times/ | once | twice | thrice "));
        this.env.bind("$REL_MOD", TokenSequencePattern.compile(this.env, "/the/? /next|following|last|previous/ | /this/ /coming|past/? | /the/ /coming|past/"));
        this.env.bind("$FREQ_MOD", TokenSequencePattern.compile(this.env, "/each/ | /every/ $NUM_ORD | /every/ /other|alternate|alternating/? | /alternate|alternating/ "));
        this.env.bind("$EARLY_LATE_MOD", TokenSequencePattern.compile(this.env, "/late|early|mid-?/ | /the/? /beginning|start|dawn|middle|end/ /of/"));
        this.env.bind("$APPROX_MOD", TokenSequencePattern.compile(this.env, "/about|around|some|exactly|precisely/"));
        this.env.bind("$YEAR", "/[012]\\d\\d\\d|'\\d\\d/ | /\\w+teen/ [ { numcompvalue<=100 } & { numcompvalue>0 } & $INT ] ");
        this.env.bind("$POSSIBLE_YEAR", " $YEAR | $INT /a\\.?d\\.?|b\\.?c\\.?/ | $INT1000TO3000 ");
        this.env.bind("$TEUNITS_NODE", TokenSequencePattern.compile(this.env, "[ /" + teUnit.pattern() + "s?/" + " & { tag:/NN.*/ } ]"));
        this.env.bindStringRegex("$NUM_TERM", numTerm.pattern());
        this.env.bindStringRegex("$NUM_ORD_TERM", numOrdTerm.pattern());
        this.env.bindStringRegex("$NUM_NO_ORD_TERM", numNoOrdTerm.pattern());
        this.env.bindStringRegex("$TEmonth", teMonth.pattern());
        this.env.bindStringRegex("$TEmonthabbr", teMonthAbbr.pattern());
        this.env.bindStringRegex("$TEUnits", teUnit.pattern());
        this.env.bindStringRegex("$OT", "\\\\b");
        this.env.bindStringRegex("$CT", "\\\\b");
        this.env.bindStringRegex("$TEOrdinalWords", teOrdinalWords.pattern());
        this.env.bindStringRegex("$TENumOrds", teNumOrds.pattern());
    }

    private void initRules() {
        this.initDurationRules();
        this.initDateTimeRules();
        final SequenceMatchRules.ListExtractRule stringExtractRule = new SequenceMatchRules.ListExtractRule(new SequenceMatchRules.ExtractRule[0]);
        final SequenceMatchRules.ListExtractRule tokenSeqExtractRule = new SequenceMatchRules.ListExtractRule(new SequenceMatchRules.ExtractRule[0]);
        for (TimeExpressionExtractors.DurationRule durationRule : this.durationRules) {
            Function r;
            if (durationRule.useTokens()) {
                r = new SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression>(durationRule.tokenPattern, new TimeExpressionExtractors.SequenceMatchExtractor(durationRule, false, durationRule.exprGroup));
                tokenSeqExtractRule.addRules(new SequenceMatchRules.ExtractRule[]{r});
                continue;
            }
            r = new SequenceMatchRules.StringPatternExtractRule<TimeExpression>(this.env, durationRule.stringPattern.pattern(), new TimeExpressionExtractors.StringMatchExtractor(durationRule, false, durationRule.exprGroup), true);
            stringExtractRule.addRules(new SequenceMatchRules.ExtractRule[]{r});
        }
        stringExtractRule.addRules(this.dateTimeStringRules);
        tokenSeqExtractRule.addRules(this.dateTimeTokenSeqRules);
        this.timeExtractionRule = new SequenceMatchRules.ExtractRule<CoreMap, TimeExpression>(){

            @Override
            public boolean extract(CoreMap in, List<TimeExpression> out2) {
                List tokens = (List)in.get(CoreAnnotations.NumerizedTokensAnnotation.class);
                boolean tsex = tokens != null && tokenSeqExtractRule.extract(tokens, out2);
                String text = (String)in.get(CoreAnnotations.TextAnnotation.class);
                boolean strex = text != null && stringExtractRule.extract(text, out2);
                return tsex || strex;
            }
        };
        TimeExpressionExtractors.GenericTimePatternExtractor adjTimeExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " /the/? ( ( [ { temporal::EXISTS } ] ) /,|of|in/? ( [ { temporal::IS_TIMEX_DATE } | { temporal::IS_TIMEX_TIME } ] ) |  ( [ { temporal::IS_TIMEX_DATE } ] ) /at/  ( [ { temporal::IS_TIMEX_TIME } ] ) |  ( [ { temporal::IS_TIMEX_TIME } | { temporal::IS_TIMEX_DURATION } ] ) /on/  ( [ { temporal::IS_TIMEX_DATE } ] ) |  ( [ { temporal::IS_TIMEX_DATE } | { temporal::IS_TIMEX_TIME } ] ) (/'s/ | /'/ /s/) ( [ { temporal::EXISTS } ] ) )"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalComposeFunc(new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.INTERSECT), new TimeExpressionExtractors.TemporalGetTEFunc(1, 0), new TimeExpressionExtractors.TemporalGetTEFunc(1, -1)));
        TimeExpressionExtractors.GenericTimePatternExtractor dateTodayExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( [ { temporal::IS_TIMEX_DATE } | { temporal::IS_TIMEX_TIME } ] )  (/today|tonight/)"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalGetTEFunc(0, 0));
        TimeExpressionExtractors.GenericTimePatternExtractor relTimeExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( [ { temporal::IS_TIMEX_DURATION } ] )  (/before|from|since|after/ | /prior/ /to/) ( [ ({ temporal::IS_TIMEX_TIME }  |  { temporal::IS_TIMEX_DATE }) ] )"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalComposeFunc(new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.OFFSET), new TimeExpressionExtractors.TemporalGetTEFunc(0, -1), new TimeExpressionExtractors.TemporalComposeObjFunc(new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.MULTIPLY), new TimeExpressionExtractors.TemporalGetTEFunc(0, 0), new Function<MatchResult, Integer>(){

            @Override
            public Integer apply(MatchResult in) {
                String rel = in.group(2).toLowerCase();
                if ("before".equals(rel) || "prior to".equals(rel)) {
                    return -1;
                }
                return 1;
            }
        })));
        TimeExpressionExtractors.GenericTimePatternExtractor relDurationExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( [ { temporal::IS_TIMEX_DURATION } ] )  (/earlier|later|ago|hence/ | /from/ /now/) "), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalComposeFunc(new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.OFFSET), new TimeExpressionExtractors.TemporalConstFunc(SUTime.TIME_REF), new TimeExpressionExtractors.TemporalComposeObjFunc(new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.MULTIPLY), new TimeExpressionExtractors.TemporalGetTEFunc(0, 0), new Function<MatchResult, Integer>(){

            @Override
            public Integer apply(MatchResult in) {
                String rel = in.group(2).toLowerCase();
                if ("earlier".equals(rel) || "ago".equals(rel)) {
                    return -1;
                }
                return 1;
            }
        })));
        TimeExpressionExtractors.GenericTimePatternExtractor relTimeExtractor2 = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( [ { temporal::EXISTS } & !{ temporal::IS_TIMEX_DURATION } ] )  (/earlier|later|late|ago|hence/ | /from/ /now/) "), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalGetTEFunc(0, 0));
        TimeExpressionExtractors.GenericTimePatternExtractor relTimeExtractor3 = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( /this|about|nearly|early|later|earlier|late/ |  /more/ /than/ | /up/ /to/ | /less/ /than/ ) ( [ { temporal::EXISTS } ] ) "), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalGetTEFunc(0, -1));
        TimeExpressionExtractors.GenericTimePatternExtractor setTimeExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ( $FREQ_MOD ) ( [ { temporal::EXISTS } & !{ temporal::IS_TIMEX_SET } ] ) "), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                TimeExpressionExtractors.TemporalGetTEFunc tFunc = new TimeExpressionExtractors.TemporalGetTEFunc(0, -1);
                SUTime.Temporal t = (SUTime.Temporal)tFunc.apply(in);
                return EnglishTimeExpressionPatterns.makeSet(t, in.group(1));
            }
        });
        TimeExpressionExtractors.GenericTimePatternExtractor rangeTimeExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " /from/? ( [ { temporal::IS_TIMEX_TIME } | { temporal::IS_TIMEX_DATE } ] ) /to|-/ ( [ { temporal::IS_TIMEX_TIME } | { temporal::IS_TIMEX_DATE } ] ) "), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                TimeExpressionExtractors.TemporalGetTEFunc t1Func = new TimeExpressionExtractors.TemporalGetTEFunc(1, 0);
                TimeExpressionExtractors.TemporalGetTEFunc t2Func = new TimeExpressionExtractors.TemporalGetTEFunc(2, 0);
                SUTime.Temporal t1 = (SUTime.Temporal)t1Func.apply(in);
                SUTime.Temporal t2 = (SUTime.Temporal)t2Func.apply(in);
                return new SUTime.Range((SUTime.Time)t1, (SUTime.Time)t2);
            }
        });
        SequenceMatchRules.ListExtractRule<List<? extends CoreMap>, TimeExpression> compositeRules = new SequenceMatchRules.ListExtractRule<List<? extends CoreMap>, TimeExpression>(TimeExpressionExtractors.getSequencePatternExtractRule(relTimeExtractor.tokenPattern, relTimeExtractor), TimeExpressionExtractors.getSequencePatternExtractRule(adjTimeExtractor.tokenPattern, adjTimeExtractor), TimeExpressionExtractors.getSequencePatternExtractRule(dateTodayExtractor.tokenPattern, dateTodayExtractor), TimeExpressionExtractors.getSequencePatternExtractRule(relDurationExtractor.tokenPattern, relDurationExtractor), TimeExpressionExtractors.getSequencePatternExtractRule(relTimeExtractor2.tokenPattern, relTimeExtractor2), TimeExpressionExtractors.getSequencePatternExtractRule(relTimeExtractor3.tokenPattern, relTimeExtractor3), TimeExpressionExtractors.getSequencePatternExtractRule(setTimeExtractor.tokenPattern, setTimeExtractor));
        if (this.options.markTimeRanges) {
            TimeExpressionExtractors.SequenceMatchExtractor extractor = new TimeExpressionExtractors.SequenceMatchExtractor(rangeTimeExtractor, true, 0);
            SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression> r = new SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression>(rangeTimeExtractor.tokenPattern, extractor);
            compositeRules.addRules(r);
        }
        this.compositeTimeExtractionRule = compositeRules;
        this.filterRules = new ArrayList<Filter<TimeExpression>>();
        this.filterRules.add(new TimeExpressionTokenSeqFilter(TokenSequencePattern.compile(this.env, "[ { word:/fall|spring|second|march|may/ } & !{ tag:/NN.*/ } ]"), true));
        this.filterRules.add(new TimeExpressionTokenSeqFilter(TokenSequencePattern.compile(this.env, "/good/ /morning|evening|day|afternoon|night/"), true));
    }

    protected boolean checkTimeExpression(TimeExpression timeExpr) {
        for (Filter<TimeExpression> filterRule : this.filterRules) {
            if (filterRule.accept(timeExpr)) continue;
            return false;
        }
        return true;
    }

    protected SequenceMatchRules.ExtractRule<CoreMap, TimeExpression> getTimeExtractionRule() {
        return this.timeExtractionRule;
    }

    protected SequenceMatchRules.ExtractRule<List<? extends CoreMap>, TimeExpression> getCompositeTimeExtractionRule() {
        return this.compositeTimeExtractionRule;
    }

    protected Filter<TimeExpression> getFilterRule() {
        return new Filters.DisjFilter<TimeExpression>(this.filterRules);
    }

    private TimeExpressionExtractors.DurationRule createDurationRule(PatternType patternType, String regex, int valMatchGroup, int unitMatchGroup) {
        return this.createDurationRule(patternType, regex, valMatchGroup, unitMatchGroup, SUTime.TIME_NONE, SUTime.TIME_NONE);
    }

    private TimeExpressionExtractors.DurationRule createDurationRule(PatternType patternType, String regex, int valMatchGroup, int valMatchGroup2, int unitMatchGroup) {
        return this.createDurationRule(patternType, regex, valMatchGroup, valMatchGroup2, unitMatchGroup, SUTime.TIME_NONE, SUTime.TIME_NONE);
    }

    private TimeExpressionExtractors.DurationRule createDurationRule(PatternType patternType, String regex, int valMatchGroup, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
        return this.createDurationRule(patternType, regex, valMatchGroup, -1, unitMatchGroup, beginTime, endTime);
    }

    private TimeExpressionExtractors.DurationRule createDurationRule(PatternType patternType, String regex, int valMatchGroup, int valMatchGroup2, int unitMatchGroup, SUTime.Time beginTime, SUTime.Time endTime) {
        switch (patternType) {
            case TOKENS: {
                TokenSequencePattern tp = TokenSequencePattern.compile(this.env, regex);
                return new TimeExpressionExtractors.DurationRule(this, tp, valMatchGroup, valMatchGroup2, unitMatchGroup, beginTime, endTime);
            }
            case STRING: {
                Pattern p = this.getPattern(regex);
                return new TimeExpressionExtractors.DurationRule(this, p, valMatchGroup, valMatchGroup2, unitMatchGroup, beginTime, endTime);
            }
        }
        throw new UnsupportedOperationException("Unknown pattern type: " + (Object)((Object)patternType));
    }

    private void initDurationRules() {
        this.durationRules.clear();
        TimeExpressionExtractors.DurationRule rule = this.createDurationRule(PatternType.TOKENS, "/the/ /past|last/ (?: ($NUM) /to|-/ )? ($NUM)? ($TEUNITS)", 1, 2, 3, SUTime.TIME_UNKNOWN, SUTime.TIME_REF);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ /next|following/ (?: ($NUM) /to|-/ )? ($NUM)? ($TEUNITS)", 1, 2, 3, SUTime.TIME_REF, SUTime.TIME_UNKNOWN);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/another/ (?: ($NUM) /to|-/ )? ($NUM)? ($TEUNITS)", 1, 2, 3, SUTime.TIME_UNKNOWN, SUTime.TIME_REF);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ (?: ($NUM) /to|-/ )? ($NUM) ($TEUNITS_NODE)", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ /first|initial|last|final/ (?: ($NUM) /to|-/ )? ($NUM)? ($TEUNITS)", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ ($NUM_ORD) /straight|consecutive/ ($TEUNIT) (?: /in/ /a/ /row/ | /consecutively/ )?", 1, 2, SUTime.TIME_UNKNOWN, SUTime.TIME_REF);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ ($NUM_ORD) /straight|consecutive/? ($TEUNIT) (?: /in/ /a/ /row/ | /consecutively/ )", 1, 2, SUTime.TIME_UNKNOWN, SUTime.TIME_REF);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/no/? /more/ /than/ (?: ($NUM) /to|-/ )? ($NUM) ($TEUNITS)", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/no/? /less/ /than/ (?: ($NUM) /to|-/ )? ($NUM) ($TEUNITS)", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/at/ /least/ (?: ($NUM) /to|-/ )? ($NUM) /more/? ($TEUNITS)", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "(/(ten|hundred|thousand|million|billion|trillion)s/) /of/ ($TEUNITS)", 1, -1, 2);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "(/recent|several/) /-/? ($TEUNITS)", -1, 2);
        this.durationRules.add(rule);
        rule.setUnderspecifiedValueMatchGroup(1, "1");
        rule = this.createDurationRule(PatternType.TOKENS, "($NUM) /to|-/ ($NUM) [ \"-\" ]? ($TEUNITS_NODE)  (?: [ \"-\" ]? /old/ )? ", 1, 2, 3);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "($NUM) [ \"-\" ]? ($TEUNITS_NODE)  (?: [ \"-\" ]? /old/ )? ", 1, 2);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.STRING, "(\\d+)[-\\s]($TEUnits)(s)?([-\\s]old)?", 1, 2);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.STRING, "$NUM_NO_ORD_TERM[-\\s]($TEUnits)(s)?([-\\s]old)?", 1, 2);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "(?: /the/ /past|next|following|coming|last|first|final/ | /a|an/ )? (/couple/ /of/? ) ($TEUNITS)", -1, 2);
        this.durationRules.add(rule);
        rule.setUnderspecifiedValueMatchGroup(3, "2");
        rule = this.createDurationRule(PatternType.TOKENS, "(?: /the/ /past|next|following|coming|last|first|final/ | /a|an/ )? (/few/ ) ($TEUNITS)", -1, 2);
        this.durationRules.add(rule);
        rule.setUnderspecifiedValueMatchGroup(1, "1");
        rule = this.createDurationRule(PatternType.TOKENS, "/a|an/ ($TEUNITS)", -1, 1);
        this.durationRules.add(rule);
        rule = this.createDurationRule(PatternType.TOKENS, "/the/ [ { tag:JJ } ]+ ($TEUNITS_NODE)", -1, 1);
        this.durationRules.add(rule);
        rule.tokenPattern.setPriority(-1.0);
        rule = this.createDurationRule(PatternType.TOKENS, "($TEUNITS_NODE)", -1, 1);
        this.durationRules.add(rule);
        rule.setUnderspecifiedValueMatchGroup(0, "X");
        rule.tokenPattern.setPriority(-1.0);
    }

    public Pattern getPattern(String regex) {
        return this.env.getStringPattern(regex);
    }

    private static SUTime.Temporal makeSet(SUTime.Temporal t, String freq) {
        if (freq == null) {
            return t;
        }
        String quant = null;
        int scale = 1;
        SUTime.Duration p = t.getPeriod();
        if (freq != null) {
            Number n;
            if ((freq = freq.toLowerCase()).equals("alternate") || freq.contains("other")) {
                quant = freq;
                scale = 2;
            } else if (freq.equals("each") || freq.equals("every")) {
                quant = freq;
            } else if (freq.startsWith("every") && (n = NumberNormalizer.wordToNumber((quant = freq).substring(6))) != null) {
                scale = n.intValue();
            }
        }
        if (p != null && scale != 1) {
            p = p.multiplyBy(scale);
        }
        return new SUTime.PeriodicTemporalSet(t, p, quant, null);
    }

    private SUTime.Temporal makeRelative(SUTime.Temporal t, String rel) {
        if (rel != null) {
            SUTime.TemporalOp seqOp = this.lookupTemporalOp(rel);
            if (rel != null) {
                t = new SUTime.RelativeTime(seqOp, t);
            }
        }
        return t;
    }

    private void initDateTimeRules() {
        SequenceMatchRules.StringPatternExtractRule<TimeExpression> srule = null;
        SequenceMatchRules.SequencePatternExtractRule<CoreMap, TimeExpression> trule = null;
        TimeExpressionExtractors.TimePatternExtractor timePatternExtractor = null;
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(this.getPattern("'(\\d\\d)\\b"), 1, -1, -1, true);
        srule = TimeExpressionExtractors.getStringPatternExtractRule(this.env, "('\\d\\d)\\b", timePatternExtractor);
        this.dateTimeStringRules.add(srule);
        srule = TimeExpressionExtractors.getStringPatternExtractRuleWithWordBoundary(this.env, "(\\d\\d\\d\\d-?\\d\\d-?\\d\\d-?T\\d\\d(:?\\d\\d)?(:?\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?)", new TimeExpressionExtractors.IsoDateTimeExtractor(ISODateTimeFormat.dateTimeParser(), true, true));
        this.dateTimeStringRules.add(srule);
        srule = TimeExpressionExtractors.getStringPatternExtractRuleWithWordBoundary(this.env, "(\\d\\d\\d\\d-\\d\\d-\\d\\d)", new TimeExpressionExtractors.IsoDateTimeExtractor(ISODateTimeFormat.dateParser(), true, false));
        this.dateTimeStringRules.add(srule);
        srule = TimeExpressionExtractors.getStringPatternExtractRuleWithWordBoundary(this.env, "(T\\d\\d(:?\\d\\d)?(:?\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?)", new TimeExpressionExtractors.IsoDateTimeExtractor(ISODateTimeFormat.timeParser(), false, true));
        this.dateTimeStringRules.add(srule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateTimeExtractor(this.getPattern("(?:(\\d\\d?):?(\\d\\d)(:?(\\d\\d))?)?.*?(\\d\\d?)\\\\?[-/](\\d\\d?)\\\\?[-/](\\d\\d(?:\\d\\d)?)"), 7, 5, 6, 1, 2, 4, true);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "/\\d\\d?:?\\d\\d(:?\\d\\d)?/?  /on/? /\\d\\d?(-|\\\\?\\/)\\d\\d?(-|\\\\?\\/)\\d\\d(\\d\\d)?/", timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoTimeExtractor(this.getPattern("(\\d\\d?):?(\\d\\d)(:?(\\d\\d))?"), 1, 2, 4);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "/\\d\\d?:\\d\\d(:\\d\\d)?/", timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(this.getPattern("(\\d\\d\\d\\d)-(\\d\\d)"), 1, 2, -1, false);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "/\\d\\d\\d\\d-\\d\\d/", timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(this.getPattern("(\\d\\d?)\\.(\\d\\d?)\\.(\\d\\d(\\d\\d)?)"), 3, 2, 1, true);
        srule = TimeExpressionExtractors.getStringPatternExtractRuleWithWordBoundary(this.env, "\\d\\d?\\.\\d\\d?\\.\\d\\d(\\d\\d)?", timePatternExtractor);
        this.dateTimeStringRules.add(srule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "(?: ($FREQ_MOD) | ($REL_MOD) )? ($TEDAYS) (?: /the/ (?$day $NUM_ORD) )? (?$tod /(morning|afternoon|evening|night)s?/)?"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                boolean isPlural = false;
                String freq = in.group(1);
                String rel = in.group(2);
                String dow = in.group(3);
                String tod = ((SequenceMatchResult)in).group("$tod");
                String day = ((SequenceMatchResult)in).group("$day");
                SUTime.Temporal temporal = EnglishTimeExpressionPatterns.this.lookupTemporal(dow);
                if (temporal != null) {
                    SUTime.Temporal t;
                    temporal = EnglishTimeExpressionPatterns.this.makeRelative(temporal, rel);
                    if (day != null) {
                        t = EnglishTimeExpressionPatterns.createIsoDate(null, null, day);
                        temporal = new SUTime.RelativeTime(temporal.getTime(), SUTime.TemporalOp.INTERSECT, t);
                    }
                    if (tod != null) {
                        t = EnglishTimeExpressionPatterns.this.lookupTemporal(tod);
                        temporal = new SUTime.RelativeTime(temporal.getTime(), SUTime.TemporalOp.INTERSECT, t);
                        if (tod.endsWith("s") || tod.endsWith("S")) {
                            isPlural = true;
                        }
                    }
                    if (freq != null) {
                        temporal = EnglishTimeExpressionPatterns.makeSet(temporal, freq);
                    } else {
                        if (dow.endsWith("s") || dow.endsWith("S")) {
                            isPlural = true;
                        }
                        if (isPlural) {
                            temporal = EnglishTimeExpressionPatterns.makeSet(temporal, "");
                        }
                    }
                }
                return temporal;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "/good/ (/morning|evening|day|afternoon|night/)"), 1);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " (?: /the/? /day/ (/before|after/))? ($RELDAY) (morning|afternoon|evening|night)?"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                SUTime.Temporal tod;
                String relday = in.group(2).toLowerCase();
                SUTime.Temporal t = EnglishTimeExpressionPatterns.this.lookupTemporal(relday);
                SUTime.Time tm = t.getTime();
                String str = in.group(3);
                if (str != null && (tod = EnglishTimeExpressionPatterns.this.lookupTemporal(str)) != null) {
                    tm = new SUTime.RelativeTime(tm, SUTime.TemporalOp.INTERSECT, tod);
                }
                if ((str = in.group(1)) != null) {
                    if (str.equalsIgnoreCase("before")) {
                        tm = tm.add(SUTime.DAY.multiplyBy(-1));
                    } else if (str.equalsIgnoreCase("after")) {
                        tm = tm.add(SUTime.DAY);
                    }
                }
                return tm;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getRelativeTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "(/early|late/)? /this/? (/morning|afternoon|evening/)"), (SUTime.Temporal)SUTime.TIME_REF, SUTime.TemporalOp.THIS, 2);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getRelativeTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "(/early|late/)? /last/ (/night/)"), (SUTime.Temporal)SUTime.TIME_REF, SUTime.TemporalOp.PREV, 2);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " (/every/ $NUM_ORD) ($TEMONTHS)"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                SUTime.Temporal t = EnglishTimeExpressionPatterns.this.lookupTemporal(in.group(2));
                return EnglishTimeExpressionPatterns.makeSet(t, in.group(1));
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, " ((/early|late/) /in|on/?)?  (?: /the/? ( (?$weeknum ($NUM_ORD|last)? /week(end)?/ ) | (?$tod /morning|day|afternoon|evening|night/) |  (?$mod /beginning|start|middle|end|ides|nones/) ) /of|in/? )? /the/? (?: (?$rel $REL_MOD) | /mid-?/ | (?$day $NUM_ORD) /of/? | (?$day /\\d\\d?/ & $INT1TO31) )?(?$month $TEMONTHS)  (?$day $NUM_ORD|/\\d\\d?/ & $INT1TO31)? (?: /of|,/? (?$year $POSSIBLE_YEAR))?"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                if (in instanceof SequenceMatchResult) {
                    SUTime.Temporal temporal;
                    String mod;
                    List mnodes;
                    SequenceMatchResult r = (SequenceMatchResult)in;
                    String weeknum = r.group("$weeknum");
                    String tod = r.group("$tod");
                    String month = r.group("$month");
                    String year = r.group("$year");
                    String day = r.group("$day");
                    String rel = r.group("$rel");
                    if (weeknum == null && tod == null && year == null && day == null && !((String)((CoreMap)(mnodes = r.groupNodes("$month")).get(0)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NN")) {
                        return SUTime.TIME_NONE_OK;
                    }
                    if (day == null && (mod = r.group("$mod")) != null && (mod.equalsIgnoreCase("ides") || mod.equalsIgnoreCase("nones"))) {
                        day = mod;
                    }
                    SUTime.Temporal t = EnglishTimeExpressionPatterns.createIsoDate(year, month, day);
                    if (rel != null) {
                        t = EnglishTimeExpressionPatterns.this.makeRelative(t, rel);
                    }
                    if (weeknum != null) {
                        int i = weeknum.lastIndexOf(" ");
                        if (i >= 0) {
                            Number ordNum;
                            String ord = weeknum.substring(0, i);
                            String week = weeknum.substring(i);
                            SUTime.Temporal weekTemp = EnglishTimeExpressionPatterns.this.lookupTemporal(week);
                            Number number = ordNum = "last".equalsIgnoreCase(ord) ? (Number)-1 : (Number)NumberNormalizer.wordToNumber(ord);
                            if (ordNum != null) {
                                weekTemp = new SUTime.OrdinalTime(weekTemp, ordNum.intValue());
                                t = SUTime.TemporalOp.IN.apply(t, weekTemp);
                            } else {
                                t = SUTime.TemporalOp.INTERSECT.apply(t, weekTemp);
                            }
                        } else {
                            t = SUTime.TemporalOp.INTERSECT.apply(t, EnglishTimeExpressionPatterns.this.lookupTemporal(weeknum));
                        }
                    }
                    if (tod != null && (temporal = EnglishTimeExpressionPatterns.this.lookupTemporal(tod)) != null) {
                        t = SUTime.TemporalOp.INTERSECT.apply(t, temporal);
                    }
                    return t;
                }
                return null;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "( $EARLY_LATE_MOD )? (?: ($FREQ_MOD) | ($REL_MOD) ) (/millisecond|second|minute|hour|weekend|week|fortnight|month|quarter|year|decade|century|millenn?ium|spring|summer|winter|fall|autumn/)"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                String freq = in.group(2);
                String rel = in.group(3);
                String dur = in.group(4);
                SUTime.Temporal t = EnglishTimeExpressionPatterns.this.lookupTemporal(dur);
                if (t != null) {
                    t = EnglishTimeExpressionPatterns.this.makeRelative(t, rel);
                    t = EnglishTimeExpressionPatterns.makeSet(t, freq);
                }
                return t;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getRelativeTimeExtractor(TokenSequencePattern.compile(this.env, "( /each/ | /late|early/  /in/?  | /every/ (?: /other/ | $NUM_ORD)? | /the/? /beginning|start|dawn|middle|end/ /of/ )? (?: /the/ )? ($SEASON) /of/? ($POSSIBLE_YEAR)?"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.IsoDateTimePatternFunc(3, -1, -1, -1, -1, -1, true), (Function<MatchResult, SUTime.TemporalOp>)new TimeExpressionExtractors.TemporalOpConstFunc(SUTime.TemporalOp.INTERSECT), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalLookupFunc(this, 2));
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "[ { tag:NNP } ]+ [ { tag:POS } ] /birthday/"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                return new SUTime.SimpleTime(in.group());
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(TokenSequencePattern.compile(this.env, "/the/? $EARLY_LATE_MOD? ( /'/ /\\d0s/ | /'\\d0s/ | /\\w+teen/? /(twen|thir|for|fif|six|seven|eigh|nine)ties/ | /\\d\\d\\d\\ds/ )"), 1, -1, -1, true);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "/the/? $EARLY_LATE_MOD? ($NUM_ORD) /-/? /century/ (/a\\.?d\\.?|b\\.?c\\.?/)?"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                Number num = NumberNormalizer.wordToNumber(in.group(1));
                if (num != null) {
                    String s = num.intValue() - 1 + "00s";
                    String era = in.group(2);
                    if (era != null) {
                        s = s + " " + era;
                    }
                    return EnglishTimeExpressionPatterns.createIsoDate(s, null, null);
                }
                return null;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "/the/? [{tag:JJ}]? ($NUM_ORD) /-/? [{tag:JJ}]? /quarter/"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                Number num = NumberNormalizer.wordToNumber(in.group(1));
                if (num != null) {
                    return SUTime.StandardTemporalType.QUARTER_OF_YEAR.createTemporal(num.intValue());
                }
                return null;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(this.getPattern("$NUM_ORD_TERM-quarter"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                Number num = NumberNormalizer.wordToNumber(in.group(1));
                if (num != null) {
                    return SUTime.StandardTemporalType.QUARTER_OF_YEAR.createTemporal(num.intValue());
                }
                return null;
            }
        });
        srule = TimeExpressionExtractors.getStringPatternExtractRule(timePatternExtractor.stringPattern, timePatternExtractor);
        this.dateTimeStringRules.add(srule);
        timePatternExtractor = TimeExpressionExtractors.getTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "/current|once|medieval/ | /the/ /future/"), 0);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "(?m){1,3} /((bi|semi)\\s*-?\\s*)?((annual|year|month|week|dai|hour|night|quarter)ly|annual)/"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                int scale = 1;
                boolean divide = false;
                String g = in.group().toLowerCase();
                if (g.startsWith("bi")) {
                    scale = 2;
                    g = g.replaceFirst("^bi\\s*\\-?\\s*", "");
                } else if (g.startsWith("semi")) {
                    scale = 2;
                    divide = true;
                    g = g.replaceFirst("^semi\\s*\\-?\\s*", "");
                }
                SUTime.Temporal t = EnglishTimeExpressionPatterns.this.lookupTemporal(g);
                if (t != null && scale != 1) {
                    t = divide ? ((SUTime.PeriodicTemporalSet)t).divideDurationBy(scale) : ((SUTime.PeriodicTemporalSet)t).multiplyDurationBy(scale);
                }
                return t;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(Pattern.compile("\b(\\d{4})\\s*(?:-|to)\\s*(\\d{4})\b"), new Function<MatchResult, SUTime.Temporal>(){

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                String y1 = in.group(1);
                String y2 = in.group(2);
                return new SUTime.Range(EnglishTimeExpressionPatterns.createIsoDate(y1, null, null), EnglishTimeExpressionPatterns.createIsoDate(y2, null, null));
            }
        });
        srule = TimeExpressionExtractors.getStringPatternExtractRule(timePatternExtractor.stringPattern, timePatternExtractor);
        this.dateTimeStringRules.add(srule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "/the/ /weekend/"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalConstFunc(SUTime.WEEKEND));
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoTimeExtractor(this.getPattern(".*(\\d\\d?)h(\\d\\d).*"), 1, 2, -1);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "/about|around|some/?  /\\d\\d?h\\d\\d/", timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        this.dateTimeTokenSeqRules.add(new SequenceMatchRules.FilterExtractRule(new TokenSeqPatternFilter(TokenSequencePattern.compile(this.env, "/time/")), TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "(/\\d{4}/ /hours/?)? (/universal|zulu/ | /[a-z]+/ /standard|daylight/) /time/", null), TimeExpressionExtractors.getSequencePatternExtractRule(this.env, "(/\\d\\d?/ /hours/?) (/\\d\\d?/ /minutes/?)? (/universal|zulu/ | /[a-z]+/ /standard|daylight/) /time/", null)));
        timePatternExtractor = TimeExpressionExtractors.getIsoTimeExtractor(this.getPattern("(\\d\\d):?(\\d\\d)(:?(\\d\\d))?\\s*h(ou)/rs?"), 1, 2, 3);
        srule = TimeExpressionExtractors.getStringPatternExtractRule(timePatternExtractor.stringPattern, timePatternExtractor);
        this.dateTimeStringRules.add(srule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "$APPROX_MOD? (?: (/a/? /quarter/| /half/ | [ $INT & { numcompvalue<=60 } ] /minutes?/? ) (/past|after|of|before|to|until/))? (/noon/|/midnight/|/the/ /hour/ (?: /of/ [ $INT & { numcompvalue<=24 } ] )?|/\\d\\d?:\\d\\d/|[ $INT & { numcompvalue<=24 } ] /o'?clock/?) (/in/ /the/ /morning|afternoon|evening/| /at/ /night/|/a\\.?m\\.?/|/p\\.?m\\.?/)? (?: /sharp/|/exactly/|/precisely/|/on/ /the/ /dot/)?"), new Function<MatchResult, SUTime.Temporal>(){
            TokenSequencePattern bareNumToNumPattern;
            {
                this.bareNumToNumPattern = TokenSequencePattern.compile(EnglishTimeExpressionPatterns.this.env, " $INT (/of|to/ $INT)? ");
            }

            @Override
            public SUTime.Temporal apply(MatchResult in) {
                SequenceMatchResult smr = (SequenceMatchResult)in;
                SequenceMatcher bm = this.bareNumToNumPattern.getMatcher(smr.groupNodes());
                if (bm.matches()) {
                    return SUTime.TIME_NONE_OK;
                }
                int minutes = 0;
                SUTime.Time t = null;
                String str = in.group(1);
                if (str != null) {
                    if ((str = str.toLowerCase()).contains("quarter")) {
                        minutes = 15;
                    } else if (str.contains("half")) {
                        minutes = 30;
                    } else {
                        str = str.replaceAll("minutes?", "");
                        minutes = NumberNormalizer.wordToNumber(str).intValue();
                    }
                    str = in.group(2).toLowerCase();
                    if (!str.equals("past") && !str.equals("after")) {
                        minutes = -minutes;
                    }
                }
                if ((str = in.group(3)) != null) {
                    if ((str = str.toLowerCase()).contains("noon")) {
                        t = SUTime.NOON;
                    } else if (str.contains("midnight")) {
                        t = SUTime.MIDNIGHT;
                    } else if (str.matches("\\d\\d?:\\d\\d")) {
                        String[] fields = str.split(":");
                        int h = NumberNormalizer.wordToNumber(fields[0]).intValue();
                        int m = NumberNormalizer.wordToNumber(fields[1]).intValue();
                        str = in.group(4);
                        if (str != null) {
                            if ((str = str.toLowerCase()).contains("night")) {
                                if (h > 4 && h < 12) {
                                    h += 12;
                                }
                            } else if ((str.contains("afternoon") || str.contains("evening") || str.matches(".*p\\.?m\\.?.*")) && h < 12) {
                                h += 12;
                            }
                        }
                        t = new SUTime.IsoTime(h, m, -1);
                    } else {
                        String orig = str;
                        str = str.replaceAll(".*\bof\b", "");
                        if ((str = str.replaceAll("o'?clock", "")).equals(orig) && in.group(1) == null && in.group(2) == null && in.group(4) == null) {
                            return SUTime.TIME_NONE_OK;
                        }
                        int h = NumberNormalizer.wordToNumber(str).intValue();
                        str = in.group(4);
                        if (str != null) {
                            if ((str = str.toLowerCase()).contains("night")) {
                                if (h > 4 && h < 12) {
                                    h += 12;
                                }
                            } else if ((str.contains("afternoon") || str.contains("evening") || str.matches(".*p\\.?m\\.?.*")) && h < 12) {
                                h += 12;
                            }
                        }
                        t = new SUTime.IsoTime(h, 0, -1);
                    }
                    if (minutes != 0) {
                        t = ((SUTime.Time)t).add(SUTime.MINUTE.multiplyBy(minutes));
                    }
                }
                return t;
            }
        });
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, " /right/? /now/ ", TimeExpressionExtractors.getTimeExtractor(SUTime.TIME_PRESENT));
        this.dateTimeTokenSeqRules.add(trule);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(this.env, " /the/ /near/ /future/ ", TimeExpressionExtractors.getTimeExtractor(SUTime.TIME_FUTURE));
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(TokenSequencePattern.compile(this.env, "$POSSIBLE_YEAR"), 0, -1, -1, true);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(TokenSequencePattern.compile(this.env, "/the/? /year/ ($POSSIBLE_YEAR)"), timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getIsoDateExtractor(TokenSequencePattern.compile(this.env, "[ { ner::IS_NIL } | { ner:DATE } | { ner:O } | { ner:NUMBER } ]+"), 0, -1, -1, true);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(TokenSequencePattern.compile(this.env, "($POSSIBLE_YEAR)"), timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "/the/? ($TIMEOFDAY)"), 1);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = TimeExpressionExtractors.getRelativeTimeLookupExtractor(this, TokenSequencePattern.compile(this.env, "/the/ [ { tag:JJ } ]* ($TEUNITS_NODE)"), null, SUTime.TemporalOp.THIS, 1);
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "/the/ /past/ | /recently/ | /previously/"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalConstFunc(SUTime.TIME_PAST));
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
        timePatternExtractor = new TimeExpressionExtractors.GenericTimePatternExtractor(TokenSequencePattern.compile(this.env, "/currently/)"), (Function<MatchResult, SUTime.Temporal>)new TimeExpressionExtractors.TemporalConstFunc(SUTime.TIME_PRESENT));
        trule = TimeExpressionExtractors.getSequencePatternExtractRule(timePatternExtractor.tokenPattern, timePatternExtractor);
        this.dateTimeTokenSeqRules.add(trule);
    }

    public SUTime.Duration getDuration(String unit) {
        if ((unit = unit.toLowerCase()).endsWith(".")) {
            unit = unit.substring(0, unit.length() - 1);
        }
        return this.abbToTimeUnit.get(unit);
    }

    public SUTime.Duration getDuration(String val, String unit) {
        SUTime.Duration d;
        if ((unit = unit.toLowerCase()).endsWith(".")) {
            unit = unit.substring(0, unit.length() - 1);
        }
        if ((d = this.abbToTimeUnit.get(unit)) != null) {
            if ("X".equals(val)) {
                return d.makeInexact();
            }
            if (val == null) {
                return null;
            }
            Matcher matcher = Pattern.compile("(\\d+)").matcher(val);
            if (matcher.find()) {
                int m = Integer.parseInt(matcher.group());
                d = d.multiplyBy(m);
            } else {
                Number n = null;
                n = NumberNormalizer.wordToNumber(val);
                if (n != null) {
                    int m = n.intValue();
                    d = d.multiplyBy(m);
                }
            }
        }
        return d;
    }

    @Override
    public int determineRelFlags(CoreMap annotation, TimeExpression te) {
        int flags = 0;
        String reason = "";
        if (this.options.teRelHeurLevel != Options.RelativeHeuristicLevel.NONE) {
            String vb2 = "";
            String vb2Pos = "";
            String vbPos = "";
            String vb = "";
            String precedingWord = "";
            int limit = 2;
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            Integer tokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
            if (tokenOffset == null) {
                tokenOffset = 0;
            }
            int tokenBegin = te.getTokenOffsets().getBegin() - tokenOffset;
            int tokenEnd = te.getTokenOffsets().getEnd() - tokenOffset;
            List lead = tokens.subList(Math.max(0, tokenBegin - limit), tokenBegin);
            if (lead.size() > 0) {
                precedingWord = (String)((CoreMap)lead.get(lead.size() - 1)).get(CoreAnnotations.TextAnnotation.class);
            }
            List after = tokens.subList(tokenEnd, Math.min(tokens.size(), tokenEnd + limit));
            SequenceMatcher vbMatcher = this.VB_NODE_PATTERN1.getMatcher(lead);
            boolean found = vbMatcher.find();
            if (!found) {
                vbMatcher = this.VB_NODE_PATTERN1.getMatcher(after);
                found = vbMatcher.find();
                if (limit < 0 && !found) {
                    vbMatcher = this.VB_NODE_PATTERN1.getMatcher(tokens);
                    found = vbMatcher.find();
                }
            }
            if (found) {
                vb = ((String)((CoreMap)vbMatcher.groupNodes().get(0)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
                vbPos = ((String)((CoreMap)vbMatcher.groupNodes().get(0)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).toUpperCase();
                if ((vbMatcher = VB_NODE_PATTERN2.getMatcher(vbMatcher.groupNodes(-2147483647))).find()) {
                    vb2 = ((String)((CoreMap)vbMatcher.groupNodes().get(0)).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
                    vb2Pos = ((String)((CoreMap)vbMatcher.groupNodes().get(0)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).toUpperCase();
                }
            } else {
                vbPos = "X";
                vb = "NoVerb";
            }
            if (vbPos.matches("(VBP|VBZ|MD)") && (vbMatcher = GOING_TO.getMatcher(tokens)).find()) {
                vbPos = "MD";
                vb = "going_to";
            }
            if ("VBD".equals(vbPos)) {
                flags |= 0x40;
                reason = vbPos;
            } else if ("MD".equals(vbPos)) {
                if (vb.matches(".*(will|'ll|going_to).*")) {
                    flags |= 0x80;
                    reason = vbPos + ":" + vb;
                } else if ("have".equals(vb2)) {
                    flags |= 0x40;
                    reason = vbPos + ":" + vb;
                } else if (vb.matches(".*(?:would|could|should|'d)")) {
                    flags |= 0x80;
                    reason = vbPos + ":" + vb;
                }
            }
            if (this.options.teRelHeurLevel == Options.RelativeHeuristicLevel.MORE && flags == 0) {
                if ("since".equals(precedingWord)) {
                    flags |= 0x40;
                    reason = "since";
                } else if ("until".equals(precedingWord)) {
                    flags |= 0x80;
                    reason = "until";
                }
            }
        }
        if (flags != 0) {
            logger.warning("Should resolve " + te + " using flags " + flags + " due to reason " + reason);
            logger.warning("Resolution context " + (String)annotation.get(CoreAnnotations.TextAnnotation.class));
        } else if (te.getTemporal() instanceof SUTime.PartialTime) {
            flags = 512;
        }
        return flags;
    }

    public SUTime.TemporalOp lookupTemporalOp(String expr) {
        expr = expr.toLowerCase();
        expr = expr.replaceAll("the\\s+", "");
        expr = expr.replaceAll("[^a-z]", "");
        return this.wordToTemporalOp.get(expr);
    }

    public SUTime.Temporal lookupTemporal(String expr) {
        expr = expr.toLowerCase();
        SUTime.Temporal temp = this.wordToTemporal.get(expr = expr.replaceAll("[^a-z]", ""));
        if (temp == null && expr.endsWith("s")) {
            temp = this.wordToTemporal.get(expr.substring(0, expr.length() - 1));
        }
        return temp;
    }

    private void initTemporalOpMap() {
        this.wordToTemporalOp.put("thiscoming", SUTime.TemporalOp.NEXT_IMMEDIATE);
        this.wordToTemporalOp.put("thispast", SUTime.TemporalOp.PREV_IMMEDIATE);
        this.wordToTemporalOp.put("this", SUTime.TemporalOp.THIS);
        this.wordToTemporalOp.put("next", SUTime.TemporalOp.NEXT);
        this.wordToTemporalOp.put("following", SUTime.TemporalOp.NEXT);
        this.wordToTemporalOp.put("previous", SUTime.TemporalOp.PREV);
        this.wordToTemporalOp.put("last", SUTime.TemporalOp.PREV);
    }

    private void initTemporalMap() {
        this.wordToTemporal.put("annual", SUTime.YEARLY);
        this.wordToTemporal.put("annually", SUTime.YEARLY);
        this.wordToTemporal.put("yearly", SUTime.YEARLY);
        this.wordToTemporal.put("hourly", SUTime.HOURLY);
        this.wordToTemporal.put("nightly", SUTime.NIGHTLY);
        this.wordToTemporal.put("daily", SUTime.DAILY);
        this.wordToTemporal.put("weekly", SUTime.WEEKLY);
        this.wordToTemporal.put("monthly", SUTime.MONTHLY);
        this.wordToTemporal.put("quarterly", SUTime.QUARTERLY);
        this.wordToTemporal.put("morning", SUTime.MORNING);
        this.wordToTemporal.put("afternoon", SUTime.AFTERNOON);
        this.wordToTemporal.put("evening", SUTime.EVENING);
        this.wordToTemporal.put("dusk", SUTime.DUSK);
        this.wordToTemporal.put("twilight", SUTime.TWILIGHT);
        this.wordToTemporal.put("dawn", SUTime.DAWN);
        this.wordToTemporal.put("daybreak", SUTime.DAWN);
        this.wordToTemporal.put("sunrise", SUTime.SUNRISE);
        this.wordToTemporal.put("sunup", SUTime.SUNRISE);
        this.wordToTemporal.put("sundown", SUTime.SUNSET);
        this.wordToTemporal.put("sunset", SUTime.SUNSET);
        this.wordToTemporal.put("midday", SUTime.NOON);
        this.wordToTemporal.put("noon", SUTime.NOON);
        this.wordToTemporal.put("midnight", SUTime.MIDNIGHT);
        this.wordToTemporal.put("teatime", SUTime.TEATIME);
        this.wordToTemporal.put("lunchtime", SUTime.LUNCHTIME);
        this.wordToTemporal.put("dinnertime", SUTime.DINNERTIME);
        this.wordToTemporal.put("suppertime", SUTime.DINNERTIME);
        this.wordToTemporal.put("daylight", SUTime.DAYTIME);
        this.wordToTemporal.put("day", SUTime.DAYTIME);
        this.wordToTemporal.put("daytime", SUTime.DAYTIME);
        this.wordToTemporal.put("nighttime", SUTime.NIGHT);
        this.wordToTemporal.put("night", SUTime.NIGHT);
        this.wordToTemporal.put("summer", SUTime.SUMMER);
        this.wordToTemporal.put("winter", SUTime.WINTER);
        this.wordToTemporal.put("fall", SUTime.FALL);
        this.wordToTemporal.put("autumn", SUTime.FALL);
        this.wordToTemporal.put("spring", SUTime.SPRING);
        this.wordToTemporal.put("yesterday", SUTime.YESTERDAY);
        this.wordToTemporal.put("today", SUTime.TODAY);
        this.wordToTemporal.put("tomorrow", SUTime.TOMORROW);
        this.wordToTemporal.put("tonight", SUTime.TONIGHT);
        this.wordToTemporal.put("tonite", SUTime.TONIGHT);
        this.wordToTemporal.put("monday", SUTime.MONDAY);
        this.wordToTemporal.put("tuesday", SUTime.TUESDAY);
        this.wordToTemporal.put("wednesday", SUTime.WEDNESDAY);
        this.wordToTemporal.put("thursday", SUTime.THURSDAY);
        this.wordToTemporal.put("friday", SUTime.FRIDAY);
        this.wordToTemporal.put("saturday", SUTime.SATURDAY);
        this.wordToTemporal.put("sunday", SUTime.SUNDAY);
        this.wordToTemporal.put("mon", SUTime.MONDAY);
        this.wordToTemporal.put("tue", SUTime.TUESDAY);
        this.wordToTemporal.put("wed", SUTime.WEDNESDAY);
        this.wordToTemporal.put("thu", SUTime.THURSDAY);
        this.wordToTemporal.put("fri", SUTime.FRIDAY);
        this.wordToTemporal.put("sat", SUTime.SATURDAY);
        this.wordToTemporal.put("sun", SUTime.SUNDAY);
        this.wordToTemporal.put("january", SUTime.JANUARY);
        this.wordToTemporal.put("february", SUTime.FEBRUARY);
        this.wordToTemporal.put("march", SUTime.MARCH);
        this.wordToTemporal.put("april", SUTime.APRIL);
        this.wordToTemporal.put("may", SUTime.MAY);
        this.wordToTemporal.put("june", SUTime.JUNE);
        this.wordToTemporal.put("july", SUTime.JULY);
        this.wordToTemporal.put("august", SUTime.AUGUST);
        this.wordToTemporal.put("september", SUTime.SEPTEMBER);
        this.wordToTemporal.put("october", SUTime.OCTOBER);
        this.wordToTemporal.put("november", SUTime.NOVEMBER);
        this.wordToTemporal.put("december", SUTime.DECEMBER);
        this.wordToTemporal.put("weekend", SUTime.WEEKEND);
        this.wordToTemporal.put("week", SUTime.WEEK);
        this.wordToTemporal.put("fortnight", SUTime.FORTNIGHT);
        this.wordToTemporal.put("month", SUTime.MONTH);
        this.wordToTemporal.put("quarter", SUTime.QUARTER);
        this.wordToTemporal.put("year", SUTime.YEAR);
        this.wordToTemporal.put("decade", SUTime.DECADE);
        this.wordToTemporal.put("century", SUTime.CENTURY);
        this.wordToTemporal.put("millennium", SUTime.MILLENNIUM);
        this.wordToTemporal.put("millennia", SUTime.MILLENNIUM);
        this.wordToTemporal.put("millenium", SUTime.MILLENNIUM);
        this.wordToTemporal.put("millenia", SUTime.MILLENNIUM);
        this.wordToTemporal.put("past", SUTime.TIME_PAST);
        this.wordToTemporal.put("present", SUTime.TIME_PRESENT);
        this.wordToTemporal.put("current", SUTime.TIME_PRESENT);
        this.wordToTemporal.put("once", SUTime.TIME_PAST);
        this.wordToTemporal.put("future", SUTime.TIME_FUTURE);
        this.wordToTemporal.put("thefuture", SUTime.TIME_FUTURE);
    }

    private void initTimeUnitsMap() {
        this.abbToTimeUnit.put("years", SUTime.YEAR);
        this.abbToTimeUnit.put("year", SUTime.YEAR);
        this.abbToTimeUnit.put("yrs", SUTime.YEAR);
        this.abbToTimeUnit.put("yr", SUTime.YEAR);
        this.abbToTimeUnit.put("months", SUTime.MONTH);
        this.abbToTimeUnit.put("month", SUTime.MONTH);
        this.abbToTimeUnit.put("mo", SUTime.MONTH);
        this.abbToTimeUnit.put("mos", SUTime.MONTH);
        this.abbToTimeUnit.put("days", SUTime.DAY);
        this.abbToTimeUnit.put("day", SUTime.DAY);
        this.abbToTimeUnit.put("hours", SUTime.HOUR);
        this.abbToTimeUnit.put("hour", SUTime.HOUR);
        this.abbToTimeUnit.put("hrs", SUTime.HOUR);
        this.abbToTimeUnit.put("hr", SUTime.HOUR);
        this.abbToTimeUnit.put("minutes", SUTime.MINUTE);
        this.abbToTimeUnit.put("minute", SUTime.MINUTE);
        this.abbToTimeUnit.put("mins", SUTime.MINUTE);
        this.abbToTimeUnit.put("min", SUTime.MINUTE);
        this.abbToTimeUnit.put("seconds", SUTime.SECOND);
        this.abbToTimeUnit.put("second", SUTime.SECOND);
        this.abbToTimeUnit.put("secs", SUTime.SECOND);
        this.abbToTimeUnit.put("sec", SUTime.SECOND);
        this.abbToTimeUnit.put("weeks", SUTime.WEEK);
        this.abbToTimeUnit.put("week", SUTime.WEEK);
        this.abbToTimeUnit.put("wks", SUTime.WEEK);
        this.abbToTimeUnit.put("wk", SUTime.WEEK);
        this.abbToTimeUnit.put("quarter", SUTime.QUARTER);
        this.abbToTimeUnit.put("quarters", SUTime.QUARTER);
        this.abbToTimeUnit.put("decades", SUTime.DECADE);
        this.abbToTimeUnit.put("decade", SUTime.DECADE);
        this.abbToTimeUnit.put("decs", SUTime.DECADE);
        this.abbToTimeUnit.put("dec", SUTime.DECADE);
        this.abbToTimeUnit.put("centurys", SUTime.CENTURY);
        this.abbToTimeUnit.put("century", SUTime.CENTURY);
        this.abbToTimeUnit.put("centuries", SUTime.CENTURY);
        this.abbToTimeUnit.put("centurie", SUTime.CENTURY);
        this.abbToTimeUnit.put("millennias", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millennia", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millenniums", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millennium", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millenias", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millenia", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("milleniums", SUTime.MILLENNIUM);
        this.abbToTimeUnit.put("millenium", SUTime.MILLENNIUM);
    }

    protected SUTime.Temporal addSet(String expression, SUTime.Temporal temporal) {
        return null;
    }

    protected static SUTime.Temporal addMod(String expression, SUTime.Temporal temporal) {
        if (expression.matches("(?i).*\\b(late|end)\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.LATE.name());
        }
        if (expression.matches("(?i).*\\bno\\s+more\\s+than\\b.*") || expression.matches("(?i).*\\bup\\s+to\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.EQUAL_OR_LESS.name());
        }
        if (expression.matches("(?i).*\\bmore\\s+than\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.MORE_THAN.name());
        }
        if (expression.matches("(?i).*\\bno\\s+less\\s+than\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.EQUAL_OR_MORE.name());
        }
        if (expression.matches("(?i).*\\bless\\s+than\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.LESS_THAN.name());
        }
        if (expression.matches("(?i).*\\b(early|start|beginning|dawn\\s+of)\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.EARLY.name());
        }
        if (expression.matches("(?i).*\\bmid(dle)?\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.MID.name());
        }
        if (expression.matches("(?i).*\\bat\\s+least\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.EQUAL_OR_MORE.name());
        }
        if (expression.matches("(?i).*\\b(about|around|some)\\b.*")) {
            return temporal.addMod(SUTime.TimexMod.APPROX.name());
        }
        return temporal;
    }

    public SUTime.Time parseDateTime(String dateStr) {
        SUTime.IsoTime isoTime;
        if (dateStr == null) {
            return null;
        }
        Pattern p = Pattern.compile("(\\d\\d\\d\\d)-?(\\d\\d)-?(\\d\\d)(-?(?:T(\\d\\d):?(\\d\\d)?:?(\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?))?");
        Matcher m = p.matcher(dateStr);
        if (m.matches()) {
            String time = m.group(4);
            SUTime.IsoDate isoDate = new SUTime.IsoDate(m.group(1), m.group(2), m.group(3));
            if (time != null) {
                SUTime.IsoTime isoTime2 = new SUTime.IsoTime(m.group(5), m.group(6), m.group(7), m.group(8));
                return new SUTime.IsoDateTime(isoDate, isoTime2);
            }
            return isoDate;
        }
        p = Pattern.compile("(\\d\\d\\d\\d)(\\d\\d)(\\d\\d):(\\d\\d)(\\d\\d)");
        m = p.matcher(dateStr);
        if (m.matches()) {
            SUTime.IsoDate date = EnglishTimeExpressionPatterns.createIsoDate(m.group(1), m.group(2), m.group(3));
            SUTime.IsoTime time = new SUTime.IsoTime(m.group(4), m.group(5), null);
            return new SUTime.IsoDateTime(date, time);
        }
        p = Pattern.compile("T(\\d\\d):?(\\d\\d)?:?(\\d\\d)?(?:[.,](\\d{1,3}))?([+-]\\d\\d:?\\d\\d)?");
        m = p.matcher(dateStr);
        if (m.matches()) {
            return new SUTime.IsoTime(m.group(1), m.group(2), m.group(3), m.group(4));
        }
        SUTime.IsoDate isoDate = null;
        p = this.getPattern(".*(\\d\\d?)\\s+($TEmonth|$TEmonthabbr\\.?),?\\s+(\\d\\d(\\s|\\Z)|\\d{4}\\b).*");
        m = p.matcher(dateStr);
        if (m.matches()) {
            isoDate = EnglishTimeExpressionPatterns.createIsoDate(m.group(5), m.group(2), m.group(1));
        }
        if (isoDate == null && (m = (p = this.getPattern(".*($TEmonth|$TEmonthabbr\\.?)\\s+(\\d\\d?|$TEOrdinalWords)\\b,?\\s*(\\d\\d(\\s|\\Z)|\\d{4}\\b).*")).matcher(dateStr)).matches()) {
            isoDate = EnglishTimeExpressionPatterns.createIsoDate(m.group(6), m.group(1), m.group(4));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d\\d\\d)\\/(\\d\\d?)\\/(\\d\\d?).*")).matcher(dateStr)).matches()) {
            isoDate = new SUTime.IsoDate(m.group(1), m.group(2), m.group(3));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d\\d\\d)\\-(\\d\\d?)\\-(\\d\\d?).*")).matcher(dateStr)).matches()) {
            isoDate = new SUTime.IsoDate(m.group(1), m.group(2), m.group(3));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\/(\\d\\d?)\\/(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new SUTime.IsoDate(m.group(3), m.group(1), m.group(2));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\-(\\d\\d?)\\-(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new SUTime.IsoDate(m.group(3), m.group(1), m.group(2));
        }
        if (isoDate == null && (m = (p = Pattern.compile(".*(\\d\\d?)\\.(\\d\\d?)\\.(\\d\\d(\\d\\d)?).*")).matcher(dateStr)).matches()) {
            isoDate = new SUTime.IsoDate(m.group(3), m.group(2), m.group(1));
        }
        if (isoDate == null && (m = (p = this.getPattern(".*($TEmonth|$TEmonthabbr\\.?)\\s+(\\d\\d?).+(\\d\\d\\d\\d)\\b.*")).matcher(dateStr)).matches()) {
            int year = Integer.parseInt(m.group(5));
            isoDate = year >= 1900 && year <= 2100 ? EnglishTimeExpressionPatterns.createIsoDate(m.group(5), m.group(1), m.group(4)) : EnglishTimeExpressionPatterns.createIsoDate(null, m.group(1), m.group(4));
        }
        if ((isoTime = null) != null || (m = (p = Pattern.compile(".*(\\d?\\d):(\\d\\d)(:(\\d\\d)(\\.\\d+)?)?(\\s*([AP])\\.?M\\.?)?(\\s+([+\\-]\\d+|[A-Z][SD]T|GMT([+\\-]\\d+)?))?.*")).matcher(dateStr)).matches()) {
            // empty if block
        }
        if (isoTime == null && (m = (p = Pattern.compile("")).matcher(dateStr)).matches()) {
            isoTime = new SUTime.IsoTime(m.group(1), m.group(2), m.group(3));
        }
        if (isoDate != null && isoTime != null) {
            return new SUTime.IsoDateTime(isoDate, isoTime);
        }
        if (isoDate != null) {
            return isoDate;
        }
        return isoTime;
    }

    public static SUTime.IsoDate createIsoDate(String year, String month, String day) {
        String y = EnglishDateTimeUtils.year2Iso(year);
        String m = EnglishDateTimeUtils.month2Iso(month);
        String d = EnglishDateTimeUtils.day2Iso(m, day);
        return new SUTime.IsoDate(y, m, d);
    }

    static class TimeExpressionTokenSeqFilter
    implements Filter<TimeExpression> {
        private static final long serialVersionUID = 1L;
        TokenSequencePattern pattern;
        boolean acceptPattern = true;

        TimeExpressionTokenSeqFilter(TokenSequencePattern pattern, boolean acceptPattern) {
            this.pattern = pattern;
            this.acceptPattern = acceptPattern;
        }

        @Override
        public boolean accept(TimeExpression obj) {
            boolean matched = this.pattern.getMatcher((List)obj.getAnnotation().get(CoreAnnotations.TokensAnnotation.class)).matches();
            if (this.acceptPattern) {
                return matched;
            }
            return !matched;
        }
    }

    static class TokenSeqPatternFilter
    implements Filter<List<? extends CoreMap>> {
        private static final long serialVersionUID = -596297552394987521L;
        TokenSequencePattern pattern;

        TokenSeqPatternFilter(TokenSequencePattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(List<? extends CoreMap> obj) {
            return this.pattern.getMatcher((List)obj).find();
        }
    }

    static class PatternFilter
    implements Filter<String> {
        private static final long serialVersionUID = 802406900800457283L;
        Pattern pattern;

        PatternFilter(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        PatternFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(String obj) {
            return this.pattern.matcher(obj).find();
        }
    }

    private static class TimexTypeMatchNodePattern
    extends NodePattern<TimeExpression> {
        SUTime.TimexType type;

        public TimexTypeMatchNodePattern(SUTime.TimexType type) {
            this.type = type;
        }

        @Override
        public boolean match(TimeExpression te) {
            SUTime.Temporal t;
            if (te != null && (t = te.getTemporal()) != null) {
                return this.type.equals((Object)t.getTimexType());
            }
            return false;
        }
    }

    protected static enum PatternType {
        TOKENS,
        STRING;

    }
}

