/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.time.SUTime;
import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.Generics;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class EnglishDateTimeUtils {
    private static final Map<String, String> fixedHol2Date;
    private static final Map<String, String> nthDOWHol2Date;
    private static final String[] months;
    private static final Map<String, Integer> month2Num;
    private static final String[] dayOfWeek;
    private static final Map<String, Integer> day2Num;
    private static final Map<String, Integer> teTimeZones;
    private static final Map<String, String> teSeason;
    private static final Map<String, Integer> teSeason2Month;
    private static final int[] teMl;
    private static final int[] teCumMl;
    private static final Map<String, Integer> teOrd2Num;
    private static final Map<String, Integer> teDecadeNums;
    private static final Pattern isoDateFormat;
    private static final Pattern isoYearWeekFormat;
    private static final Pattern yearEraPattern;

    private EnglishDateTimeUtils() {
    }

    private static int getMonthLength(int year, int month) {
        int ml = month == 2 && EnglishDateTimeUtils.isLeapYear(year) ? 29 : teMl[month];
        return ml;
    }

    private static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    private static int dayOfYear(String iso) {
        Matcher matcher = isoDateFormat.matcher(iso);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            return EnglishDateTimeUtils.dayOfYear(year, month, day);
        }
        return 0;
    }

    private static int dayOfYear(int year, int month, int day) {
        int doy = teCumMl[month - 1] + day;
        if (EnglishDateTimeUtils.isLeapYear(year) && month > 2) {
            ++doy;
        }
        return doy;
    }

    private static SUTime.IsoDate parseIsoDate(String iso) {
        Matcher matcher = isoDateFormat.matcher(iso);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            return new SUTime.IsoDate(year, month, day);
        }
        return null;
    }

    private static String week2DateIso(String iso) {
        Matcher matcher = isoYearWeekFormat.matcher(iso);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int week = Integer.parseInt(matcher.group(2));
            return EnglishDateTimeUtils.week2DateIso(year, week);
        }
        return "00000001";
    }

    private static String week2DateIso(int year, int week) {
        int doy;
        int month = 1;
        int ml = EnglishDateTimeUtils.getMonthLength(year, month);
        for (doy = week * 7 - 3; doy > ml; doy -= ml) {
            if (++month > 12) {
                return "00000002";
            }
            ml = EnglishDateTimeUtils.getMonthLength(year, month);
        }
        String isoOut = String.format("%04d%02d%02d", year, month, doy);
        return isoOut;
    }

    protected static String date2Week(String iso) {
        SUTime.IsoDate isoDate = EnglishDateTimeUtils.parseIsoDate(iso);
        if (isoDate != null) {
            return EnglishDateTimeUtils.date2Week(isoDate.year, isoDate.month, isoDate.day);
        }
        return null;
    }

    private static String date2Week(int year, int month, int day) {
        int dl = EnglishDateTimeUtils.date2DOW(year, 1, 1);
        int doy = EnglishDateTimeUtils.dayOfYear(year, month, day);
        if (dl > 4 && doy < 7 - doy) {
            dl = EnglishDateTimeUtils.date2DOW(--year, 1, 1);
            doy += 365 + (EnglishDateTimeUtils.isLeapYear(year) ? 1 : 0);
        }
        int w = (doy + dl + 5) / 7;
        if (dl > 4) {
            --w;
        }
        String weekStr = String.format("%4dW%02d", year, w);
        return weekStr;
    }

    private static int date2DOW(String iso) {
        SUTime.IsoDate isoDate = EnglishDateTimeUtils.parseIsoDate(iso);
        if (isoDate != null) {
            return EnglishDateTimeUtils.date2DOW(isoDate.year, isoDate.month, isoDate.day);
        }
        return 7;
    }

    private static int date2DOW(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year - a;
        int m = month + 12 * a - 2;
        int d = (day + y + y / 4 - y / 100 + y / 400 + 31 * m / 12) % 7;
        return d;
    }

    protected static int nthDOW2Date(int month, int dow, int nth, int year) {
        String str;
        int firstDow;
        int shift;
        if (dow == 7) {
            dow = 0;
        }
        if ((shift = dow - (firstDow = EnglishDateTimeUtils.date2DOW(str = String.format("%04d%02d01", year, month)))) < 0) {
            shift += 7;
        }
        return shift + 7 * nth - 6;
    }

    private static String getEasterDate(int year) {
        int g = year % 19;
        int c = year / 100;
        int h = (c - c / 4 - (8 * c + 13) / 25 + 19 * g + 15) % 30;
        int i = h - h / 28 * (1 - h / 28 * (29 / (h + 1)) * ((21 - g) / 11));
        int j = (year + year / 4 + i + 2 - c + c / 4) % 7;
        int l = i - j;
        int m = 3 + (l + 40) / 44;
        int d = l + 28 - 31 * (m / 4);
        String date = String.format("%04d%02d%02d", year, m, d);
        return date;
    }

    protected static String month2Iso(String month) {
        int m = EnglishDateTimeUtils.month2Num(month);
        if (m < 0) {
            return null;
        }
        return String.format("%02d", m);
    }

    protected static int month2Num(String month) {
        if (month == null) {
            return -1;
        }
        if (Character.isLetter(month.charAt(0))) {
            month = month.substring(0, 3).toLowerCase();
            return month2Num.get(month);
        }
        return Integer.parseInt(month);
    }

    protected static String day2Iso(String month, String day) {
        int d = EnglishDateTimeUtils.day2Num(EnglishDateTimeUtils.month2Num(month), day);
        if (d < 0) {
            return null;
        }
        return String.format("%02d", d);
    }

    protected static int day2Num(int month, String day) {
        if (day == null) {
            return -1;
        }
        if (Character.isLetter((day = day.toLowerCase()).charAt(0))) {
            if ("ides".equals(day)) {
                return month == 3 || month == 5 || month == 7 || month == 10 ? 15 : 13;
            }
            if ("nones".equals(day)) {
                return month == 3 || month == 5 || month == 7 || month == 10 ? 7 : 5;
            }
            Number d2 = NumberNormalizer.wordToNumber(day);
            if (d2 != null) {
                return d2.intValue();
            }
            return -1;
        }
        if (day.endsWith("th") || day.endsWith("rd") || day.endsWith("nd") || day.endsWith("st")) {
            day = day.substring(0, day.length() - 2);
        }
        return Integer.parseInt(day);
    }

    protected static int year2Num(String year) {
        if (year == null) {
            return -1;
        }
        return Integer.parseInt(year);
    }

    protected static String year2Iso(String year) {
        Number y;
        String[] fields;
        if (year == null) {
            return null;
        }
        if (year.matches("[+-]?[0-9X]{4}")) {
            return year;
        }
        if ((year = year.toLowerCase()).startsWith("'")) {
            year = year.substring(1);
        }
        boolean negative = false;
        Matcher m = yearEraPattern.matcher(year);
        if (m.find()) {
            String era = m.group(1);
            year = m.replaceAll("");
            if (era.startsWith("b")) {
                negative = true;
            }
        }
        if (year.endsWith("ties")) {
            fields = year.split("\\s+|-");
            if (fields.length == 2) {
                Number century = NumberNormalizer.wordToNumber(fields[0]);
                Integer decade = teDecadeNums.get(fields[1]);
                if (decade != null && century != null) {
                    String res = String.format("%02d%01dX", century.intValue(), decade);
                    return negative ? "-" + res : res;
                }
                throw new IllegalArgumentException("Invalid year: " + year);
            }
            if (fields.length == 1) {
                Integer decade = teDecadeNums.get(fields[0]);
                if (decade != null) {
                    String res = String.format("XX%01dX", decade);
                    return negative ? "-" + res : res;
                }
                throw new IllegalArgumentException("Invalid year: " + year);
            }
            throw new IllegalArgumentException("Invalid year: " + year);
        }
        if (year.endsWith("0s")) {
            fields = (year = year.substring(0, year.length() - 1)).split("\\s+|-");
            if (fields.length == 2) {
                Number century = NumberNormalizer.wordToNumber(fields[0]);
                Number decade = NumberNormalizer.wordToNumber(fields[1]);
                if (decade != null && century != null) {
                    String res = String.format("%02d%01dX", century.intValue(), decade.intValue() / 10);
                    return negative ? "-" + res : res;
                }
                throw new IllegalArgumentException("Invalid year: " + year);
            }
            if (fields.length == 1) {
                Number decade = NumberNormalizer.wordToNumber(fields[0]);
                if (decade != null) {
                    if (decade.intValue() < 100) {
                        String res = String.format("XX%01dX", decade.intValue() / 10);
                        return negative ? "-" + res : res;
                    }
                    if (decade.intValue() % 100 == 0) {
                        String res = String.format("%02dXX", decade.intValue() / 100);
                        return negative ? "-" + res : res;
                    }
                    String res = String.format("%03dX", decade.intValue() / 10);
                    return negative ? "-" + res : res;
                }
                throw new IllegalArgumentException("Invalid year: " + year);
            }
            throw new IllegalArgumentException("Invalid year: " + year);
        }
        if (year.contains("teen ") && (fields = year.split("\\s+", 2)).length == 2) {
            Number a = NumberNormalizer.wordToNumber(fields[0]);
            Number b = NumberNormalizer.wordToNumber(fields[1]);
            if (b.intValue() > 0 && b.intValue() < 100) {
                if (negative) {
                    int v = a.intValue() * 100 + b.intValue();
                    return String.format("-%04d", --v);
                }
                return String.format("%02d%02d", a.intValue(), b.intValue());
            }
        }
        if ((y = NumberNormalizer.wordToNumber(year)) != null) {
            int v = y.intValue();
            if (negative) {
                return String.format("-%04d", --v);
            }
            return String.format("%04d", v);
        }
        throw new IllegalArgumentException("Invalid year: " + year);
    }

    static {
        int i;
        fixedHol2Date = Generics.newHashMap(30);
        fixedHol2Date.put("newyear", "0101");
        fixedHol2Date.put("inauguration", "0120");
        fixedHol2Date.put("valentine", "0214");
        fixedHol2Date.put("ground", "0202");
        fixedHol2Date.put("candlemas", "0202");
        fixedHol2Date.put("patrick", "0317");
        fixedHol2Date.put("fool", "0401");
        fixedHol2Date.put("st.george", "0423");
        fixedHol2Date.put("saintgeorge", "0423");
        fixedHol2Date.put("walpurgisnacht", "0430");
        fixedHol2Date.put("mayday", "0501");
        fixedHol2Date.put("beltane", "0501");
        fixedHol2Date.put("cinco", "0505");
        fixedHol2Date.put("flag", "0614");
        fixedHol2Date.put("baptiste", "0624");
        fixedHol2Date.put("dominion", "0701");
        fixedHol2Date.put("canada", "0701");
        fixedHol2Date.put("independence", "0704");
        fixedHol2Date.put("bastille", "0714");
        fixedHol2Date.put("halloween", "1031");
        fixedHol2Date.put("allhallow", "1101");
        fixedHol2Date.put("allsaints", "1101");
        fixedHol2Date.put("allsouls", "1102");
        fixedHol2Date.put("dayofthedead", "1102");
        fixedHol2Date.put("fawkes", "1105");
        fixedHol2Date.put("veteran", "1111");
        fixedHol2Date.put("christmas", "1225");
        fixedHol2Date.put("xmas", "1225");
        nthDOWHol2Date = Generics.newHashMap(9);
        nthDOWHol2Date.put("mlk", "1-1-3");
        nthDOWHol2Date.put("king", "1-1-3");
        nthDOWHol2Date.put("president", "2-1-3");
        nthDOWHol2Date.put("canberra", "3-1-3");
        nthDOWHol2Date.put("mother", "5-7-2");
        nthDOWHol2Date.put("father", "6-7-3");
        nthDOWHol2Date.put("labor", "9-1-1");
        nthDOWHol2Date.put("columbus", "10-1-2");
        nthDOWHol2Date.put("thanksgiving", "11-4-4");
        months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        month2Num = Generics.newHashMap(months.length);
        for (i = 0; i < months.length; ++i) {
            month2Num.put(months[i], i + 1);
        }
        dayOfWeek = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
        day2Num = Generics.newHashMap(dayOfWeek.length);
        for (i = 0; i < dayOfWeek.length; ++i) {
            day2Num.put(dayOfWeek[i], i);
        }
        teTimeZones = new ArrayMap<String, Integer>(4);
        teTimeZones.put("E", -5);
        teTimeZones.put("C", -6);
        teTimeZones.put("M", -7);
        teTimeZones.put("P", -8);
        teSeason = new ArrayMap<String, String>(5);
        teSeason.put("spring", "SP");
        teSeason.put("summer", "SU");
        teSeason.put("autumn", "FA");
        teSeason.put("fall", "FA");
        teSeason.put("winter", "WI");
        teSeason2Month = new ArrayMap<String, Integer>(4);
        teSeason2Month.put("SP", 4);
        teSeason2Month.put("SU", 6);
        teSeason2Month.put("FA", 9);
        teSeason2Month.put("WI", 12);
        teMl = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        teCumMl = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        teOrd2Num = Generics.newHashMap(31);
        teOrd2Num.put("first", 1);
        teOrd2Num.put("second", 2);
        teOrd2Num.put("third", 3);
        teOrd2Num.put("fourth", 4);
        teOrd2Num.put("fifth", 5);
        teOrd2Num.put("sixth", 6);
        teOrd2Num.put("seventh", 7);
        teOrd2Num.put("eighth", 8);
        teOrd2Num.put("ninth", 9);
        teOrd2Num.put("tenth", 10);
        teOrd2Num.put("eleventh", 11);
        teOrd2Num.put("twelfth", 12);
        teOrd2Num.put("thirteenth", 13);
        teOrd2Num.put("fourteenth", 14);
        teOrd2Num.put("fifteenth", 15);
        teOrd2Num.put("sixteenth", 16);
        teOrd2Num.put("seventeenth", 17);
        teOrd2Num.put("eighteenth", 18);
        teOrd2Num.put("nineteenth", 19);
        teOrd2Num.put("twentieth", 20);
        teOrd2Num.put("twenty-first", 21);
        teOrd2Num.put("twenty-second", 22);
        teOrd2Num.put("twenty-third", 23);
        teOrd2Num.put("twenty-fourth", 24);
        teOrd2Num.put("twenty-fifth", 25);
        teOrd2Num.put("twenty-sixth", 26);
        teOrd2Num.put("twenty-seventh", 27);
        teOrd2Num.put("twenty-eighth", 28);
        teOrd2Num.put("twenty-ninth", 29);
        teOrd2Num.put("thirtieth", 30);
        teOrd2Num.put("thirty-first", 31);
        teDecadeNums = Generics.newHashMap(9);
        teDecadeNums.put("twenties", 2);
        teDecadeNums.put("thirties", 3);
        teDecadeNums.put("forties", 4);
        teDecadeNums.put("fifties", 5);
        teDecadeNums.put("sixties", 6);
        teDecadeNums.put("seventies", 7);
        teDecadeNums.put("eighties", 8);
        teDecadeNums.put("nineties", 9);
        isoDateFormat = Pattern.compile("(\\d\\d\\d\\d)(\\d\\d)(\\d\\d)");
        isoYearWeekFormat = Pattern.compile("(\\d\\d\\d\\d)W(\\d\\d)");
        yearEraPattern = Pattern.compile("\\s*\\b(a\\.?d|b\\.?c)(?:\\.|\\b)\\s*", 2);
    }
}

