/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;

public class SentimentUtils {
    private SentimentUtils() {
    }

    public static void attachGoldLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentUtils.attachGoldLabels(child);
        }
        RNNCoreAnnotations.setGoldClass(tree, Integer.valueOf(tree.label().value()));
    }

    public static List<Tree> readTreesWithGoldLabels(String path) {
        ArrayList<Tree> trees = Generics.newArrayList();
        MemoryTreebank treebank = new MemoryTreebank();
        treebank.loadPath(path, null);
        for (Tree tree : treebank) {
            SentimentUtils.attachGoldLabels(tree);
            trees.add(tree);
        }
        return trees;
    }

    public static String sentimentString(int sentiment) {
        switch (sentiment) {
            case 0: {
                return "Very negative";
            }
            case 1: {
                return "Negative";
            }
            case 2: {
                return "Neutral";
            }
            case 3: {
                return "Positive";
            }
            case 4: {
                return "Very positive";
            }
        }
        return "Unknown sentiment label " + sentiment;
    }
}

