/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import org.ejml.simple.SimpleMatrix;

public class SentimentPipeline {
    private static final NumberFormat NF = new DecimalFormat("0.0000");

    static void setSentimentLabels(Tree tree) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentPipeline.setSentimentLabels(child);
        }
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("Required a tree with CoreLabels");
        }
        CoreLabel cl = (CoreLabel)label;
        cl.setValue(Integer.toString(RNNCoreAnnotations.getPredictedClass(tree)));
    }

    static int setIndexLabels(Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        tree.label().setValue(Integer.toString(index));
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.setIndexLabels(child, index);
        }
        return index;
    }

    static int outputTreeVectors(Tree tree, int index) {
        if (tree.isLeaf()) {
            return index;
        }
        System.out.print("  " + index + ":");
        SimpleMatrix vector = RNNCoreAnnotations.getNodeVector(tree);
        for (int i = 0; i < vector.getNumElements(); ++i) {
            System.out.print("  " + NF.format(vector.get(i)));
        }
        System.out.println();
        ++index;
        for (Tree child : tree.children()) {
            index = SentimentPipeline.outputTreeVectors(child, index);
        }
        return index;
    }

    static void outputTree(Tree tree, Output output) {
        switch (output) {
            case PENNTREES: {
                Tree copy = tree.deepCopy();
                SentimentPipeline.setSentimentLabels(copy);
                System.out.println(copy);
                break;
            }
            case VECTORS: {
                Tree copy = tree.deepCopy();
                SentimentPipeline.setIndexLabels(copy, 0);
                System.out.println(copy);
                SentimentPipeline.outputTreeVectors(tree, 0);
                break;
            }
            case ROOT: {
                int sentiment = RNNCoreAnnotations.getPredictedClass(tree);
                System.out.println("  " + SentimentUtils.sentimentString(sentiment));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown output format " + (Object)((Object)output));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String parserModel = null;
        String sentimentModel = null;
        String filename = null;
        boolean stdin = false;
        Output output = Output.ROOT;
        int argIndex = 0;
        while (argIndex < args.length) {
            if (args[argIndex].equalsIgnoreCase("-sentimentModel")) {
                sentimentModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-parserModel")) {
                parserModel = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-file")) {
                filename = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-stdin")) {
                stdin = true;
                ++argIndex;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-output")) {
                String format = args[argIndex + 1];
                output = Output.valueOf(format.toUpperCase());
                argIndex += 2;
                continue;
            }
            System.err.println("Unknown argument " + args[argIndex + 1]);
            throw new IllegalArgumentException("Unknown argument " + args[argIndex + 1]);
        }
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, parse, sentiment");
        if (sentimentModel != null) {
            props.setProperty("sentiment.model", sentimentModel);
        }
        if (parserModel != null) {
            props.setProperty("parse.model", parserModel);
        }
        if (filename != null && stdin) {
            throw new IllegalArgumentException("Please only specify one of -file or -stdin");
        }
        if (filename == null && !stdin) {
            throw new IllegalArgumentException("Please specify either -file or -stdin");
        }
        if (stdin) {
            props.setProperty("ssplit.eolonly", "true");
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        if (filename != null) {
            String text = IOUtils.slurpFileNoExceptions(filename);
            Annotation annotation = new Annotation(text);
            pipeline.annotate(annotation);
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                Tree tree = (Tree)sentence.get(SentimentCoreAnnotations.AnnotatedTree.class);
                System.out.println(sentence);
                SentimentPipeline.outputTree(tree, output);
            }
        } else {
            String line;
            System.err.println("Reading in text from stdin.");
            System.err.println("Please enter one sentence per line.");
            System.err.println("Processing will end when EOF is reached.");
            BufferedReader reader = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, "utf-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    Annotation annotation = pipeline.process(line);
                    for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                        Tree tree = (Tree)sentence.get(SentimentCoreAnnotations.AnnotatedTree.class);
                        SentimentPipeline.outputTree(tree, output);
                    }
                    continue;
                }
                System.out.println("");
            }
        }
    }

    static enum Output {
        PENNTREES,
        VECTORS,
        ROOT;

    }
}

