/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.sentiment.RNNTrainOptions;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.io.Serializable;
import java.util.Random;

public class RNNOptions
implements Serializable {
    public int randomSeed = new Random().nextInt();
    public String wordVectors;
    public String unkWord = "UNK";
    public boolean randomWordVectors = true;
    public int numHid = 25;
    public int numClasses = 5;
    public boolean lowercaseWordVectors = false;
    public boolean useTensors = true;
    public TreebankLanguagePack langpack = new PennTreebankLanguagePack();
    public boolean simplifiedModel = true;
    public boolean combineClassification = true;
    public RNNTrainOptions trainOptions = new RNNTrainOptions();
    private static final long serialVersionUID = 1L;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("GENERAL OPTIONS\n");
        result.append("randomSeed=" + this.randomSeed + "\n");
        result.append("wordVectors=" + this.wordVectors + "\n");
        result.append("unkWord=" + this.unkWord + "\n");
        result.append("randomWordVectors=" + this.randomWordVectors + "\n");
        result.append("numHid=" + this.numHid + "\n");
        result.append("numClasses=" + this.numClasses + "\n");
        result.append("lowercaseWordVectors=" + this.lowercaseWordVectors + "\n");
        result.append("useTensors=" + this.useTensors + "\n");
        result.append("simplifiedModel=" + this.simplifiedModel + "\n");
        result.append("combineClassification=" + this.combineClassification + "\n");
        result.append(this.trainOptions.toString());
        return result.toString();
    }

    public int setOption(String[] args, int argIndex) {
        if (args[argIndex].equalsIgnoreCase("-randomSeed")) {
            this.randomSeed = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-wordVectors")) {
            this.wordVectors = args[argIndex + 1];
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-unkWord")) {
            this.unkWord = args[argIndex] + 1;
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-numHid")) {
            this.numHid = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-numClasses")) {
            this.numClasses = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-lowercaseWordVectors")) {
            this.lowercaseWordVectors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nolowercaseWordVectors")) {
            this.lowercaseWordVectors = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-randomWordVectors")) {
            this.randomWordVectors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-norandomWordVectors")) {
            this.randomWordVectors = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-simplifiedModel")) {
            this.simplifiedModel = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nosimplifiedModel")) {
            this.simplifiedModel = false;
            this.combineClassification = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-combineClassification")) {
            this.combineClassification = true;
            this.simplifiedModel = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nocombineClassification")) {
            this.combineClassification = false;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-useTensors")) {
            this.useTensors = true;
            return argIndex + 1;
        }
        if (args[argIndex].equalsIgnoreCase("-nouseTensors")) {
            this.useTensors = false;
            return argIndex + 1;
        }
        return this.trainOptions.setOption(args, argIndex);
    }
}

