/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading;

import edu.stanford.nlp.ie.machinereading.BasicEntityExtractor;
import edu.stanford.nlp.ie.machinereading.Extractor;
import edu.stanford.nlp.ie.machinereading.GenericDataSetReader;
import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.RelationFeatureFactory;
import edu.stanford.nlp.ie.machinereading.structure.RelationMentionFactory;
import edu.stanford.nlp.util.Execution;
import java.util.logging.Logger;

public class MachineReadingProperties {
    @Execution.Option(name="logger", gloss="Static logger for this entire class")
    public static Logger logger = Logger.getLogger(MachineReading.class.getName());
    @Execution.Option(name="datasetReaderClass", gloss="which GenericDataSetReader to use (needs to match the corpus in question)", required=true)
    public static Class<GenericDataSetReader> datasetReaderClass;
    @Execution.Option(name="datasetAuxReaderClass", gloss="which GenericDataSetReader to use for aux data set (needs to match the corpus in question)")
    public static Class<GenericDataSetReader> datasetAuxReaderClass;
    @Execution.Option(name="useNewHeadFinder", gloss="If false, use the original head (and worse) finding mechanism in GenericDataSetReader.  This option is primarily around for legacy purposes.")
    public static boolean useNewHeadFinder;
    @Execution.Option(name="readerLogLevel", gloss="verbosity of the corpus reader")
    public static String readerLogLevel;
    @Execution.Option(name="serializeCorpora", gloss="if false, we do not attempt to serialize the train/test corpora after reading")
    public static boolean serializeCorpora;
    @Execution.Option(name="forceGenerationOfIndexSpans", gloss="if true (default), regenerate span annotations for trees")
    public static boolean forceGenerationOfIndexSpans;
    @Execution.Option(name="serializedEntityExtractorPath", gloss="where to store/load the serialized entity extraction model")
    protected static String serializedEntityExtractorPath;
    @Execution.Option(name="serializedEntityExtractionResults", gloss="where to store the serialized sentences containing the results of entity extraction")
    protected static String serializedEntityExtractionResults;
    @Execution.Option(name="entityGazetteerPath", gloss="location of entity gazetteer file (if you're using one) -- this is a temporary option")
    public static String entityGazetteerPath;
    @Execution.Option(name="entityClassifier", gloss="entity extractor class to use")
    public static Class<BasicEntityExtractor> entityClassifier;
    @Execution.Option(name="entityResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of entity extraction")
    public static String entityResultsPrinters;
    @Execution.Option(name="serializedRelationExtractorPath", gloss="where to store/load the serialized relation extraction model")
    protected static String serializedRelationExtractorPath;
    @Execution.Option(name="serializedRelationExtractionResults", gloss="where to store the serialized sentences containing the results of relation extraction")
    protected static String serializedRelationExtractionResults;
    @Execution.Option(name="relationFeatureFactoryClass", gloss="FeatureFactory class to use for generating features from relations for relation extraction")
    public static Class<RelationFeatureFactory> relationFeatureFactoryClass;
    @Execution.Option(name="relationMentionFactoryClass", gloss="relation mention factory class to use.")
    public static Class<RelationMentionFactory> relationMentionFactoryClass;
    @Execution.Option(name="relationFeatures", gloss="comma-separated list of feature types to generate for relation extraction.")
    public static String relationFeatures;
    @Execution.Option(name="relationResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of relation extraction")
    public static String relationResultsPrinters;
    @Execution.Option(name="trainRelationsUsingPredictedEntities", gloss="if true, the relation extraction model trains using predicted rather than gold entity mentions")
    public static boolean trainRelationsUsingPredictedEntities;
    @Execution.Option(name="testRelationsUsingPredictedEntities", gloss="if true, the relation extraction model is evaluated using predicted rather than gold entity mentions.")
    public static boolean testRelationsUsingPredictedEntities;
    @Execution.Option(name="createUnrelatedRelations", gloss="If true, it creates automatically negative examples by generating all combinations between EntityMentions in a sentence")
    public static boolean createUnrelatedRelations;
    @Execution.Option(name="doNotLexicalizeFirstArg", gloss="If true, it does not create any lexicalized features from the first argument (needed for KBP)")
    public static boolean doNotLexicalizeFirstArg;
    @Execution.Option(name="useRelationExtractionModelMerging", gloss="If true, the relation extractor will use ExtractorMerger for annotation (not training)")
    public static boolean useRelationExtractionModelMerging;
    @Execution.Option(name="relationsToSkipDuringTraining", gloss="comma-separated list relation types to skip during training")
    public static String relationsToSkipDuringTraining;
    @Execution.Option(name="relationExtractionPostProcessorClass", gloss="additional (probably domain-dependent) annotator to postprocess relations")
    public static Class<Extractor> relationExtractionPostProcessorClass;
    @Execution.Option(name="serializedEventExtractorPath", gloss="where to store/load the serialized event extraction model")
    protected static String serializedEventExtractorPath;
    @Execution.Option(name="serializedEventExtractionResults", gloss="where to store the serialized sentences containing the results of event extraction")
    protected static String serializedEventExtractionResults;
    @Execution.Option(name="eventResultsPrinters", gloss="comma-separated list of ResultsPrinter subclasses to use for printing the results of event extraction")
    public static String eventResultsPrinters;
    @Execution.Option(name="trainEventsUsingPredictedEntities", gloss="if true, the event extraction model trains using predicted rather than gold entity mentions")
    public static boolean trainEventsUsingPredictedEntities;
    @Execution.Option(name="testEventsUsingPredictedEntities", gloss="if true, the event extraction model is evaluated using predicted rather than gold entity mentions")
    public static boolean testEventsUsingPredictedEntities;
    @Execution.Option(name="consistencyCheck", gloss="consistency checker class to use")
    public static Class<Extractor> consistencyCheck;
    @Execution.Option(name="trainPath", gloss=" path to the training file/directory")
    protected static String trainPath;
    @Execution.Option(name="auxDataPath", gloss="path to the aux training file/directory")
    protected static String auxDataPath;
    @Execution.Option(name="serializedTrainingSentencesPath", gloss=" where to store the serialized training sentences objects", required=true)
    protected static String serializedTrainingSentencesPath;
    @Execution.Option(name="serializedAuxTrainingSentencesPath", gloss="where to store the serialized aux training sentences objects")
    protected static String serializedAuxTrainingSentencesPath;
    @Execution.Option(name="loadModel", gloss="if true, load a serialized model rather than training a new one")
    protected static boolean loadModel;
    @Execution.Option(name="trainOnly", gloss="if true, don't run evaluation (implies forceRetraining)")
    protected static boolean trainOnly;
    @Execution.Option(name="testPath", gloss="path to the testing file/directory")
    protected static String testPath;
    @Execution.Option(name="serializedTestSentencesPath", gloss="where to store the serialized test sentence objects")
    protected static String serializedTestSentencesPath;
    @Execution.Option(name="extractEntities", gloss="whether to extract entities, or use gold-standard entities for relation/event extraction")
    protected static boolean extractEntities;
    @Execution.Option(name="extractRelations", gloss="whether we should extract relations")
    protected static boolean extractRelations;
    @Execution.Option(name="extractEvents", gloss="whether we should extract events")
    protected static boolean extractEvents;
    @Execution.Option(name="crossValidate", gloss="if true, run cross-validation")
    protected static boolean crossValidate;
    @Execution.Option(name="kfold", gloss="number of partitions in training data for cross validation")
    public static int kfold;
    @Execution.Option(name="percentageOfTrain", gloss="Pct of train partition to use for training (e.g. for RELMS experiment)")
    public static double percentageOfTrain;

    static {
        useNewHeadFinder = true;
        readerLogLevel = "SEVERE";
        serializeCorpora = true;
        forceGenerationOfIndexSpans = true;
        serializedEntityExtractorPath = "";
        entityClassifier = BasicEntityExtractor.class;
        entityResultsPrinters = "";
        serializedRelationExtractorPath = null;
        serializedRelationExtractionResults = null;
        relationFeatureFactoryClass = RelationFeatureFactory.class;
        relationMentionFactoryClass = RelationMentionFactory.class;
        relationFeatures = "all";
        relationResultsPrinters = "edu.stanford.nlp.ie.machinereading.RelationExtractorResultsPrinter";
        trainRelationsUsingPredictedEntities = false;
        testRelationsUsingPredictedEntities = false;
        createUnrelatedRelations = true;
        doNotLexicalizeFirstArg = false;
        useRelationExtractionModelMerging = false;
        relationsToSkipDuringTraining = "";
        serializedEventExtractorPath = "";
        eventResultsPrinters = "";
        trainEventsUsingPredictedEntities = false;
        testEventsUsingPredictedEntities = false;
        loadModel = false;
        trainOnly = false;
        extractEntities = true;
        extractRelations = true;
        extractEvents = true;
        crossValidate = false;
        kfold = 5;
        percentageOfTrain = 1.0;
    }
}

