/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAggregator;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.Pair;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberNormalizer {
    private static final Logger logger = Logger.getLogger(NumberNormalizer.class.getName());
    private static final Pattern numUnitPattern = Pattern.compile("(?i)(hundred|thousand|million|billion|trillion)");
    private static final Pattern numEndUnitPattern = Pattern.compile("(?i)(gross|dozen|score)");
    private static final Pattern numberTermPattern = Pattern.compile("(?i)(zero|one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eighteen|nineteen|twenty|thirty|forty|fifty|sixty|seventy|eighty|ninety|hundred|thousand|million|billion|trillion|first|second|third|fourth|fifth|sixth|seventh|eighth|ninth|tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth|hundred?th|thousandth|millionth|billionth|trillionth)");
    private static final Pattern numberTermPattern2 = Pattern.compile("(?i)(" + numberTermPattern.pattern() + "(-" + numberTermPattern.pattern() + ")?)");
    private static final Pattern ordinalUnitPattern = Pattern.compile("(?i)(hundredth|thousandth|millionth)");
    protected static final Pattern digitsPattern = Pattern.compile("\\d+");
    private static final Pattern numPattern = Pattern.compile("[-+]?(?:\\d+(?:,\\d\\d\\d)*(?:\\.\\d*)?|\\.\\d+)");
    private static final Pattern numRangePattern = Pattern.compile("(" + numPattern.pattern() + ")-(" + numPattern.pattern() + ")");
    private static final Map<String, Number> word2NumMap = Generics.newHashMap();
    private static final Map<String, Number> ordWord2NumMap;
    private static final Pattern alphaPattern;
    private static final Pattern wsPattern;
    private static final Env env;
    private static final TokenSequencePattern numberPattern;
    private static final TokenSequencePattern rangePattern;

    private NumberNormalizer() {
    }

    public static void setVerbose(boolean verbose) {
        if (verbose) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.SEVERE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Number wordToNumber(String str) {
        if (str.trim().equals("")) {
            return null;
        }
        boolean neg = false;
        String originalString = str;
        str = str.trim();
        if ((str = str.toLowerCase()).startsWith("-")) {
            neg = true;
        }
        str = str.replaceAll("\\band\\b", " ");
        str = str.replaceAll("-", " ");
        str = str.replaceAll("(\\d),(\\d)", "$1$2");
        str = str.replaceAll(",", " ");
        if ((str = str.trim()).startsWith("a ")) {
            str = str.replace("a", "one");
        }
        if (str.endsWith("sands")) {
            str = str.substring(0, str.length() - 1);
        } else if (str.endsWith("ions")) {
            str = str.substring(0, str.length() - 1);
        }
        String[] fields = wsPattern.split(str);
        Number[] numFields = new Number[fields.length];
        int numWords = fields.length;
        for (int curIndex = 0; curIndex < numWords; ++curIndex) {
            String curPart = fields[curIndex];
            Matcher m = alphaPattern.matcher(curPart);
            if (m.find()) {
                Number curNum;
                if (word2NumMap.containsKey(curPart)) {
                    curNum = word2NumMap.get(curPart);
                } else if (ordWord2NumMap.containsKey(curPart)) {
                    if (curIndex != numWords - 1) throw new NumberFormatException("Error in wordToNumber function.");
                    curNum = ordWord2NumMap.get(curPart);
                } else if (curIndex > 0 && (curPart.endsWith("ths") || curPart.endsWith("rds"))) {
                    curNum = ordWord2NumMap.get(curPart.substring(0, curPart.length() - 1));
                    if (curNum == null) throw new NumberFormatException("Bad number put into wordToNumber.  Word is: \"" + curPart + "\", originally part of \"" + originalString + "\", piece # " + curIndex);
                    curNum = 1.0 / curNum.doubleValue();
                } else {
                    if (!Character.isDigit(curPart.charAt(0))) throw new NumberFormatException("Bad number put into wordToNumber.  Word is: \"" + curPart + "\", originally part of \"" + originalString + "\", piece # " + curIndex);
                    if (curPart.endsWith("th") || curPart.endsWith("rd") || curPart.endsWith("nd") || curPart.endsWith("st")) {
                        curPart = curPart.substring(0, curPart.length() - 2);
                    }
                    if (!digitsPattern.matcher(curPart).matches()) throw new NumberFormatException("Bad number put into wordToNumber.  Word is: \"" + curPart + "\", originally part of \"" + originalString + "\", piece # " + curIndex);
                    curNum = Long.parseLong(curPart);
                }
                numFields[curIndex] = curNum;
                continue;
            }
            if (digitsPattern.matcher(curPart).matches()) {
                numFields[curIndex] = Long.parseLong(curPart);
                continue;
            }
            if (!numPattern.matcher(curPart).matches()) throw new NumberFormatException("Bad number put into wordToNumber.  Word is: \"" + curPart + "\", originally part of \"" + originalString + "\", piece # " + curIndex);
            numFields[curIndex] = new BigDecimal(curPart);
        }
        Number n = NumberNormalizer.wordToNumberRecurse(numFields);
        return neg ? (Number)(-n.doubleValue()) : (Number)n;
    }

    private static Number wordToNumberRecurse(Number[] numFields) {
        return NumberNormalizer.wordToNumberRecurse(numFields, 0, numFields.length);
    }

    private static Number wordToNumberRecurse(Number[] numFields, int start, int end) {
        Number afterNum;
        if (end <= start) {
            return 0;
        }
        if (end - start == 1) {
            return numFields[start];
        }
        Number highestNum = Double.NEGATIVE_INFINITY;
        int highestNumIndex = start;
        for (int i = start; i < end; ++i) {
            Number curNum = numFields[i];
            if (curNum == null || !(curNum.doubleValue() >= highestNum.doubleValue())) continue;
            highestNum = curNum;
            highestNumIndex = i;
        }
        Number beforeNum = 1;
        if (highestNumIndex > start && (beforeNum = NumberNormalizer.wordToNumberRecurse(numFields, start, highestNumIndex)) == null) {
            beforeNum = 1;
        }
        if ((afterNum = NumberNormalizer.wordToNumberRecurse(numFields, highestNumIndex + 1, end)) == null) {
            afterNum = 0;
        }
        Double evaluatedNumber = beforeNum.doubleValue() * highestNum.doubleValue() + afterNum.doubleValue();
        return evaluatedNumber;
    }

    public static Env getNewEnv() {
        Env env = TokenSequencePattern.getNewEnv();
        env.setDefaultStringPatternFlags(2);
        NumberNormalizer.initEnv(env);
        return env;
    }

    public static void initEnv(Env env) {
        env.bind("numtype", CoreAnnotations.NumericTypeAnnotation.class);
        env.bind("numvalue", CoreAnnotations.NumericValueAnnotation.class);
        env.bind("numcomptype", CoreAnnotations.NumericCompositeTypeAnnotation.class);
        env.bind("numcompvalue", CoreAnnotations.NumericCompositeValueAnnotation.class);
        env.bind("$NUMCOMPTERM", " [ { numcomptype::EXISTS } & !{ numcomptype:NUMBER_RANGE } ] ");
        env.bind("$NUMTERM", " [ { numtype::EXISTS } & !{ numtype:NUMBER_RANGE } ] ");
        env.bind("$NUMRANGE", " [ { numtype:NUMBER_RANGE } ] ");
        env.bind("$INTTERM", " [ { numtype::EXISTS } & !{ numtype:NUMBER_RANGE } & !{ word:/.*\\.\\d+.*/} ] ");
        env.bind("$POSINTTERM", " [ { numvalue>0 } & !{ word:/.*\\.\\d+.*/} ] ");
        env.bind("$ORDTERM", " [ { numtype:ORDINAL } ] ");
        env.bind("$BEFORE_WS", " [ { before:/\\s*/ } | !{ before::EXISTS} ]");
        env.bind("$AFTER_WS", " [ { after:/\\s*/ } | !{ after::EXISTS} ]");
        env.bind("$BEFORE_AFTER_WS", " [ $BEFORE_WS & $AFTER_WS ]");
    }

    public static List<CoreMap> findNumbers(CoreMap annotation) {
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            String w = token.word();
            if (!numPattern.matcher(w = w.trim().toLowerCase()).matches() && !numberTermPattern2.matcher(w).matches() && !NumberSequenceClassifier.ORDINAL_PATTERN.matcher(w).matches() && !numEndUnitPattern.matcher(w).matches()) continue;
            try {
                token.set(CoreAnnotations.NumericValueAnnotation.class, NumberNormalizer.wordToNumber(w));
                if (NumberSequenceClassifier.ORDINAL_PATTERN.matcher(w).find()) {
                    token.set(CoreAnnotations.NumericTypeAnnotation.class, "ORDINAL");
                    continue;
                }
                if (numUnitPattern.matcher(w).matches()) {
                    token.set(CoreAnnotations.NumericTypeAnnotation.class, "UNIT");
                    continue;
                }
                if (numEndUnitPattern.matcher(w).matches()) {
                    token.set(CoreAnnotations.NumericTypeAnnotation.class, "UNIT");
                    continue;
                }
                token.set(CoreAnnotations.NumericTypeAnnotation.class, "NUMBER");
            }
            catch (Exception ex) {
                logger.warning("Error interpreting number " + w + ": " + ex.getMessage());
            }
        }
        SequenceMatcher matcher = numberPattern.getMatcher(tokens);
        ArrayList<CoreMap> numbers = new ArrayList<CoreMap>();
        while (matcher.find()) {
            List matchedTokens = matcher.groupNodes();
            int numStart = matcher.start();
            int possibleNumEnd = -1;
            int lastUnitPos = -1;
            int possibleNumStart = -1;
            Number possibleNumEndUnit = null;
            Number lastUnit = null;
            for (int i = matcher.start(); i < matcher.end(); ++i) {
                CoreLabel token = (CoreLabel)tokens.get(i);
                CoreLabel prev = i > matcher.start() ? (CoreLabel)tokens.get(i - 1) : null;
                Number num = (Number)token.get(CoreAnnotations.NumericValueAnnotation.class);
                Number prevNum = prev != null ? (Number)((Number)prev.get(CoreAnnotations.NumericValueAnnotation.class)) : (Number)null;
                String w = token.word();
                if (",".equals(w = w.trim().toLowerCase())) {
                    if (lastUnit != null && lastUnitPos == i - 1) {
                        possibleNumEnd = i;
                        possibleNumEndUnit = lastUnit;
                    } else if (numStart < i) {
                        numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, i));
                        numStart = i + 1;
                        possibleNumEnd = -1;
                        possibleNumEndUnit = null;
                        lastUnit = null;
                        lastUnitPos = -1;
                    }
                    if (numStart != i) continue;
                    numStart = i + 1;
                    continue;
                }
                if ("and".equals(w)) {
                    String prevWord = prev.word();
                    if (lastUnitPos == i - 1 || lastUnitPos == i - 2 && ",".equals(prevWord)) continue;
                    if (numStart < possibleNumEnd) {
                        numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, possibleNumEnd));
                        numStart = possibleNumStart >= possibleNumEnd ? possibleNumStart : i + 1;
                    } else if (numStart < i) {
                        numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, i));
                        numStart = i + 1;
                    }
                    if (lastUnitPos < numStart) {
                        lastUnit = null;
                        lastUnitPos = -1;
                    }
                    possibleNumEnd = -1;
                    possibleNumEndUnit = null;
                    continue;
                }
                String numType = (String)token.get(CoreAnnotations.NumericTypeAnnotation.class);
                if ("UNIT".equals(numType)) {
                    if (lastUnit != null && lastUnit.longValue() <= num.longValue() && numStart < possibleNumEnd && num.longValue() >= possibleNumEndUnit.longValue()) {
                        numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, possibleNumEnd));
                        numStart = possibleNumStart >= possibleNumEnd ? possibleNumStart : i;
                        possibleNumEnd = -1;
                        possibleNumEndUnit = null;
                    }
                    lastUnit = num;
                    lastUnitPos = i;
                    continue;
                }
                if (num == null) {
                    logger.warning("NO NUMBER: " + token.word());
                    continue;
                }
                if (prevNum != null && num.doubleValue() > 0.0) {
                    if (num.doubleValue() < 10.0) {
                        if (numPattern.matcher(prev.word()).matches() || prevNum.longValue() < 10L || prevNum.longValue() % 10L != 0L) {
                            if (numStart < i) {
                                numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, i));
                            }
                            numStart = i;
                            possibleNumEnd = -1;
                            possibleNumEndUnit = null;
                            lastUnit = null;
                            lastUnitPos = -1;
                        }
                    } else {
                        String prevNumType = (String)prev.get(CoreAnnotations.NumericTypeAnnotation.class);
                        if (!"UNIT".equals(prevNumType) && !ordinalUnitPattern.matcher(w).matches()) {
                            if (numStart < i) {
                                numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, i));
                            }
                            numStart = i;
                            possibleNumEnd = -1;
                            possibleNumEndUnit = null;
                            lastUnit = null;
                            lastUnitPos = -1;
                        }
                    }
                }
                if ("ORDINAL".equals(numType)) {
                    if (possibleNumEnd >= 0) {
                        if (numStart < possibleNumEnd) {
                            numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, possibleNumEnd));
                        }
                        if (possibleNumStart > possibleNumEnd) {
                            numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, possibleNumStart, i + 1));
                        } else {
                            numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, possibleNumEnd + 1, i + 1));
                        }
                    } else if (numStart < i + 1) {
                        numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, i + 1));
                    }
                    numStart = i + 1;
                    possibleNumEnd = -1;
                    possibleNumEndUnit = null;
                    lastUnit = null;
                    lastUnitPos = -1;
                }
                if (possibleNumStart >= possibleNumEnd) continue;
                possibleNumStart = i;
            }
            if (numStart >= matcher.end()) continue;
            numbers.add(ChunkAnnotationUtils.getAnnotatedChunk(annotation, numStart, matcher.end()));
        }
        for (CoreMap n : numbers) {
            String exp = (String)n.get(CoreAnnotations.TextAnnotation.class);
            List ts = (List)n.get(CoreAnnotations.TokensAnnotation.class);
            String label = (String)((CoreLabel)ts.get(ts.size() - 1)).get(CoreAnnotations.NumericTypeAnnotation.class);
            if ("UNIT".equals(label)) {
                label = "NUMBER";
            }
            try {
                Number num = NumberNormalizer.wordToNumber(exp);
                if (num == null) {
                    logger.warning("NO NUMBER FOR: \"" + exp + "\"");
                }
                n.set(CoreAnnotations.NumericCompositeValueAnnotation.class, num);
                n.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, label);
                for (CoreLabel t : ts) {
                    t.set(CoreAnnotations.NumericCompositeValueAnnotation.class, num);
                    t.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, label);
                }
            }
            catch (NumberFormatException ex) {
                logger.log(Level.WARNING, "Invalid number for: \"" + exp + "\"", ex);
            }
        }
        return numbers;
    }

    public static List<CoreMap> findNumberRanges(CoreMap annotation) {
        List numerizedTokens = (List)annotation.get(CoreAnnotations.NumerizedTokensAnnotation.class);
        for (CoreMap token : numerizedTokens) {
            String w = (String)token.get(CoreAnnotations.TextAnnotation.class);
            Matcher rangeMatcher = numRangePattern.matcher(w = w.trim().toLowerCase());
            if (!rangeMatcher.matches()) continue;
            try {
                String w1 = rangeMatcher.group(1);
                String w2 = rangeMatcher.group(2);
                Number v1 = NumberNormalizer.wordToNumber(w1);
                Number v2 = NumberNormalizer.wordToNumber(w2);
                if (!(v2.doubleValue() > v1.doubleValue())) continue;
                token.set(CoreAnnotations.NumericTypeAnnotation.class, "NUMBER_RANGE");
                token.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, "NUMBER_RANGE");
                Pair<Number, Number> range = new Pair<Number, Number>(v1, v2);
                token.set(CoreAnnotations.NumericCompositeObjectAnnotation.class, range);
            }
            catch (Exception ex) {
                logger.warning("Error interpreting number range " + w + ": " + ex.getMessage());
            }
        }
        ArrayList<CoreMap> numberRanges = new ArrayList<CoreMap>();
        SequenceMatcher matcher = rangePattern.getMatcher(numerizedTokens);
        while (matcher.find()) {
            List matched = matcher.groupNodes();
            if (matched.size() == 1) {
                numberRanges.add((CoreMap)matched.get(0));
                continue;
            }
            Number v1 = (Number)((CoreMap)matched.get(0)).get(CoreAnnotations.NumericCompositeValueAnnotation.class);
            Number v2 = (Number)((CoreMap)matched.get(matched.size() - 1)).get(CoreAnnotations.NumericCompositeValueAnnotation.class);
            if (!(v2.doubleValue() > v1.doubleValue())) continue;
            CoreMap newChunk = ChunkAnnotationUtils.getMergedChunk((List<? extends CoreMap>)numerizedTokens, matcher.start(), matcher.end(), CoreMapAttributeAggregator.getDefaultAggregators());
            newChunk.set(CoreAnnotations.NumericCompositeTypeAnnotation.class, "NUMBER_RANGE");
            Pair<Number, Number> range = new Pair<Number, Number>(v1, v2);
            newChunk.set(CoreAnnotations.NumericCompositeObjectAnnotation.class, range);
            numberRanges.add(newChunk);
        }
        return numberRanges;
    }

    public static List<CoreMap> findAndMergeNumbers(CoreMap annotationRaw) {
        ArrayCoreMap annotation = new ArrayCoreMap(annotationRaw);
        List<CoreMap> numbers = NumberNormalizer.findNumbers(annotation);
        CoreMapAggregator numberAggregator = CoreMapAggregator.getAggregator(CoreMapAttributeAggregator.DEFAULT_NUMERIC_AGGREGATORS, CoreAnnotations.TokensAnnotation.class);
        Integer startTokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (startTokenOffset == null) {
            startTokenOffset = 0;
        }
        int i = 0;
        LinkedList savedTokenBegins = new LinkedList();
        LinkedList savedTokenEnds = new LinkedList();
        for (CoreLabel c : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (i == 0 && c.get(CoreAnnotations.TokenBeginAnnotation.class) != null || i > 0 && !savedTokenBegins.isEmpty()) {
                savedTokenBegins.add(c.get(CoreAnnotations.TokenBeginAnnotation.class));
            }
            c.set(CoreAnnotations.TokenBeginAnnotation.class, i + startTokenOffset);
            if (++i == 1 && c.get(CoreAnnotations.TokenEndAnnotation.class) != null || i > 1 && !savedTokenEnds.isEmpty()) {
                savedTokenEnds.add(c.get(CoreAnnotations.TokenEndAnnotation.class));
            }
            c.set(CoreAnnotations.TokenEndAnnotation.class, i + startTokenOffset);
        }
        final Integer startTokenOffsetFinal = startTokenOffset;
        List<CoreMap> mergedNumbers = numberAggregator.merge((List<? extends CoreMap>)((List)annotation.get(CoreAnnotations.TokensAnnotation.class)), numbers, new Function<CoreMap, Interval<Integer>>(){

            @Override
            public Interval<Integer> apply(CoreMap in) {
                return Interval.toInterval((Integer)in.get(CoreAnnotations.TokenBeginAnnotation.class) - startTokenOffsetFinal, (Integer)in.get(CoreAnnotations.TokenEndAnnotation.class) - startTokenOffsetFinal);
            }
        });
        if (!savedTokenBegins.isEmpty() && !savedTokenEnds.isEmpty()) {
            for (CoreMap c : mergedNumbers) {
                int newBegin = (Integer)c.get(CoreAnnotations.TokenBeginAnnotation.class) - startTokenOffset;
                int newEnd = (Integer)c.get(CoreAnnotations.TokenEndAnnotation.class) - startTokenOffset;
                c.set(CoreAnnotations.TokenBeginAnnotation.class, savedTokenBegins.get(newBegin));
                c.set(CoreAnnotations.TokenEndAnnotation.class, savedTokenEnds.get(newEnd - 1));
            }
        }
        return mergedNumbers;
    }

    public static List<CoreMap> findAndAnnotateNumericExpressions(CoreMap annotation) {
        List<CoreMap> mergedNumbers = NumberNormalizer.findAndMergeNumbers(annotation);
        annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbers);
        return mergedNumbers;
    }

    public static List<CoreMap> findAndAnnotateNumericExpressionsWithRanges(CoreMap annotation) {
        Integer startTokenOffset = (Integer)annotation.get(CoreAnnotations.TokenBeginAnnotation.class);
        if (startTokenOffset == null) {
            startTokenOffset = 0;
        }
        List<CoreMap> mergedNumbers = NumberNormalizer.findAndMergeNumbers(annotation);
        annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbers);
        List<CoreMap> numberRanges = NumberNormalizer.findNumberRanges(annotation);
        final Integer startTokenOffsetFinal = startTokenOffset;
        List<CoreMap> mergedNumbersWithRanges = CollectionUtils.mergeListWithSortedMatchedPreAggregated((List)annotation.get(CoreAnnotations.NumerizedTokensAnnotation.class), numberRanges, new Function<CoreMap, Interval<Integer>>(){

            @Override
            public Interval<Integer> apply(CoreMap in) {
                return Interval.toInterval((Integer)in.get(CoreAnnotations.TokenBeginAnnotation.class) - startTokenOffsetFinal, (Integer)in.get(CoreAnnotations.TokenEndAnnotation.class) - startTokenOffsetFinal);
            }
        });
        annotation.set(CoreAnnotations.NumerizedTokensAnnotation.class, mergedNumbersWithRanges);
        return mergedNumbersWithRanges;
    }

    static {
        word2NumMap.put("dozen", 12);
        word2NumMap.put("score", 20);
        word2NumMap.put("gross", 144);
        word2NumMap.put("quarter", 0.25);
        word2NumMap.put("half", 0.5);
        word2NumMap.put("oh", 0);
        word2NumMap.put("a", 1);
        word2NumMap.put("an", 1);
        word2NumMap.put("zero", 0);
        word2NumMap.put("one", 1);
        word2NumMap.put("two", 2);
        word2NumMap.put("three", 3);
        word2NumMap.put("four", 4);
        word2NumMap.put("five", 5);
        word2NumMap.put("six", 6);
        word2NumMap.put("seven", 7);
        word2NumMap.put("eight", 8);
        word2NumMap.put("nine", 9);
        word2NumMap.put("ten", 10);
        word2NumMap.put("eleven", 11);
        word2NumMap.put("twelve", 12);
        word2NumMap.put("thirteen", 13);
        word2NumMap.put("fourteen", 14);
        word2NumMap.put("fifteen", 15);
        word2NumMap.put("sixteen", 16);
        word2NumMap.put("seventeen", 17);
        word2NumMap.put("eighteen", 18);
        word2NumMap.put("nineteen", 19);
        word2NumMap.put("twenty", 20);
        word2NumMap.put("thirty", 30);
        word2NumMap.put("forty", 40);
        word2NumMap.put("fifty", 50);
        word2NumMap.put("sixty", 60);
        word2NumMap.put("seventy", 70);
        word2NumMap.put("eighty", 80);
        word2NumMap.put("ninety", 90);
        word2NumMap.put("hundred", 100);
        word2NumMap.put("thousand", 1000);
        word2NumMap.put("million", 1000000);
        word2NumMap.put("billion", 1000000000);
        word2NumMap.put("trillion", 1000000000000L);
        ordWord2NumMap = Generics.newHashMap();
        ordWord2NumMap.put("zeroth", 0);
        ordWord2NumMap.put("first", 1);
        ordWord2NumMap.put("second", 2);
        ordWord2NumMap.put("third", 3);
        ordWord2NumMap.put("fourth", 4);
        ordWord2NumMap.put("fifth", 5);
        ordWord2NumMap.put("sixth", 6);
        ordWord2NumMap.put("seventh", 7);
        ordWord2NumMap.put("eighth", 8);
        ordWord2NumMap.put("ninth", 9);
        ordWord2NumMap.put("tenth", 10);
        ordWord2NumMap.put("eleventh", 11);
        ordWord2NumMap.put("twelfth", 12);
        ordWord2NumMap.put("thirteenth", 13);
        ordWord2NumMap.put("fourteenth", 14);
        ordWord2NumMap.put("fifteenth", 15);
        ordWord2NumMap.put("sixteenth", 16);
        ordWord2NumMap.put("seventeenth", 17);
        ordWord2NumMap.put("eighteenth", 18);
        ordWord2NumMap.put("nineteenth", 19);
        ordWord2NumMap.put("twentieth", 20);
        ordWord2NumMap.put("thirtieth", 30);
        ordWord2NumMap.put("fortieth", 40);
        ordWord2NumMap.put("fiftieth", 50);
        ordWord2NumMap.put("sixtieth", 60);
        ordWord2NumMap.put("seventieth", 70);
        ordWord2NumMap.put("eightieth", 80);
        ordWord2NumMap.put("ninetieth", 90);
        ordWord2NumMap.put("hundredth", 100);
        ordWord2NumMap.put("hundreth", 100);
        ordWord2NumMap.put("thousandth", 1000);
        ordWord2NumMap.put("millionth", 1000000);
        ordWord2NumMap.put("billionth", 1000000000);
        ordWord2NumMap.put("trillionth", 1000000000000L);
        alphaPattern = Pattern.compile("([a-zA-Z]+)");
        wsPattern = Pattern.compile("\\s+");
        env = NumberNormalizer.getNewEnv();
        numberPattern = TokenSequencePattern.compile(env, "$NUMTERM ( [/,/ & $BEFORE_WS]? [$POSINTTERM & $BEFORE_WS]  )* ( [/,/ & $BEFORE_WS]? [/and/ & $BEFORE_WS] [$POSINTTERM & $BEFORE_WS]+ )? ");
        rangePattern = TokenSequencePattern.compile(env, "(?:$NUMCOMPTERM /-|to/ $NUMCOMPTERM) | $NUMRANGE");
    }
}

