/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.dcoref.ACEMentionExtractor;
import edu.stanford.nlp.dcoref.CoNLLMentionExtractor;
import edu.stanford.nlp.dcoref.Constants;
import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefMentionFinder;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.MUCMentionExtractor;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.ScorerBCubed;
import edu.stanford.nlp.dcoref.ScorerMUC;
import edu.stanford.nlp.dcoref.ScorerPairwise;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.sievepasses.DeterministicCorefSieve;
import edu.stanford.nlp.dcoref.sievepasses.ExactStringMatch;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.io.StringOutputStream;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.SystemUtils;
import edu.stanford.nlp.util.logging.NewlineLogFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SieveCoreferenceSystem {
    public static final Logger logger = Logger.getLogger(SieveCoreferenceSystem.class.getName());
    private final boolean doScore;
    private final boolean doPostProcessing;
    private final int maxSentDist;
    private final boolean useSemantics;
    private final boolean useSingletonPredictor;
    private final boolean replicateCoNLL;
    public final String conllMentionEvalScript;
    private final boolean optimizeSieves;
    private List<Pair<Integer, Integer>> sievesKeepOrder;
    private final String optimizeScoreType;
    private final boolean optimizeConllScore;
    private final String optimizeMetricType;
    private final CorefScorer.SubScoreType optimizeSubScoreType;
    private DeterministicCorefSieve[] sieves;
    private String[] sieveClassNames;
    private final Dictionaries dictionaries;
    private final Semantics semantics;
    private LogisticClassifier<String, String> singletonPredictor;
    private int currentSieve = -1;
    private List<Pair<Integer, Integer>> linksCountInPass;
    private List<CorefScorer> scorePairwise;
    private List<CorefScorer> scoreBcubed;
    private List<CorefScorer> scoreMUC;
    private List<CorefScorer> scoreSingleDoc;
    private int additionalCorrectLinksCount;
    private int additionalLinksCount;

    public SieveCoreferenceSystem(Properties props) throws Exception {
        String keepSieveOrder;
        String sievePasses = props.getProperty("dcoref.sievePasses", "MarkRole, DiscourseMatch, ExactStringMatch, RelaxedExactStringMatch, PreciseConstructs, StrictHeadMatch1, StrictHeadMatch2, StrictHeadMatch3, StrictHeadMatch4, RelaxedHeadMatch, PronounMatch");
        this.sieveClassNames = sievePasses.trim().split(",\\s*");
        this.sieves = new DeterministicCorefSieve[this.sieveClassNames.length];
        for (int i = 0; i < this.sieveClassNames.length; ++i) {
            this.sieves[i] = (DeterministicCorefSieve)Class.forName("edu.stanford.nlp.dcoref.sievepasses." + this.sieveClassNames[i]).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.sieves[i].init(props);
        }
        this.doScore = Boolean.parseBoolean(props.getProperty("dcoref.score", "false"));
        this.doPostProcessing = Boolean.parseBoolean(props.getProperty("dcoref.postprocessing", "false"));
        this.useSingletonPredictor = Boolean.parseBoolean(props.getProperty("dcoref.singleton.predictor", "true"));
        this.maxSentDist = Integer.parseInt(props.getProperty("dcoref.maxdist", "-1"));
        this.useSemantics = sievePasses.contains("AliasMatch") || sievePasses.contains("LexicalChainMatch");
        this.replicateCoNLL = Boolean.parseBoolean(props.getProperty("dcoref.replicate.conll", "false"));
        this.conllMentionEvalScript = props.getProperty("dcoref.conll.scorer", "/scr/nlp/data/conll-2011/scorer/v4/scorer.pl");
        this.optimizeSieves = Boolean.parseBoolean(props.getProperty("dcoref.optimize.sieves", "false"));
        this.optimizeScoreType = props.getProperty("dcoref.optimize.sieves.score", "pairwise.Precision");
        String[] validMetricTypes = new String[]{"muc", "pairwise", "bcub", "ceafe", "ceafm", "combined"};
        String[] parts = this.optimizeScoreType.split("\\.");
        this.optimizeConllScore = parts.length > 2 && "conll".equalsIgnoreCase(parts[2]);
        this.optimizeMetricType = parts[0];
        boolean optimizeMetricTypeOk = false;
        for (String validMetricType : validMetricTypes) {
            if (!validMetricType.equalsIgnoreCase(this.optimizeMetricType)) continue;
            optimizeMetricTypeOk = true;
            break;
        }
        if (!optimizeMetricTypeOk) {
            throw new IllegalArgumentException("Invalid metric type for dcoref.optimize.sieves.score property: " + this.optimizeScoreType);
        }
        this.optimizeSubScoreType = CorefScorer.SubScoreType.valueOf(parts[1]);
        if (this.optimizeSieves && (keepSieveOrder = props.getProperty("dcoref.optimize.sieves.keepOrder")) != null) {
            String[] orderings = keepSieveOrder.split("\\s*,\\s*");
            this.sievesKeepOrder = new ArrayList<Pair<Integer, Integer>>();
            String firstSieveConstraint = null;
            String lastSieveConstraint = null;
            for (String ordering : orderings) {
                Pair<Integer, Integer> p = SieveCoreferenceSystem.fromSieveOrderConstraintString(ordering, this.sieveClassNames);
                if (p.first() < 0 && p.second() < 0) {
                    throw new IllegalArgumentException("Invalid ordering constraint: " + ordering);
                }
                if (p.first() < 0) {
                    if (lastSieveConstraint != null) {
                        throw new IllegalArgumentException("Cannot have these two ordering constraints: " + lastSieveConstraint + "," + ordering);
                    }
                    lastSieveConstraint = ordering;
                } else if (p.second() < 0) {
                    if (firstSieveConstraint != null) {
                        throw new IllegalArgumentException("Cannot have these two ordering constraints: " + firstSieveConstraint + "," + ordering);
                    }
                    firstSieveConstraint = ordering;
                }
                this.sievesKeepOrder.add(p);
            }
        }
        if (this.doScore) {
            this.initScorers();
        }
        this.dictionaries = new Dictionaries(props);
        Semantics semantics = this.semantics = this.useSemantics ? new Semantics(this.dictionaries) : null;
        if (this.useSingletonPredictor) {
            this.singletonPredictor = SieveCoreferenceSystem.getSingletonPredictorFromSerializedFile("edu/stanford/nlp/models/dcoref/singleton.predictor.ser");
        }
    }

    public static String signature(Properties props) {
        StringBuilder os = new StringBuilder();
        os.append("dcoref.sievePasses:" + props.getProperty("dcoref.sievePasses", "MarkRole, DiscourseMatch, ExactStringMatch, RelaxedExactStringMatch, PreciseConstructs, StrictHeadMatch1, StrictHeadMatch2, StrictHeadMatch3, StrictHeadMatch4, RelaxedHeadMatch, PronounMatch"));
        os.append("dcoref.singleton.predictor:" + props.getProperty("dcoref.singleton.predictor", "false"));
        os.append("dcoref.score:" + props.getProperty("dcoref.score", "false"));
        os.append("dcoref.postprocessing:" + props.getProperty("dcoref.postprocessing", "false"));
        os.append("dcoref.maxdist:" + props.getProperty("dcoref.maxdist", "-1"));
        os.append("dcoref.replicate.conll:" + props.getProperty("dcoref.replicate.conll", "false"));
        os.append("dcoref.conll.scorer:" + props.getProperty("dcoref.conll.scorer", "/scr/nlp/data/conll-2011/scorer/v4/scorer.pl"));
        os.append(Dictionaries.signature(props));
        return os.toString();
    }

    public void initScorers() {
        this.linksCountInPass = new ArrayList<Pair<Integer, Integer>>();
        this.scorePairwise = new ArrayList<CorefScorer>();
        this.scoreBcubed = new ArrayList<CorefScorer>();
        this.scoreMUC = new ArrayList<CorefScorer>();
        for (int i = 0; i < this.sieveClassNames.length; ++i) {
            this.scorePairwise.add(new ScorerPairwise());
            this.scoreBcubed.add(new ScorerBCubed(ScorerBCubed.BCubedType.Bconll));
            this.scoreMUC.add(new ScorerMUC());
            this.linksCountInPass.add(new Pair<Integer, Integer>(0, 0));
        }
    }

    public boolean doScore() {
        return this.doScore;
    }

    public Dictionaries dictionaries() {
        return this.dictionaries;
    }

    public Semantics semantics() {
        return this.semantics;
    }

    public String sieveClassName(int sieveIndex) {
        return sieveIndex >= 0 && sieveIndex < this.sieveClassNames.length ? this.sieveClassNames[sieveIndex] : null;
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        SieveCoreferenceSystem.initializeAndRunCoref(props);
    }

    public static String initializeAndRunCoref(Properties props) throws Exception {
        String timeStamp = Calendar.getInstance().getTime().toString().replaceAll("\\s", "-").replaceAll(":", "-");
        String logFileName = props.getProperty("dcoref.logFile", "log.txt");
        logFileName = logFileName.endsWith(".txt") ? logFileName.substring(0, logFileName.length() - 4) + "_" + timeStamp + ".txt" : logFileName + "_" + timeStamp + ".txt";
        try {
            FileHandler fh = new FileHandler(logFileName, false);
            logger.addHandler(fh);
            logger.setLevel(Level.FINE);
            fh.setFormatter(new NewlineLogFormatter());
        }
        catch (SecurityException e) {
            System.err.println("ERROR: cannot initialize logger!");
            throw e;
        }
        catch (IOException e) {
            System.err.println("ERROR: cannot initialize logger!");
            throw e;
        }
        logger.fine(timeStamp);
        logger.fine(props.toString());
        Constants.printConstants(logger);
        SieveCoreferenceSystem corefSystem = new SieveCoreferenceSystem(props);
        MentionExtractor mentionExtractor = null;
        if (props.containsKey("dcoref.muc")) {
            mentionExtractor = new MUCMentionExtractor(corefSystem.dictionaries, props, corefSystem.semantics, corefSystem.singletonPredictor);
        } else if (props.containsKey("dcoref.ace2004") || props.containsKey("dcoref.ace2005")) {
            mentionExtractor = new ACEMentionExtractor(corefSystem.dictionaries, props, corefSystem.semantics, corefSystem.singletonPredictor);
        } else if (props.containsKey("dcoref.conll2011")) {
            mentionExtractor = new CoNLLMentionExtractor(corefSystem.dictionaries, props, corefSystem.semantics, corefSystem.singletonPredictor);
        }
        if (mentionExtractor == null) {
            throw new RuntimeException("No input file specified!");
        }
        String mentionFinderClass = props.getProperty("dcoref.mentionFinder");
        if (mentionFinderClass != null) {
            CorefMentionFinder mentionFinder;
            String mentionFinderPropFilename = props.getProperty("dcoref.mentionFinder.props");
            if (mentionFinderPropFilename != null) {
                Properties mentionFinderProps = new Properties();
                FileInputStream fis = new FileInputStream(mentionFinderPropFilename);
                mentionFinderProps.load(fis);
                fis.close();
                mentionFinder = (CorefMentionFinder)Class.forName(mentionFinderClass).getConstructor(Properties.class).newInstance(mentionFinderProps);
            } else {
                mentionFinder = (CorefMentionFinder)Class.forName(mentionFinderClass).newInstance();
            }
            mentionExtractor.setMentionFinder(mentionFinder);
        }
        if (mentionExtractor.mentionFinder == null) {
            logger.warning("No mention finder specified, but not using gold mentions");
        }
        if (corefSystem.optimizeSieves && corefSystem.sieves.length > 1) {
            corefSystem.optimizeSieveOrdering(mentionExtractor, props, timeStamp);
        }
        try {
            SieveCoreferenceSystem.runAndScoreCoref(corefSystem, mentionExtractor, props, timeStamp);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "ERROR in running coreference", ex);
        }
        logger.info("done");
        String endTimeStamp = Calendar.getInstance().getTime().toString().replaceAll("\\s", "-");
        logger.fine(endTimeStamp);
        return logFileName;
    }

    public static double runAndScoreCoref(SieveCoreferenceSystem corefSystem, MentionExtractor mentionExtractor, Properties props, String timeStamp) throws Exception {
        String scoresFile;
        Document document;
        PrintWriter writerGold = null;
        PrintWriter writerPredicted = null;
        PrintWriter writerPredictedCoref = null;
        String conllOutputMentionGoldFile = null;
        String conllOutputMentionPredictedFile = null;
        String conllOutputMentionCorefPredictedFile = null;
        String conllMentionEvalFile = null;
        String conllMentionEvalErrFile = null;
        String conllMentionCorefEvalFile = null;
        String conllMentionCorefEvalErrFile = null;
        if (corefSystem.replicateCoNLL) {
            String conllOutput = props.getProperty("dcoref.conll.output", "conlloutput");
            conllOutputMentionGoldFile = conllOutput + "-" + timeStamp + ".gold.txt";
            conllOutputMentionPredictedFile = conllOutput + "-" + timeStamp + ".predicted.txt";
            conllOutputMentionCorefPredictedFile = conllOutput + "-" + timeStamp + ".coref.predicted.txt";
            conllMentionEvalFile = conllOutput + "-" + timeStamp + ".eval.txt";
            conllMentionEvalErrFile = conllOutput + "-" + timeStamp + ".eval.err.txt";
            conllMentionCorefEvalFile = conllOutput + "-" + timeStamp + ".coref.eval.txt";
            conllMentionCorefEvalErrFile = conllOutput + "-" + timeStamp + ".coref.eval.err.txt";
            logger.info("CONLL MENTION GOLD FILE: " + conllOutputMentionGoldFile);
            logger.info("CONLL MENTION PREDICTED FILE: " + conllOutputMentionPredictedFile);
            logger.info("CONLL MENTION EVAL FILE: " + conllMentionEvalFile);
            logger.info("CONLL MENTION PREDICTED WITH COREF FILE: " + conllOutputMentionCorefPredictedFile);
            logger.info("CONLL MENTION WITH COREF EVAL FILE: " + conllMentionCorefEvalFile);
            writerGold = new PrintWriter(new FileOutputStream(conllOutputMentionGoldFile));
            writerPredicted = new PrintWriter(new FileOutputStream(conllOutputMentionPredictedFile));
            writerPredictedCoref = new PrintWriter(new FileOutputStream(conllOutputMentionCorefPredictedFile));
        }
        mentionExtractor.resetDocs();
        if (corefSystem.doScore()) {
            corefSystem.initScorers();
        }
        while ((document = mentionExtractor.nextDoc()) != null) {
            if (!props.containsKey("dcoref.muc")) {
                SieveCoreferenceSystem.printRawDoc(document, true);
                SieveCoreferenceSystem.printRawDoc(document, false);
            }
            SieveCoreferenceSystem.printDiscourseStructure(document);
            if (corefSystem.doScore()) {
                document.extractGoldCorefClusters();
            }
            if (corefSystem.replicateCoNLL) {
                SieveCoreferenceSystem.printConllOutput(document, writerGold, true);
                SieveCoreferenceSystem.printConllOutput(document, writerPredicted, false);
            }
            corefSystem.coref(document);
            if (corefSystem.doScore()) {
                corefSystem.printTopK(logger, document, corefSystem.semantics);
                logger.fine("pairwise score for this doc: ");
                corefSystem.scoreSingleDoc.get(corefSystem.sieves.length - 1).printF1(logger);
                logger.fine("accumulated score: ");
                corefSystem.printF1(true);
                logger.fine("\n");
            }
            if (!corefSystem.replicateCoNLL) continue;
            SieveCoreferenceSystem.printConllOutput(document, writerPredictedCoref, false, true);
        }
        double finalScore = 0.0;
        if (corefSystem.replicateCoNLL) {
            writerGold.close();
            writerPredicted.close();
            writerPredictedCoref.close();
            if (corefSystem.conllMentionEvalScript != null) {
                String summary = SieveCoreferenceSystem.getConllEvalSummary(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionPredictedFile);
                logger.info("\nCONLL EVAL SUMMARY (Before COREF)");
                SieveCoreferenceSystem.printScoreSummary(summary, logger, false);
                summary = SieveCoreferenceSystem.getConllEvalSummary(corefSystem.conllMentionEvalScript, conllOutputMentionGoldFile, conllOutputMentionCorefPredictedFile);
                logger.info("\nCONLL EVAL SUMMARY (After COREF)");
                SieveCoreferenceSystem.printScoreSummary(summary, logger, true);
                SieveCoreferenceSystem.printFinalConllScore(summary);
                if (corefSystem.optimizeConllScore) {
                    finalScore = SieveCoreferenceSystem.getFinalConllScore(summary, corefSystem.optimizeMetricType, corefSystem.optimizeSubScoreType.toString());
                }
            }
        }
        if (!corefSystem.optimizeConllScore && corefSystem.doScore()) {
            finalScore = corefSystem.getFinalScore(corefSystem.optimizeMetricType, corefSystem.optimizeSubScoreType);
        }
        if ((scoresFile = props.getProperty("dcoref.score.output")) != null) {
            PrintWriter pw = IOUtils.getPrintWriter(scoresFile);
            pw.println(new DecimalFormat("#.##").format(finalScore));
            pw.close();
        }
        if (corefSystem.optimizeSieves) {
            logger.info("Final reported score for sieve optimization " + corefSystem.optimizeScoreType + " : " + finalScore);
        }
        return finalScore;
    }

    public static void runAndScoreCorefDist(String runDistCmd, Properties props, String propsFile) throws Exception {
        PrintWriter pw = IOUtils.getPrintWriter(propsFile);
        props.store(pw, null);
        pw.close();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(runDistCmd.split("\\s+")));
        cmd.add("-props");
        cmd.add(propsFile);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> curEnv = System.getenv();
        Map<String, String> pbEnv = pb.environment();
        pbEnv.putAll(curEnv);
        logger.info("Running distributed coref:" + StringUtils.join(pb.command(), " "));
        StringWriter outSos = new StringWriter();
        StringWriter errSos = new StringWriter();
        PrintWriter out2 = new PrintWriter(new BufferedWriter(outSos));
        PrintWriter err2 = new PrintWriter(new BufferedWriter(errSos));
        SystemUtils.run(pb, out2, err2);
        out2.close();
        err2.close();
        String outStr = outSos.toString();
        String errStr = errSos.toString();
        logger.info("Finished distributed coref: " + runDistCmd + ", props=" + propsFile);
        logger.info("Output: " + outStr);
        if (errStr.length() > 0) {
            logger.info("Error: " + errStr);
        }
    }

    static boolean waitForFiles(File workDir, FileFilter fileFilter, int howMany) throws InterruptedException {
        File[] checkFiles;
        logger.info("Waiting until we see " + howMany + " " + fileFilter + " files in directory " + workDir + "...");
        int seconds = 0;
        while (true) {
            if ((checkFiles = workDir.listFiles(fileFilter)) != null && checkFiles.length >= howMany) break;
            Thread.sleep(60000L);
            if ((seconds += 60) % 600 != 0) continue;
            double minutes = seconds / 60;
            logger.info("Still waiting... " + minutes + " minutes have passed.");
        }
        logger.info("Found " + checkFiles.length + " " + fileFilter + " files. Continuing execution.");
        return true;
    }

    private static int fromSieveNameToIndex(String sieveName, String[] sieveNames) {
        if ("*".equals(sieveName)) {
            return -1;
        }
        for (int i = 0; i < sieveNames.length; ++i) {
            if (!sieveNames[i].equals(sieveName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid sieve name: " + sieveName);
    }

    private static Pair<Integer, Integer> fromSieveOrderConstraintString(String s, String[] sieveNames) {
        String[] parts = s.split("<");
        if (parts.length == 2) {
            String first = parts[0].trim();
            String second = parts[1].trim();
            int a = SieveCoreferenceSystem.fromSieveNameToIndex(first, sieveNames);
            int b = SieveCoreferenceSystem.fromSieveNameToIndex(second, sieveNames);
            return new Pair<Integer, Integer>(a, b);
        }
        throw new IllegalArgumentException("Invalid sieve ordering constraint: " + s);
    }

    private static String toSieveOrderConstraintString(Pair<Integer, Integer> orderedSieveIndices, String[] sieveNames) {
        String first = orderedSieveIndices.first() < 0 ? "*" : sieveNames[orderedSieveIndices.first()];
        String second = orderedSieveIndices.second() < 0 ? "*" : sieveNames[orderedSieveIndices.second()];
        return first + " < " + second;
    }

    public void optimizeSieveOrdering(MentionExtractor mentionExtractor, Properties props, String timestamp) throws Exception {
        logger.info("=============SIEVE OPTIMIZATION START ====================");
        logger.info("Optimize sieves using score: " + this.optimizeScoreType);
        FileFilter scoreFilesFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().endsWith(".score");
            }

            public String toString() {
                return ".score";
            }
        };
        Pattern scoreFilePattern = Pattern.compile(".*sieves\\.(\\d+)\\.(\\d+).score");
        String runDistributedCmd = props.getProperty("dcoref.dist.cmd");
        String mainWorkDirPath = props.getProperty("dcoref.dist.workdir", "workdir") + "-" + timestamp + File.separator;
        DeterministicCorefSieve[] origSieves = this.sieves;
        String[] origSieveNames = this.sieveClassNames;
        Set<Integer> remainingSieveIndices = Generics.newHashSet();
        for (int i = 0; i < origSieves.length; ++i) {
            remainingSieveIndices.add(i);
        }
        ArrayList<Integer> optimizedOrdering = new ArrayList<Integer>();
        while (!remainingSieveIndices.isEmpty()) {
            int curSievesNumber = optimizedOrdering.size();
            this.sieves = new DeterministicCorefSieve[curSievesNumber + 1];
            this.sieveClassNames = new String[curSievesNumber + 1];
            for (int i = 0; i < curSievesNumber; ++i) {
                this.sieves[i] = origSieves[(Integer)optimizedOrdering.get(i)];
                this.sieveClassNames[i] = origSieveNames[(Integer)optimizedOrdering.get(i)];
            }
            logger.info("*** Optimizing Sieve ordering for pass " + curSievesNumber + " ***");
            Set<Integer> selectableSieveIndices = new TreeSet(remainingSieveIndices);
            if (this.sievesKeepOrder != null) {
                for (Pair<Integer, Integer> ko : this.sievesKeepOrder) {
                    if (ko.second() < 0) {
                        if (!remainingSieveIndices.contains(ko.first())) continue;
                        logger.info("Restrict selection to " + origSieveNames[ko.first()] + " because of constraint " + SieveCoreferenceSystem.toSieveOrderConstraintString(ko, origSieveNames));
                        selectableSieveIndices = Generics.newHashSet(1);
                        selectableSieveIndices.add(ko.first());
                        break;
                    }
                    if (ko.first() < 0 && remainingSieveIndices.size() > 1) {
                        if (!remainingSieveIndices.contains(ko.second())) continue;
                        logger.info("Remove selection " + origSieveNames[ko.second()] + " because of constraint " + SieveCoreferenceSystem.toSieveOrderConstraintString(ko, origSieveNames));
                        selectableSieveIndices.remove(ko.second());
                        continue;
                    }
                    if (!remainingSieveIndices.contains(ko.first()) || !remainingSieveIndices.contains(ko.second())) continue;
                    logger.info("Remove selection " + origSieveNames[ko.second()] + " because of constraint " + SieveCoreferenceSystem.toSieveOrderConstraintString(ko, origSieveNames));
                    selectableSieveIndices.remove(ko.second());
                }
            }
            if (selectableSieveIndices.isEmpty()) {
                throw new RuntimeException("Unable to find sieve ordering to satisfy all ordering constraints!!!!");
            }
            int selected = -1;
            if (selectableSieveIndices.size() > 1) {
                ArrayList<Pair<Double, Integer>> scores = new ArrayList<Pair<Double, Integer>>();
                if (runDistributedCmd != null) {
                    File[] scoreFiles;
                    String workDirPath = mainWorkDirPath + curSievesNumber + File.separator;
                    File workDir = new File(workDirPath);
                    workDir.mkdirs();
                    workDirPath = workDir.getAbsolutePath() + File.separator;
                    Iterator i$ = selectableSieveIndices.iterator();
                    while (i$.hasNext()) {
                        int n = (Integer)i$.next();
                        String sieveSelectionId = curSievesNumber + "." + n;
                        String jobDirPath = workDirPath + sieveSelectionId + File.separator;
                        File jobDir = new File(jobDirPath);
                        jobDir.mkdirs();
                        Properties newProps = new Properties();
                        for (String key : props.stringPropertyNames()) {
                            String value = props.getProperty(key);
                            value = value.replaceAll("\\$\\{JOBDIR\\}", jobDirPath);
                            newProps.setProperty(key, value);
                        }
                        this.sieves[curSievesNumber] = origSieves[n];
                        this.sieveClassNames[curSievesNumber] = origSieveNames[n];
                        newProps.setProperty("dcoref.optimize.sieves", "false");
                        newProps.setProperty("dcoref.score", "true");
                        newProps.setProperty("dcoref.sievePasses", StringUtils.join(this.sieveClassNames, ","));
                        newProps.setProperty("dcoref.logFile", jobDirPath + "sieves." + sieveSelectionId + ".log");
                        newProps.setProperty("dcoref.score.output", workDirPath + "sieves." + sieveSelectionId + ".score");
                        if (this.replicateCoNLL) {
                            newProps.setProperty("dcoref.conll.output", jobDirPath + "sieves." + sieveSelectionId + ".conlloutput");
                        }
                        String distCmd = newProps.getProperty("dcoref.dist.cmd", runDistributedCmd);
                        SieveCoreferenceSystem.runAndScoreCorefDist(distCmd, newProps, workDirPath + "sieves." + sieveSelectionId + ".props");
                    }
                    SieveCoreferenceSystem.waitForFiles(workDir, scoreFilesFilter, selectableSieveIndices.size());
                    for (File file : scoreFiles = workDir.listFiles(scoreFilesFilter)) {
                        Matcher m = scoreFilePattern.matcher(file.getName());
                        if (!m.matches()) {
                            throw new RuntimeException("Bad score file name: " + file);
                        }
                        int potentialSieveIndex = Integer.parseInt(m.group(2));
                        String text = IOUtils.slurpFile(file);
                        double score = Double.parseDouble(text);
                        scores.add(new Pair<Double, Integer>(score, potentialSieveIndex));
                    }
                } else {
                    Iterator i$ = selectableSieveIndices.iterator();
                    while (i$.hasNext()) {
                        int potentialSieveIndex = (Integer)i$.next();
                        this.sieves[curSievesNumber] = origSieves[potentialSieveIndex];
                        this.sieveClassNames[curSievesNumber] = origSieveNames[potentialSieveIndex];
                        logger.info("Trying sieve " + curSievesNumber + "=" + this.sieveClassNames[curSievesNumber] + ": ");
                        logger.info(" Trying sieves: " + StringUtils.join(this.sieveClassNames, ","));
                        double score = SieveCoreferenceSystem.runAndScoreCoref(this, mentionExtractor, props, timestamp);
                        scores.add(new Pair<Double, Integer>(score, potentialSieveIndex));
                        logger.info(" Trying sieves: " + StringUtils.join(this.sieveClassNames, ","));
                        logger.info(" Trying sieves score: " + score);
                    }
                }
                double bestScore = -1.0;
                for (Pair pair : scores) {
                    if (selected >= 0 && !((Double)pair.first() > bestScore)) continue;
                    bestScore = (Double)pair.first();
                    selected = (Integer)pair.second();
                }
                Collections.sort(scores);
                Collections.reverse(scores);
                logger.info("Ordered sieves");
                for (Pair pair : scores) {
                    logger.info("Sieve optimization pass " + curSievesNumber + " scores: Sieve=" + origSieveNames[(Integer)pair.second()] + ", score=" + pair.first());
                }
            } else {
                logger.info("Only one choice for next sieve");
                selected = (Integer)selectableSieveIndices.iterator().next();
            }
            this.sieves[curSievesNumber] = origSieves[selected];
            this.sieveClassNames[curSievesNumber] = origSieveNames[selected];
            logger.info("Adding sieve " + curSievesNumber + "=" + this.sieveClassNames[curSievesNumber] + " to existing sieves: ");
            logger.info(" Current Sieves: " + StringUtils.join(this.sieveClassNames, ","));
            optimizedOrdering.add(selected);
            remainingSieveIndices.remove(selected);
        }
        logger.info("Final Sieve Ordering: " + StringUtils.join(this.sieveClassNames, ","));
        logger.info("=============SIEVE OPTIMIZATION DONE ====================");
    }

    public Map<Integer, CorefChain> coref(Document document) throws Exception {
        for (int i = 0; i < this.sieves.length; ++i) {
            this.currentSieve = i;
            DeterministicCorefSieve sieve = this.sieves[i];
            this.coreference(document, sieve);
        }
        if (this.doPostProcessing || this.replicateCoNLL) {
            SieveCoreferenceSystem.postProcessing(document);
        }
        Map<Integer, CorefChain> result = Generics.newHashMap();
        for (CorefCluster c : document.corefClusters.values()) {
            result.put(c.clusterID, new CorefChain(c, document.positions));
        }
        return result;
    }

    private void coreference(Document document, DeterministicCorefSieve sieve) throws Exception {
        logger.finer("Coreference: sieve " + sieve.getClass().getSimpleName());
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        Map<Integer, CorefCluster> corefClusters = document.corefClusters;
        Set<Mention> roleSet = document.roleSet;
        logger.finest("ROLE SET (Skip exact string match): ------------------");
        for (Mention m : roleSet) {
            logger.finest("\t" + m.spanToString());
        }
        logger.finest("-------------------------------------------------------");
        this.additionalCorrectLinksCount = 0;
        this.additionalLinksCount = 0;
        for (int sentI = 0; sentI < orderedMentionsBySentence.size(); ++sentI) {
            List<Mention> orderedMentions = orderedMentionsBySentence.get(sentI);
            block2: for (int mentionI = 0; mentionI < orderedMentions.size(); ++mentionI) {
                Mention m1 = orderedMentions.get(mentionI);
                if (sieve.skipThisMention(document, m1, corefClusters.get(m1.corefClusterID), this.dictionaries)) continue;
                for (int sentJ = sentI; sentJ >= 0; --sentJ) {
                    List<Mention> l = sieve.getOrderedAntecedents(sentJ, sentI, orderedMentions, orderedMentionsBySentence, m1, mentionI, corefClusters, this.dictionaries);
                    if (this.maxSentDist != -1 && sentI - sentJ > this.maxSentDist) continue;
                    for (int i = 0; i < l.size(); ++i) {
                        for (int j = 0; j < l.size(); ++j) {
                            if (!l.get((int)i).headString.equals(l.get((int)j).headString) || l.get((int)i).startIndex != l.get((int)j).startIndex || !l.get(i).sameSentence(l.get(j)) || j <= i || l.get(i).spanToString().length() <= l.get(j).spanToString().length()) continue;
                            logger.finest("FLIPPED: " + l.get(i).spanToString() + "(" + i + "), " + l.get(j).spanToString() + "(" + j + ")");
                            l.set(j, l.set(i, l.get(j)));
                        }
                    }
                    for (Mention m2 : l) {
                        if (m1.isSingleton && m2.isSingleton || m1.corefClusterID == m2.corefClusterID) continue;
                        CorefCluster c1 = corefClusters.get(m1.corefClusterID);
                        CorefCluster c2 = corefClusters.get(m2.corefClusterID);
                        if (c2 == null) {
                            logger.warning("NO corefcluster id " + m2.corefClusterID);
                        }
                        assert (c1 != null);
                        assert (c2 != null);
                        if (sieve.useRoleSkip()) {
                            if (m1.isRoleAppositive(m2, this.dictionaries)) {
                                roleSet.add(m1);
                                continue;
                            }
                            if (!m2.isRoleAppositive(m1, this.dictionaries)) continue;
                            roleSet.add(m2);
                            continue;
                        }
                        if (!sieve.coreferent(document, c1, c2, m1, m2, this.dictionaries, roleSet, this.semantics)) continue;
                        if (this.doScore()) {
                            SieveCoreferenceSystem.printLogs(c1, c2, m1, m2, document, this.currentSieve);
                        }
                        int removeID = c1.clusterID;
                        CorefCluster.mergeClusters(c2, c1);
                        document.mergeIncompatibles(c2, c1);
                        document.mergeAcronymCache(c2, c1);
                        corefClusters.remove(removeID);
                        continue block2;
                    }
                }
            }
        }
        if (this.doScore()) {
            this.scoreMUC.get(this.currentSieve).calculateScore(document);
            this.scoreBcubed.get(this.currentSieve).calculateScore(document);
            this.scorePairwise.get(this.currentSieve).calculateScore(document);
            if (this.currentSieve == 0) {
                this.scoreSingleDoc = new ArrayList<CorefScorer>();
                this.scoreSingleDoc.add(new ScorerPairwise());
                this.scoreSingleDoc.get(this.currentSieve).calculateScore(document);
                this.additionalCorrectLinksCount = (int)this.scoreSingleDoc.get((int)this.currentSieve).precisionNumSum;
                this.additionalLinksCount = (int)this.scoreSingleDoc.get((int)this.currentSieve).precisionDenSum;
            } else {
                this.scoreSingleDoc.add(new ScorerPairwise());
                this.scoreSingleDoc.get(this.currentSieve).calculateScore(document);
                this.additionalCorrectLinksCount = (int)(this.scoreSingleDoc.get((int)this.currentSieve).precisionNumSum - this.scoreSingleDoc.get((int)(this.currentSieve - 1)).precisionNumSum);
                this.additionalLinksCount = (int)(this.scoreSingleDoc.get((int)this.currentSieve).precisionDenSum - this.scoreSingleDoc.get((int)(this.currentSieve - 1)).precisionDenSum);
            }
            this.linksCountInPass.get(this.currentSieve).setFirst(this.linksCountInPass.get(this.currentSieve).first() + this.additionalCorrectLinksCount);
            this.linksCountInPass.get(this.currentSieve).setSecond(this.linksCountInPass.get(this.currentSieve).second() + this.additionalLinksCount);
            this.printSieveScore(document, sieve);
        }
    }

    private static void postProcessing(Document document) {
        Set<Mention> removeSet = Generics.newHashSet();
        Set<Integer> removeClusterSet = Generics.newHashSet();
        for (CorefCluster c : document.corefClusters.values()) {
            Set<Mention> removeMentions = Generics.newHashSet();
            for (Mention m : c.getCorefMentions()) {
                if (!(m.appositions != null && m.appositions.size() > 0 || m.predicateNominatives != null && m.predicateNominatives.size() > 0) && (m.relativePronouns == null || m.relativePronouns.size() <= 0)) continue;
                removeMentions.add(m);
                removeSet.add(m);
                m.corefClusterID = m.mentionID;
            }
            c.corefMentions.removeAll(removeMentions);
            if (c.getCorefMentions().size() != 1) continue;
            removeClusterSet.add(c.clusterID);
        }
        Iterator<CorefCluster> i$ = removeClusterSet.iterator();
        while (i$.hasNext()) {
            int removeId = (Integer)((Object)i$.next());
            document.corefClusters.remove(removeId);
        }
        for (Mention m : removeSet) {
            document.positions.remove(m);
        }
    }

    public static LogisticClassifier<String, String> getSingletonPredictorFromSerializedFile(String serializedFile) {
        try {
            ObjectInputStream ois = IOUtils.readStreamFromString(serializedFile);
            Object o = ois.readObject();
            if (o instanceof LogisticClassifier) {
                return (LogisticClassifier)o;
            }
            throw new ClassCastException("Wanted SingletonPredictor, got " + o.getClass());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<List<Mention>> filterMentionsWithSingletonClusters(Document document, List<List<Mention>> mentions) {
        ArrayList<List<Mention>> res = new ArrayList<List<Mention>>(mentions.size());
        for (List<Mention> ml : mentions) {
            ArrayList<Mention> filtered = new ArrayList<Mention>();
            for (Mention m : ml) {
                CorefCluster cluster = document.corefClusters.get(m.corefClusterID);
                if (cluster == null || cluster.getCorefMentions().size() <= 1) continue;
                filtered.add(m);
            }
            res.add(filtered);
        }
        return res;
    }

    public static void runConllEval(String conllMentionEvalScript, String goldFile, String predictFile, String evalFile, String errFile) throws IOException {
        ProcessBuilder process = new ProcessBuilder(conllMentionEvalScript, "all", goldFile, predictFile);
        PrintWriter out2 = new PrintWriter(new FileOutputStream(evalFile));
        PrintWriter err2 = new PrintWriter(new FileOutputStream(errFile));
        SystemUtils.run(process, out2, err2);
        out2.close();
        err2.close();
    }

    public static String getConllEvalSummary(String conllMentionEvalScript, String goldFile, String predictFile) throws IOException {
        ProcessBuilder process = new ProcessBuilder(conllMentionEvalScript, "all", goldFile, predictFile, "none");
        StringOutputStream errSos = new StringOutputStream();
        StringOutputStream outSos = new StringOutputStream();
        PrintWriter out2 = new PrintWriter(outSos);
        PrintWriter err2 = new PrintWriter(errSos);
        SystemUtils.run(process, out2, err2);
        out2.close();
        err2.close();
        String summary = outSos.toString();
        String errStr = errSos.toString();
        if (!errStr.isEmpty()) {
            summary = summary + "\nERROR: " + errStr;
        }
        Pattern pattern = Pattern.compile("\\d+.\\d\\d\\d+");
        DecimalFormat df = new DecimalFormat("#.##");
        Matcher matcher = pattern.matcher(summary);
        while (matcher.find()) {
            String number = matcher.group();
            summary = summary.replaceFirst(number, df.format(Double.parseDouble(number)));
        }
        return summary;
    }

    public void printTopK(Logger logger, Document document, Semantics semantics) {
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        Map<Integer, CorefCluster> corefClusters = document.corefClusters;
        Map<Mention, IntTuple> positions = document.allPositions;
        Map<Integer, Mention> golds = document.allGoldMentions;
        logger.fine("=======ERROR ANALYSIS=========================================================");
        ExactStringMatch tmpSieve = new ExactStringMatch();
        for (int i = 0; i < orderedMentionsBySentence.size(); ++i) {
            List<Mention> orderedMentions = orderedMentionsBySentence.get(i);
            for (int j = 0; j < orderedMentions.size(); ++j) {
                Mention m = orderedMentions.get(j);
                logger.fine("=========Line: " + i + "\tmention: " + j + "=======================================================");
                logger.fine(m.spanToString() + "\tmentionID: " + m.mentionID + "\tcorefClusterID: " + m.corefClusterID + "\tgoldCorefClusterID: " + m.goldCorefClusterID);
                CorefCluster corefCluster = corefClusters.get(m.corefClusterID);
                if (corefCluster != null) {
                    corefCluster.printCorefCluster(logger);
                } else {
                    logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                }
                logger.fine("-------------------------------------------------------");
                boolean oneRecallErrorPrinted = false;
                boolean onePrecisionErrorPrinted = false;
                boolean alreadyChoose = false;
                for (int sentJ = i; sentJ >= 0; --sentJ) {
                    int ii;
                    List<Mention> l = tmpSieve.getOrderedAntecedents(sentJ, i, orderedMentions, orderedMentionsBySentence, m, j, corefClusters, this.dictionaries);
                    for (ii = 0; ii < l.size(); ++ii) {
                        for (int jj = 0; jj < l.size(); ++jj) {
                            if (!l.get((int)ii).headString.equals(l.get((int)jj).headString) || l.get((int)ii).startIndex != l.get((int)jj).startIndex || !l.get(ii).sameSentence(l.get(jj)) || jj <= ii || l.get(ii).spanToString().length() <= l.get(jj).spanToString().length()) continue;
                            logger.finest("FLIPPED: " + l.get(ii).spanToString() + "(" + ii + "), " + l.get(jj).spanToString() + "(" + jj + ")");
                            l.set(jj, l.set(ii, l.get(jj)));
                        }
                    }
                    logger.finest("Candidates in sentence #" + sentJ + " for mention: " + m.spanToString());
                    for (ii = 0; ii < l.size(); ++ii) {
                        logger.finest("\tCandidate #" + ii + ": " + l.get(ii).spanToString());
                    }
                    for (Mention antecedent : l) {
                        boolean chosen = m.corefClusterID == antecedent.corefClusterID;
                        IntTuple src = new IntTuple(2);
                        src.set(0, i);
                        src.set(1, j);
                        IntTuple ant = positions.get(antecedent);
                        if (ant == null) continue;
                        boolean coreferent = golds.containsKey(m.mentionID) && golds.containsKey(antecedent.mentionID) && golds.get((Object)Integer.valueOf((int)m.mentionID)).goldCorefClusterID == golds.get((Object)Integer.valueOf((int)antecedent.mentionID)).goldCorefClusterID;
                        boolean correct = chosen == coreferent;
                        String chosenness = chosen ? "Chosen" : "Not Chosen";
                        String correctness = correct ? "Correct" : "Incorrect";
                        logger.fine("\t" + correctness + "\t\t" + chosenness + "\t" + antecedent.spanToString());
                        CorefCluster mC = corefClusters.get(m.corefClusterID);
                        CorefCluster aC = corefClusters.get(antecedent.corefClusterID);
                        if (chosen && !correct && !onePrecisionErrorPrinted && !alreadyChoose) {
                            onePrecisionErrorPrinted = true;
                            SieveCoreferenceSystem.printLinkWithContext(logger, "\nPRECISION ERROR ", src, ant, document, semantics);
                            logger.fine("END of PRECISION ERROR LOG");
                        }
                        if (!chosen && !correct && !oneRecallErrorPrinted && (!alreadyChoose || alreadyChoose && onePrecisionErrorPrinted)) {
                            oneRecallErrorPrinted = true;
                            SieveCoreferenceSystem.printLinkWithContext(logger, "\nRECALL ERROR ", src, ant, document, semantics);
                            logger.finer("cluster info: ");
                            if (mC != null) {
                                mC.printCorefCluster(logger);
                            } else {
                                logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                            }
                            logger.finer("----------------------------------------------------------");
                            if (aC != null) {
                                aC.printCorefCluster(logger);
                            } else {
                                logger.finer("CANNOT find coref cluster for cluster " + m.corefClusterID);
                            }
                            logger.finer("");
                            logger.fine("END of RECALL ERROR LOG");
                        }
                        if (!chosen) continue;
                        alreadyChoose = true;
                    }
                }
                logger.fine("\n");
            }
        }
        logger.fine("===============================================================================");
    }

    public void printF1(boolean printF1First) {
        this.scoreMUC.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
        this.scoreBcubed.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
        this.scorePairwise.get(this.sieveClassNames.length - 1).printF1(logger, printF1First);
    }

    private void printSieveScore(Document document, DeterministicCorefSieve sieve) {
        logger.fine("===========================================");
        logger.fine("pass" + this.currentSieve + ": " + sieve.flagsToString());
        this.scoreMUC.get(this.currentSieve).printF1(logger);
        this.scoreBcubed.get(this.currentSieve).printF1(logger);
        this.scorePairwise.get(this.currentSieve).printF1(logger);
        logger.fine("# of Clusters: " + document.corefClusters.size() + ",\t# of additional links: " + this.additionalLinksCount + ",\t# of additional correct links: " + this.additionalCorrectLinksCount + ",\tprecision of new links: " + 1.0 * (double)this.additionalCorrectLinksCount / (double)this.additionalLinksCount);
        logger.fine("# of total additional links: " + this.linksCountInPass.get(this.currentSieve).second() + ",\t# of total additional correct links: " + this.linksCountInPass.get(this.currentSieve).first() + ",\taccumulated precision of this pass: " + 1.0 * (double)this.linksCountInPass.get(this.currentSieve).first().intValue() / (double)this.linksCountInPass.get(this.currentSieve).second().intValue());
        logger.fine("--------------------------------------");
    }

    private static void printLink(Logger logger, String header, IntTuple src, IntTuple dst, List<List<Mention>> orderedMentionsBySentence) {
        Mention srcMention = orderedMentionsBySentence.get(src.get(0)).get(src.get(1));
        Mention dstMention = orderedMentionsBySentence.get(dst.get(0)).get(dst.get(1));
        if (src.get(0) == dst.get(0)) {
            logger.fine(header + ": [" + srcMention.spanToString() + "](id=" + srcMention.mentionID + ") in sent #" + src.get(0) + " => [" + dstMention.spanToString() + "](id=" + dstMention.mentionID + ") in sent #" + dst.get(0) + " Same Sentence");
        } else {
            logger.fine(header + ": [" + srcMention.spanToString() + "](id=" + srcMention.mentionID + ") in sent #" + src.get(0) + " => [" + dstMention.spanToString() + "](id=" + dstMention.mentionID + ") in sent #" + dst.get(0));
        }
    }

    protected static void printList(Logger logger, String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
            sb.append('\t');
        }
        logger.fine(sb.toString());
    }

    private static void printLinkWithContext(Logger logger, String header, IntTuple src, IntTuple dst, Document document, Semantics semantics) {
        int i;
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        List<List<Mention>> goldOrderedMentionsBySentence = document.goldOrderedMentionsBySentence;
        Mention srcMention = orderedMentionsBySentence.get(src.get(0)).get(src.get(1));
        Mention dstMention = orderedMentionsBySentence.get(dst.get(0)).get(dst.get(1));
        List<CoreLabel> srcSentence = srcMention.sentenceWords;
        List<CoreLabel> dstSentence = dstMention.sentenceWords;
        SieveCoreferenceSystem.printLink(logger, header, src, dst, orderedMentionsBySentence);
        SieveCoreferenceSystem.printList(logger, "Mention:" + srcMention.spanToString(), "Gender:" + srcMention.gender.toString(), "Number:" + srcMention.number.toString(), "Animacy:" + srcMention.animacy.toString(), "Person:" + srcMention.person.toString(), "NER:" + srcMention.nerString, "Head:" + srcMention.headString, "Type:" + srcMention.mentionType.toString(), "utter: " + srcMention.headWord.get(CoreAnnotations.UtteranceAnnotation.class), "speakerID: " + (String)srcMention.headWord.get(CoreAnnotations.SpeakerAnnotation.class), "twinless:" + srcMention.twinless);
        logger.fine("Context:");
        String p = "";
        for (int i2 = 0; i2 < srcSentence.size(); ++i2) {
            if (i2 == srcMention.startIndex) {
                p = p + "[";
            }
            if (i2 == srcMention.endIndex) {
                p = p + "]";
            }
            p = p + srcSentence.get(i2).word() + " ";
        }
        logger.fine(p);
        StringBuilder golds = new StringBuilder();
        golds.append("Gold mentions in the sentence:\n");
        ClassicCounter<Integer> mBegin = new ClassicCounter<Integer>();
        ClassicCounter<Integer> mEnd = new ClassicCounter<Integer>();
        for (Mention m : goldOrderedMentionsBySentence.get(src.get(0))) {
            mBegin.incrementCount(m.startIndex);
            mEnd.incrementCount(m.endIndex);
        }
        List l = (List)((CoreMap)((List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(src.get(0))).get(CoreAnnotations.TokensAnnotation.class);
        for (i = 0; i < l.size(); ++i) {
            int j = 0;
            while ((double)j < mEnd.getCount(i)) {
                golds.append("]");
                ++j;
            }
            j = 0;
            while ((double)j < mBegin.getCount(i)) {
                golds.append("[");
                ++j;
            }
            golds.append((String)((CoreLabel)l.get(i)).get(CoreAnnotations.TextAnnotation.class));
            golds.append(" ");
        }
        logger.fine(golds.toString());
        SieveCoreferenceSystem.printList(logger, "\nAntecedent:" + dstMention.spanToString(), "Gender:" + dstMention.gender.toString(), "Number:" + dstMention.number.toString(), "Animacy:" + dstMention.animacy.toString(), "Person:" + dstMention.person.toString(), "NER:" + dstMention.nerString, "Head:" + dstMention.headString, "Type:" + dstMention.mentionType.toString(), "utter: " + dstMention.headWord.get(CoreAnnotations.UtteranceAnnotation.class), "speakerID: " + (String)dstMention.headWord.get(CoreAnnotations.SpeakerAnnotation.class), "twinless:" + dstMention.twinless);
        logger.fine("Context:");
        p = "";
        for (i = 0; i < dstSentence.size(); ++i) {
            if (i == dstMention.startIndex) {
                p = p + "[";
            }
            if (i == dstMention.endIndex) {
                p = p + "]";
            }
            p = p + dstSentence.get(i).word() + " ";
        }
        logger.fine(p);
        golds = new StringBuilder();
        golds.append("Gold mentions in the sentence:\n");
        mBegin = new ClassicCounter();
        mEnd = new ClassicCounter();
        for (Mention m : goldOrderedMentionsBySentence.get(dst.get(0))) {
            mBegin.incrementCount(m.startIndex);
            mEnd.incrementCount(m.endIndex);
        }
        l = (List)((CoreMap)((List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(dst.get(0))).get(CoreAnnotations.TokensAnnotation.class);
        for (int i3 = 0; i3 < l.size(); ++i3) {
            int j = 0;
            while ((double)j < mEnd.getCount(i3)) {
                golds.append("]");
                ++j;
            }
            j = 0;
            while ((double)j < mBegin.getCount(i3)) {
                golds.append("[");
                ++j;
            }
            golds.append((String)((CoreLabel)l.get(i3)).get(CoreAnnotations.TextAnnotation.class));
            golds.append(" ");
        }
        logger.fine(golds.toString());
        logger.finer("\nMention:: --------------------------------------------------------");
        try {
            logger.finer(srcMention.dependency.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.finer("Parse:");
        logger.finer(SieveCoreferenceSystem.formatPennTree(srcMention.contextParseTree));
        logger.finer("\nAntecedent:: -----------------------------------------------------");
        try {
            logger.finer(dstMention.dependency.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.finer("Parse:");
        logger.finer(SieveCoreferenceSystem.formatPennTree(dstMention.contextParseTree));
    }

    public static String formatPennTree(Tree parseTree) {
        String treeString = parseTree.pennString();
        treeString = treeString.replaceAll("\\[TextAnnotation=", "");
        treeString = treeString.replaceAll("(NamedEntityTag|Value|Index|PartOfSpeech)Annotation.+?\\)", ")");
        treeString = treeString.replaceAll("\\[.+?\\]", "");
        return treeString;
    }

    private static void printLogs(CorefCluster c1, CorefCluster c2, Mention m1, Mention m2, Document document, int sieveIndex) {
        Map<Mention, IntTuple> positions = document.positions;
        List<List<Mention>> orderedMentionsBySentence = document.getOrderedMentions();
        List<Pair<IntTuple, IntTuple>> goldLinks = document.getGoldLinks();
        IntTuple p1 = positions.get(m1);
        assert (p1 != null);
        IntTuple p2 = positions.get(m2);
        assert (p2 != null);
        int menDist = 0;
        for (int i = p2.get(0); i <= p1.get(0); ++i) {
            if (p1.get(0) == p2.get(0)) {
                menDist = p1.get(1) - p2.get(1);
                break;
            }
            if (i == p2.get(0)) {
                menDist += orderedMentionsBySentence.get(p2.get(0)).size() - p2.get(1);
                continue;
            }
            if (i == p1.get(0)) {
                menDist += p1.get(1);
                continue;
            }
            if (p2.get(0) >= i || i >= p1.get(0)) continue;
            menDist += orderedMentionsBySentence.get(i).size();
        }
        String correct = goldLinks.contains(new Pair<IntTuple, IntTuple>(p1, p2)) ? "\tCorrect" : "\tIncorrect";
        logger.finest("\nsentence distance: " + (p1.get(0) - p2.get(0)) + "\tmention distance: " + menDist + correct);
        if (!goldLinks.contains(new Pair<IntTuple, IntTuple>(p1, p2))) {
            logger.finer("-------Incorrect merge in pass" + sieveIndex + "::--------------------");
            c1.printCorefCluster(logger);
            logger.finer("--------------------------------------------");
            c2.printCorefCluster(logger);
            logger.finer("--------------------------------------------");
        }
        logger.finer("antecedent: " + m2.spanToString() + "(" + m2.mentionID + ")\tmention: " + m1.spanToString() + "(" + m1.mentionID + ")\tsentDistance: " + Math.abs(m1.sentNum - m2.sentNum) + "\t" + correct + " Pass" + sieveIndex + ":");
    }

    private static void printDiscourseStructure(Document document) {
        logger.finer("DISCOURSE STRUCTURE==============================");
        logger.finer("doc type: " + (Object)((Object)document.docType));
        int previousUtterIndex = -1;
        String previousSpeaker = "";
        StringBuilder sb = new StringBuilder();
        for (CoreMap s : (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel l : (List)s.get(CoreAnnotations.TokensAnnotation.class)) {
                int utterIndex = (Integer)l.get(CoreAnnotations.UtteranceAnnotation.class);
                String speaker = (String)l.get(CoreAnnotations.SpeakerAnnotation.class);
                String word = (String)l.get(CoreAnnotations.TextAnnotation.class);
                if (previousUtterIndex != utterIndex) {
                    try {
                        int previousSpeakerID = Integer.parseInt(previousSpeaker);
                        logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + document.allPredictedMentions.get(previousSpeakerID).spanToString());
                    }
                    catch (Exception e) {
                        logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + previousSpeaker);
                    }
                    logger.finer(sb.toString());
                    sb.setLength(0);
                    previousUtterIndex = utterIndex;
                    previousSpeaker = speaker;
                }
                sb.append(" ").append(word);
            }
            sb.append("\n");
        }
        try {
            int previousSpeakerID = Integer.parseInt(previousSpeaker);
            logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + document.allPredictedMentions.get(previousSpeakerID).spanToString());
        }
        catch (Exception e) {
            logger.finer("\n<utter>: " + previousUtterIndex + " <speaker>: " + previousSpeaker);
        }
        logger.finer(sb.toString());
        logger.finer("END OF DISCOURSE STRUCTURE==============================");
    }

    private static void printScoreSummary(String summary, Logger logger, boolean afterPostProcessing) {
        String[] lines = summary.split("\n");
        if (!afterPostProcessing) {
            for (String line : lines) {
                if (!line.startsWith("Identification of Mentions")) continue;
                logger.info(line);
                return;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (line.startsWith("METRIC")) {
                    sb.append(line);
                }
                if (line.startsWith("Identification of Mentions") || !line.contains("Recall")) continue;
                sb.append(line).append("\n");
            }
            logger.info(sb.toString());
        }
    }

    private static void printFinalConllScore(String summary) {
        Pattern f1 = Pattern.compile("Coreference:.*F1: (.*)%");
        Matcher f1Matcher = f1.matcher(summary);
        double[] F1s = new double[5];
        int i = 0;
        while (f1Matcher.find()) {
            F1s[i++] = Double.parseDouble(f1Matcher.group(1));
        }
        double finalScore = (F1s[0] + F1s[1] + F1s[3]) / 3.0;
        logger.info("Final conll score ((muc+bcub+ceafe)/3) = " + new DecimalFormat("#.##").format(finalScore));
    }

    private static double getFinalConllScore(String summary, String metricType, String scoreType) {
        Pattern pattern = Pattern.compile("METRIC\\s+(.*):Coreference:.*" + scoreType + ":\\s*(\\([ 0-9./]*\\))?\\s*(\\d+(\\.\\d+)?)%");
        Matcher matcher = pattern.matcher(summary);
        double[] scores = new double[5];
        String[] names = new String[5];
        int i = 0;
        while (matcher.find()) {
            names[i] = matcher.group(1);
            scores[i] = Double.parseDouble(matcher.group(3));
            ++i;
        }
        if ("combined".equals(metricType = metricType.toLowerCase())) {
            double finalScore = (scores[0] + scores[1] + scores[3]) / 3.0;
            logger.info("Final conll score ((muc+bcub+ceafe)/3) " + scoreType + " = " + finalScore);
            return finalScore;
        }
        if ("bcubed".equals(metricType)) {
            metricType = "bcub";
        }
        for (i = 0; i < names.length; ++i) {
            if (names[i] == null || !names[i].equals(metricType)) continue;
            double finalScore = scores[i];
            logger.info("Final conll score (" + metricType + ") " + scoreType + " = " + finalScore);
            return finalScore;
        }
        throw new IllegalArgumentException("Invalid metricType:" + metricType);
    }

    private double getFinalScore(String metricType, CorefScorer.SubScoreType subScoreType) {
        double finalScore;
        metricType = metricType.toLowerCase();
        int passIndex = this.sieveClassNames.length - 1;
        String scoreDesc = metricType;
        if ("combined".equals(metricType)) {
            finalScore = (this.scoreMUC.get(passIndex).getScore(subScoreType) + this.scoreBcubed.get(passIndex).getScore(subScoreType) + this.scorePairwise.get(passIndex).getScore(subScoreType)) / 3.0;
            scoreDesc = "(muc + bcub + pairwise)/3";
        } else if ("muc".equals(metricType)) {
            finalScore = this.scoreMUC.get(passIndex).getScore(subScoreType);
        } else if ("bcub".equals(metricType) || "bcubed".equals(metricType)) {
            finalScore = this.scoreBcubed.get(passIndex).getScore(subScoreType);
        } else if ("pairwise".equals(metricType)) {
            finalScore = this.scorePairwise.get(passIndex).getScore(subScoreType);
        } else {
            throw new IllegalArgumentException("Invalid sub score type:" + (Object)((Object)subScoreType));
        }
        logger.info("Final score (" + scoreDesc + ") " + (Object)((Object)subScoreType) + " = " + new DecimalFormat("#.##").format(finalScore));
        return finalScore;
    }

    public static void printConllOutput(Document document, PrintWriter writer, boolean gold) {
        SieveCoreferenceSystem.printConllOutput(document, writer, gold, false);
    }

    public static void printConllOutput(Document document, PrintWriter writer, boolean gold, boolean filterSingletons) {
        List<List<Mention>> orderedMentions = gold ? document.goldOrderedMentionsBySentence : document.predictedOrderedMentionsBySentence;
        if (filterSingletons) {
            orderedMentions = SieveCoreferenceSystem.filterMentionsWithSingletonClusters(document, orderedMentions);
        }
        SieveCoreferenceSystem.printConllOutput(document, writer, orderedMentions, gold);
    }

    public static void printConllOutput(Document document, PrintWriter writer, List<List<Mention>> orderedMentions, boolean gold) {
        Annotation anno = document.annotation;
        List<List<String[]>> conllDocSentences = document.conllDoc.sentenceWordLists;
        String docID = (String)anno.get(CoreAnnotations.DocIDAnnotation.class);
        StringBuilder sb = new StringBuilder();
        sb.append("#begin document ").append(docID).append("\n");
        List sentences = (List)anno.get(CoreAnnotations.SentencesAnnotation.class);
        for (int sentNum = 0; sentNum < sentences.size(); ++sentNum) {
            int i;
            List sentence = (List)((CoreMap)sentences.get(sentNum)).get(CoreAnnotations.TokensAnnotation.class);
            List<String[]> conllSentence = conllDocSentences.get(sentNum);
            Map mentionBeginOnly = Generics.newHashMap();
            Map mentionEndOnly = Generics.newHashMap();
            Map mentionBeginEnd = Generics.newHashMap();
            for (i = 0; i < sentence.size(); ++i) {
                mentionBeginOnly.put(i, new LinkedHashSet());
                mentionEndOnly.put(i, new LinkedHashSet());
                mentionBeginEnd.put(i, new LinkedHashSet());
            }
            for (Mention m : orderedMentions.get(sentNum)) {
                if (m.startIndex == m.endIndex - 1) {
                    ((Set)mentionBeginEnd.get(m.startIndex)).add(m);
                    continue;
                }
                ((Set)mentionBeginOnly.get(m.startIndex)).add(m);
                ((Set)mentionEndOnly.get(m.endIndex - 1)).add(m);
            }
            for (i = 0; i < sentence.size(); ++i) {
                int corefClusterId;
                StringBuilder sb2 = new StringBuilder();
                for (Mention m : (Set)mentionBeginOnly.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append("(").append(corefClusterId);
                }
                for (Mention m : (Set)mentionBeginEnd.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append("(").append(corefClusterId).append(")");
                }
                for (Mention m : (Set)mentionEndOnly.get(i)) {
                    if (sb2.length() > 0) {
                        sb2.append("|");
                    }
                    corefClusterId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    sb2.append(corefClusterId).append(")");
                }
                if (sb2.length() == 0) {
                    sb2.append("-");
                }
                String[] columns = conllSentence.get(i);
                for (int j = 0; j < columns.length - 1; ++j) {
                    String column = columns[j];
                    sb.append(column).append("\t");
                }
                sb.append((CharSequence)sb2).append("\n");
            }
            sb.append("\n");
        }
        sb.append("#end document").append("\n");
        writer.print(sb.toString());
        writer.flush();
    }

    public static void printRawDoc(Document document, boolean gold) throws FileNotFoundException {
        List sentences = (List)document.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        List<List<Mention>> allMentions = gold ? document.goldOrderedMentionsBySentence : document.predictedOrderedMentionsBySentence;
        StringBuilder doc = new StringBuilder();
        int previousOffset = 0;
        for (int i = 0; i < sentences.size(); ++i) {
            CoreMap sentence = (CoreMap)sentences.get(i);
            List<Mention> mentions = allMentions.get(i);
            List t = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            String[] tokens = new String[t.size()];
            for (CoreLabel c : t) {
                tokens[c.index() - 1] = c.word();
            }
            if (previousOffset + 2 < (Integer)((CoreLabel)t.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                doc.append("\n");
            }
            previousOffset = (Integer)((CoreLabel)t.get(t.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            ClassicCounter<Integer> startCounts = new ClassicCounter<Integer>();
            ClassicCounter<Integer> endCounts = new ClassicCounter<Integer>();
            Map endMentions = Generics.newHashMap();
            for (Mention m : mentions) {
                startCounts.incrementCount(m.startIndex);
                endCounts.incrementCount(m.endIndex);
                if (!endMentions.containsKey(m.endIndex)) {
                    endMentions.put(m.endIndex, Generics.newHashSet());
                }
                ((Set)endMentions.get(m.endIndex)).add(m);
            }
            for (int j = 0; j < tokens.length; ++j) {
                if (endMentions.containsKey(j)) {
                    for (Mention m : (Set)endMentions.get(j)) {
                        int corefChainId = gold ? m.goldCorefClusterID : m.corefClusterID;
                        doc.append("]_").append(corefChainId);
                    }
                }
                int k = 0;
                while ((double)k < startCounts.getCount(j)) {
                    if (doc.length() > 0 && doc.charAt(doc.length() - 1) != '[') {
                        doc.append(" ");
                    }
                    doc.append("[");
                    ++k;
                }
                if (doc.length() > 0 && doc.charAt(doc.length() - 1) != '[') {
                    doc.append(" ");
                }
                doc.append(tokens[j]);
            }
            if (endMentions.containsKey(tokens.length)) {
                for (Mention m : (Set)endMentions.get(tokens.length)) {
                    int corefChainId = gold ? m.goldCorefClusterID : m.corefClusterID;
                    doc.append("]_").append(corefChainId);
                }
            }
            doc.append("\n");
        }
        logger.fine((String)document.annotation.get(CoreAnnotations.DocIDAnnotation.class));
        if (gold) {
            logger.fine("New DOC: (GOLD MENTIONS) ==================================================");
        } else {
            logger.fine("New DOC: (Predicted Mentions) ==================================================");
        }
        logger.fine(doc.toString());
    }

    public static List<Pair<IntTuple, IntTuple>> getLinks(Map<Integer, CorefChain> result) {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        CorefChain.CorefMentionComparator comparator = new CorefChain.CorefMentionComparator();
        for (CorefChain c : result.values()) {
            List<CorefChain.CorefMention> s = c.getMentionsInTextualOrder();
            for (CorefChain.CorefMention m1 : s) {
                for (CorefChain.CorefMention m2 : s) {
                    if (comparator.compare(m1, m2) != 1) continue;
                    links.add(new Pair<IntTuple, IntTuple>(m1.position, m2.position));
                }
            }
        }
        return links;
    }

    public static void debugPrintMentions(PrintStream out2, String tag, List<List<Mention>> mentions) {
        for (int i = 0; i < mentions.size(); ++i) {
            out2.println(tag + " SENTENCE " + i);
            for (int j = 0; j < mentions.get(i).size(); ++j) {
                Mention m = mentions.get(i).get(j);
                String ms = "(" + m.mentionID + "," + m.originalRef + "," + m.corefClusterID + ",[" + m.startIndex + "," + m.endIndex + "]" + ") ";
                out2.print(ms);
            }
            out2.println();
        }
    }

    public static boolean checkClusters(Logger logger, String tag, Document document) {
        List<List<Mention>> mentions = document.getOrderedMentions();
        boolean clustersOk = true;
        for (List<Mention> mentionCluster : mentions) {
            for (Mention m : mentionCluster) {
                String ms = "(" + m.mentionID + "," + m.originalRef + "," + m.corefClusterID + ",[" + m.startIndex + "," + m.endIndex + "]" + ") ";
                CorefCluster cluster = document.corefClusters.get(m.corefClusterID);
                if (cluster == null) {
                    logger.warning(tag + ": Cluster not found for mention: " + ms);
                    clustersOk = false;
                    continue;
                }
                if (cluster.getCorefMentions().contains(m)) continue;
                logger.warning(tag + ": Cluster does not contain mention: " + ms);
                clustersOk = false;
            }
        }
        return clustersOk;
    }
}

