/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CorefChain
implements Serializable {
    private final int chainID;
    private final List<CorefMention> mentions;
    private final Map<IntPair, Set<CorefMention>> mentionMap;
    private final CorefMention representative;
    private static final long serialVersionUID = 3657691243506528L;

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof CorefChain)) {
            return false;
        }
        CorefChain that = (CorefChain)aThat;
        if (this.chainID != that.chainID) {
            return false;
        }
        if (!((Object)this.mentions).equals(that.mentions)) {
            return false;
        }
        if (this.representative == null && that.representative == null) {
            return true;
        }
        return this.representative != null && that.representative != null && this.representative.equals(that.representative);
    }

    public int hashCode() {
        return ((Object)this.mentions).hashCode();
    }

    public List<CorefMention> getMentionsInTextualOrder() {
        return this.mentions;
    }

    public Set<CorefMention> getMentionsWithSameHead(IntPair position) {
        return this.mentionMap.get(position);
    }

    public Set<CorefMention> getMentionsWithSameHead(int sentenceNumber, int headIndex) {
        return this.mentionMap.get(new IntPair(sentenceNumber, headIndex));
    }

    public Map<IntPair, Set<CorefMention>> getMentionMap() {
        return this.mentionMap;
    }

    public CorefMention getRepresentativeMention() {
        return this.representative;
    }

    public int getChainID() {
        return this.chainID;
    }

    public CorefChain(CorefCluster c, Map<Mention, IntTuple> positions) {
        this.chainID = c.clusterID;
        this.mentions = new ArrayList<CorefMention>();
        this.mentionMap = Generics.newHashMap();
        CorefMention represents = null;
        for (Mention m : c.getCorefMentions()) {
            CorefMention men = new CorefMention(m, positions.get(m));
            this.mentions.add(men);
        }
        Collections.sort(this.mentions, new CorefMentionComparator());
        for (CorefMention men : this.mentions) {
            IntPair position = new IntPair(men.sentNum, men.headIndex);
            if (!this.mentionMap.containsKey(position)) {
                this.mentionMap.put(position, Generics.newHashSet());
            }
            this.mentionMap.get(position).add(men);
            if (!men.moreRepresentativeThan(represents)) continue;
            represents = men;
        }
        this.representative = represents;
    }

    public CorefChain(int cid, Map<IntPair, Set<CorefMention>> mentionMap, CorefMention representative) {
        this.chainID = cid;
        this.representative = representative;
        this.mentionMap = mentionMap;
        this.mentions = new ArrayList<CorefMention>();
        for (Set<CorefMention> ms : mentionMap.values()) {
            for (CorefMention m : ms) {
                this.mentions.add(m);
            }
        }
        Collections.sort(this.mentions, new CorefMentionComparator());
    }

    public String toString() {
        return "CHAIN" + this.chainID + "-" + this.mentions.toString();
    }

    protected static class MentionComparator
    implements Comparator<Mention> {
        protected MentionComparator() {
        }

        @Override
        public int compare(Mention m1, Mention m2) {
            if (m1.sentNum < m2.sentNum) {
                return -1;
            }
            if (m1.sentNum > m2.sentNum) {
                return 1;
            }
            if (m1.startIndex < m2.startIndex) {
                return -1;
            }
            if (m1.startIndex > m2.startIndex) {
                return 1;
            }
            if (m1.endIndex > m2.endIndex) {
                return -1;
            }
            if (m1.endIndex < m2.endIndex) {
                return 1;
            }
            return 0;
        }
    }

    protected static class CorefMentionComparator
    implements Comparator<CorefMention> {
        protected CorefMentionComparator() {
        }

        @Override
        public int compare(CorefMention m1, CorefMention m2) {
            if (m1.sentNum < m2.sentNum) {
                return -1;
            }
            if (m1.sentNum > m2.sentNum) {
                return 1;
            }
            if (m1.startIndex < m2.startIndex) {
                return -1;
            }
            if (m1.startIndex > m2.startIndex) {
                return 1;
            }
            if (m1.endIndex > m2.endIndex) {
                return -1;
            }
            if (m1.endIndex < m2.endIndex) {
                return 1;
            }
            return 0;
        }
    }

    public static class CorefMention
    implements Serializable {
        public final Dictionaries.MentionType mentionType;
        public final Dictionaries.Number number;
        public final Dictionaries.Gender gender;
        public final Dictionaries.Animacy animacy;
        public final int startIndex;
        public final int endIndex;
        public final int headIndex;
        public final int corefClusterID;
        public final int mentionID;
        public final int sentNum;
        public final IntTuple position;
        public final String mentionSpan;
        private static final long serialVersionUID = 3657691243504173L;

        public CorefMention(Dictionaries.MentionType mentionType, Dictionaries.Number number, Dictionaries.Gender gender, Dictionaries.Animacy animacy, int startIndex, int endIndex, int headIndex, int corefClusterID, int mentionID, int sentNum, IntTuple position, String mentionSpan) {
            this.mentionType = mentionType;
            this.number = number;
            this.gender = gender;
            this.animacy = animacy;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.headIndex = headIndex;
            this.corefClusterID = corefClusterID;
            this.mentionID = mentionID;
            this.sentNum = sentNum;
            this.position = position;
            this.mentionSpan = mentionSpan;
        }

        public CorefMention(Mention m, IntTuple pos) {
            this.mentionType = m.mentionType;
            this.number = m.number;
            this.gender = m.gender;
            this.animacy = m.animacy;
            this.startIndex = m.startIndex + 1;
            this.endIndex = m.endIndex + 1;
            this.headIndex = m.headIndex + 1;
            this.corefClusterID = m.corefClusterID;
            this.sentNum = m.sentNum + 1;
            this.mentionID = m.mentionID;
            this.mentionSpan = m.spanToString();
            this.position = new IntTuple(2);
            this.position.set(0, pos.get(0) + 1);
            this.position.set(1, pos.get(1) + 1);
            m.headWord.set(CorefCoreAnnotations.CorefClusterIdAnnotation.class, this.corefClusterID);
        }

        public boolean equals(Object aThat) {
            if (this == aThat) {
                return true;
            }
            if (!(aThat instanceof CorefMention)) {
                return false;
            }
            CorefMention that = (CorefMention)aThat;
            if (this.mentionType != that.mentionType) {
                return false;
            }
            if (this.number != that.number) {
                return false;
            }
            if (this.gender != that.gender) {
                return false;
            }
            if (this.animacy != that.animacy) {
                return false;
            }
            if (this.startIndex != that.startIndex) {
                return false;
            }
            if (this.endIndex != that.endIndex) {
                return false;
            }
            if (this.headIndex != that.headIndex) {
                return false;
            }
            if (this.corefClusterID != that.corefClusterID) {
                return false;
            }
            if (this.mentionID != that.mentionID) {
                return false;
            }
            if (this.sentNum != that.sentNum) {
                return false;
            }
            return this.position.equals(that.position);
        }

        public int hashCode() {
            return this.position.hashCode();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("\"").append(this.mentionSpan).append("\"").append(" in sentence ").append(this.sentNum);
            return s.toString();
        }

        private boolean moreRepresentativeThan(CorefMention m) {
            if (m == null) {
                return true;
            }
            if (this.mentionType != m.mentionType) {
                return this.mentionType == Dictionaries.MentionType.PROPER || this.mentionType == Dictionaries.MentionType.NOMINAL && m.mentionType == Dictionaries.MentionType.PRONOMINAL;
            }
            if (this.headIndex - this.startIndex > m.headIndex - m.startIndex) {
                return true;
            }
            if (this.headIndex - this.startIndex < m.headIndex - m.startIndex) {
                return false;
            }
            if (this.endIndex - this.startIndex > m.endIndex - m.startIndex) {
                return true;
            }
            if (this.endIndex - this.startIndex < m.endIndex - m.startIndex) {
                return false;
            }
            if (this.sentNum < m.sentNum) {
                return true;
            }
            if (this.sentNum > m.sentNum) {
                return false;
            }
            if (this.headIndex < m.headIndex) {
                return true;
            }
            if (this.headIndex > m.headIndex) {
                return false;
            }
            if (this.startIndex < m.startIndex) {
                return true;
            }
            if (this.startIndex > m.startIndex) {
                return false;
            }
            return false;
        }
    }
}

