/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.ReadCsv;

public class ReadMatrixCsv
extends ReadCsv {
    public ReadMatrixCsv(InputStream inputStream) {
        super(inputStream);
    }

    public DenseMatrix64F read() throws IOException {
        List<String> list = this.extractWords();
        if (list.size() != 2) {
            throw new IOException("Unexpected number of words on first line.");
        }
        int n = Integer.parseInt(list.get(0));
        int n2 = Integer.parseInt(list.get(1));
        if (n < 0 || n2 < 0) {
            throw new IOException("Invalid number of rows and/or columns: " + n + " " + n2);
        }
        return this.read(n, n2);
    }

    public DenseMatrix64F read(int n, int n2) throws IOException {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        for (int i = 0; i < n; ++i) {
            List<String> list = this.extractWords();
            if (list.size() != n2) {
                throw new IOException("Unexpected number of words in column. Found " + list.size() + " expected " + n2);
            }
            for (int j = 0; j < n2; ++j) {
                denseMatrix64F.set(i, j, Double.parseDouble(list.get(j)));
            }
        }
        return denseMatrix64F;
    }
}

