/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.LinearSolverFactory;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.linsol.lu.LinearSolverLu;
import org.ejml.alg.dense.misc.ImplCommonOps_DenseMatrix64F;
import org.ejml.alg.dense.misc.ImplCommonOps_Matrix64F;
import org.ejml.alg.dense.misc.TransposeAlgs;
import org.ejml.alg.dense.misc.UnrolledDeterminantFromMinor;
import org.ejml.alg.dense.misc.UnrolledInverseFromMinor;
import org.ejml.alg.dense.mult.MatrixMatrixMult;
import org.ejml.alg.dense.mult.MatrixMultProduct;
import org.ejml.alg.dense.mult.MatrixVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.MatrixFeatures;

public class CommonOps {
    public static void mult(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols == 1) {
            MatrixVectorMult.mult(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else if (rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.mult_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.mult_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void mult(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.mult_reorder(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.mult_small(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multTransA(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols == 1) {
            if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult.multTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            } else {
                MatrixVectorMult.multTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            }
        } else if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multTransA(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multTransA_reorder(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multTransA_small(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multTransB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numRows == 1) {
            MatrixVectorMult.mult(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multTransB(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multTransB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        MatrixMatrixMult.multTransB(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
    }

    public static void multTransAB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numRows == 1) {
            if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult.multTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            } else {
                MatrixVectorMult.multTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            }
        } else if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult.multTransAB_aux(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3, null);
        } else {
            MatrixMatrixMult.multTransAB(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multTransAB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult.multTransAB_aux(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3, null);
        } else {
            MatrixMatrixMult.multTransAB(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multInner(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        if (rowD1Matrix64F.numCols != rowD1Matrix64F2.numCols || rowD1Matrix64F.numCols != rowD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("Rows and columns of 'c' must be the same as the columns in 'a'");
        }
        if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_INNER_SWITCH) {
            MatrixMultProduct.inner_small(rowD1Matrix64F, rowD1Matrix64F2);
        } else {
            MatrixMultProduct.inner_reorder(rowD1Matrix64F, rowD1Matrix64F2);
        }
    }

    public static void multOuter(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2) {
        if (rowD1Matrix64F.numRows != rowD1Matrix64F2.numCols || rowD1Matrix64F.numRows != rowD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("Rows and columns of 'c' must be the same as the rows in 'a'");
        }
        MatrixMultProduct.outer(rowD1Matrix64F, rowD1Matrix64F2);
    }

    public static void multAdd(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols == 1) {
            MatrixVectorMult.multAdd(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else if (rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multAdd_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multAdd_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multAdd(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multAdd_reorder(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multAdd_small(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multAddTransA(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numCols == 1) {
            if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult.multAddTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            } else {
                MatrixVectorMult.multAddTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            }
        } else if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multAddTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multAddTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multAddTransA(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH || rowD1Matrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            MatrixMatrixMult.multAddTransA_reorder(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        } else {
            MatrixMatrixMult.multAddTransA_small(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multAddTransB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        MatrixMatrixMult.multAddTransB(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
    }

    public static void multAddTransB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        MatrixMatrixMult.multAddTransB(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
    }

    public static void multAddTransAB(RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F2.numRows == 1) {
            if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
                MatrixVectorMult.multAddTransA_reorder(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            } else {
                MatrixVectorMult.multAddTransA_small(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
            }
        } else if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult.multAddTransAB_aux(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3, null);
        } else {
            MatrixMatrixMult.multAddTransAB(rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static void multAddTransAB(double d, RowD1Matrix64F rowD1Matrix64F, RowD1Matrix64F rowD1Matrix64F2, RowD1Matrix64F rowD1Matrix64F3) {
        if (rowD1Matrix64F.numCols >= EjmlParameters.MULT_TRANAB_COLUMN_SWITCH) {
            MatrixMatrixMult.multAddTransAB_aux(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3, null);
        } else {
            MatrixMatrixMult.multAddTransAB(d, rowD1Matrix64F, rowD1Matrix64F2, rowD1Matrix64F3);
        }
    }

    public static boolean solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.general(denseMatrix64F.numRows, denseMatrix64F.numCols);
        if (!(linearSolver = new LinearSolverSafe<DenseMatrix64F>(linearSolver)).setA(denseMatrix64F)) {
            return false;
        }
        linearSolver.solve(denseMatrix64F2, denseMatrix64F3);
        return true;
    }

    public static void transpose(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numCols == denseMatrix64F.numRows) {
            TransposeAlgs.square(denseMatrix64F);
        } else {
            DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numCols, denseMatrix64F.numRows);
            CommonOps.transpose(denseMatrix64F, denseMatrix64F2);
            denseMatrix64F.setReshape(denseMatrix64F2);
        }
    }

    public static DenseMatrix64F transpose(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2 == null) {
            denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numCols, denseMatrix64F.numRows);
        } else if (denseMatrix64F.numRows != denseMatrix64F2.numCols || denseMatrix64F.numCols != denseMatrix64F2.numRows) {
            throw new IllegalArgumentException("Incompatible matrix dimensions");
        }
        if (denseMatrix64F.numRows > EjmlParameters.TRANSPOSE_SWITCH && denseMatrix64F.numCols > EjmlParameters.TRANSPOSE_SWITCH) {
            TransposeAlgs.block(denseMatrix64F, denseMatrix64F2, EjmlParameters.BLOCK_WIDTH);
        } else {
            TransposeAlgs.standard(denseMatrix64F, denseMatrix64F2);
        }
        return denseMatrix64F2;
    }

    public static double trace(RowD1Matrix64F rowD1Matrix64F) {
        if (rowD1Matrix64F.numRows != rowD1Matrix64F.numCols) {
            throw new IllegalArgumentException("The matrix must be square");
        }
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < rowD1Matrix64F.numRows; ++i) {
            d += rowD1Matrix64F.get(n);
            n += 1 + rowD1Matrix64F.numCols;
        }
        return d;
    }

    public static double det(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2 = denseMatrix64F.getNumCols();
        if (n2 != (n = denseMatrix64F.getNumRows())) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        if (n2 <= 6) {
            if (n2 >= 2) {
                return UnrolledDeterminantFromMinor.det(denseMatrix64F);
            }
            return denseMatrix64F.get(0);
        }
        LUDecompositionAlt lUDecompositionAlt = new LUDecompositionAlt();
        if (!lUDecompositionAlt.decompose(denseMatrix64F)) {
            return 0.0;
        }
        return lUDecompositionAlt.computeDeterminant();
    }

    public static boolean invert(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numCols <= 5) {
            if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
                throw new IllegalArgumentException("Must be a square matrix.");
            }
            if (denseMatrix64F.numCols >= 2) {
                UnrolledInverseFromMinor.inv(denseMatrix64F, denseMatrix64F);
            } else {
                denseMatrix64F.set(0, 1.0 / denseMatrix64F.get(0));
            }
        } else {
            LUDecompositionAlt lUDecompositionAlt = new LUDecompositionAlt();
            LinearSolverLu linearSolverLu = new LinearSolverLu(lUDecompositionAlt);
            if (linearSolverLu.setA(denseMatrix64F)) {
                linearSolverLu.invert(denseMatrix64F);
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean invert(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F.numCols <= 5) {
            if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
                throw new IllegalArgumentException("Must be a square matrix.");
            }
            if (denseMatrix64F2.numCols >= 2) {
                UnrolledInverseFromMinor.inv(denseMatrix64F, denseMatrix64F2);
            } else {
                denseMatrix64F2.set(0, 1.0 / denseMatrix64F.get(0));
            }
        } else {
            LUDecompositionAlt lUDecompositionAlt = new LUDecompositionAlt();
            LinearSolverLu linearSolverLu = new LinearSolverLu(lUDecompositionAlt);
            if (!linearSolverLu.setA(denseMatrix64F)) {
                return false;
            }
            linearSolverLu.invert(denseMatrix64F2);
        }
        return true;
    }

    public static void pinv(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.pseudoInverse(true);
        if (linearSolver.modifiesA()) {
            denseMatrix64F = denseMatrix64F.copy();
        }
        if (!linearSolver.setA(denseMatrix64F)) {
            throw new IllegalArgumentException("Invert failed, maybe a bug?");
        }
        linearSolver.invert(denseMatrix64F2);
    }

    public static DenseMatrix64F[] columnsToVector(DenseMatrix64F denseMatrix64F, DenseMatrix64F[] denseMatrix64FArray) {
        DenseMatrix64F[] denseMatrix64FArray2 = denseMatrix64FArray == null || denseMatrix64FArray.length < denseMatrix64F.numCols ? new DenseMatrix64F[denseMatrix64F.numCols] : denseMatrix64FArray;
        for (int i = 0; i < denseMatrix64FArray2.length; ++i) {
            if (denseMatrix64FArray2[i] == null) {
                denseMatrix64FArray2[i] = new DenseMatrix64F(denseMatrix64F.numRows, 1);
            } else {
                denseMatrix64FArray2[i].reshape(denseMatrix64F.numRows, 1, false);
            }
            DenseMatrix64F denseMatrix64F2 = denseMatrix64FArray2[i];
            for (int j = 0; j < denseMatrix64F.numRows; ++j) {
                denseMatrix64F2.set(j, 0, denseMatrix64F.get(j, i));
            }
        }
        return denseMatrix64FArray2;
    }

    public static DenseMatrix64F[] rowsToVector(DenseMatrix64F denseMatrix64F, DenseMatrix64F[] denseMatrix64FArray) {
        DenseMatrix64F[] denseMatrix64FArray2 = denseMatrix64FArray == null || denseMatrix64FArray.length < denseMatrix64F.numRows ? new DenseMatrix64F[denseMatrix64F.numRows] : denseMatrix64FArray;
        for (int i = 0; i < denseMatrix64FArray2.length; ++i) {
            if (denseMatrix64FArray2[i] == null) {
                denseMatrix64FArray2[i] = new DenseMatrix64F(denseMatrix64F.numCols, 1);
            } else {
                denseMatrix64FArray2[i].reshape(denseMatrix64F.numCols, 1, false);
            }
            DenseMatrix64F denseMatrix64F2 = denseMatrix64FArray2[i];
            for (int j = 0; j < denseMatrix64F.numCols; ++j) {
                denseMatrix64F2.set(j, 0, denseMatrix64F.get(i, j));
            }
        }
        return denseMatrix64FArray2;
    }

    public static void setIdentity(RowD1Matrix64F rowD1Matrix64F) {
        int n;
        int n2 = rowD1Matrix64F.numRows < rowD1Matrix64F.numCols ? rowD1Matrix64F.numRows : rowD1Matrix64F.numCols;
        int n3 = rowD1Matrix64F.getNumElements();
        for (n = 0; n < n3; ++n) {
            rowD1Matrix64F.set(n, 0.0);
        }
        n = 0;
        int n4 = 0;
        while (n4 < n2) {
            rowD1Matrix64F.set(n, 1.0);
            ++n4;
            n += rowD1Matrix64F.numCols + 1;
        }
    }

    public static DenseMatrix64F identity(int n) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n);
        for (int i = 0; i < n; ++i) {
            denseMatrix64F.set(i, i, 1.0);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F identity(int n, int n2) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        int n3 = n < n2 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            denseMatrix64F.set(i, i, 1.0);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F diag(double ... dArray) {
        return CommonOps.diag(null, dArray.length, dArray);
    }

    public static DenseMatrix64F diag(DenseMatrix64F denseMatrix64F, int n, double ... dArray) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(n, n);
        } else {
            if (denseMatrix64F.numRows != n || denseMatrix64F.numCols != n) {
                throw new IllegalArgumentException("Unexpected matrix size");
            }
            CommonOps.set(denseMatrix64F, 0.0);
        }
        for (int i = 0; i < n; ++i) {
            denseMatrix64F.set(i, i, dArray[i]);
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F diagR(int n, int n2, double ... dArray) {
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n, n2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            denseMatrix64F.set(i, i, dArray[i]);
        }
        return denseMatrix64F;
    }

    public static void kron(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, DenseMatrix64F denseMatrix64F3) {
        int n = denseMatrix64F.numCols * denseMatrix64F2.numCols;
        int n2 = denseMatrix64F.numRows * denseMatrix64F2.numRows;
        if (denseMatrix64F3.numCols != n || denseMatrix64F3.numRows != n2) {
            throw new IllegalArgumentException("C does not have the expected dimensions");
        }
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            for (int j = 0; j < denseMatrix64F.numCols; ++j) {
                double d = denseMatrix64F.get(i, j);
                for (int k = 0; k < denseMatrix64F2.numRows; ++k) {
                    for (int i2 = 0; i2 < denseMatrix64F2.numCols; ++i2) {
                        double d2 = d * denseMatrix64F2.get(k, i2);
                        denseMatrix64F3.set(i * denseMatrix64F2.numRows + k, j * denseMatrix64F2.numCols + i2, d2);
                    }
                }
            }
        }
    }

    public static void extract(Matrix64F matrix64F, int n, int n2, int n3, int n4, Matrix64F matrix64F2, int n5, int n6) {
        if (n2 < n || n < 0 || n2 > matrix64F.numRows) {
            throw new IllegalArgumentException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (n4 < n3 || n3 < 0 || n4 > matrix64F.numCols) {
            throw new IllegalArgumentException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int n7 = n4 - n3;
        int n8 = n2 - n;
        if (n5 + n8 > matrix64F2.numRows) {
            throw new IllegalArgumentException("dst is too small in rows");
        }
        if (n6 + n7 > matrix64F2.numCols) {
            throw new IllegalArgumentException("dst is too small in columns");
        }
        if (matrix64F instanceof DenseMatrix64F && matrix64F2 instanceof DenseMatrix64F) {
            ImplCommonOps_DenseMatrix64F.extract((DenseMatrix64F)matrix64F, n, n3, (DenseMatrix64F)matrix64F2, n5, n6, n8, n7);
        } else {
            ImplCommonOps_Matrix64F.extract(matrix64F, n, n3, matrix64F2, n5, n6, n8, n7);
        }
    }

    public static DenseMatrix64F extract(DenseMatrix64F denseMatrix64F, int n, int n2, int n3, int n4) {
        if (n2 <= n || n < 0 || n2 > denseMatrix64F.numRows) {
            throw new IllegalArgumentException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (n4 <= n3 || n3 < 0 || n4 > denseMatrix64F.numCols) {
            throw new IllegalArgumentException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int n5 = n4 - n3;
        int n6 = n2 - n;
        DenseMatrix64F denseMatrix64F2 = new DenseMatrix64F(n6, n5);
        ImplCommonOps_DenseMatrix64F.extract(denseMatrix64F, n, n3, denseMatrix64F2, 0, 0, n6, n5);
        return denseMatrix64F2;
    }

    public static void extractDiag(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n = Math.min(denseMatrix64F.numRows, denseMatrix64F.numCols);
        if (!MatrixFeatures.isVector(denseMatrix64F2)) {
            throw new IllegalArgumentException("Expected a vector for dst.");
        }
        if (denseMatrix64F2.getNumElements() != n) {
            throw new IllegalArgumentException("Expected " + n + " elements in dst.");
        }
        for (int i = 0; i < n; ++i) {
            denseMatrix64F2.set(i, denseMatrix64F.unsafe_get(i, i));
        }
    }

    public static void insert(Matrix64F matrix64F, Matrix64F matrix64F2, int n, int n2) {
        CommonOps.extract(matrix64F, 0, matrix64F.numRows, 0, matrix64F.numCols, matrix64F2, n, n2);
    }

    public static double elementMax(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        double d = d1Matrix64F.get(0);
        for (int i = 1; i < n; ++i) {
            double d2 = d1Matrix64F.get(i);
            if (!(d2 >= d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMaxAbs(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(d1Matrix64F.get(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMin(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        double d = d1Matrix64F.get(0);
        for (int i = 1; i < n; ++i) {
            double d2 = d1Matrix64F.get(i);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMinAbs(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            double d2 = Math.abs(d1Matrix64F.get(i));
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static void elementMult(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatable dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.times(i, d1Matrix64F2.get(i));
        }
    }

    public static void elementMult(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numRows != d1Matrix64F3.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d1Matrix64F.get(i) * d1Matrix64F2.get(i));
        }
    }

    public static void elementDiv(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatable dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.div(i, d1Matrix64F2.get(i));
        }
    }

    public static void elementDiv(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numRows != d1Matrix64F3.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d1Matrix64F.get(i) / d1Matrix64F2.get(i));
        }
    }

    public static double elementSum(D1Matrix64F d1Matrix64F) {
        double d = 0.0;
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d += d1Matrix64F.get(i);
        }
        return d;
    }

    public static double elementSumAbs(D1Matrix64F d1Matrix64F) {
        double d = 0.0;
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d += Math.abs(d1Matrix64F.get(i));
        }
        return d;
    }

    public static DenseMatrix64F sumRows(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2 == null) {
            denseMatrix64F2 = new DenseMatrix64F(denseMatrix64F.numRows, 1);
        } else if (denseMatrix64F2.getNumElements() != denseMatrix64F.numRows) {
            throw new IllegalArgumentException("Output does not have enough elements to store the results");
        }
        for (int i = 0; i < denseMatrix64F.numRows; ++i) {
            double d = 0.0;
            int n = (i + 1) * denseMatrix64F.numCols;
            for (int j = i * denseMatrix64F.numCols; j < n; ++j) {
                d += denseMatrix64F.data[j];
            }
            denseMatrix64F2.set(i, d);
        }
        return denseMatrix64F2;
    }

    public static DenseMatrix64F sumCols(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F2 == null) {
            denseMatrix64F2 = new DenseMatrix64F(1, denseMatrix64F.numCols);
        } else if (denseMatrix64F2.getNumElements() != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Output does not have enough elements to store the results");
        }
        for (int i = 0; i < denseMatrix64F.numCols; ++i) {
            int n;
            double d = 0.0;
            int n2 = n + denseMatrix64F.numCols * denseMatrix64F.numRows;
            for (n = i; n < n2; n += denseMatrix64F.numCols) {
                d += denseMatrix64F.data[n];
            }
            denseMatrix64F2.set(i, d);
        }
        return denseMatrix64F2;
    }

    public static void addEquals(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.plus(i, d1Matrix64F2.get(i));
        }
    }

    public static void addEquals(D1Matrix64F d1Matrix64F, double d, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatible dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.plus(i, d * d1Matrix64F2.get(i));
        }
    }

    public static void add(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols || d1Matrix64F.numRows != d1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d1Matrix64F.get(i) + d1Matrix64F2.get(i));
        }
    }

    public static void add(D1Matrix64F d1Matrix64F, double d, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols || d1Matrix64F.numRows != d1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d1Matrix64F.get(i) + d * d1Matrix64F2.get(i));
        }
    }

    public static void add(double d, D1Matrix64F d1Matrix64F, double d2, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols || d1Matrix64F.numRows != d1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d * d1Matrix64F.get(i) + d2 * d1Matrix64F2.get(i));
        }
    }

    public static void add(double d, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F3.numCols || d1Matrix64F.numRows != d1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d * d1Matrix64F.get(i) + d1Matrix64F2.get(i));
        }
    }

    public static void add(D1Matrix64F d1Matrix64F, double d) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.plus(i, d);
        }
    }

    public static void add(D1Matrix64F d1Matrix64F, double d, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Dimensions of a and c do not match.");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F2.set(i, d1Matrix64F.get(i) + d);
        }
    }

    public static void subEquals(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatable dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.minus(i, d1Matrix64F2.get(i));
        }
    }

    public static void sub(D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2, D1Matrix64F d1Matrix64F3) {
        if (d1Matrix64F.numCols != d1Matrix64F2.numCols || d1Matrix64F.numRows != d1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'a' and 'b' matrices do not have compatable dimensions");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F3.set(i, d1Matrix64F.get(i) - d1Matrix64F2.get(i));
        }
    }

    public static void scale(double d, D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.times(i, d);
        }
    }

    public static void scale(double d, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Matrices must have the same shape");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F2.set(i, d1Matrix64F.get(i) * d);
        }
    }

    public static void divide(double d, D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.div(i, d);
        }
    }

    public static void divide(double d, D1Matrix64F d1Matrix64F, D1Matrix64F d1Matrix64F2) {
        if (d1Matrix64F.numRows != d1Matrix64F2.numRows || d1Matrix64F.numCols != d1Matrix64F2.numCols) {
            throw new IllegalArgumentException("Matrices must have the same shape");
        }
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F2.set(i, d1Matrix64F.get(i) / d);
        }
    }

    public static void changeSign(D1Matrix64F d1Matrix64F) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.set(i, -d1Matrix64F.get(i));
        }
    }

    public static void set(D1Matrix64F d1Matrix64F, double d) {
        int n = d1Matrix64F.getNumElements();
        for (int i = 0; i < n; ++i) {
            d1Matrix64F.set(i, d);
        }
    }
}

