/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.data.MatrixIterator;

public abstract class Matrix64F
implements Serializable {
    private static final long serialVersionUID = 423423451942L;
    public int numRows;
    public int numCols;

    public abstract void reshape(int var1, int var2, boolean var3);

    public void reshape(int n, int n2) {
        this.reshape(n, n2, false);
    }

    public abstract double get(int var1, int var2);

    public abstract double unsafe_get(int var1, int var2);

    public abstract void set(int var1, int var2, double var3);

    public abstract void unsafe_set(int var1, int var2, double var3);

    public MatrixIterator iterator(boolean bl, int n, int n2, int n3, int n4) {
        return new MatrixIterator(this, bl, n, n2, n3, n4);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public abstract int getNumElements();

    public void set(Matrix64F matrix64F) {
        if (matrix64F.numRows != this.numRows) {
            throw new IllegalArgumentException("Unexpected number of rows.");
        }
        if (matrix64F.numCols != this.numCols) {
            throw new IllegalArgumentException("Unexpected number of columns.");
        }
        for (int i = 0; i < matrix64F.numRows; ++i) {
            for (int j = 0; j < matrix64F.numCols; ++j) {
                this.set(i, j, matrix64F.get(i, j));
            }
        }
    }

    public abstract <T extends Matrix64F> T copy();

    public abstract void print();
}

