/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol;

import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner;
import org.ejml.alg.dense.decomposition.lu.LUDecompositionAlt;
import org.ejml.alg.dense.decomposition.qr.QRColPivDecompositionHouseholderColumn;
import org.ejml.alg.dense.linsol.AdjustableLinearSolver;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.chol.LinearSolverChol;
import org.ejml.alg.dense.linsol.chol.LinearSolverCholBlock64;
import org.ejml.alg.dense.linsol.lu.LinearSolverLu;
import org.ejml.alg.dense.linsol.qr.AdjLinearSolverQr;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrBlock64;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrHouseCol;
import org.ejml.alg.dense.linsol.qr.LinearSolverQrpHouseCol;
import org.ejml.alg.dense.linsol.qr.SolvePseudoInverseQrp;
import org.ejml.alg.dense.linsol.svd.SolvePseudoInverseSvd;
import org.ejml.data.DenseMatrix64F;

public class LinearSolverFactory {
    public static LinearSolver<DenseMatrix64F> general(int n, int n2) {
        if (n == n2) {
            return LinearSolverFactory.linear(n);
        }
        return LinearSolverFactory.leastSquares(n, n2);
    }

    public static LinearSolver<DenseMatrix64F> linear(int n) {
        return new LinearSolverLu(new LUDecompositionAlt());
    }

    public static LinearSolver<DenseMatrix64F> leastSquares(int n, int n2) {
        if (n2 < EjmlParameters.SWITCH_BLOCK64_QR) {
            return new LinearSolverQrHouseCol();
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new LinearSolverQrBlock64();
        }
        return new LinearSolverQrHouseCol();
    }

    public static LinearSolver<DenseMatrix64F> symmPosDef(int n) {
        if (n < EjmlParameters.SWITCH_BLOCK64_CHOLESKY) {
            CholeskyDecompositionInner choleskyDecompositionInner = new CholeskyDecompositionInner(true);
            return new LinearSolverChol(choleskyDecompositionInner);
        }
        if (EjmlParameters.MEMORY == EjmlParameters.MemoryUsage.FASTER) {
            return new LinearSolverCholBlock64();
        }
        CholeskyDecompositionInner choleskyDecompositionInner = new CholeskyDecompositionInner(true);
        return new LinearSolverChol(choleskyDecompositionInner);
    }

    public static LinearSolver<DenseMatrix64F> leastSquaresQrPivot(boolean bl, boolean bl2) {
        QRColPivDecompositionHouseholderColumn qRColPivDecompositionHouseholderColumn = new QRColPivDecompositionHouseholderColumn();
        if (bl2) {
            return new SolvePseudoInverseQrp(qRColPivDecompositionHouseholderColumn, bl);
        }
        return new LinearSolverQrpHouseCol(qRColPivDecompositionHouseholderColumn, bl);
    }

    public static LinearSolver<DenseMatrix64F> pseudoInverse(boolean bl) {
        if (bl) {
            return new SolvePseudoInverseSvd();
        }
        return LinearSolverFactory.leastSquaresQrPivot(true, false);
    }

    public static AdjustableLinearSolver adjustable() {
        return new AdjLinearSolverQr();
    }
}

