/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.QRPDecomposition;
import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QRColPivDecompositionHouseholderColumn
extends QRDecompositionHouseholderColumn
implements QRPDecomposition<DenseMatrix64F> {
    protected int[] pivots;
    protected double[] normsCol;
    protected double maxAbs;
    protected double singularThreshold;
    protected int rank;

    public QRColPivDecompositionHouseholderColumn(double d) {
        this.singularThreshold = d;
    }

    public QRColPivDecompositionHouseholderColumn() {
        this(UtilEjml.EPS);
    }

    @Override
    public void setExpectedMaxSize(int n, int n2) {
        super.setExpectedMaxSize(n, n2);
        if (this.pivots == null || this.pivots.length < n2) {
            this.pivots = new int[n2];
            this.normsCol = new double[n2];
        }
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            if (denseMatrix64F == null) {
                denseMatrix64F = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(denseMatrix64F);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = CommonOps.identity(this.numRows);
        } else {
            if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (int i = this.rank - 1; i >= 0; --i) {
            double[] dArray = this.dataQR[i];
            double d = dArray[i];
            dArray[i] = 1.0;
            QrHelperFunctions.rank1UpdateMultR(denseMatrix64F, dArray, this.gammas[i], i, i, this.numRows, this.v);
            dArray[i] = d;
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        this.convertToColumnMajor(denseMatrix64F);
        this.maxAbs = CommonOps.elementMaxAbs(denseMatrix64F);
        this.setupPivotInfo();
        for (int i = 0; i < this.minLength; ++i) {
            if (i > 0) {
                this.updateNorms(i);
            }
            this.swapColumns(i);
            if (!this.householderPivot(i)) break;
            this.updateA(i);
            this.rank = i + 1;
        }
        return true;
    }

    private void setupPivotInfo() {
        for (int i = 0; i < this.numCols; ++i) {
            this.pivots[i] = i;
            double[] dArray = this.dataQR[i];
            double d = 0.0;
            for (int j = 0; j < this.numRows; ++j) {
                double d2 = dArray[j];
                d += d2 * d2;
            }
            this.normsCol[i] = d;
        }
    }

    private void updateNorms(int n) {
        int n2;
        boolean bl = false;
        for (n2 = n; n2 < this.numCols; ++n2) {
            double d = this.dataQR[n2][n - 1];
            int n3 = n2;
            this.normsCol[n3] = this.normsCol[n3] - d * d;
            if (!(this.normsCol[n2] < 0.0)) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (n2 = n; n2 < this.numCols; ++n2) {
                double[] dArray = this.dataQR[n2];
                double d = 0.0;
                for (int i = n; i < this.numRows; ++i) {
                    double d2 = dArray[i];
                    d += d2 * d2;
                }
                this.normsCol[n2] = d;
            }
        }
    }

    private void swapColumns(int n) {
        double d;
        int n2 = n;
        double d2 = this.normsCol[n];
        for (int i = n + 1; i < this.numCols; ++i) {
            d = this.normsCol[i];
            if (!(d > d2)) continue;
            d2 = d;
            n2 = i;
        }
        double[] dArray = this.dataQR[n];
        this.dataQR[n] = this.dataQR[n2];
        this.dataQR[n2] = dArray;
        d = this.normsCol[n];
        this.normsCol[n] = this.normsCol[n2];
        this.normsCol[n2] = d;
        int n3 = this.pivots[n];
        this.pivots[n] = this.pivots[n2];
        this.pivots[n2] = n3;
    }

    protected boolean householderPivot(int n) {
        double[] dArray = this.dataQR[n];
        double d = QrHelperFunctions.findMax(dArray, n, this.numRows - n);
        if (d <= 0.0) {
            return false;
        }
        this.tau = QrHelperFunctions.computeTauAndDivide(n, this.numRows, dArray, d);
        double d2 = dArray[n] + this.tau;
        QrHelperFunctions.divideElements(n + 1, this.numRows, dArray, d2);
        this.gamma = d2 / this.tau;
        this.tau *= d;
        dArray[n] = -this.tau;
        if (Math.abs(this.tau) <= this.singularThreshold * this.maxAbs) {
            return false;
        }
        this.gammas[n] = this.gamma;
        return true;
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public int[] getPivots() {
        return this.pivots;
    }

    @Override
    public DenseMatrix64F getPivotMatrix(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.numCols, this.numCols);
        } else {
            if (denseMatrix64F.numRows != this.numCols) {
                throw new IllegalArgumentException("Number of rows must be " + this.numCols);
            }
            if (denseMatrix64F.numCols != this.numCols) {
                throw new IllegalArgumentException("Number of columns must be " + this.numCols);
            }
            denseMatrix64F.zero();
        }
        for (int i = 0; i < this.numCols; ++i) {
            denseMatrix64F.set(this.pivots[i], i, 1.0);
        }
        return denseMatrix64F;
    }
}

