/*
 * Decompiled with CFR 0.152.
 */
package org.ejml;

import java.util.Arrays;
import java.util.Comparator;
import org.ejml.data.DenseMatrix64F;

public class UtilEjml {
    public static String VERSION = "0.19";
    public static double TOLERANCE = 1.0E-8;
    public static double EPS = Math.pow(2.0, -52.0);

    public static boolean isUncountable(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public static void memset(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
    }

    public static void memset(double[] dArray, double d, int n) {
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
    }

    public static void memset(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static <T> void setnull(T[] TArray) {
        for (int i = 0; i < TArray.length; ++i) {
            TArray[i] = null;
        }
    }

    public static double max(double[] dArray, int n, int n2) {
        double d = dArray[n];
        int n3 = n + n2;
        for (int i = n + 1; i < n3; ++i) {
            double d2 = dArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static DenseMatrix64F parseMatrix(String string, int n) {
        String[] stringArray = string.split("(\\s)+");
        int n2 = stringArray[0].isEmpty() ? 1 : 0;
        int n3 = (stringArray.length - n2) / n;
        DenseMatrix64F denseMatrix64F = new DenseMatrix64F(n3, n);
        int n4 = n2;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix64F.set(i, j, Double.parseDouble(stringArray[n4++]));
            }
        }
        return denseMatrix64F;
    }

    public static Integer[] sortByIndex(final double[] dArray, int n) {
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = i;
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return Double.compare(dArray[n], dArray[n2]);
            }
        });
        return integerArray;
    }
}

