/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Interval;

public class FuzzyInterval<E extends FuzzyComparable<E>>
extends Interval<E> {
    private static final long serialVersionUID = 1L;

    private FuzzyInterval(E a, E b, int flags) {
        super(a, b, flags);
    }

    public static <E extends FuzzyComparable<E>> FuzzyInterval<E> toInterval(E a, E b) {
        return FuzzyInterval.toInterval(a, b, 0);
    }

    public static <E extends FuzzyComparable<E>> FuzzyInterval<E> toInterval(E a, E b, int flags) {
        int comp = a.compareTo(b);
        if (comp <= 0) {
            return new FuzzyInterval<E>(a, b, flags);
        }
        return null;
    }

    public static <E extends FuzzyComparable<E>> FuzzyInterval<E> toValidInterval(E a, E b) {
        return FuzzyInterval.toValidInterval(a, b, 0);
    }

    public static <E extends FuzzyComparable<E>> FuzzyInterval<E> toValidInterval(E a, E b, int flags) {
        int comp = a.compareTo(b);
        if (comp <= 0) {
            return new FuzzyInterval<E>(a, b, flags);
        }
        return new FuzzyInterval<E>(b, a, flags);
    }

    @Override
    public int getRelationFlags(Interval<E> other) {
        if (other == null) {
            return 0;
        }
        int flags = 0;
        boolean hasUnknown = false;
        if (((FuzzyComparable)this.first).isComparable(other.first())) {
            int comp11 = ((FuzzyComparable)this.first).compareTo(other.first());
            flags |= this.toRelFlags(comp11, 0);
        } else {
            flags |= 7;
            hasUnknown = true;
        }
        if (((FuzzyComparable)this.second).isComparable(other.second())) {
            int comp22 = ((FuzzyComparable)this.second).compareTo(other.second());
            flags |= this.toRelFlags(comp22, 12);
        } else {
            flags |= 0x7000;
            hasUnknown = true;
        }
        if (((FuzzyComparable)this.first).isComparable(other.second())) {
            int comp12 = ((FuzzyComparable)this.first).compareTo(other.second());
            flags |= this.toRelFlags(comp12, 4);
        } else {
            flags |= 0x70;
            hasUnknown = true;
        }
        if (((FuzzyComparable)this.second).isComparable(other.first())) {
            int comp21 = ((FuzzyComparable)this.second).compareTo(other.first());
            flags |= this.toRelFlags(comp21, 8);
        } else {
            flags |= 0x700;
            hasUnknown = true;
        }
        if (hasUnknown) {
            flags = this.restrictFlags(flags);
        }
        flags = this.addIntervalRelationFlags(flags, hasUnknown);
        return flags;
    }

    private int restrictFlags(int flags) {
        int f11 = FuzzyInterval.extractRelationSubflags(flags, 0);
        int f22 = FuzzyInterval.extractRelationSubflags(flags, 12);
        int f12 = FuzzyInterval.extractRelationSubflags(flags, 4);
        int f21 = FuzzyInterval.extractRelationSubflags(flags, 8);
        if (f12 == 4) {
            f11 &= 4;
            f21 &= 4;
            f22 &= 4;
        } else if ((f12 & 2) == 0) {
            f11 &= 5;
            f21 &= 5;
            f22 &= 5;
        }
        if (f11 == 4) {
            f21 &= 4;
        } else if (f11 == 2) {
            f12 &= 2;
        } else if ((f11 & 2) == 0) {
            f21 &= 5;
        } else if ((f11 & 4) == 0) {
            f12 &= 3;
        }
        if (f21 == 2) {
            f11 &= 2;
            f12 &= 2;
            f22 &= 2;
        } else if ((f12 & 4) == 0) {
            f11 &= 2;
            f12 &= 2;
            f22 &= 2;
        }
        if (f22 == 4) {
            f21 &= 4;
        } else if (f22 == 2) {
            f12 &= 2;
        } else if ((f22 & 2) == 0) {
            f21 &= 5;
        } else if ((f22 & 4) == 0) {
            f12 &= 3;
        }
        return f11 << 0 & f12 << 4 & f21 << 8 & f22 << 12;
    }

    @Override
    public Interval.RelType getRelation(Interval<E> other) {
        if (other == null) {
            return Interval.RelType.NONE;
        }
        int flags = this.getRelationFlags(other);
        if ((flags & Integer.MIN_VALUE) != 0) {
            return Interval.RelType.UNKNOWN;
        }
        if ((flags & 0x770000) != 0) {
            return Interval.RelType.BEFORE;
        }
        if ((flags & 0x20000) != 0) {
            return Interval.RelType.AFTER;
        }
        if ((flags & 0x40000) != 0) {
            return Interval.RelType.EQUAL;
        }
        if ((flags & 0x200000) != 0) {
            return Interval.RelType.INSIDE;
        }
        if ((flags & 0x400000) != 0) {
            return Interval.RelType.CONTAIN;
        }
        if ((flags & 0x100000) != 0) {
            return Interval.RelType.OVERLAP;
        }
        return Interval.RelType.UNKNOWN;
    }

    public static interface FuzzyComparable<T>
    extends Comparable<T> {
        public boolean isComparable(T var1);
    }
}

