/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WordsToSentencesAnnotator
implements Annotator {
    private final WordToSentenceProcessor<CoreLabel> wts;
    private final boolean VERBOSE;
    private boolean countLineNumbers = false;

    public WordsToSentencesAnnotator() {
        this(false);
    }

    public WordsToSentencesAnnotator(boolean verbose) {
        this(new WordToSentenceProcessor<CoreLabel>(), verbose);
    }

    public WordsToSentencesAnnotator(boolean verbose, String boundaryTokenRegex) {
        this(new WordToSentenceProcessor<CoreLabel>(boundaryTokenRegex), verbose);
    }

    private WordsToSentencesAnnotator(WordToSentenceProcessor<CoreLabel> wts, boolean verbose) {
        this.VERBOSE = verbose;
        this.wts = wts;
    }

    public static WordsToSentencesAnnotator newlineSplitter(boolean verbose, String ... nlToken) {
        WordToSentenceProcessor<CoreLabel> wts;
        if (nlToken.length == 0) {
            wts = new WordToSentenceProcessor<CoreLabel>("", Collections.<String>emptySet(), Collections.<String>emptySet());
        } else if (nlToken.length == 1) {
            wts = new WordToSentenceProcessor("", Collections.<String>emptySet(), Collections.singleton(nlToken[0]));
        } else {
            Set<String> nlTokens = Generics.newHashSet(Arrays.asList(nlToken));
            wts = new WordToSentenceProcessor("", Collections.<String>emptySet(), nlTokens);
        }
        return new WordsToSentencesAnnotator(wts, verbose);
    }

    public void setSentenceBoundaryToDiscard(Set<String> boundaries) {
        this.wts.setSentenceBoundaryToDiscard(boundaries);
    }

    public void addHtmlSentenceBoundaryToDiscard(Set<String> boundaries) {
        this.wts.addHtmlSentenceBoundaryToDiscard(boundaries);
    }

    public void setOneSentence(boolean isOneSentence) {
        this.wts.setOneSentence(isOneSentence);
    }

    public void setCountLineNumbers(boolean countLineNumbers) {
        this.countLineNumbers = countLineNumbers;
        this.wts.setAllowEmptySentences(countLineNumbers);
    }

    @Override
    public void annotate(Annotation annotation) {
        ArrayList<Annotation> sentences;
        if (this.VERBOSE) {
            System.err.print("Sentence splitting ...");
        }
        if (annotation.has(CoreAnnotations.TokensAnnotation.class)) {
            String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int tokenOffset = 0;
            int lineNumber = 0;
            sentences = new ArrayList<Annotation>();
            for (List<CoreLabel> sentenceTokens : this.wts.process(tokens)) {
                if (this.countLineNumbers) {
                    ++lineNumber;
                }
                if (sentenceTokens.isEmpty()) {
                    if (this.countLineNumbers) continue;
                    throw new RuntimeException("unexpected empty sentence: " + sentenceTokens);
                }
                int begin = (Integer)sentenceTokens.get(0).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int last = sentenceTokens.size() - 1;
                int end = (Integer)sentenceTokens.get(last).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                String sentenceText = text.substring(begin, end);
                Annotation sentence = new Annotation(sentenceText);
                sentence.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
                sentence.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
                sentence.set(CoreAnnotations.TokensAnnotation.class, sentenceTokens);
                sentence.set(CoreAnnotations.TokenBeginAnnotation.class, tokenOffset);
                sentence.set(CoreAnnotations.TokenEndAnnotation.class, tokenOffset += sentenceTokens.size());
                sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, sentences.size());
                if (this.countLineNumbers) {
                    sentence.set(CoreAnnotations.LineNumberAnnotation.class, lineNumber);
                }
                sentences.add(sentence);
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.singleton(TOKENIZE_REQUIREMENT);
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(SSPLIT_REQUIREMENT);
    }
}

