/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.PTBTokenizerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class AnnotationPipeline
implements Annotator {
    protected static final boolean TIME = true;
    private final List<Annotator> annotators;
    private List<MutableInteger> accumulatedTime;

    public AnnotationPipeline(List<Annotator> annotators) {
        this.annotators = annotators;
        int num = annotators.size();
        this.accumulatedTime = new ArrayList<MutableInteger>(num);
        for (int i = 0; i < num; ++i) {
            this.accumulatedTime.add(new MutableInteger());
        }
    }

    public AnnotationPipeline() {
        this(new ArrayList<Annotator>());
    }

    public void addAnnotator(Annotator annotator) {
        this.annotators.add(annotator);
        this.accumulatedTime.add(new MutableInteger());
    }

    @Override
    public void annotate(Annotation annotation) {
        Iterator<MutableInteger> it = this.accumulatedTime.iterator();
        Timing t = new Timing();
        for (Annotator annotator : this.annotators) {
            t.start();
            annotator.annotate(annotation);
            int elapsed = (int)t.stop();
            MutableInteger m = it.next();
            m.incValue(elapsed);
        }
    }

    public void annotate(Iterable<Annotation> annotations) {
        this.annotate(annotations, Runtime.getRuntime().availableProcessors());
    }

    public void annotate(Iterable<Annotation> annotations, Function<Annotation, Object> callback) {
        this.annotate(annotations, Runtime.getRuntime().availableProcessors(), callback);
    }

    public void annotate(Iterable<Annotation> annotations, int numThreads) {
        this.annotate(annotations, numThreads, new Function<Annotation, Object>(){

            @Override
            public Object apply(Annotation in) {
                return null;
            }
        });
    }

    public void annotate(final Iterable<Annotation> annotations, int numThreads, final Function<Annotation, Object> callback) {
        if (numThreads == 1) {
            for (Annotation ann : annotations) {
                this.annotate(ann);
                callback.apply(ann);
            }
        }
        Iterable<Runnable> threads = new Iterable<Runnable>(){

            @Override
            public Iterator<Runnable> iterator() {
                final Iterator iter = annotations.iterator();
                return new Iterator<Runnable>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Runnable next() {
                        if (!iter.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        final Annotation input = (Annotation)iter.next();
                        return new Runnable(){

                            @Override
                            public void run() {
                                String beginningOfDocument = input.toString().substring(0, Math.min(50, input.toString().length()));
                                Redwood.startTrack("Annotating \"" + beginningOfDocument + "...\"");
                                AnnotationPipeline.this.annotate(input);
                                callback.apply(input);
                                Redwood.endTrack("Annotating \"" + beginningOfDocument + "...\"");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iter.remove();
                    }
                };
            }
        };
        Redwood.Util.threadAndRun(this.getClass().getSimpleName(), threads, numThreads);
    }

    protected long getTotalTime() {
        long total = 0L;
        for (MutableInteger m : this.accumulatedTime) {
            total += m.longValue();
        }
        return total;
    }

    public String timingInformation() {
        StringBuilder sb = new StringBuilder();
        sb.append("Annotation pipeline timing information:\n");
        Iterator<MutableInteger> it = this.accumulatedTime.iterator();
        long total = 0L;
        for (Annotator annotator : this.annotators) {
            MutableInteger m = it.next();
            sb.append(StringUtils.getShortClassName(annotator)).append(": ");
            sb.append(Timing.toSecondsString(m.longValue())).append(" sec.\n");
            total += m.longValue();
        }
        sb.append("TOTAL: ").append(Timing.toSecondsString(total)).append(" sec.");
        return sb.toString();
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        Set<Annotator.Requirement> satisfied = Generics.newHashSet();
        for (Annotator annotator : this.annotators) {
            satisfied.addAll(annotator.requirementsSatisfied());
        }
        return satisfied;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        if (this.annotators.isEmpty()) {
            return Collections.emptySet();
        }
        return this.annotators.get(0).requires();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Timing tim = new Timing();
        AnnotationPipeline ap = new AnnotationPipeline();
        boolean verbose = false;
        ap.addAnnotator(new PTBTokenizerAnnotator(verbose));
        ap.addAnnotator(new WordsToSentencesAnnotator(verbose));
        ap.addAnnotator(new ParserAnnotator(verbose, -1));
        String text = "USAir said in the filings that Mr. Icahn first contacted Mr. Colodny last September to discuss the benefits of combining TWA and USAir -- either by TWA's acquisition of USAir, or USAir's acquisition of TWA.";
        Annotation a = new Annotation(text);
        ap.annotate(a);
        System.out.println(a.get(CoreAnnotations.TokensAnnotation.class));
        for (CoreMap sentence : (List)a.get(CoreAnnotations.SentencesAnnotation.class)) {
            System.out.println(sentence.get(TreeCoreAnnotations.TreeAnnotation.class));
        }
        System.out.println(ap.timingInformation());
        System.err.println("Total time for AnnotationPipeline: " + tim.toSecondsString() + " sec.");
    }
}

