/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.CacheMap;
import edu.stanford.nlp.util.Comparators;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interner;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.IntervalTree;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class PhraseTable
implements Serializable {
    private static final String PHRASE_END = "";
    private static final long serialVersionUID = 1L;
    Map<String, Object> rootTree;
    public boolean normalize = true;
    public boolean caseInsensitive = false;
    public boolean ignorePunctuation = false;
    public boolean ignorePunctuationTokens = true;
    public Annotator tokenizer;
    int nPhrases = 0;
    int nStrings = 0;
    transient CacheMap<String, String> normalizedCache = new CacheMap(5000);
    private static final Pattern tabPattern = Pattern.compile("\t");
    private int MAX_LIST_SIZE = 20;
    private static final Pattern punctWhitespacePattern = Pattern.compile("\\s*(\\p{Punct})\\s*");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");
    private static final Pattern delimPattern = Pattern.compile("[\\s_-]+");
    private static final Pattern possPattern = Pattern.compile("'s(\\s+|$)");
    public static final Comparator<PhraseMatch> PHRASEMATCH_LENGTH_ENDPOINTS_COMPARATOR = Comparators.chain(HasInterval.LENGTH_COMPARATOR, HasInterval.ENDPOINTS_COMPARATOR);

    public PhraseTable() {
    }

    public PhraseTable(int initSize) {
        this.rootTree = new HashMap<String, Object>(initSize);
    }

    public PhraseTable(boolean normalize, boolean caseInsensitive, boolean ignorePunctuation) {
        this.normalize = normalize;
        this.caseInsensitive = caseInsensitive;
        this.ignorePunctuation = ignorePunctuation;
    }

    public void clear() {
        this.rootTree = null;
        this.nPhrases = 0;
        this.nStrings = 0;
    }

    public void setNormalizationCacheSize(int cacheSize) {
        CacheMap<String, String> newNormalizedCache = new CacheMap<String, String>(cacheSize);
        newNormalizedCache.putAll(this.normalizedCache);
        this.normalizedCache = newNormalizedCache;
    }

    public void readPhrases(String filename, boolean checkTag) throws IOException {
        this.readPhrases(filename, checkTag, tabPattern);
    }

    public void readPhrases(String filename, boolean checkTag, String delimiterRegex) throws IOException {
        this.readPhrases(filename, checkTag, Pattern.compile(delimiterRegex));
    }

    public void readPhrases(String filename, boolean checkTag, Pattern delimiterPattern) throws IOException {
        String line;
        Timing timer = new Timing();
        timer.doing("Reading phrases: " + filename);
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        while ((line = br.readLine()) != null) {
            if (checkTag) {
                String[] columns = delimiterPattern.split(line, 2);
                if (columns.length == 1) {
                    this.addPhrase(columns[0]);
                    continue;
                }
                this.addPhrase(columns[0], columns[1]);
                continue;
            }
            this.addPhrase(line);
        }
        br.close();
        timer.done();
    }

    public void readPhrases(String filename, int phraseColIndex, int tagColIndex) throws IOException {
        String line;
        if (phraseColIndex < 0) {
            throw new IllegalArgumentException("Invalid phraseColIndex " + phraseColIndex);
        }
        Timing timer = new Timing();
        timer.doing("Reading phrases: " + filename);
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        while ((line = br.readLine()) != null) {
            String[] columns = tabPattern.split(line);
            String phrase = columns[phraseColIndex];
            String tag = tagColIndex >= 0 ? columns[tagColIndex] : null;
            this.addPhrase(phrase, tag);
        }
        br.close();
        timer.done();
    }

    public static Phrase getLongestPhrase(List<Phrase> phrases) {
        Phrase longest = null;
        for (Phrase phrase : phrases) {
            if (longest != null && !phrase.isLonger(longest)) continue;
            longest = phrase;
        }
        return longest;
    }

    public String[] splitText(String phraseText) {
        String[] words;
        if (this.tokenizer != null) {
            Annotation annotation = new Annotation(phraseText);
            this.tokenizer.annotate(annotation);
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            words = new String[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                words[i] = ((CoreLabel)tokens.get(i)).word();
            }
        } else {
            phraseText = possPattern.matcher(phraseText).replaceAll(" 's$1");
            words = delimPattern.split(phraseText);
        }
        return words;
    }

    public WordList toWordList(String phraseText) {
        String[] words = this.splitText(phraseText);
        return new StringList(words);
    }

    public WordList toNormalizedWordList(String phraseText) {
        String[] words = this.splitText(phraseText);
        ArrayList<String> list = new ArrayList<String>(words.length);
        for (String word : words) {
            if ((word = this.getNormalizedForm(word)).length() <= 0) continue;
            list.add(word);
        }
        return new StringList(list);
    }

    public void addPhrases(Collection<String> phraseTexts) {
        for (String phraseText : phraseTexts) {
            this.addPhrase(phraseText, null);
        }
    }

    public void addPhrases(Map<String, String> taggedPhraseTexts) {
        for (String phraseText : taggedPhraseTexts.keySet()) {
            this.addPhrase(phraseText, taggedPhraseTexts.get(phraseText));
        }
    }

    public boolean addPhrase(String phraseText) {
        return this.addPhrase(phraseText, null);
    }

    public boolean addPhrase(String phraseText, String tag) {
        return this.addPhrase(phraseText, tag, null);
    }

    public boolean addPhrase(String phraseText, String tag, Object phraseData) {
        WordList wordList = this.toNormalizedWordList(phraseText);
        return this.addPhrase(phraseText, tag, wordList, phraseData);
    }

    public boolean addPhrase(List<String> tokens) {
        return this.addPhrase(tokens, null);
    }

    public boolean addPhrase(List<String> tokens, String tag) {
        return this.addPhrase(tokens, tag, null);
    }

    public boolean addPhrase(List<String> tokens, String tag, Object phraseData) {
        StringList wordList = new StringList(tokens);
        return this.addPhrase(StringUtils.join(tokens, " "), tag, wordList, phraseData);
    }

    private synchronized boolean addPhrase(String phraseText, String tag, WordList wordList, Object phraseData) {
        if (this.rootTree == null) {
            this.rootTree = new HashMap<String, Object>();
        }
        return this.addPhrase(this.rootTree, phraseText, tag, wordList, phraseData, 0);
    }

    private synchronized void addPhrase(Map<String, Object> tree, Phrase phrase, int wordIndex) {
        String word = phrase.wordList.size() <= wordIndex ? PHRASE_END : phrase.wordList.getWord(wordIndex);
        Object node = tree.get(word);
        if (node == null) {
            tree.put(word, phrase);
        } else if (node instanceof Phrase) {
            ArrayList<Object> list = new ArrayList<Object>(2);
            list.add(phrase);
            list.add(node);
            tree.put(word, list);
        } else if (node instanceof Map) {
            this.addPhrase((Map)node, phrase, wordIndex + 1);
        } else if (node instanceof List) {
            ((List)node).add(phrase);
        } else {
            throw new RuntimeException("Unexpected class " + node.getClass() + " while adding word " + wordIndex + "(" + word + ") in phrase " + phrase.getText());
        }
    }

    private synchronized boolean addPhrase(Map<String, Object> tree, String phraseText, String tag, WordList wordList, Object phraseData, int wordIndex) {
        boolean phraseAdded = false;
        boolean newPhraseAdded = false;
        boolean oldPhraseNewFormAdded = false;
        for (int i = wordIndex; i < wordList.size(); ++i) {
            Phrase newphrase;
            String word = Interner.globalIntern(wordList.getWord(i));
            Object node = tree.get(word);
            if (node == null) {
                Phrase phrase = new Phrase(wordList, phraseText, tag, phraseData);
                tree.put(word, phrase);
                phraseAdded = true;
                newPhraseAdded = true;
            } else if (node instanceof Phrase) {
                Phrase oldphrase = (Phrase)node;
                int matchedTokenEnd = this.checkWordListMatch(oldphrase, wordList, 0, wordList.size(), i + 1, true);
                if (matchedTokenEnd >= 0) {
                    oldPhraseNewFormAdded = oldphrase.addForm(phraseText);
                } else {
                    newphrase = new Phrase(wordList, phraseText, tag, phraseData);
                    ArrayList<Phrase> list = new ArrayList<Phrase>(2);
                    list.add(oldphrase);
                    list.add(newphrase);
                    tree.put(word, list);
                    newPhraseAdded = true;
                }
                phraseAdded = true;
            } else if (node instanceof Map) {
                tree = (Map)node;
            } else if (node instanceof List) {
                List lookupList = (List)node;
                int nMaps = 0;
                for (Object obj : lookupList) {
                    if (obj instanceof Phrase) {
                        Phrase oldphrase = (Phrase)obj;
                        int matchedTokenEnd = this.checkWordListMatch(oldphrase, wordList, 0, wordList.size(), i, true);
                        if (matchedTokenEnd < 0) continue;
                        oldPhraseNewFormAdded = oldphrase.addForm(phraseText);
                        phraseAdded = true;
                        break;
                    }
                    if (obj instanceof Map) {
                        if (nMaps == 1) {
                            throw new RuntimeException("More than one map in list while adding word " + i + "(" + word + ") in phrase " + phraseText);
                        }
                        tree = (Map)obj;
                        ++nMaps;
                        continue;
                    }
                    throw new RuntimeException("Unexpected class in list " + obj.getClass() + " while adding word " + i + "(" + word + ") in phrase " + phraseText);
                }
                if (!phraseAdded && nMaps == 0) {
                    newphrase = new Phrase(wordList, phraseText, tag, phraseData);
                    lookupList.add(newphrase);
                    newPhraseAdded = true;
                    phraseAdded = true;
                    if (lookupList.size() > this.MAX_LIST_SIZE) {
                        HashMap<String, Object> newMap = new HashMap<String, Object>(lookupList.size());
                        for (Object obj : lookupList) {
                            if (obj instanceof Phrase) {
                                Phrase oldphrase = (Phrase)obj;
                                this.addPhrase(newMap, oldphrase, i + 1);
                                continue;
                            }
                            throw new RuntimeException("Unexpected class in list " + obj.getClass() + " while converting list to map");
                        }
                        tree.put(word, newMap);
                    }
                }
            } else {
                throw new RuntimeException("Unexpected class in list " + node.getClass() + " while adding word " + i + "(" + word + ") in phrase " + phraseText);
            }
            if (phraseAdded) break;
        }
        if (!phraseAdded) {
            if (wordList.size() == 0) {
                System.err.println("WARNING: " + phraseText + " not added");
            } else {
                Phrase oldphrase = (Phrase)tree.get(PHRASE_END);
                if (oldphrase != null) {
                    int matchedTokenEnd = this.checkWordListMatch(oldphrase, wordList, 0, wordList.size(), wordList.size(), true);
                    if (matchedTokenEnd >= 0) {
                        oldPhraseNewFormAdded = oldphrase.addForm(phraseText);
                    } else {
                        Phrase newphrase = new Phrase(wordList, phraseText, tag, phraseData);
                        ArrayList<Phrase> list = new ArrayList<Phrase>(2);
                        list.add(oldphrase);
                        list.add(newphrase);
                        tree.put(PHRASE_END, list);
                        newPhraseAdded = true;
                    }
                } else {
                    Phrase newphrase = new Phrase(wordList, phraseText, tag, phraseData);
                    tree.put(PHRASE_END, newphrase);
                    newPhraseAdded = true;
                }
            }
        }
        if (newPhraseAdded) {
            ++this.nPhrases;
            ++this.nStrings;
        } else {
            ++this.nStrings;
        }
        return newPhraseAdded || oldPhraseNewFormAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNormalizedForm(String word) {
        String normalized = this.normalizedCache.get(word);
        if (normalized == null) {
            normalized = this.createNormalizedForm(word);
            PhraseTable phraseTable = this;
            synchronized (phraseTable) {
                this.normalizedCache.put(word, normalized);
            }
        }
        return normalized;
    }

    private String createNormalizedForm(String word) {
        if (this.normalize) {
            word = Normalizer.normalize(word, Normalizer.Form.NFKD);
        }
        if (this.caseInsensitive) {
            word = word.toLowerCase();
        }
        if (this.ignorePunctuation) {
            word = punctWhitespacePattern.matcher(word).replaceAll(PHRASE_END);
        } else if (this.ignorePunctuationTokens && punctWhitespacePattern.matcher(word).matches()) {
            word = PHRASE_END;
        }
        word = whitespacePattern.matcher(word).replaceAll(PHRASE_END);
        return word;
    }

    public Phrase lookup(String phrase) {
        return this.lookup(this.toWordList(phrase));
    }

    public Phrase lookupNormalized(String phrase) {
        return this.lookup(this.toNormalizedWordList(phrase));
    }

    public Phrase lookup(WordList wordList) {
        if (wordList == null || this.rootTree == null) {
            return null;
        }
        Map tree = this.rootTree;
        for (int i = 0; i < wordList.size(); ++i) {
            String word = wordList.getWord(i);
            Object node = tree.get(word);
            if (node == null) {
                return null;
            }
            if (node instanceof Phrase) {
                Phrase phrase = (Phrase)node;
                int matchedTokenEnd = this.checkWordListMatch(phrase, wordList, 0, wordList.size(), i, true);
                if (matchedTokenEnd < 0) continue;
                return phrase;
            }
            if (node instanceof Map) {
                tree = (Map)node;
                continue;
            }
            if (node instanceof List) {
                List lookupList = (List)node;
                int nMaps = 0;
                for (Object obj : lookupList) {
                    if (obj instanceof Phrase) {
                        Phrase phrase = (Phrase)obj;
                        int matchedTokenEnd = this.checkWordListMatch(phrase, wordList, 0, wordList.size(), i, true);
                        if (matchedTokenEnd < 0) continue;
                        return phrase;
                    }
                    if (obj instanceof Map) {
                        if (nMaps == 1) {
                            throw new RuntimeException("More than one map in list while looking up word " + i + "(" + word + ") in phrase " + wordList.toString());
                        }
                        tree = (Map)obj;
                        ++nMaps;
                        continue;
                    }
                    throw new RuntimeException("Unexpected class in list " + obj.getClass() + " while looking up word " + i + "(" + word + ") in phrase " + wordList.toString());
                }
                if (nMaps != 0) continue;
                return null;
            }
            throw new RuntimeException("Unexpected class in list " + node.getClass() + " while looking up word " + i + "(" + word + ") in phrase " + wordList.toString());
        }
        Phrase phrase = (Phrase)tree.get(PHRASE_END);
        if (phrase != null) {
            int matchedTokenEnd = this.checkWordListMatch(phrase, wordList, 0, wordList.size(), wordList.size(), true);
            return matchedTokenEnd >= 0 ? phrase : null;
        }
        return null;
    }

    public List<PhraseMatch> findAllMatches(String text) {
        WordList tokens = this.toNormalizedWordList(text);
        return this.findAllMatches(tokens, 0, tokens.size(), false);
    }

    public List<PhraseMatch> findAllMatches(WordList tokens) {
        return this.findAllMatches(tokens, 0, tokens.size(), true);
    }

    public List<PhraseMatch> findAllMatches(List<Phrase> acceptablePhrases, String text) {
        WordList tokens = this.toNormalizedWordList(text);
        return this.findAllMatches(acceptablePhrases, tokens, 0, tokens.size(), false);
    }

    public List<PhraseMatch> findAllMatches(List<Phrase> acceptablePhrases, WordList tokens) {
        return this.findAllMatches(acceptablePhrases, tokens, 0, tokens.size(), true);
    }

    public List<PhraseMatch> findAllMatches(WordList tokens, int tokenStart, int tokenEnd, boolean needNormalization) {
        return this.findMatches(null, tokens, tokenStart, tokenEnd, needNormalization, true, false);
    }

    public List<PhraseMatch> findAllMatches(List<Phrase> acceptablePhrases, WordList tokens, int tokenStart, int tokenEnd, boolean needNormalization) {
        return this.findMatches(acceptablePhrases, tokens, tokenStart, tokenEnd, needNormalization, true, false);
    }

    public List<PhraseMatch> findMatches(String text) {
        WordList tokens = this.toNormalizedWordList(text);
        return this.findMatches(tokens, 0, tokens.size(), false);
    }

    public List<PhraseMatch> findMatches(WordList tokens) {
        return this.findMatches(tokens, 0, tokens.size(), true);
    }

    public List<PhraseMatch> findMatches(WordList tokens, int tokenStart, int tokenEnd, boolean needNormalization) {
        return this.findMatches(null, tokens, tokenStart, tokenEnd, needNormalization, false, false);
    }

    public List<PhraseMatch> findMatches(String text, int tokenStart, int tokenEnd, boolean needNormalization) {
        WordList tokens = this.toNormalizedWordList(text);
        return this.findMatches(tokens, tokenStart, tokenEnd, false);
    }

    protected int checkWordListMatch(Phrase phrase, WordList tokens, int tokenStart, int tokenEnd, int checkStart, boolean matchEnd) {
        int i;
        if (checkStart < tokenStart) {
            return -1;
        }
        int phraseSize = phrase.wordList.size();
        for (i = checkStart; i < tokenEnd && i - tokenStart < phraseSize; ++i) {
            String word = tokens.getWord(i);
            String phraseWord = phrase.wordList.getWord(i - tokenStart);
            if (phraseWord.equals(word)) continue;
            return -1;
        }
        if (i - tokenStart == phraseSize) {
            if (matchEnd) {
                return i == tokenEnd ? i : -1;
            }
            return i;
        }
        return -1;
    }

    public List<PhraseMatch> findNonOverlappingPhrases(List<PhraseMatch> phraseMatches) {
        if (phraseMatches.size() > 1) {
            return IntervalTree.getNonOverlapping(phraseMatches, PHRASEMATCH_LENGTH_ENDPOINTS_COMPARATOR);
        }
        return phraseMatches;
    }

    protected List<PhraseMatch> findMatches(Collection<Phrase> acceptablePhrases, WordList tokens, int tokenStart, int tokenEnd, boolean needNormalization, boolean findAll, boolean matchEnd) {
        if (needNormalization) {
            assert (tokenStart >= 0);
            assert (tokenEnd > tokenStart);
            int n = tokenEnd - tokenStart;
            ArrayList<String> normalized = new ArrayList<String>(n);
            int[] tokenIndexMap = new int[n + 1];
            int j = 0;
            int last = 0;
            for (int i = tokenStart; i < tokenEnd; ++i) {
                String word = tokens.getWord(i);
                if ((word = this.getNormalizedForm(word)).length() == 0) continue;
                normalized.add(word);
                tokenIndexMap[j] = i;
                last = i;
                ++j;
            }
            tokenIndexMap[j] = Math.min(last + 1, tokenEnd);
            List<PhraseMatch> matched = this.findMatchesNormalized(acceptablePhrases, new StringList(normalized), 0, normalized.size(), findAll, matchEnd);
            for (PhraseMatch pm : matched) {
                assert (pm.tokenBegin >= 0);
                assert (pm.tokenEnd >= pm.tokenBegin);
                assert (pm.tokenEnd <= normalized.size());
                pm.tokenEnd = pm.tokenEnd > 0 && pm.tokenEnd > pm.tokenBegin ? tokenIndexMap[pm.tokenEnd - 1] + 1 : tokenIndexMap[pm.tokenEnd];
                pm.tokenBegin = tokenIndexMap[pm.tokenBegin];
                assert (pm.tokenBegin >= 0);
                assert (pm.tokenEnd >= pm.tokenBegin);
            }
            return matched;
        }
        return this.findMatchesNormalized(acceptablePhrases, tokens, tokenStart, tokenEnd, findAll, matchEnd);
    }

    protected List<PhraseMatch> findMatchesNormalized(Collection<Phrase> acceptablePhrases, WordList tokens, int tokenStart, int tokenEnd, boolean findAll, boolean matchEnd) {
        ArrayList<PhraseMatch> matched = new ArrayList<PhraseMatch>();
        Stack<StackEntry> todoStack = new Stack<StackEntry>();
        todoStack.push(new StackEntry(this.rootTree, tokenStart, tokenStart, tokenEnd, findAll ? tokenStart + 1 : -1));
        while (!todoStack.isEmpty()) {
            int newStart;
            StackEntry cur = (StackEntry)todoStack.pop();
            Map tree = cur.tree;
            for (int i = cur.tokenNext; i <= cur.tokenEnd; ++i) {
                String word;
                Object node;
                if (tree.containsKey(PHRASE_END)) {
                    int matchedTokenEnd;
                    Phrase phrase = (Phrase)tree.get(PHRASE_END);
                    if ((acceptablePhrases == null || acceptablePhrases.contains(phrase)) && (matchedTokenEnd = this.checkWordListMatch(phrase, tokens, cur.tokenStart, cur.tokenEnd, i, matchEnd)) >= 0) {
                        matched.add(new PhraseMatch(phrase, cur.tokenStart, matchedTokenEnd));
                    }
                }
                if (i == cur.tokenEnd || (node = tree.get(word = tokens.getWord(i))) == null) break;
                if (node instanceof Phrase) {
                    int matchedTokenEnd;
                    Phrase phrase = (Phrase)node;
                    if (acceptablePhrases != null && !acceptablePhrases.contains(phrase) || (matchedTokenEnd = this.checkWordListMatch(phrase, tokens, cur.tokenStart, cur.tokenEnd, i + 1, matchEnd)) < 0) break;
                    matched.add(new PhraseMatch(phrase, cur.tokenStart, matchedTokenEnd));
                    break;
                }
                if (!(node instanceof Map)) {
                    if (node instanceof List) {
                        List lookupList = (List)node;
                        for (Object obj : lookupList) {
                            if (obj instanceof Phrase) {
                                int matchedTokenEnd;
                                Phrase phrase = (Phrase)obj;
                                if (acceptablePhrases != null && !acceptablePhrases.contains(phrase) || (matchedTokenEnd = this.checkWordListMatch(phrase, tokens, cur.tokenStart, cur.tokenEnd, i + 1, matchEnd)) < 0) continue;
                                matched.add(new PhraseMatch(phrase, cur.tokenStart, matchedTokenEnd));
                                continue;
                            }
                            if (obj instanceof Map) {
                                todoStack.push(new StackEntry((Map)obj, cur.tokenStart, i + 1, cur.tokenEnd, -1));
                                continue;
                            }
                            throw new RuntimeException("Unexpected class in list " + obj.getClass() + " while looking up " + word);
                        }
                        break;
                    }
                    throw new RuntimeException("Unexpected class " + node.getClass() + " while looking up " + word);
                }
                tree = (Map)node;
            }
            if (cur.continueAt < 0 || (newStart = cur.continueAt > cur.tokenStart ? cur.continueAt : cur.tokenStart + 1) >= cur.tokenEnd) continue;
            todoStack.push(new StackEntry(cur.tree, newStart, newStart, cur.tokenEnd, newStart + 1));
        }
        return matched;
    }

    public Iterator<Phrase> iterator() {
        return new PhraseTableIterator(this);
    }

    public static String toString(WordList wordList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < wordList.size(); ++i) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(wordList.getWord(i));
        }
        return sb.toString();
    }

    public static class PhraseStringCollection
    implements Collection<String> {
        PhraseTable phraseTable;
        boolean useNormalizedLookup;

        public PhraseStringCollection(PhraseTable phraseTable, boolean useNormalizedLookup) {
            this.phraseTable = phraseTable;
            this.useNormalizedLookup = useNormalizedLookup;
        }

        @Override
        public int size() {
            return this.phraseTable.nStrings;
        }

        @Override
        public boolean isEmpty() {
            return this.phraseTable.nStrings == 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof String) {
                if (this.useNormalizedLookup) {
                    return this.phraseTable.lookupNormalized((String)o) != null;
                }
                return this.phraseTable.lookup((String)o) != null;
            }
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            throw new UnsupportedOperationException("iterator is not supported for PhraseTable.PhraseStringCollection");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("toArray is not supported for PhraseTable.PhraseStringCollection");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("toArray is not supported for PhraseTable.PhraseStringCollection");
        }

        @Override
        public boolean add(String s) {
            return this.phraseTable.addPhrase(s);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Remove is not supported for PhraseTable.PhraseStringCollection");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            boolean modified = false;
            for (String string : c) {
                if (!this.add(string)) continue;
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            for (Object o : c) {
                if (!this.remove(o)) continue;
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll is not supported for PhraseTable.PhraseStringCollection");
        }

        @Override
        public void clear() {
            this.phraseTable.clear();
        }
    }

    public static class StringList
    implements WordList {
        private List<String> words;

        public StringList(List<String> words) {
            this.words = words;
        }

        public StringList(String[] wordsArray) {
            this.words = Arrays.asList(wordsArray);
        }

        @Override
        public String getWord(int i) {
            return this.words.get(i);
        }

        @Override
        public int size() {
            return this.words.size();
        }

        public String toString() {
            return PhraseTable.toString(this);
        }
    }

    public static class TokenList
    implements WordList {
        private List<? extends CoreMap> tokens;
        private Class textKey = CoreAnnotations.TextAnnotation.class;

        public TokenList(List<CoreLabel> tokens) {
            this.tokens = tokens;
        }

        public TokenList(List<? extends CoreMap> tokens, Class key) {
            this.tokens = tokens;
            this.textKey = key;
        }

        @Override
        public String getWord(int i) {
            return (String)this.tokens.get(i).get(this.textKey);
        }

        @Override
        public int size() {
            return this.tokens.size();
        }

        public String toString() {
            return PhraseTable.toString(this);
        }
    }

    public static interface WordList {
        public String getWord(int var1);

        public int size();
    }

    public static class PhraseMatch
    implements HasInterval<Integer> {
        Phrase phrase;
        int tokenBegin;
        int tokenEnd;
        transient Interval<Integer> span;

        public PhraseMatch(Phrase phrase, int tokenBegin, int tokenEnd) {
            this.phrase = phrase;
            this.tokenBegin = tokenBegin;
            this.tokenEnd = tokenEnd;
        }

        public Phrase getPhrase() {
            return this.phrase;
        }

        public int getTokenBegin() {
            return this.tokenBegin;
        }

        public int getTokenEnd() {
            return this.tokenEnd;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.phrase);
            sb.append(" at (").append(this.tokenBegin);
            sb.append(",").append(this.tokenEnd).append(")");
            return sb.toString();
        }

        @Override
        public Interval<Integer> getInterval() {
            if (this.span == null) {
                this.span = Interval.toInterval(this.tokenBegin, this.tokenEnd, Interval.INTERVAL_OPEN_END);
            }
            return this.span;
        }
    }

    public static class Phrase {
        WordList wordList;
        String text;
        String tag;
        Object data;
        private Set<String> alternateForms;

        public Phrase(WordList wordList, String text, String tag, Object data) {
            this.wordList = wordList;
            this.text = text;
            this.tag = tag;
            this.data = data;
        }

        public boolean isLonger(Phrase phrase) {
            return this.getWordList().size() > phrase.getWordList().size() || this.getWordList().size() == phrase.getWordList().size() && this.getText().length() > phrase.getText().length();
        }

        public boolean addForm(String form) {
            if (this.alternateForms == null) {
                this.alternateForms = new HashSet<String>(4);
                this.alternateForms.add(this.text);
            }
            return this.alternateForms.add(form);
        }

        public WordList getWordList() {
            return this.wordList;
        }

        public String getText() {
            return this.text;
        }

        public String getTag() {
            return this.tag;
        }

        public Collection<String> getAlternateForms() {
            if (this.alternateForms == null) {
                ArrayList<String> forms = new ArrayList<String>(1);
                forms.add(this.text);
                return forms;
            }
            return this.alternateForms;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class StackEntry {
        Map<String, Object> tree;
        int tokenStart;
        int tokenNext;
        int tokenEnd;
        int continueAt;

        private StackEntry(Map<String, Object> tree, int tokenStart, int tokenNext, int tokenEnd, int continueAt) {
            this.tree = tree;
            this.tokenStart = tokenStart;
            this.tokenNext = tokenNext;
            this.tokenEnd = tokenEnd;
            this.continueAt = continueAt;
        }
    }

    private static class PhraseTableIterator
    extends AbstractIterator<Phrase> {
        private PhraseTable phraseTable;
        private Stack<Iterator<Object>> iteratorStack = new Stack();
        private Phrase next = null;

        public PhraseTableIterator(PhraseTable phraseTable) {
            this.phraseTable = phraseTable;
            this.iteratorStack.push(this.phraseTable.rootTree.values().iterator());
            this.next = this.getNext();
        }

        private Phrase getNext() {
            while (!this.iteratorStack.isEmpty()) {
                Iterator<Object> iter = this.iteratorStack.peek();
                if (iter.hasNext()) {
                    Object obj = iter.next();
                    if (obj instanceof Phrase) {
                        return (Phrase)obj;
                    }
                    if (obj instanceof Map) {
                        this.iteratorStack.push(((Map)obj).values().iterator());
                        continue;
                    }
                    if (obj instanceof List) {
                        this.iteratorStack.push(((List)obj).iterator());
                        continue;
                    }
                    throw new RuntimeException("Unexpected class in phrase table " + obj.getClass());
                }
                this.iteratorStack.pop();
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Phrase next() {
            Phrase res = this.next;
            this.next = this.getNext();
            return res;
        }
    }
}

