/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.ling.tokensregex.types.Expressions;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Env {
    SequencePattern.Parser parser;
    Map<String, Object> variables = Generics.newHashMap();
    Map<String, Pair<Pattern, String>> stringRegexVariables = Generics.newHashMap();
    public Map<String, Object> defaults = Generics.newHashMap();
    public int defaultStringPatternFlags = 0;
    public Class sequenceMatchResultExtractor;
    public Class stringMatchResultExtractor;
    public Class defaultTokensAnnotationKey;
    public Class defaultTextAnnotationKey;
    public List<Class> defaultTokensResultAnnotationKey;
    public List<Class> defaultResultAnnotationKey;
    public Class defaultNestedResultsAnnotationKey;
    public Map<Class, CoreMapAttributeAggregator> defaultTokensAggregators;
    Function<MatchedExpression, ?> defaultResultsAnnotationExtractor;
    private static final Pattern STRING_REGEX_VAR_NAME_PATTERN = Pattern.compile("\\$[A-Za-z0-9_]+");

    public Env(SequencePattern.Parser p) {
        this.parser = p;
    }

    public void initDefaultBindings() {
        this.bind("FALSE", Expressions.FALSE);
        this.bind("TRUE", Expressions.TRUE);
        this.bind("NIL", Expressions.NIL);
        this.bind("ENV", this);
        this.bind("tags", Tags.TagsAnnotation.class);
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Map<String, Object> defaults) {
        this.defaults = defaults;
    }

    public Map<Class, CoreMapAttributeAggregator> getDefaultTokensAggregators() {
        return this.defaultTokensAggregators;
    }

    public void setDefaultTokensAggregators(Map<Class, CoreMapAttributeAggregator> defaultTokensAggregators) {
        this.defaultTokensAggregators = defaultTokensAggregators;
    }

    public Class getDefaultTextAnnotationKey() {
        return this.defaultTextAnnotationKey;
    }

    public void setDefaultTextAnnotationKey(Class defaultTextAnnotationKey) {
        this.defaultTextAnnotationKey = defaultTextAnnotationKey;
    }

    public Class getDefaultTokensAnnotationKey() {
        return this.defaultTokensAnnotationKey;
    }

    public void setDefaultTokensAnnotationKey(Class defaultTokensAnnotationKey) {
        this.defaultTokensAnnotationKey = defaultTokensAnnotationKey;
    }

    public List<Class> getDefaultTokensResultAnnotationKey() {
        return this.defaultTokensResultAnnotationKey;
    }

    public void setDefaultTokensResultAnnotationKey(Class ... defaultTokensResultAnnotationKey) {
        this.defaultTokensResultAnnotationKey = Arrays.asList(defaultTokensResultAnnotationKey);
    }

    public void setDefaultTokensResultAnnotationKey(List<Class> defaultTokensResultAnnotationKey) {
        this.defaultTokensResultAnnotationKey = defaultTokensResultAnnotationKey;
    }

    public List<Class> getDefaultResultAnnotationKey() {
        return this.defaultResultAnnotationKey;
    }

    public void setDefaultResultAnnotationKey(Class ... defaultResultAnnotationKey) {
        this.defaultResultAnnotationKey = Arrays.asList(defaultResultAnnotationKey);
    }

    public void setDefaultResultAnnotationKey(List<Class> defaultResultAnnotationKey) {
        this.defaultResultAnnotationKey = defaultResultAnnotationKey;
    }

    public Class getDefaultNestedResultsAnnotationKey() {
        return this.defaultNestedResultsAnnotationKey;
    }

    public void setDefaultNestedResultsAnnotationKey(Class defaultNestedResultsAnnotationKey) {
        this.defaultNestedResultsAnnotationKey = defaultNestedResultsAnnotationKey;
    }

    public Function<MatchedExpression, ?> getDefaultResultsAnnotationExtractor() {
        return this.defaultResultsAnnotationExtractor;
    }

    public void setDefaultResultsAnnotationExtractor(Function<MatchedExpression, ?> defaultResultsAnnotationExtractor) {
        this.defaultResultsAnnotationExtractor = defaultResultsAnnotationExtractor;
    }

    public Class getSequenceMatchResultExtractor() {
        return this.sequenceMatchResultExtractor;
    }

    public void setSequenceMatchResultExtractor(Class sequenceMatchResultExtractor) {
        this.sequenceMatchResultExtractor = sequenceMatchResultExtractor;
    }

    public Class getStringMatchResultExtractor() {
        return this.stringMatchResultExtractor;
    }

    public void setStringMatchResultExtractor(Class stringMatchResultExtractor) {
        this.stringMatchResultExtractor = stringMatchResultExtractor;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public int getDefaultStringPatternFlags() {
        return this.defaultStringPatternFlags;
    }

    public void setDefaultStringPatternFlags(int defaultStringPatternFlags) {
        this.defaultStringPatternFlags = defaultStringPatternFlags;
    }

    public void bindStringRegex(String var, String regex) {
        if (!STRING_REGEX_VAR_NAME_PATTERN.matcher(var).matches()) {
            throw new IllegalArgumentException("StringRegex binding error: Invalid variable name " + var);
        }
        Pattern varPattern = Pattern.compile(Pattern.quote(var));
        String replace = Matcher.quoteReplacement(regex);
        this.stringRegexVariables.put(var, new Pair<Pattern, String>(varPattern, replace));
    }

    public String expandStringRegex(String regex) {
        String expanded = regex;
        for (String v : this.stringRegexVariables.keySet()) {
            Pair<Pattern, String> p = this.stringRegexVariables.get(v);
            expanded = p.first().matcher(expanded).replaceAll(p.second());
        }
        return expanded;
    }

    public Pattern getStringPattern(String regex) {
        String expanded = this.expandStringRegex(regex);
        return Pattern.compile(expanded, this.defaultStringPatternFlags);
    }

    public void bind(String name, Object obj) {
        if (obj != null) {
            this.variables.put(name, obj);
        } else {
            this.variables.remove(name);
        }
    }

    public void bind(String name, SequencePattern pattern) {
        this.bind(name, pattern.getPatternExpr());
    }

    public void unbind(String name) {
        this.bind(name, null);
    }

    public NodePattern getNodePattern(String name) {
        Object obj = this.variables.get(name);
        if (obj != null) {
            if (obj instanceof SequencePattern) {
                SequencePattern seqPattern = (SequencePattern)obj;
                if (seqPattern.getPatternExpr() instanceof SequencePattern.NodePatternExpr) {
                    return ((SequencePattern.NodePatternExpr)seqPattern.getPatternExpr()).nodePattern;
                }
                throw new Error("Invalid node pattern class: " + seqPattern.getPatternExpr().getClass() + " for variable " + name);
            }
            if (obj instanceof SequencePattern.NodePatternExpr) {
                SequencePattern.NodePatternExpr pe = (SequencePattern.NodePatternExpr)obj;
                return pe.nodePattern;
            }
            if (obj instanceof NodePattern) {
                return (NodePattern)obj;
            }
            if (obj instanceof String) {
                try {
                    SequencePattern.NodePatternExpr pe = (SequencePattern.NodePatternExpr)this.parser.parseNode(this, (String)obj);
                    return pe.nodePattern;
                }
                catch (Exception pex) {
                    throw new RuntimeException("Error parsing " + obj + " to node pattern", pex);
                }
            }
            throw new Error("Invalid node pattern variable class: " + obj.getClass() + " for variable " + name);
        }
        return null;
    }

    public SequencePattern.PatternExpr getSequencePatternExpr(String name, boolean copy) {
        Object obj = this.variables.get(name);
        if (obj != null) {
            if (obj instanceof SequencePattern) {
                SequencePattern seqPattern = (SequencePattern)obj;
                return seqPattern.getPatternExpr();
            }
            if (obj instanceof SequencePattern.PatternExpr) {
                SequencePattern.PatternExpr pe = (SequencePattern.PatternExpr)obj;
                return copy ? pe.copy() : pe;
            }
            if (obj instanceof NodePattern) {
                return new SequencePattern.NodePatternExpr((NodePattern)obj);
            }
            if (obj instanceof String) {
                try {
                    return this.parser.parseSequence(this, (String)obj);
                }
                catch (Exception pex) {
                    throw new RuntimeException("Error parsing " + obj + " to sequence pattern", pex);
                }
            }
            throw new Error("Invalid sequence pattern variable class: " + obj.getClass());
        }
        return null;
    }

    public Object get(String name) {
        return this.variables.get(name);
    }

    public static interface Binder {
        public void init(String var1, Properties var2);

        public void bind(Env var1);
    }
}

