/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.AcquisitionsPrior;
import edu.stanford.nlp.ie.BisequenceEmpiricalNERPrior;
import edu.stanford.nlp.ie.EmpiricalNERPrior;
import edu.stanford.nlp.ie.EmpiricalNERPriorBIO;
import edu.stanford.nlp.ie.SeminarsPrior;
import edu.stanford.nlp.ie.UniformPrior;
import edu.stanford.nlp.ie.crf.CRFClassifierEvaluator;
import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFFeatureExporter;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFloatFunction;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunctionForLOP;
import edu.stanford.nlp.ie.crf.CRFNonLinearLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CRFNonLinearSecondOrderLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CliquePotentialFunction;
import edu.stanford.nlp.ie.crf.FactorTable;
import edu.stanford.nlp.ie.crf.HasCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.LinearCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NonLinearCliquePotentialFunction;
import edu.stanford.nlp.ie.crf.NonLinearSecondOrderCliquePotentialFunction;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.optimization.HasEvaluators;
import edu.stanford.nlp.optimization.HybridMinimizer;
import edu.stanford.nlp.optimization.MemoryEvaluator;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.ResultStoringFloatMonitor;
import edu.stanford.nlp.optimization.ResultStoringMonitor;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.optimization.SGDToQNMinimizer;
import edu.stanford.nlp.optimization.SGDWithAdaGradAndFOBOS;
import edu.stanford.nlp.optimization.SMDMinimizer;
import edu.stanford.nlp.optimization.ScaledSGDMinimizer;
import edu.stanford.nlp.optimization.StochasticDiffFunctionTester;
import edu.stanford.nlp.optimization.StochasticInPlaceMinimizer;
import edu.stanford.nlp.sequences.BeamBestSequenceFinder;
import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.Clique;
import edu.stanford.nlp.sequences.CoolingSchedule;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.FactoredSequenceListener;
import edu.stanford.nlp.sequences.FactoredSequenceModel;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceGibbsSampler;
import edu.stanford.nlp.sequences.SequenceListener;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.ConvertByteArray;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Quadruple;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CRFClassifier<IN extends CoreMap>
extends AbstractSequenceClassifier<IN> {
    List<Index<CRFLabel>> labelIndices;
    Index<String> tagIndex;
    Pair<double[][], double[][]> entityMatrices;
    CliquePotentialFunction cliquePotentialFunction;
    HasCliquePotentialFunction cliquePotentialFunctionHelper;
    double[][] weights;
    double[][] linearWeights;
    double[][] inputLayerWeights4Edge;
    double[][] outputLayerWeights4Edge;
    double[][] inputLayerWeights;
    double[][] outputLayerWeights;
    Index<String> featureIndex;
    int[] map;
    List<Set<Integer>> featureIndicesSetArray;
    List<List<Integer>> featureIndicesListArray;
    Random random = new Random(Integer.MAX_VALUE);
    Index<Integer> nodeFeatureIndicesMap;
    Index<Integer> edgeFeatureIndicesMap;
    Map<String, double[]> embeddings;
    public static final String DEFAULT_CLASSIFIER = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz";
    private static final boolean VERBOSE = false;
    Pattern suffixPatt = Pattern.compile(".+?((?:-[A-Z]+)+)\\|.*C");
    Index<String> templateGroupIndex;
    Map<Integer, Integer> featureIndexToTemplateIndex;

    protected CRFClassifier() {
        super(new SeqClassifierFlags());
    }

    public CRFClassifier(Properties props) {
        super(props);
    }

    public CRFClassifier(SeqClassifierFlags flags) {
        super(flags);
    }

    public CRFClassifier(CRFClassifier<IN> crf) {
        super(crf.flags);
        this.windowSize = crf.windowSize;
        this.featureFactory = crf.featureFactory;
        this.pad = crf.pad;
        this.knownLCWords = crf.knownLCWords != null ? Generics.newHashSet(crf.knownLCWords) : null;
        HashIndex<String> hashIndex = this.featureIndex = crf.featureIndex != null ? new HashIndex<String>(crf.featureIndex.objectsList()) : null;
        if (crf.flags.nonLinearCRF) {
            this.nodeFeatureIndicesMap = crf.nodeFeatureIndicesMap != null ? new HashIndex<Integer>(crf.nodeFeatureIndicesMap.objectsList()) : null;
            this.edgeFeatureIndicesMap = crf.edgeFeatureIndicesMap != null ? new HashIndex<Integer>(crf.edgeFeatureIndicesMap.objectsList()) : null;
        }
        Index index = this.classIndex = crf.classIndex != null ? new HashIndex(crf.classIndex.objectsList()) : null;
        if (crf.labelIndices != null) {
            this.labelIndices = new ArrayList<Index<CRFLabel>>(crf.labelIndices.size());
            for (int i = 0; i < crf.labelIndices.size(); ++i) {
                this.labelIndices.add((Index<CRFLabel>)(crf.labelIndices.get(i) != null ? new HashIndex<CRFLabel>(crf.labelIndices.get(i).objectsList()) : null));
            }
        } else {
            this.labelIndices = null;
        }
        this.cliquePotentialFunction = crf.cliquePotentialFunction;
    }

    public int getNumWeights() {
        if (this.weights == null) {
            return 0;
        }
        int numWeights = 0;
        for (double[] wts : this.weights) {
            numWeights += wts.length;
        }
        return numWeights;
    }

    private int getFeatureTypeIndex(int i) {
        return CRFClassifier.getFeatureTypeIndex(this.featureIndex.get(i));
    }

    private static int getFeatureTypeIndex(String feature) {
        if (feature.endsWith("|C")) {
            return 0;
        }
        if (feature.endsWith("|CpC")) {
            return 1;
        }
        if (feature.endsWith("|Cp2C")) {
            return 2;
        }
        if (feature.endsWith("|Cp3C")) {
            return 3;
        }
        if (feature.endsWith("|Cp4C")) {
            return 4;
        }
        if (feature.endsWith("|Cp5C")) {
            return 5;
        }
        throw new RuntimeException("Unknown feature type " + feature);
    }

    public void scaleWeights(double scale) {
        for (int i = 0; i < this.weights.length; ++i) {
            int j = 0;
            while (j < this.weights[i].length) {
                double[] dArray = this.weights[i];
                int n = j++;
                dArray[n] = dArray[n] * scale;
            }
        }
    }

    private void combineWeights(CRFClassifier<IN> crf, double weight) {
        int i;
        int i2;
        int numFeatures = this.featureIndex.size();
        int oldNumFeatures = this.weights.length;
        Map<CRFLabel, CRFLabel> crfLabelMap = Generics.newHashMap();
        for (i2 = 0; i2 < crf.labelIndices.size(); ++i2) {
            for (int j = 0; j < crf.labelIndices.get(i2).size(); ++j) {
                CRFLabel labels = crf.labelIndices.get(i2).get(j);
                int[] newLabelIndices = new int[i2 + 1];
                for (int ci = 0; ci <= i2; ++ci) {
                    String classLabel = (String)crf.classIndex.get(labels.getLabel()[ci]);
                    newLabelIndices[ci] = this.classIndex.indexOf(classLabel);
                }
                CRFLabel newLabels = new CRFLabel(newLabelIndices);
                crfLabelMap.put(labels, newLabels);
                int k = this.labelIndices.get(i2).indexOf(newLabels);
            }
        }
        this.map = new int[numFeatures];
        for (i2 = 0; i2 < numFeatures; ++i2) {
            this.map[i2] = this.getFeatureTypeIndex(i2);
        }
        double[][] newWeights = new double[numFeatures][];
        for (i = 0; i < numFeatures; ++i) {
            int length = this.labelIndices.get(this.map[i]).size();
            newWeights[i] = new double[length];
            if (i >= oldNumFeatures) continue;
            assert (length >= this.weights[i].length);
            System.arraycopy(this.weights[i], 0, newWeights[i], 0, this.weights[i].length);
        }
        this.weights = newWeights;
        for (i = 0; i < crf.weights.length; ++i) {
            String feature = crf.featureIndex.get(i);
            int newIndex = this.featureIndex.indexOf(feature);
            if (this.weights[newIndex].length < crf.weights[i].length) {
                throw new RuntimeException("Incompatible CRFClassifier: weight length mismatch for feature " + newIndex + ": " + this.featureIndex.get(newIndex) + " (also feature " + i + ": " + crf.featureIndex.get(i) + ") " + ", len1=" + this.weights[newIndex].length + ", len2=" + crf.weights[i].length);
            }
            int featureTypeIndex = this.map[newIndex];
            for (int j = 0; j < crf.weights[i].length; ++j) {
                CRFLabel labels = crf.labelIndices.get(featureTypeIndex).get(j);
                CRFLabel newLabels = (CRFLabel)crfLabelMap.get(labels);
                int k = this.labelIndices.get(featureTypeIndex).indexOf(newLabels);
                double[] dArray = this.weights[newIndex];
                int n = k;
                dArray[n] = dArray[n] + crf.weights[i][j] * weight;
            }
        }
    }

    public void combine(CRFClassifier<IN> crf, double weight) {
        Timing timer = new Timing();
        if (!this.pad.equals(crf.pad)) {
            throw new RuntimeException("Incompatible CRFClassifier: pad does not match");
        }
        if (this.windowSize != crf.windowSize) {
            throw new RuntimeException("Incompatible CRFClassifier: windowSize does not match");
        }
        if (this.labelIndices.size() != crf.labelIndices.size()) {
            throw new RuntimeException("Incompatible CRFClassifier: labelIndices length does not match");
        }
        this.classIndex.addAll(crf.classIndex.objectsList());
        int oldNumFeatures1 = this.featureIndex.size();
        int oldNumFeatures2 = crf.featureIndex.size();
        int oldNumWeights1 = this.getNumWeights();
        int oldNumWeights2 = crf.getNumWeights();
        this.featureIndex.addAll(crf.featureIndex.objectsList());
        this.knownLCWords.addAll(crf.knownLCWords);
        assert (this.weights.length == oldNumFeatures1);
        for (int i = 0; i < this.labelIndices.size(); ++i) {
            this.labelIndices.get(i).addAll(crf.labelIndices.get(i).objectsList());
        }
        System.err.println("Combining weights: will automatically match labelIndices");
        this.combineWeights(crf, weight);
        int numFeatures = this.featureIndex.size();
        int numWeights = this.getNumWeights();
        long elapsedMs = timer.stop();
        System.err.println("numFeatures: orig1=" + oldNumFeatures1 + ", orig2=" + oldNumFeatures2 + ", combined=" + numFeatures);
        System.err.println("numWeights: orig1=" + oldNumWeights1 + ", orig2=" + oldNumWeights2 + ", combined=" + numWeights);
        System.err.println("Time to combine CRFClassifier: " + Timing.toSecondsString(elapsedMs) + " seconds");
    }

    public void dropFeaturesBelowThreshold(double threshold) {
        HashIndex<String> newFeatureIndex = new HashIndex<String>();
        block0: for (int i = 0; i < this.weights.length; ++i) {
            double smallest = this.weights[i][0];
            double biggest = this.weights[i][0];
            for (int j = 1; j < this.weights[i].length; ++j) {
                if (this.weights[i][j] > biggest) {
                    biggest = this.weights[i][j];
                }
                if (this.weights[i][j] < smallest) {
                    smallest = this.weights[i][j];
                }
                if (!(biggest - smallest > threshold)) continue;
                newFeatureIndex.add(this.featureIndex.get(i));
                continue block0;
            }
        }
        int[] newMap = new int[newFeatureIndex.size()];
        for (int i = 0; i < newMap.length; ++i) {
            int index = this.featureIndex.indexOf((String)newFeatureIndex.get(i));
            newMap[i] = this.map[index];
        }
        this.map = newMap;
        this.featureIndex = newFeatureIndex;
    }

    public Triple<int[][][], int[], double[][][]> documentToDataAndLabels(List<IN> document) {
        return this.documentToDataAndLabels(document, false);
    }

    public Triple<int[][][], int[], double[][][]> documentToDataAndLabels(List<IN> document, boolean trainTime) {
        boolean droppedFeature = false;
        int docSize = document.size();
        int[][][] data = new int[docSize][this.windowSize][];
        double[][][] featureVals = new double[docSize][this.windowSize][];
        int[] labels = new int[docSize];
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        for (int j = 0; j < docSize; ++j) {
            CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j, this.featureFactory);
            List<List<String>> features = d.asFeatures();
            List<double[]> featureValList = d.asFeatureVals();
            int fSize = features.size();
            for (int k = 0; k < fSize; ++k) {
                Collection cliqueFeatures = features.get(k);
                data[j][k] = new int[cliqueFeatures.size()];
                if (featureValList != null) {
                    featureVals[j][k] = featureValList.get(k);
                }
                int m = 0;
                for (String feature : cliqueFeatures) {
                    int index = this.featureIndex.indexOf(feature);
                    if (index < 0) continue;
                    data[j][k][m] = index;
                    ++m;
                }
                if (m >= data[j][k].length) continue;
                int[] f = new int[m];
                System.arraycopy(data[j][k], 0, f, 0, m);
                data[j][k] = f;
                if (featureVals[j][k] == null) continue;
                double[] fVal = new double[m];
                System.arraycopy(featureVals[j][k], 0, fVal, 0, m);
                featureVals[j][k] = fVal;
            }
            CoreMap wi = (CoreMap)document.get(j);
            labels[j] = this.classIndex.indexOf(wi.get(CoreAnnotations.AnswerAnnotation.class));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        if (this.flags.nonLinearCRF) {
            data = this.transformDocData(data);
        }
        return new Triple<int[][][], int[], double[][][]>(data, labels, featureVals);
    }

    private int[][][] transformDocData(int[][][] docData) {
        int[][][] transData = new int[docData.length][][];
        for (int i = 0; i < docData.length; ++i) {
            transData[i] = new int[docData[i].length][];
            for (int j = 0; j < docData[i].length; ++j) {
                int[] cliqueFeatures = docData[i][j];
                transData[i][j] = new int[cliqueFeatures.length];
                for (int n = 0; n < cliqueFeatures.length; ++n) {
                    int transFeatureIndex = -1;
                    if (j == 0) {
                        transFeatureIndex = this.nodeFeatureIndicesMap.indexOf(cliqueFeatures[n]);
                        if (transFeatureIndex == -1) {
                            throw new RuntimeException("node cliqueFeatures[n]=" + cliqueFeatures[n] + " not found, nodeFeatureIndicesMap.size=" + this.nodeFeatureIndicesMap.size());
                        }
                    } else {
                        transFeatureIndex = this.edgeFeatureIndicesMap.indexOf(cliqueFeatures[n]);
                        if (transFeatureIndex == -1) {
                            throw new RuntimeException("edge cliqueFeatures[n]=" + cliqueFeatures[n] + " not found, edgeFeatureIndicesMap.size=" + this.edgeFeatureIndicesMap.size());
                        }
                    }
                    transData[i][j][n] = transFeatureIndex;
                }
            }
        }
        return transData;
    }

    public void printLabelInformation(String testFile, DocumentReaderAndWriter<IN> readerAndWriter) throws Exception {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        for (List<IN> document : documents) {
            this.printLabelValue(document);
        }
    }

    public void printLabelValue(List<IN> document) {
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        DecimalFormat nf = new DecimalFormat();
        ArrayList classes = new ArrayList();
        for (int i = 0; i < this.classIndex.size(); ++i) {
            classes.add(this.classIndex.get(i));
        }
        Object[] columnHeaders = classes.toArray(new String[classes.size()]);
        for (int j = 0; j < document.size(); ++j) {
            System.out.println("--== " + (String)((CoreMap)document.get(j)).get(CoreAnnotations.TextAnnotation.class) + " ==--");
            ArrayList<String[]> lines = new ArrayList<String[]>();
            ArrayList<String> rowHeaders = new ArrayList<String>();
            ArrayList<String> line = new ArrayList<String>();
            for (int p = 0; p < this.labelIndices.size(); ++p) {
                if (j + p >= document.size()) continue;
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(document, j + p, this.featureFactory);
                List<List<String>> features = d.asFeatures();
                int fSize = features.size();
                for (int k = p; k < fSize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    for (String feature : cliqueFeatures) {
                        int index = this.featureIndex.indexOf(feature);
                        if (index < 0) continue;
                        rowHeaders.add(feature + '[' + -p + ']');
                        double[] values = new double[this.labelIndices.get(0).size()];
                        for (CRFLabel label : this.labelIndices.get(k)) {
                            int[] l = label.getLabel();
                            double v = this.weights[index][this.labelIndices.get(k).indexOf(label)];
                            int n = l[l.length - 1 - p];
                            values[n] = values[n] + v;
                        }
                        for (double value : values) {
                            line.add(nf.format(value));
                        }
                        lines.add(line.toArray(new String[line.size()]));
                        line = new ArrayList();
                    }
                }
                System.out.println(StringUtils.makeAsciiTable((Object[][])lines.toArray((T[])new String[lines.size()][0]), rowHeaders.toArray(new String[rowHeaders.size()]), columnHeaders, 0, 1, true));
                System.out.println();
            }
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
    }

    public Triple<int[][][][], int[][], double[][][][]> documentsToDataAndLabels(Collection<List<IN>> documents) {
        ArrayList<int[][][]> data = new ArrayList<int[][][]>();
        ArrayList<double[][][]> featureVal = new ArrayList<double[][][]>();
        ArrayList<int[]> labels = new ArrayList<int[]>();
        int numDatums = 0;
        for (List<IN> doc : documents) {
            Triple<int[][][], int[], double[][][]> docTriple = this.documentToDataAndLabels(doc, true);
            data.add(docTriple.first());
            labels.add(docTriple.second());
            if (this.flags.useEmbedding) {
                featureVal.add(docTriple.third());
            }
            numDatums += doc.size();
        }
        System.err.println("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        System.err.println("numDocuments: " + data.size());
        System.err.println("numDatums: " + numDatums);
        System.err.println("numFeatures: " + this.featureIndex.size());
        this.printFeatures();
        double[][][][] featureValArr = null;
        if (this.flags.useEmbedding) {
            featureValArr = (double[][][][])featureVal.toArray((T[])new double[data.size()][][][]);
        }
        return new Triple<T[], T[], double[][][][]>(data.toArray((T[])new int[data.size()][][][]), labels.toArray((T[])new int[labels.size()][]), featureValArr);
    }

    public List<Triple<int[][][], int[], double[][][]>> documentsToDataAndLabelsList(Collection<List<IN>> documents) {
        int numDatums = 0;
        ArrayList<Triple<int[][][], int[], double[][][]>> docList = new ArrayList<Triple<int[][][], int[], double[][][]>>();
        for (List<IN> doc : documents) {
            Triple<int[][][], int[], double[][][]> docTriple = this.documentToDataAndLabels(doc);
            docList.add(docTriple);
            numDatums += doc.size();
        }
        System.err.println("numClasses: " + this.classIndex.size() + ' ' + this.classIndex);
        System.err.println("numDocuments: " + docList.size());
        System.err.println("numDatums: " + numDatums);
        System.err.println("numFeatures: " + this.featureIndex.size());
        return docList;
    }

    protected void printFeatures() {
        if (this.flags.printFeatures == null) {
            return;
        }
        try {
            String enc = this.flags.inputEncoding;
            if (this.flags.inputEncoding == null) {
                System.err.println("flags.inputEncoding doesn't exist, Use UTF-8 as default");
                enc = "UTF-8";
            }
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("features-" + this.flags.printFeatures + ".txt"), enc), true);
            for (String feat : this.featureIndex) {
                pw.println(feat);
            }
            pw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void makeAnswerArraysAndTagIndex(Collection<List<IN>> ob) {
        int i;
        int i2;
        HashSet[] featureIndices = new HashSet[this.windowSize];
        for (i2 = 0; i2 < this.windowSize; ++i2) {
            featureIndices[i2] = Generics.newHashSet();
        }
        this.labelIndices = new ArrayList<Index<CRFLabel>>(this.windowSize);
        for (i2 = 0; i2 < this.windowSize; ++i2) {
            this.labelIndices.add(new HashIndex());
        }
        Index<CRFLabel> labelIndex = this.labelIndices.get(this.windowSize - 1);
        this.classIndex = new HashIndex();
        this.classIndex.add(this.flags.backgroundSymbol);
        HashSet[] seenBackgroundFeatures = new HashSet[]{Generics.newHashSet(), Generics.newHashSet()};
        int wordCount = 0;
        for (List<IN> doc : ob) {
            if (this.flags.useReverse) {
                Collections.reverse(doc);
            }
            for (CoreMap token : doc) {
                ++wordCount;
                String ans = (String)token.get(CoreAnnotations.AnswerAnnotation.class);
                if (ans == null || ans.equals("")) {
                    throw new IllegalArgumentException("Word " + wordCount + " (\"" + (String)token.get(CoreAnnotations.TextAnnotation.class) + "\") has a blank answer");
                }
                this.classIndex.add(ans);
            }
            int docSize = doc.size();
            for (int j = 0; j < docSize; ++j) {
                CRFDatum<List<String>, CRFLabel> d = this.makeDatum(doc, j, this.featureFactory);
                labelIndex.add(d.label());
                List<List<String>> features = d.asFeatures();
                int fSize = features.size();
                for (int k = 0; k < fSize; ++k) {
                    Collection cliqueFeatures = features.get(k);
                    if (k < 2 && this.flags.removeBackgroundSingletonFeatures) {
                        String ans = (String)((CoreMap)doc.get(j)).get(CoreAnnotations.AnswerAnnotation.class);
                        boolean background = ans.equals(this.flags.backgroundSymbol);
                        if (k == 1 && j > 0 && background) {
                            ans = (String)((CoreMap)doc.get(j - 1)).get(CoreAnnotations.AnswerAnnotation.class);
                            background = ans.equals(this.flags.backgroundSymbol);
                        }
                        if (background) {
                            for (String f : cliqueFeatures) {
                                if (featureIndices[k].contains(f)) continue;
                                if (seenBackgroundFeatures[k].contains(f)) {
                                    seenBackgroundFeatures[k].remove(f);
                                    featureIndices[k].add(f);
                                    continue;
                                }
                                seenBackgroundFeatures[k].add(f);
                            }
                            continue;
                        }
                        seenBackgroundFeatures[k].removeAll(cliqueFeatures);
                        featureIndices[k].addAll(cliqueFeatures);
                        continue;
                    }
                    featureIndices[k].addAll(cliqueFeatures);
                }
            }
            if (!this.flags.useReverse) continue;
            Collections.reverse(doc);
        }
        int numFeatures = 0;
        for (int i3 = 0; i3 < this.windowSize; ++i3) {
            numFeatures += featureIndices[i3].size();
        }
        this.featureIndex = new HashIndex<String>();
        this.map = new int[numFeatures];
        if (this.flags.groupByFeatureTemplate) {
            this.templateGroupIndex = new HashIndex<String>();
            this.featureIndexToTemplateIndex = new HashMap<Integer, Integer>();
        }
        Matcher m = null;
        String groupSuffix = null;
        for (i = 0; i < this.windowSize; ++i) {
            HashIndex<Integer> featureIndexMap = new HashIndex<Integer>();
            this.featureIndex.addAll(featureIndices[i]);
            for (String str : featureIndices[i]) {
                int index = this.featureIndex.indexOf(str);
                this.map[index] = i;
                featureIndexMap.add(index);
                if (!this.flags.groupByFeatureTemplate) continue;
                m = this.suffixPatt.matcher(str);
                groupSuffix = "NoTemplate";
                if (m.matches()) {
                    groupSuffix = m.group(1);
                }
                groupSuffix = groupSuffix + "-c:" + i;
                int groupIndex = this.templateGroupIndex.indexOf(groupSuffix, true);
                this.featureIndexToTemplateIndex.put(index, groupIndex);
            }
            if (i == 0) {
                this.nodeFeatureIndicesMap = featureIndexMap;
                System.err.println("setting nodeFeatureIndicesMap, size=" + this.nodeFeatureIndicesMap.size());
                continue;
            }
            this.edgeFeatureIndicesMap = featureIndexMap;
            System.err.println("setting edgeFeatureIndicesMap, size=" + this.edgeFeatureIndicesMap.size());
        }
        if (this.flags.numOfFeatureSlices > 0) {
            System.err.println("Taking " + this.flags.numOfFeatureSlices + " out of " + this.flags.totalFeatureSlice + " slices of node features for training");
            this.pruneNodeFeatureIndices(this.flags.totalFeatureSlice, this.flags.numOfFeatureSlices);
        }
        if (this.flags.useObservedSequencesOnly) {
            int liSize = labelIndex.size();
            for (i = 0; i < liSize; ++i) {
                CRFLabel label = labelIndex.get(i);
                for (int j = this.windowSize - 2; j >= 0; --j) {
                    label = label.getOneSmallerLabel();
                    this.labelIndices.get(j).add(label);
                }
            }
        } else {
            for (i = 0; i < this.labelIndices.size(); ++i) {
                this.labelIndices.set(i, CRFClassifier.allLabels(i + 1, this.classIndex));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static Index<CRFLabel> allLabels(int window, Index<String> classIndex) {
        label = new int[window];
        numClasses = classIndex.size();
        labelIndex = new HashIndex<CRFLabel>();
        block0: while (true) {
            l = new CRFLabel(label);
            labelIndex.add(l);
            label1 = new int[window];
            System.arraycopy(label, 0, label1, 0, label.length);
            label = label1;
            j = 0;
            while (true) {
                if (j >= label.length) continue block0;
                v0 = j;
                label[v0] = label[v0] + 1;
                if (label[j] >= numClasses) ** break;
                continue block0;
                label[j] = 0;
                if (j == label.length - 1) break block0;
                ++j;
            }
            break;
        }
        return labelIndex;
    }

    public CRFDatum<List<String>, CRFLabel> makeDatum(List<IN> info, int loc, FeatureFactory<IN> featureFactory) {
        PaddedList<CoreMap> pInfo = new PaddedList<CoreMap>(info, this.pad);
        ArrayList<List<String>> features = new ArrayList<List<String>>();
        ArrayList<double[]> featureVals = new ArrayList<double[]>();
        Set<Clique> done = Generics.newHashSet();
        for (int i = 0; i < this.windowSize; ++i) {
            ArrayList<String> featuresC = new ArrayList<String>();
            List<Clique> windowCliques = FeatureFactory.getCliques(i, 0);
            windowCliques.removeAll(done);
            done.addAll(windowCliques);
            double[] featureValArr = null;
            if (this.flags.useEmbedding && i == 0) {
                ArrayList<double[]> embeddingList = new ArrayList<double[]>();
                int concatEmbeddingLen = 0;
                String currentWord = null;
                for (int currLoc = loc - 2; currLoc <= loc + 2; ++currLoc) {
                    double[] embedding = null;
                    if (currLoc >= 0 && currLoc < info.size()) {
                        currentWord = (String)((CoreMap)info.get(loc)).get(CoreAnnotations.TextAnnotation.class);
                        String word = currentWord.toLowerCase();
                        embedding = this.embeddings.containsKey(word = word.replaceAll("(-)?\\d+(\\.\\d*)?", "0")) ? this.embeddings.get(word) : this.embeddings.get("UNKNOWN");
                    } else {
                        embedding = this.embeddings.get("PADDING");
                    }
                    for (int e = 0; e < embedding.length; ++e) {
                        featuresC.add("EMBEDDING-(" + (currLoc - loc) + ")-" + e);
                    }
                    if (this.flags.addCapitalFeatures) {
                        int numOfCapitalFeatures = 4;
                        double[] newEmbedding = new double[embedding.length + numOfCapitalFeatures];
                        int currLen = embedding.length;
                        System.arraycopy(embedding, 0, newEmbedding, 0, currLen);
                        for (int e = 0; e < numOfCapitalFeatures; ++e) {
                            featuresC.add("CAPITAL-(" + (currLoc - loc) + ")-" + e);
                        }
                        if (currLoc >= 0 && currLoc < info.size()) {
                            if (currentWord.toUpperCase().equals(currentWord)) {
                                newEmbedding[currLen] = 1.0;
                            } else {
                                ++currLen;
                                if (currentWord.toLowerCase().equals(currentWord)) {
                                    newEmbedding[currLen] = 1.0;
                                } else {
                                    ++currLen;
                                    if (Character.isUpperCase(currentWord.charAt(0))) {
                                        newEmbedding[currLen] = 1.0;
                                    } else {
                                        ++currLen;
                                        String remainder = currentWord.substring(1);
                                        if (!remainder.toLowerCase().equals(remainder)) {
                                            newEmbedding[currLen] = 1.0;
                                        }
                                    }
                                }
                            }
                        }
                        embedding = newEmbedding;
                    }
                    embeddingList.add(embedding);
                    concatEmbeddingLen += embedding.length;
                }
                double[] concatEmbedding = new double[concatEmbeddingLen];
                int currPos = 0;
                for (double[] em : embeddingList) {
                    System.arraycopy(em, 0, concatEmbedding, currPos, em.length);
                    currPos += em.length;
                }
                if (this.flags.prependEmbedding) {
                    int additionalFeatureCount = 0;
                    for (Clique c : windowCliques) {
                        Collection<String> fCol = featureFactory.getCliqueFeatures(pInfo, loc, c);
                        featuresC.addAll(fCol);
                        additionalFeatureCount += fCol.size();
                    }
                    featureValArr = new double[concatEmbedding.length + additionalFeatureCount];
                    System.arraycopy(concatEmbedding, 0, featureValArr, 0, concatEmbedding.length);
                    Arrays.fill(featureValArr, concatEmbedding.length, featureValArr.length, 1.0);
                } else {
                    featureValArr = concatEmbedding;
                }
                if (this.flags.addBiasToEmbedding) {
                    featuresC.add("BIAS-FEATURE");
                    double[] newFeatureValArr = new double[featureValArr.length + 1];
                    System.arraycopy(featureValArr, 0, newFeatureValArr, 0, featureValArr.length);
                    newFeatureValArr[newFeatureValArr.length - 1] = 1.0;
                    featureValArr = newFeatureValArr;
                }
            } else {
                for (Clique c : windowCliques) {
                    featuresC.addAll(featureFactory.getCliqueFeatures(pInfo, loc, c));
                }
            }
            features.add(featuresC);
            featureVals.add(featureValArr);
        }
        int[] labels = new int[this.windowSize];
        for (int i = 0; i < this.windowSize; ++i) {
            String answer = (String)pInfo.get(loc + i - this.windowSize + 1).get(CoreAnnotations.AnswerAnnotation.class);
            labels[i] = this.classIndex.indexOf(answer);
        }
        this.printFeatureLists(pInfo.get(loc), features);
        CRFDatum<List<String>, CRFLabel> d = new CRFDatum<List<String>, CRFLabel>(features, new CRFLabel(labels), featureVals);
        return d;
    }

    @Override
    public List<IN> classify(List<IN> document) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document);
            }
            catch (Exception e) {
                System.err.println("Error running testGibbs inference!");
                e.printStackTrace();
                return null;
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    private List<IN> classify(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) {
        if (this.flags.doGibbs) {
            try {
                return this.classifyGibbs(document, documentDataAndLabels);
            }
            catch (Exception e) {
                System.err.println("Error running testGibbs inference!");
                e.printStackTrace();
                return null;
            }
        }
        if (this.flags.crfType.equalsIgnoreCase("maxent")) {
            return this.classifyMaxEnt(document, documentDataAndLabels);
        }
        throw new RuntimeException("Unsupported inference type: " + this.flags.crfType);
    }

    void classifyAndWriteAnswers(Collection<List<IN>> documents, List<Triple<int[][][], int[], double[][][]>> documentDataAndLabels, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        boolean resultsCounted = true;
        int numWords = 0;
        int numDocs = 0;
        for (List<IN> doc : documents) {
            this.classify(doc, documentDataAndLabels.get(numDocs));
            numWords += doc.size();
            this.writeAnswers(doc, printWriter, readerAndWriter);
            resultsCounted = resultsCounted && this.countResults(doc, entityTP, entityFP, entityFN);
            ++numDocs;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        if (!this.flags.suppressTestDebug) {
            System.err.println(StringUtils.getShortClassName(this) + " tagged " + numWords + " words in " + numDocs + " documents at " + nf.format(wordspersec) + " words per second.");
        }
        if (resultsCounted && !this.flags.suppressTestDebug) {
            CRFClassifier.printResults(entityTP, entityFP, entityFN);
        }
    }

    @Override
    public SequenceModel getSequenceModel(List<IN> doc) {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(doc);
        return this.getSequenceModel(p);
    }

    private SequenceModel getSequenceModel(Triple<int[][][], int[], double[][][]> documentDataAndLabels) {
        return new TestSequenceModel(this.getCliqueTree(documentDataAndLabels));
    }

    private CliquePotentialFunction getCliquePotentialFunction() {
        if (this.cliquePotentialFunction == null) {
            this.cliquePotentialFunction = this.flags.nonLinearCRF ? (this.flags.secondOrderNonLinear ? new NonLinearSecondOrderCliquePotentialFunction(this.inputLayerWeights4Edge, this.outputLayerWeights4Edge, this.inputLayerWeights, this.outputLayerWeights, this.flags) : new NonLinearCliquePotentialFunction(this.linearWeights, this.inputLayerWeights, this.outputLayerWeights, this.flags)) : new LinearCliquePotentialFunction(this.weights);
        }
        return this.cliquePotentialFunction;
    }

    public void updateWeights(double[] x) {
        this.cliquePotentialFunction = this.cliquePotentialFunctionHelper.getCliquePotentialFunction(x);
    }

    public List<IN> classifyMaxEnt(List<IN> document) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(document);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) {
        if (document.isEmpty()) {
            return document;
        }
        SequenceModel model = this.getSequenceModel(documentDataAndLabels);
        return this.classifyMaxEnt(document, model);
    }

    private List<IN> classifyMaxEnt(List<IN> document, SequenceModel model) {
        BestSequenceFinder tagInference;
        if (document.isEmpty()) {
            return document;
        }
        if (this.flags.inferenceType == null) {
            this.flags.inferenceType = "Viterbi";
        }
        if (this.flags.inferenceType.equalsIgnoreCase("Viterbi")) {
            tagInference = new ExactBestSequenceFinder();
        } else if (this.flags.inferenceType.equalsIgnoreCase("Beam")) {
            tagInference = new BeamBestSequenceFinder(this.flags.beamSize);
        } else {
            throw new RuntimeException("Unknown inference type: " + this.flags.inferenceType + ". Your options are Viterbi|Beam.");
        }
        int[] bestSequence = tagInference.bestSequence(model);
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int docSize = document.size();
        for (int j = 0; j < docSize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            String guess = (String)this.classIndex.get(bestSequence[j + this.windowSize - 1]);
            wi.set(CoreAnnotations.AnswerAnnotation.class, guess);
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    public List<IN> classifyGibbs(List<IN> document) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        return this.classifyGibbs(document, p);
    }

    public List<IN> classifyGibbs(List<IN> document, Triple<int[][][], int[], double[][][]> documentDataAndLabels) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SequenceListener prior;
        CRFCliqueTree<String> cliqueTree;
        List<IN> newDocument = document;
        if (this.flags.useReverse) {
            Collections.reverse(document);
            newDocument = new ArrayList<IN>(document);
            Collections.reverse(document);
        }
        SequenceModel model = cliqueTree = this.getCliqueTree(documentDataAndLabels);
        SequenceListener listener = cliqueTree;
        SequenceListener priorModel = null;
        SequenceListener priorListener = null;
        if (this.flags.useNERPrior) {
            priorModel = prior = new EmpiricalNERPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useNERPriorBIO) {
            priorModel = prior = new EmpiricalNERPriorBIO<IN>(this.flags.backgroundSymbol, this.classIndex, this.tagIndex, newDocument, this.entityMatrices, this.flags);
            priorListener = prior;
        } else if (this.flags.useAcqPrior) {
            priorModel = prior = new AcquisitionsPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useSemPrior) {
            priorModel = prior = new SeminarsPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorListener = prior;
        } else if (this.flags.useUniformPrior) {
            UniformPrior<IN> uniPrior = new UniformPrior<IN>(this.flags.backgroundSymbol, this.classIndex, newDocument);
            priorModel = uniPrior;
            priorListener = uniPrior;
        } else {
            throw new RuntimeException("no prior specified");
        }
        model = new FactoredSequenceModel(model, (SequenceModel)((Object)priorModel));
        listener = new FactoredSequenceListener(listener, priorListener);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)document.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(document);
        }
        return document;
    }

    public List<IN> classifyGibbsUsingPrior(List<IN> sentence, SequenceModel[] priorModels, SequenceListener[] priorListeners, double[] modelWts) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        CRFCliqueTree<String> cliqueTree;
        if (priorModels.length + 1 != modelWts.length) {
            throw new RuntimeException("modelWts array should be longer than the priorModels array by 1 unit since it also includes the weight of the CRF model at position 0.");
        }
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(sentence);
        List<IN> newDocument = sentence;
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
            newDocument = new ArrayList<IN>(sentence);
            Collections.reverse(sentence);
        }
        SequenceModel model = cliqueTree = this.getCliqueTree(p);
        SequenceListener listener = cliqueTree;
        SequenceModel[] models = new SequenceModel[priorModels.length + 1];
        models[0] = model;
        for (int i = 1; i < models.length; ++i) {
            models[i] = priorModels[i - 1];
        }
        model = new FactoredSequenceModel(models, modelWts);
        SequenceListener[] listeners = new SequenceListener[priorListeners.length + 1];
        listeners[0] = listener;
        for (int i = 1; i < listeners.length; ++i) {
            listeners[i] = priorListeners[i - 1];
        }
        listener = new FactoredSequenceListener(listeners);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)sentence.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        return sentence;
    }

    public List<IN> classifyGibbsUsingPrior(List<IN> sentence, SequenceModel priorModel, SequenceListener priorListener, double model1Wt, double model2Wt) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        CRFCliqueTree<String> cliqueTree;
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(sentence);
        List<IN> newDocument = sentence;
        if (this.flags.useReverse) {
            newDocument = new ArrayList<IN>(sentence);
            Collections.reverse(newDocument);
        }
        SequenceModel model = cliqueTree = this.getCliqueTree(p);
        SequenceListener listener = cliqueTree;
        model = new FactoredSequenceModel(model, priorModel, model1Wt, model2Wt);
        listener = new FactoredSequenceListener(listener, priorListener);
        SequenceGibbsSampler sampler = new SequenceGibbsSampler(0, 0, listener);
        int[] sequence = new int[cliqueTree.length()];
        if (this.flags.initViterbi) {
            TestSequenceModel testSequenceModel = new TestSequenceModel(cliqueTree);
            ExactBestSequenceFinder tagInference = new ExactBestSequenceFinder();
            int[] bestSequence = tagInference.bestSequence(testSequenceModel);
            System.arraycopy(bestSequence, this.windowSize - 1, sequence, 0, sequence.length);
        } else {
            int[] initialSequence = SequenceGibbsSampler.getRandomSequence(model);
            System.arraycopy(initialSequence, 0, sequence, 0, sequence.length);
        }
        SequenceGibbsSampler.verbose = 0;
        if (this.flags.annealingType.equalsIgnoreCase("linear")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getLinearSchedule(1.0, this.flags.numSamples), sequence);
        } else if (this.flags.annealingType.equalsIgnoreCase("exp") || this.flags.annealingType.equalsIgnoreCase("exponential")) {
            sequence = sampler.findBestUsingAnnealing(model, CoolingSchedule.getExponentialSchedule(1.0, this.flags.annealingRate, this.flags.numSamples), sequence);
        } else {
            throw new RuntimeException("No annealing type specified");
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        int dsize = newDocument.size();
        for (int j = 0; j < dsize; ++j) {
            CoreMap wi = (CoreMap)sentence.get(j);
            if (wi == null) {
                throw new RuntimeException("");
            }
            if (this.classIndex == null) {
                throw new RuntimeException("");
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.classIndex.get(sequence[j]));
        }
        if (this.flags.useReverse) {
            Collections.reverse(sentence);
        }
        return sentence;
    }

    @Override
    public void printProbsDocument(List<IN> document) {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(p);
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            System.out.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + '\t');
            Iterator iter = this.classIndex.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                int index = this.classIndex.indexOf(label);
                double prob = cliqueTree.prob(i, index);
                System.out.print(label + '=' + prob);
                if (iter.hasNext()) {
                    System.out.print("\t");
                    continue;
                }
                System.out.print("\n");
            }
        }
    }

    public void printFirstOrderProbs(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = false;
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printFirstOrderProbsDocuments(docs);
    }

    public void printFactorTable(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = false;
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printFactorTableDocuments(docs);
    }

    public void printFirstOrderProbsDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printFirstOrderProbsDocument(doc);
            System.out.println();
        }
    }

    public void printFactorTableDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printFactorTableDocument(doc);
            System.out.println();
        }
    }

    public List<CRFCliqueTree<String>> getCliqueTrees(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = false;
        ArrayList<CRFCliqueTree<String>> cts = new ArrayList<CRFCliqueTree<String>>();
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        for (List<IN> doc : docs) {
            cts.add(this.getCliqueTree(doc));
        }
        return cts;
    }

    public CRFCliqueTree<String> getCliqueTree(Triple<int[][][], int[], double[][][]> p) {
        int[][][] data = p.first();
        double[][][] featureVal = p.third();
        return CRFCliqueTree.getCalibratedCliqueTree(data, this.labelIndices, this.classIndex.size(), this.classIndex, this.flags.backgroundSymbol, this.getCliquePotentialFunction(), featureVal);
    }

    public CRFCliqueTree<String> getCliqueTree(List<IN> document) {
        Triple<int[][][], int[], double[][][]> p = this.documentToDataAndLabels(document);
        return this.getCliqueTree(p);
    }

    public void printFactorTableDocument(List<IN> document) {
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(document);
        FactorTable[] factorTables = cliqueTree.getFactorTables();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < factorTables.length; ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            sb.append((String)wi.get(CoreAnnotations.TextAnnotation.class));
            sb.append("\t");
            FactorTable table = factorTables[i];
            double totalMass = table.totalMass();
            for (int j = 0; j < table.size(); ++j) {
                int[] arr = table.toArray(j);
                sb.append((String)this.classIndex.get(arr[0]));
                sb.append(":");
                sb.append((String)this.classIndex.get(arr[1]));
                sb.append(":");
                sb.append(table.getValue(j) - totalMass);
                sb.append(" ");
            }
            sb.append("\n");
        }
        System.out.print(sb.toString());
    }

    public void printFirstOrderProbsDocument(List<IN> document) {
        CRFCliqueTree<String> cliqueTree = this.getCliqueTree(document);
        for (int i = 0; i < cliqueTree.length(); ++i) {
            CoreMap wi = (CoreMap)document.get(i);
            System.out.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + '\t');
            Iterator iter = this.classIndex.iterator();
            while (iter.hasNext()) {
                String label = (String)iter.next();
                int index = this.classIndex.indexOf(label);
                if (i == 0) {
                    double prob = cliqueTree.prob(i, index);
                    System.out.print(label + '=' + prob);
                    if (iter.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                    continue;
                }
                Iterator iter1 = this.classIndex.iterator();
                while (iter1.hasNext()) {
                    String label1 = (String)iter1.next();
                    int index1 = this.classIndex.indexOf(label1);
                    double prob = cliqueTree.prob(i, new int[]{index1, index});
                    System.out.print(label1 + '_' + label + '=' + prob);
                    if (iter.hasNext() || iter1.hasNext()) {
                        System.out.print("\t");
                        continue;
                    }
                    System.out.print("\n");
                }
            }
        }
    }

    @Override
    public void train(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        Timing timer = new Timing();
        timer.start();
        if (this.flags.numOfSlices > 0) {
            System.err.println("Taking " + this.flags.numOfSlices + " out of " + this.flags.totalDataSlice + " slices of data for training");
            ArrayList<List<IN>> docsToShuffle = new ArrayList<List<IN>>();
            for (List<IN> doc : docs) {
                docsToShuffle.add(doc);
            }
            Collections.shuffle(docsToShuffle, this.random);
            int cutOff = (int)((double)docsToShuffle.size() / ((double)this.flags.totalDataSlice + 0.0) * (double)this.flags.numOfSlices);
            docs = docsToShuffle.subList(0, cutOff);
        }
        this.makeAnswerArraysAndTagIndex(docs);
        long elapsedMs = timer.stop();
        System.err.println("Time to convert docs to feature indices: " + Timing.toSecondsString(elapsedMs) + " seconds");
        if (this.flags.exportFeatures != null) {
            timer.start();
            CRFFeatureExporter<IN> featureExporter = new CRFFeatureExporter<IN>(this);
            featureExporter.printFeatures(this.flags.exportFeatures, docs);
            elapsedMs = timer.stop();
            System.err.println("Time to export features: " + Timing.toSecondsString(elapsedMs) + " seconds");
        }
        for (int i = 0; i <= this.flags.numTimesPruneFeatures; ++i) {
            List<List<CRFDatum<Collection<String>, String>>> processedData;
            timer.start();
            Triple<int[][][][], int[][], double[][][][]> dataAndLabelsAndFeatureVals = this.documentsToDataAndLabels(docs);
            elapsedMs = timer.stop();
            System.err.println("Time to convert docs to data/labels: " + Timing.toSecondsString(elapsedMs) + " seconds");
            Evaluator[] evaluators = null;
            if (this.flags.evaluateIters > 0 || this.flags.terminateOnEvalImprovement) {
                CRFClassifierEvaluator<IN> crfEvaluator;
                ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>();
                if (this.flags.useMemoryEvaluator) {
                    evaluatorList.add(new MemoryEvaluator());
                }
                if (this.flags.evaluateTrain) {
                    crfEvaluator = new CRFClassifierEvaluator<IN>("Train set", this);
                    ArrayList<Triple<int[][][], int[], double[][][]>> trainDataAndLabels = new ArrayList<Triple<int[][][], int[], double[][][]>>();
                    int[][][][] data = dataAndLabelsAndFeatureVals.first();
                    int[][] labels = dataAndLabelsAndFeatureVals.second();
                    double[][][][] featureVal = dataAndLabelsAndFeatureVals.third();
                    for (int j = 0; j < data.length; ++j) {
                        Triple<int[][][], int[], double[][][]> p = new Triple<int[][][], int[], double[][][]>(data[j], labels[j], featureVal[j]);
                        trainDataAndLabels.add(p);
                    }
                    crfEvaluator.setTestData(docs, trainDataAndLabels);
                    if (this.flags.evalCmd.length() > 0) {
                        crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    }
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFile != null) {
                    crfEvaluator = new CRFClassifierEvaluator("Test set (" + this.flags.testFile + ")", this);
                    ObjectBank<List<IN>> testObjBank = this.makeObjectBankFromFile(this.flags.testFile, readerAndWriter);
                    ArrayList<List<IN>> testDocs = new ArrayList<List<IN>>();
                    for (List<IN> doc : testObjBank) {
                        testDocs.add(doc);
                    }
                    List<Triple<int[][][], int[], double[][][]>> testDataAndLabels = this.documentsToDataAndLabelsList(testDocs);
                    crfEvaluator.setTestData(testDocs, testDataAndLabels);
                    if (this.flags.evalCmd.length() > 0) {
                        crfEvaluator.setEvalCmd(this.flags.evalCmd);
                    }
                    evaluatorList.add(crfEvaluator);
                }
                if (this.flags.testFiles != null) {
                    String[] testFiles;
                    for (String testFile : testFiles = this.flags.testFiles.split(",")) {
                        CRFClassifierEvaluator<IN> crfEvaluator2 = new CRFClassifierEvaluator<IN>("Test set (" + testFile + ")", this);
                        ObjectBank<List<IN>> testObjBank = this.makeObjectBankFromFile(testFile, readerAndWriter);
                        List<Triple<int[][][], int[], double[][][]>> testDataAndLabels = this.documentsToDataAndLabelsList(testObjBank);
                        crfEvaluator2.setTestData(testObjBank, testDataAndLabels);
                        if (this.flags.evalCmd.length() > 0) {
                            crfEvaluator2.setEvalCmd(this.flags.evalCmd);
                        }
                        evaluatorList.add(crfEvaluator2);
                    }
                }
                evaluators = new Evaluator[evaluatorList.size()];
                evaluatorList.toArray(evaluators);
            }
            if (this.flags.numTimesPruneFeatures == i) {
                docs = null;
            }
            File featIndexFile = null;
            int numFeatures = this.featureIndex.size();
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    System.err.println("Writing feature index to temporary file.");
                    featIndexFile = IOUtils.writeObjectToTempFile(this.featureIndex, "featIndex" + i + ".tmp");
                    this.featureIndex = null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not open temporary feature index file for writing.");
                }
            }
            Object data = dataAndLabelsAndFeatureVals.first();
            Object labels = dataAndLabelsAndFeatureVals.second();
            Object featureVals = dataAndLabelsAndFeatureVals.third();
            if (this.flags.loadProcessedData != null && (processedData = CRFClassifier.loadProcessedData(this.flags.loadProcessedData)) != null) {
                int[][][][] allData = new int[((int[][][][])data).length + processedData.size()][][][];
                double[][][][] allFeatureVals = new double[((double[][][][])featureVals).length + processedData.size()][][][];
                int[][] allLabels = new int[((int[][])labels).length + processedData.size()][];
                System.arraycopy(data, 0, allData, 0, ((int[][][][])data).length);
                System.arraycopy(labels, 0, allLabels, 0, ((int[][])labels).length);
                System.arraycopy(featureVals, 0, allFeatureVals, 0, ((double[][][][])featureVals).length);
                this.addProcessedData(processedData, allData, allLabels, allFeatureVals, ((int[][][][])data).length);
                data = allData;
                labels = allLabels;
                featureVals = allFeatureVals;
            }
            if (this.flags.nonLinearCRF) {
                int jj;
                Comparable params;
                AbstractCachingDiffFunction func;
                if (this.flags.secondOrderNonLinear) {
                    int ii;
                    func = new CRFNonLinearSecondOrderLogConditionalObjectiveFunction((int[][][][])data, (int[][])labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags, this.nodeFeatureIndicesMap.size(), this.edgeFeatureIndicesMap.size());
                    this.cliquePotentialFunctionHelper = func;
                    double[] allWeights = this.trainWeightsUsingNonLinearCRF(func, evaluators);
                    params = ((CRFNonLinearSecondOrderLogConditionalObjectiveFunction)func).separateWeights(allWeights);
                    this.inputLayerWeights4Edge = ((Quadruple)params).first();
                    this.outputLayerWeights4Edge = (double[][])((Quadruple)params).second();
                    this.inputLayerWeights = (double[][])((Quadruple)params).third();
                    this.outputLayerWeights = (double[][])((Quadruple)params).fourth();
                    System.err.println("Edge Output Layer Weights:");
                    for (ii = 0; ii < this.outputLayerWeights4Edge.length; ++ii) {
                        System.err.print("[ ");
                        for (jj = 0; jj < this.outputLayerWeights4Edge[ii].length; ++jj) {
                            System.err.print(this.outputLayerWeights4Edge[ii][jj] + " ");
                        }
                        System.err.println("]");
                    }
                    System.err.println("Node Output Layer Weights:");
                    for (ii = 0; ii < this.outputLayerWeights.length; ++ii) {
                        System.err.print("[ ");
                        for (jj = 0; jj < this.outputLayerWeights[ii].length; ++jj) {
                            System.err.print(this.outputLayerWeights[ii][jj] + " ");
                        }
                        System.err.println("]");
                    }
                } else {
                    func = new CRFNonLinearLogConditionalObjectiveFunction((int[][][][])data, (int[][])labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags, this.nodeFeatureIndicesMap.size(), this.edgeFeatureIndicesMap.size(), (double[][][][])featureVals);
                    if (this.flags.useAdaGradFOBOS) {
                        ((CRFNonLinearLogConditionalObjectiveFunction)func).gradientsOnly = true;
                    }
                    this.cliquePotentialFunctionHelper = func;
                    double[] allWeights = this.trainWeightsUsingNonLinearCRF(func, evaluators);
                    params = ((CRFNonLinearLogConditionalObjectiveFunction)func).separateWeights(allWeights);
                    this.linearWeights = (double[][])((Triple)params).first();
                    this.inputLayerWeights = (double[][])((Triple)params).second();
                    this.outputLayerWeights = (double[][])((Triple)params).third();
                    if (this.flags.printWeights) {
                        int ii;
                        System.err.println("Linear Layer Weights:");
                        for (ii = 0; ii < this.linearWeights.length; ++ii) {
                            System.err.print("[ ");
                            for (jj = 0; jj < this.linearWeights[ii].length; ++jj) {
                                System.err.print(this.linearWeights[ii][jj] + " ");
                            }
                            System.err.println("]");
                        }
                        System.err.println("Input Layer Weights:");
                        for (ii = 0; ii < this.inputLayerWeights.length; ++ii) {
                            System.err.print("[ ");
                            for (jj = 0; jj < this.inputLayerWeights[ii].length; ++jj) {
                                System.err.print(this.inputLayerWeights[ii][jj] + " ");
                            }
                            System.err.println("]");
                        }
                        System.err.println("Output Layer Weights:");
                        for (ii = 0; ii < this.outputLayerWeights.length; ++ii) {
                            System.err.print("[ ");
                            for (jj = 0; jj < this.outputLayerWeights[ii].length; ++jj) {
                                System.err.print(this.outputLayerWeights[ii][jj] + " ");
                            }
                            System.err.println("]");
                        }
                    }
                }
            } else {
                double[] oneDimWeights = null;
                oneDimWeights = this.flags.useFloat ? this.trainWeightsUsingFloatCRF((int[][][][])data, (int[][])labels, i) : (this.flags.numLopExpert > 1 ? this.trainWeightsUsingLopCRF(numFeatures, (int[][][][])data, (int[][])labels, evaluators, i) : this.trainWeightsUsingDoubleCRF((int[][][][])data, (int[][])labels, evaluators, i, (double[][][][])featureVals));
                this.weights = CRFLogConditionalObjectiveFunction.to2D(oneDimWeights, this.labelIndices, this.map);
            }
            if (this.flags.saveFeatureIndexToDisk) {
                try {
                    System.err.println("Reading temporary feature index file.");
                    this.featureIndex = (Index)IOUtils.readObjectFromFile(featIndexFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not open temporary feature index file for reading.");
                }
            }
            if (i == this.flags.numTimesPruneFeatures) continue;
            this.dropFeaturesBelowThreshold(this.flags.featureDiffThresh);
            System.err.println("Removing features with weight below " + this.flags.featureDiffThresh + " and retraining...");
        }
    }

    protected double[] trainWeightsUsingFloatCRF(int[][][][] data, int[][] labels, int pruneFeatureItr) {
        float[] initialWeights;
        QNMinimizer minimizer;
        CRFLogConditionalObjectiveFloatFunction func = new CRFLogConditionalObjectiveFloatFunction(data, labels, this.featureIndex, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.backgroundSymbol, this.flags.sigma);
        this.cliquePotentialFunctionHelper = func;
        if (this.flags.interimOutputFreq != 0) {
            ResultStoringFloatMonitor monitor = new ResultStoringFloatMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
            minimizer = new QNMinimizer(monitor);
        } else {
            minimizer = new QNMinimizer();
        }
        if (pruneFeatureItr == 0) {
            minimizer.setM(this.flags.QNsize);
        } else {
            minimizer.setM(this.flags.QNsize2);
        }
        if (this.flags.initialWeights == null) {
            initialWeights = func.initial();
        } else {
            try {
                System.err.println("Reading initial weights from file " + this.flags.initialWeights);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                initialWeights = ConvertByteArray.readFloatArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from float initial weight file " + this.flags.initialWeights);
            }
        }
        System.err.println("numWeights: " + initialWeights.length);
        float[] weights = minimizer.minimize(func, (float)this.flags.tolerance, initialWeights);
        return ArrayMath.floatArrayToDoubleArray(weights);
    }

    protected void pruneNodeFeatureIndices(int totalNumOfFeatureSlices, int numOfFeatureSlices) {
        int index;
        String f;
        int numOfNodeFeatures = this.nodeFeatureIndicesMap.size();
        int beginIndex = 0;
        int endIndex = Math.min((int)((double)numOfNodeFeatures / ((double)totalNumOfFeatureSlices + 0.0) * (double)numOfFeatureSlices), numOfNodeFeatures);
        List<Integer> nodeFeatureOriginalIndices = this.nodeFeatureIndicesMap.objectsList();
        List<Integer> edgeFeatureOriginalIndices = this.edgeFeatureIndicesMap.objectsList();
        HashIndex<Integer> newNodeFeatureIndex = new HashIndex<Integer>();
        HashIndex<Integer> newEdgeFeatureIndex = new HashIndex<Integer>();
        HashIndex<String> newFeatureIndex = new HashIndex<String>();
        for (int i = beginIndex; i < endIndex; ++i) {
            int oldIndex = nodeFeatureOriginalIndices.get(i);
            f = this.featureIndex.get(oldIndex);
            index = newFeatureIndex.indexOf(f, true);
            newNodeFeatureIndex.add(index);
        }
        for (Integer edgeFIndex : edgeFeatureOriginalIndices) {
            f = this.featureIndex.get(edgeFIndex);
            index = newFeatureIndex.indexOf(f, true);
            newEdgeFeatureIndex.add(index);
        }
        this.nodeFeatureIndicesMap = newNodeFeatureIndex;
        this.edgeFeatureIndicesMap = newEdgeFeatureIndex;
        int[] newMap = new int[newFeatureIndex.size()];
        for (int i = 0; i < newMap.length; ++i) {
            int index2 = this.featureIndex.indexOf((String)newFeatureIndex.get(i));
            newMap[i] = this.map[index2];
        }
        this.map = newMap;
        this.featureIndex = newFeatureIndex;
    }

    protected int[][][][] createPartialDataForLOP(int lopIter, int[][][][] data) {
        int[] oldFeatures = null;
        int oldFeatureIndex = -1;
        ArrayList<Integer> newFeatureList = new ArrayList<Integer>(1000);
        Set<Integer> featureIndicesSet = this.featureIndicesSetArray.get(lopIter);
        int[][][][] newData = new int[data.length][][][];
        for (int i = 0; i < data.length; ++i) {
            newData[i] = new int[data[i].length][][];
            for (int j = 0; j < data[i].length; ++j) {
                newData[i][j] = new int[data[i][j].length][];
                for (int k = 0; k < data[i][j].length; ++k) {
                    int l;
                    oldFeatures = data[i][j][k];
                    newFeatureList.clear();
                    for (l = 0; l < oldFeatures.length; ++l) {
                        oldFeatureIndex = oldFeatures[l];
                        if (!featureIndicesSet.contains(oldFeatureIndex)) continue;
                        newFeatureList.add(oldFeatureIndex);
                    }
                    newData[i][j][k] = new int[newFeatureList.size()];
                    for (l = 0; l < newFeatureList.size(); ++l) {
                        newData[i][j][k][l] = (Integer)newFeatureList.get(l);
                    }
                }
            }
        }
        return newData;
    }

    protected void getFeatureBoundaryIndices(int numFeatures, int numLopExpert) {
        int lopIter;
        int interval = numFeatures / numLopExpert;
        this.featureIndicesSetArray = new ArrayList<Set<Integer>>(numLopExpert);
        this.featureIndicesListArray = new ArrayList<List<Integer>>(numLopExpert);
        for (int i = 0; i < numLopExpert; ++i) {
            this.featureIndicesSetArray.add(Generics.newHashSet(interval));
            this.featureIndicesListArray.add(Generics.newArrayList(interval));
        }
        if (this.flags.randomLopFeatureSplit) {
            for (int fIndex = 0; fIndex < numFeatures; ++fIndex) {
                int lopIter2 = this.random.nextInt(numLopExpert);
                this.featureIndicesSetArray.get(lopIter2).add(fIndex);
                this.featureIndicesListArray.get(lopIter2).add(fIndex);
            }
        } else {
            for (lopIter = 0; lopIter < numLopExpert; ++lopIter) {
                int beginIndex = lopIter * interval;
                int endIndex = (lopIter + 1) * interval;
                if (lopIter == numLopExpert - 1) {
                    endIndex = numFeatures;
                }
                for (int fIndex = beginIndex; fIndex < endIndex; ++fIndex) {
                    this.featureIndicesSetArray.get(lopIter).add(fIndex);
                    this.featureIndicesListArray.get(lopIter).add(fIndex);
                }
            }
        }
        for (lopIter = 0; lopIter < numLopExpert; ++lopIter) {
            Collections.sort(this.featureIndicesListArray.get(lopIter));
        }
    }

    protected double[] trainWeightsUsingLopCRF(int numFeatures, int[][][][] data, int[][] labels, Evaluator[] evaluators, int pruneFeatureItr) {
        double[] initialScales;
        int numLopExpert = this.flags.numLopExpert;
        double[][] lopExpertWeights = new double[numLopExpert][];
        this.getFeatureBoundaryIndices(numFeatures, numLopExpert);
        if (this.flags.initialLopWeights != null) {
            try {
                String line;
                System.err.println("Reading initial LOP weights from file " + this.flags.initialLopWeights + " ...");
                BufferedReader br = IOUtils.readerFromString(this.flags.initialLopWeights);
                ArrayList<double[]> listOfWeights = new ArrayList<double[]>(numLopExpert);
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    String[] parts = line.split("\t");
                    double[] wArr = new double[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        wArr[i] = Double.parseDouble(parts[i]);
                    }
                    listOfWeights.add(wArr);
                }
                assert (listOfWeights.size() == numLopExpert);
                System.err.println("Done!");
                for (int i = 0; i < numLopExpert; ++i) {
                    lopExpertWeights[i] = (double[])listOfWeights.get(i);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from double initial LOP weights file " + this.flags.initialLopWeights);
            }
        } else {
            for (int lopIter = 0; lopIter < numLopExpert; ++lopIter) {
                int[][][][] partialData = this.createPartialDataForLOP(lopIter, data);
                lopExpertWeights[lopIter] = this.flags.randomLopWeights ? this.initWeightsUsingDoubleCRF(partialData, labels, evaluators, pruneFeatureItr) : this.trainWeightsUsingDoubleCRF(partialData, labels, evaluators, pruneFeatureItr, null);
            }
            if (this.flags.includeFullCRFInLOP) {
                double[][] newLopExpertWeights = new double[numLopExpert + 1][];
                System.arraycopy(lopExpertWeights, 0, newLopExpertWeights, 0, lopExpertWeights.length);
                newLopExpertWeights[numLopExpert] = this.flags.randomLopWeights ? this.initWeightsUsingDoubleCRF(data, labels, evaluators, pruneFeatureItr) : this.trainWeightsUsingDoubleCRF(data, labels, evaluators, pruneFeatureItr, null);
                Set<Integer> newSet = Generics.newHashSet(numFeatures);
                ArrayList<Integer> newList = new ArrayList<Integer>(numFeatures);
                for (int fIndex = 0; fIndex < numFeatures; ++fIndex) {
                    newSet.add(fIndex);
                    newList.add(fIndex);
                }
                this.featureIndicesSetArray.add(newSet);
                this.featureIndicesListArray.add(newList);
                ++numLopExpert;
                lopExpertWeights = newLopExpertWeights;
            }
        }
        CRFLogConditionalObjectiveFunctionForLOP func = new CRFLogConditionalObjectiveFunctionForLOP(data, labels, lopExpertWeights, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.backgroundSymbol, numLopExpert, this.featureIndicesSetArray, this.featureIndicesListArray, this.flags.backpropLopTraining);
        this.cliquePotentialFunctionHelper = func;
        Minimizer minimizer = this.getMinimizer(0, evaluators);
        if (this.flags.initialLopScales == null) {
            initialScales = func.initial();
        } else {
            try {
                System.err.println("Reading initial LOP scales from file " + this.flags.initialLopScales);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialLopScales))));
                initialScales = ConvertByteArray.readDoubleArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from double initial LOP scales file " + this.flags.initialLopScales);
            }
        }
        double[] learnedParams = minimizer.minimize(func, this.flags.tolerance, initialScales);
        double[] rawScales = func.separateLopScales(learnedParams);
        double[] lopScales = ArrayMath.softmax(rawScales);
        System.err.println("After SoftMax Transformation, learned scales are:");
        for (int lopIter = 0; lopIter < numLopExpert; ++lopIter) {
            System.err.println("lopScales[" + lopIter + "] = " + lopScales[lopIter]);
        }
        Object learnedLopExpertWeights = lopExpertWeights;
        if (this.flags.backpropLopTraining) {
            learnedLopExpertWeights = func.separateLopExpertWeights(learnedParams);
        }
        return CRFLogConditionalObjectiveFunctionForLOP.combineAndScaleLopWeights(numLopExpert, learnedLopExpertWeights, lopScales);
    }

    protected double[] initWeightsUsingDoubleCRF(int[][][][] data, int[][] labels, Evaluator[] evaluators, int pruneFeatureItr) {
        CRFLogConditionalObjectiveFunction func = new CRFLogConditionalObjectiveFunction(data, labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.priorType, this.flags.backgroundSymbol, this.flags.sigma, null);
        return func.initial();
    }

    protected double[] trainWeightsUsingNonLinearCRF(AbstractCachingDiffFunction func, Evaluator[] evaluators) {
        double[] initialWeights;
        Minimizer minimizer = this.getMinimizer(0, evaluators);
        if (this.flags.initialWeights == null) {
            initialWeights = func.initial();
        } else {
            try {
                System.err.println("Reading initial weights from file " + this.flags.initialWeights);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                initialWeights = ConvertByteArray.readDoubleArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from double initial weight file " + this.flags.initialWeights);
            }
        }
        System.err.println("numWeights: " + initialWeights.length);
        if (this.flags.testObjFunction) {
            StochasticDiffFunctionTester tester = new StochasticDiffFunctionTester(func);
            if (tester.testSumOfBatches(initialWeights, 1.0E-4)) {
                System.err.println("Testing complete... exiting");
                System.exit(1);
            } else {
                System.err.println("Testing failed....exiting");
                System.exit(1);
            }
        }
        if (this.flags.checkGradient) {
            if (func.gradientCheck()) {
                System.err.println("gradient check passed");
            } else {
                throw new RuntimeException("gradient check failed");
            }
        }
        return minimizer.minimize(func, this.flags.tolerance, initialWeights);
    }

    protected double[] trainWeightsUsingDoubleCRF(int[][][][] data, int[][] labels, Evaluator[] evaluators, int pruneFeatureItr, double[][][][] featureVals) {
        double[] initialWeights;
        int cliqueOutClass;
        int numCliqueTypeOutputClass;
        int cliqueType;
        int pIndex;
        CRFLogConditionalObjectiveFunction func = new CRFLogConditionalObjectiveFunction(data, labels, this.windowSize, this.classIndex, this.labelIndices, this.map, this.flags.priorType, this.flags.backgroundSymbol, this.flags.sigma, featureVals);
        this.cliquePotentialFunctionHelper = func;
        HashMap featureSets = null;
        if (this.flags.groupByOutputClass) {
            featureSets = new HashMap();
            if (this.flags.groupByFeatureTemplate) {
                pIndex = 0;
                for (int fIndex = 0; fIndex < this.map.length; ++fIndex) {
                    cliqueType = this.map[fIndex];
                    numCliqueTypeOutputClass = this.labelIndices.get(this.map[fIndex]).size();
                    for (cliqueOutClass = 0; cliqueOutClass < numCliqueTypeOutputClass; ++cliqueOutClass) {
                        String name = "c:" + cliqueType + "-o:" + cliqueOutClass + "-g:" + this.featureIndexToTemplateIndex.get(fIndex);
                        if (featureSets.containsKey(name)) {
                            ((Set)featureSets.get(name)).add(pIndex);
                        } else {
                            HashSet<Integer> newSet = new HashSet<Integer>();
                            newSet.add(pIndex);
                            featureSets.put(name, newSet);
                        }
                        ++pIndex;
                    }
                }
            } else {
                pIndex = 0;
                for (int cliqueType2 : this.map) {
                    int numCliqueTypeOutputClass2 = this.labelIndices.get(cliqueType2).size();
                    for (int cliqueOutClass2 = 0; cliqueOutClass2 < numCliqueTypeOutputClass2; ++cliqueOutClass2) {
                        String name = "c:" + cliqueType2 + "-o:" + cliqueOutClass2;
                        if (featureSets.containsKey(name)) {
                            ((Set)featureSets.get(name)).add(pIndex);
                        } else {
                            HashSet<Integer> newSet = new HashSet<Integer>();
                            newSet.add(pIndex);
                            featureSets.put(name, newSet);
                        }
                        ++pIndex;
                    }
                }
            }
        } else if (this.flags.groupByFeatureTemplate) {
            featureSets = new HashMap();
            pIndex = 0;
            for (int fIndex = 0; fIndex < this.map.length; ++fIndex) {
                cliqueType = this.map[fIndex];
                numCliqueTypeOutputClass = this.labelIndices.get(this.map[fIndex]).size();
                for (cliqueOutClass = 0; cliqueOutClass < numCliqueTypeOutputClass; ++cliqueOutClass) {
                    String name = "c:" + cliqueType + "-g:" + this.featureIndexToTemplateIndex.get(fIndex);
                    if (featureSets.containsKey(name)) {
                        ((Set)featureSets.get(name)).add(pIndex);
                    } else {
                        HashSet<Integer> newSet = new HashSet<Integer>();
                        newSet.add(pIndex);
                        featureSets.put(name, newSet);
                    }
                    ++pIndex;
                }
            }
        }
        if (featureSets != null) {
            int[][] fg = new int[featureSets.size()][];
            System.err.println("After feature grouping, total of " + fg.length + " groups");
            int count = 0;
            for (Set aSet : featureSets.values()) {
                fg[count] = new int[aSet.size()];
                int i = 0;
                for (Integer val : aSet) {
                    fg[count][i++] = val;
                }
                ++count;
            }
            func.setFeatureGrouping(fg);
        }
        Minimizer minimizer = this.getMinimizer(pruneFeatureItr, evaluators);
        if (this.flags.initialWeights == null) {
            initialWeights = func.initial();
        } else {
            try {
                System.err.println("Reading initial weights from file " + this.flags.initialWeights);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.flags.initialWeights))));
                initialWeights = ConvertByteArray.readDoubleArr(dis);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read from double initial weight file " + this.flags.initialWeights);
            }
        }
        System.err.println("numWeights: " + initialWeights.length);
        if (this.flags.testObjFunction) {
            StochasticDiffFunctionTester tester = new StochasticDiffFunctionTester(func);
            if (tester.testSumOfBatches(initialWeights, 1.0E-4)) {
                System.err.println("Testing complete... exiting");
                System.exit(1);
            } else {
                System.err.println("Testing failed....exiting");
                System.exit(1);
            }
        }
        if (this.flags.checkGradient) {
            if (func.gradientCheck()) {
                System.err.println("gradient check passed");
            } else {
                throw new RuntimeException("gradient check failed");
            }
        }
        return minimizer.minimize(func, this.flags.tolerance, initialWeights);
    }

    protected Minimizer getMinimizer() {
        return this.getMinimizer(0, null);
    }

    protected Minimizer getMinimizer(int featurePruneIteration, Evaluator[] evaluators) {
        Minimizer<DiffFunction> minimizer = null;
        if (this.flags.useQN) {
            int QNmem = featurePruneIteration == 0 ? this.flags.QNsize : this.flags.QNsize2;
            if (this.flags.interimOutputFreq != 0) {
                ResultStoringMonitor monitor = new ResultStoringMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                minimizer = new QNMinimizer(monitor, QNmem, this.flags.useRobustQN);
            } else {
                minimizer = new QNMinimizer(QNmem, this.flags.useRobustQN);
            }
            minimizer.terminateOnEvalImprovement(this.flags.terminateOnEvalImprovement);
            minimizer.setTerminateOnEvalImprovementNumOfEpoch(this.flags.terminateOnEvalImprovementNumOfEpoch);
            minimizer.suppressTestPrompt(this.flags.suppressTestDebug);
            if (this.flags.useOWLQN) {
                minimizer.useOWLQN(this.flags.useOWLQN, this.flags.priorLambda);
            }
        } else if (this.flags.useInPlaceSGD) {
            StochasticInPlaceMinimizer<DiffFunction> sgdMinimizer = new StochasticInPlaceMinimizer<DiffFunction>(this.flags.sigma, this.flags.SGDPasses, this.flags.tuneSampleSize, this.flags.stochasticBatchSize);
            if (this.flags.useSGDtoQN) {
                QNMinimizer qnMinimizer;
                int QNmem = featurePruneIteration == 0 ? this.flags.QNsize : this.flags.QNsize2;
                if (this.flags.interimOutputFreq != 0) {
                    ResultStoringMonitor monitor = new ResultStoringMonitor(this.flags.interimOutputFreq, this.flags.serializeTo);
                    qnMinimizer = new QNMinimizer(monitor, QNmem, this.flags.useRobustQN);
                } else {
                    qnMinimizer = new QNMinimizer(QNmem, this.flags.useRobustQN);
                }
                minimizer = new HybridMinimizer(sgdMinimizer, qnMinimizer, this.flags.SGDPasses);
            } else {
                minimizer = sgdMinimizer;
            }
        } else if (this.flags.useAdaGradFOBOS) {
            minimizer = new SGDWithAdaGradAndFOBOS(this.flags.initRate, this.flags.priorLambda, this.flags.SGDPasses, this.flags.tuneSampleSize, this.flags.stochasticBatchSize, this.flags.priorType, this.flags.priorAlpha);
            ((SGDWithAdaGradAndFOBOS)minimizer).terminateOnEvalImprovement(this.flags.terminateOnEvalImprovement);
            ((SGDWithAdaGradAndFOBOS)minimizer).setTerminateOnEvalImprovementNumOfEpoch(this.flags.terminateOnEvalImprovementNumOfEpoch);
            ((SGDWithAdaGradAndFOBOS)minimizer).suppressTestPrompt(this.flags.suppressTestDebug);
        } else if (this.flags.useSGDtoQN) {
            minimizer = new SGDToQNMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.QNPasses, this.flags.SGD2QNhessSamples, this.flags.QNsize, this.flags.outputIterationsToFile);
        } else if (this.flags.useSMD) {
            minimizer = new SMDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.stochasticMethod, this.flags.SGDPasses);
        } else if (this.flags.useSGD) {
            minimizer = new SGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize);
        } else if (this.flags.useScaledSGD) {
            minimizer = new ScaledSGDMinimizer(this.flags.initialGain, this.flags.stochasticBatchSize, this.flags.SGDPasses, this.flags.scaledSGDMethod);
        } else if (this.flags.l1reg > 0.0) {
            minimizer = (Minimizer)ReflectionLoading.loadByReflection("edu.stanford.nlp.optimization.OWLQNMinimizer", this.flags.l1reg);
        }
        if (minimizer instanceof HasEvaluators) {
            ((HasEvaluators)((Object)minimizer)).setEvaluators(this.flags.evaluateIters, evaluators);
        }
        if (minimizer == null) {
            throw new RuntimeException("No minimizer assigned!");
        }
        return minimizer;
    }

    protected List<CRFDatum<? extends Collection<String>, ? extends CharSequence>> extractDatumSequence(int[][][] allData, int beginPosition, int endPosition, List<IN> labeledWordInfos) {
        CRFDatum datum;
        ArrayList<double[]> featureVals;
        ArrayList<List<Object>> cliqueFeatures;
        int position;
        ArrayList<CRFDatum<? extends Collection<String>, ? extends CharSequence>> result = new ArrayList<CRFDatum<? extends Collection<String>, ? extends CharSequence>>();
        int beginContext = beginPosition - this.windowSize + 1;
        if (beginContext < 0) {
            beginContext = 0;
        }
        for (position = beginContext; position < beginPosition; ++position) {
            cliqueFeatures = new ArrayList<List<Object>>();
            featureVals = new ArrayList<double[]>();
            for (int i = 0; i < this.windowSize; ++i) {
                cliqueFeatures.add(Collections.emptyList());
                featureVals.add(null);
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class), featureVals);
            result.add(datum);
        }
        for (position = beginPosition; position <= endPosition; ++position) {
            cliqueFeatures = new ArrayList();
            featureVals = new ArrayList();
            for (int i = 0; i < this.windowSize; ++i) {
                ArrayList<String> features = new ArrayList<String>();
                for (int j = 0; j < allData[position][i].length; ++j) {
                    features.add(this.featureIndex.get(allData[position][i][j]));
                }
                cliqueFeatures.add(features);
                featureVals.add(null);
            }
            datum = new CRFDatum(cliqueFeatures, ((CoreMap)labeledWordInfos.get(position)).get(CoreAnnotations.AnswerAnnotation.class), featureVals);
            result.add(datum);
        }
        return result;
    }

    protected void addProcessedData(List<List<CRFDatum<Collection<String>, String>>> processedData, int[][][][] data, int[][] labels, double[][][][] featureVals, int offset) {
        int pdSize = processedData.size();
        for (int i = 0; i < pdSize; ++i) {
            int dataIndex = i + offset;
            List<CRFDatum<Collection<String>, String>> document = processedData.get(i);
            int dsize = document.size();
            labels[dataIndex] = new int[dsize];
            data[dataIndex] = new int[dsize][][];
            if (featureVals != null) {
                featureVals[dataIndex] = new double[dsize][][];
            }
            for (int j = 0; j < dsize; ++j) {
                CRFDatum<Collection<String>, String> crfDatum = document.get(j);
                labels[dataIndex][j] = this.classIndex.indexOf(crfDatum.label());
                List<double[]> featureValList = null;
                if (featureVals != null) {
                    featureValList = crfDatum.asFeatureVals();
                }
                List<Collection<String>> cliques = crfDatum.asFeatures();
                int csize = cliques.size();
                data[dataIndex][j] = new int[csize][];
                if (featureVals != null) {
                    featureVals[dataIndex][j] = new double[csize][];
                }
                for (int k = 0; k < csize; ++k) {
                    Collection<String> features = cliques.get(k);
                    data[dataIndex][j][k] = new int[features.size()];
                    if (featureVals != null) {
                        featureVals[dataIndex][j][k] = featureValList.get(k);
                    }
                    int m = 0;
                    try {
                        for (String feature : features) {
                            if (this.featureIndex == null) {
                                System.out.println("Feature is NULL!");
                            }
                            data[dataIndex][j][k][m] = this.featureIndex.indexOf(feature);
                            ++m;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.printf("[index=%d, j=%d, k=%d, m=%d]%n", dataIndex, j, k, m);
                        System.err.println("data.length                    " + data.length);
                        System.err.println("data[dataIndex].length         " + data[dataIndex].length);
                        System.err.println("data[dataIndex][j].length      " + data[dataIndex][j].length);
                        System.err.println("data[dataIndex][j][k].length   " + data[dataIndex][j].length);
                        System.err.println("data[dataIndex][j][k][m]       " + data[dataIndex][j][k][m]);
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void saveProcessedData(List datums, String filename) {
        System.err.print("Saving processed data of size " + datums.size() + " to serialized file...");
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(filename));
            oos.writeObject(datums);
        }
        catch (IOException iOException) {
            IOUtils.closeIgnoringExceptions(oos);
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(oos);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(oos);
        System.err.println("done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<List<CRFDatum<Collection<String>, String>>> loadProcessedData(String filename) {
        System.err.print("Loading processed data from serialized file...");
        ObjectInputStream ois = null;
        List result = Collections.emptyList();
        try {
            ois = new ObjectInputStream(new FileInputStream(filename));
            result = (List)ois.readObject();
            IOUtils.closeIgnoringExceptions(ois);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(ois);
        }
        System.err.println("done. Got " + result.size() + " datums.");
        return result;
    }

    public void loadTextClassifier(String text, Properties props) throws ClassCastException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String[] featureFactoryName;
        int i2;
        String[] weightsValue;
        int weights2Length;
        int count;
        System.err.println("Loading Text Classifier from " + text);
        BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(text))));
        String line = br.readLine();
        String[] toks = line.split("\\t");
        if (!toks[0].equals("labelIndices.length=")) {
            throw new RuntimeException("format error");
        }
        int size = Integer.parseInt(toks[1]);
        this.labelIndices = new ArrayList<Index<CRFLabel>>(size);
        for (int labelIndicesIdx = 0; labelIndicesIdx < size; ++labelIndicesIdx) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].startsWith("labelIndices[") || !toks[0].endsWith("].size()=")) {
                throw new RuntimeException("format error");
            }
            int labelIndexSize = Integer.parseInt(toks[1]);
            this.labelIndices.add(new HashIndex());
            for (int count2 = 0; count2 < labelIndexSize; ++count2) {
                line = br.readLine();
                toks = line.split("\\t");
                int idx = Integer.parseInt(toks[0]);
                if (count2 != idx) {
                    throw new RuntimeException("format error");
                }
                String[] crflabelstr = toks[1].split(" ");
                int[] crflabel = new int[crflabelstr.length];
                for (int i = 0; i < crflabelstr.length; ++i) {
                    crflabel[i] = Integer.parseInt(crflabelstr[i]);
                }
                CRFLabel crfL = new CRFLabel(crflabel);
                this.labelIndices.get(labelIndicesIdx).add(crfL);
            }
        }
        System.err.printf("DEBUG: labelIndices.length=\t%d%n", this.labelIndices.size());
        for (int i = 0; i < this.labelIndices.size(); ++i) {
            System.err.printf("DEBUG: labelIndices[%d].size()=\t%d%n", i, this.labelIndices.get(i).size());
            for (int j = 0; j < this.labelIndices.get(i).size(); ++j) {
                int[] label = this.labelIndices.get(i).get(j).getLabel();
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int l : label) {
                    list.add(l);
                }
                System.err.printf("DEBUG: %d\t%s%n", j, StringUtils.join(list, " "));
            }
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("classIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int classIndexSize = Integer.parseInt(toks[1]);
        this.classIndex = new HashIndex();
        for (count = 0; count < classIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.classIndex.add(toks[1]);
        }
        System.err.printf("DEBUG: classIndex.size()=\t%d%n", this.classIndex.size());
        for (int i = 0; i < this.classIndex.size(); ++i) {
            System.err.printf("DEBUG: %d\t%s%n", i, this.classIndex.get(i));
        }
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("featureIndex.size()=")) {
            throw new RuntimeException("format error");
        }
        int featureIndexSize = Integer.parseInt(toks[1]);
        this.featureIndex = new HashIndex<String>();
        for (count = 0; count < featureIndexSize; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            int idx = Integer.parseInt(toks[0]);
            if (count != idx) {
                throw new RuntimeException("format error");
            }
            this.featureIndex.add(toks[1]);
        }
        System.err.printf("DEBUG: featureIndex.size()=\t%d%n", this.featureIndex.size());
        line = br.readLine();
        if (!line.equals("<flags>")) {
            throw new RuntimeException("format error");
        }
        Properties p = new Properties();
        line = br.readLine();
        while (!line.equals("</flags>")) {
            String[] keyValue = line.split("=");
            p.setProperty(keyValue[0], keyValue[1]);
            line = br.readLine();
        }
        this.flags = new SeqClassifierFlags(p);
        System.err.println("DEBUG: <flags>");
        System.err.print(this.flags.toString());
        System.err.println("DEBUG: </flags>");
        if (this.flags.useEmbedding) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("embeddings.size()=")) {
                throw new RuntimeException("format error in embeddings");
            }
            int embeddingSize = Integer.parseInt(toks[1]);
            this.embeddings = Generics.newHashMap(embeddingSize);
            for (count = 0; count < embeddingSize; ++count) {
                line = br.readLine().trim();
                toks = line.split("\\t");
                String word = toks[0];
                double[] arr = ArrayUtils.toDoubleArray(toks[1].split(" "));
                this.embeddings.put(word, arr);
            }
        }
        if (this.flags.nonLinearCRF) {
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("nodeFeatureIndicesMap.size()=")) {
                throw new RuntimeException("format error in nodeFeatureIndicesMap");
            }
            int nodeFeatureIndicesMapSize = Integer.parseInt(toks[1]);
            this.nodeFeatureIndicesMap = new HashIndex<Integer>();
            for (count = 0; count < nodeFeatureIndicesMapSize; ++count) {
                line = br.readLine();
                toks = line.split("\\t");
                int idx = Integer.parseInt(toks[0]);
                if (count != idx) {
                    throw new RuntimeException("format error");
                }
                this.nodeFeatureIndicesMap.add(Integer.parseInt(toks[1]));
            }
            System.err.printf("DEBUG: nodeFeatureIndicesMap.size()=\t%d%n", this.nodeFeatureIndicesMap.size());
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("edgeFeatureIndicesMap.size()=")) {
                throw new RuntimeException("format error");
            }
            int edgeFeatureIndicesMapSize = Integer.parseInt(toks[1]);
            this.edgeFeatureIndicesMap = new HashIndex<Integer>();
            for (count = 0; count < edgeFeatureIndicesMapSize; ++count) {
                line = br.readLine();
                toks = line.split("\\t");
                int idx = Integer.parseInt(toks[0]);
                if (count != idx) {
                    throw new RuntimeException("format error");
                }
                this.edgeFeatureIndicesMap.add(Integer.parseInt(toks[1]));
            }
            System.err.printf("DEBUG: edgeFeatureIndicesMap.size()=\t%d%n", this.edgeFeatureIndicesMap.size());
            int weightsLength = -1;
            if (this.flags.secondOrderNonLinear) {
                line = br.readLine();
                toks = line.split("\\t");
                if (!toks[0].equals("inputLayerWeights4Edge.length=")) {
                    throw new RuntimeException("format error");
                }
                weightsLength = Integer.parseInt(toks[1]);
                this.inputLayerWeights4Edge = new double[weightsLength][];
                for (count = 0; count < weightsLength; ++count) {
                    line = br.readLine();
                    toks = line.split("\\t");
                    weights2Length = Integer.parseInt(toks[0]);
                    this.inputLayerWeights4Edge[count] = new double[weights2Length];
                    weightsValue = toks[1].split(" ");
                    if (weights2Length != weightsValue.length) {
                        throw new RuntimeException("weights format error");
                    }
                    for (i2 = 0; i2 < weights2Length; ++i2) {
                        this.inputLayerWeights4Edge[count][i2] = Double.parseDouble(weightsValue[i2]);
                    }
                }
                System.err.printf("DEBUG: double[%d][] inputLayerWeights4Edge loaded%n", weightsLength);
                line = br.readLine();
                toks = line.split("\\t");
                if (!toks[0].equals("outputLayerWeights4Edge.length=")) {
                    throw new RuntimeException("format error");
                }
                weightsLength = Integer.parseInt(toks[1]);
                this.outputLayerWeights4Edge = new double[weightsLength][];
                for (count = 0; count < weightsLength; ++count) {
                    line = br.readLine();
                    toks = line.split("\\t");
                    weights2Length = Integer.parseInt(toks[0]);
                    this.outputLayerWeights4Edge[count] = new double[weights2Length];
                    weightsValue = toks[1].split(" ");
                    if (weights2Length != weightsValue.length) {
                        throw new RuntimeException("weights format error");
                    }
                    for (i2 = 0; i2 < weights2Length; ++i2) {
                        this.outputLayerWeights4Edge[count][i2] = Double.parseDouble(weightsValue[i2]);
                    }
                }
                System.err.printf("DEBUG: double[%d][] outputLayerWeights loaded%n", weightsLength);
            } else {
                line = br.readLine();
                toks = line.split("\\t");
                if (!toks[0].equals("linearWeights.length=")) {
                    throw new RuntimeException("format error");
                }
                weightsLength = Integer.parseInt(toks[1]);
                this.linearWeights = new double[weightsLength][];
                for (count = 0; count < weightsLength; ++count) {
                    line = br.readLine();
                    toks = line.split("\\t");
                    weights2Length = Integer.parseInt(toks[0]);
                    this.linearWeights[count] = new double[weights2Length];
                    weightsValue = toks[1].split(" ");
                    if (weights2Length != weightsValue.length) {
                        throw new RuntimeException("weights format error");
                    }
                    for (i2 = 0; i2 < weights2Length; ++i2) {
                        this.linearWeights[count][i2] = Double.parseDouble(weightsValue[i2]);
                    }
                }
                System.err.printf("DEBUG: double[%d][] linearWeights loaded%n", weightsLength);
            }
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("inputLayerWeights.length=")) {
                throw new RuntimeException("format error");
            }
            weightsLength = Integer.parseInt(toks[1]);
            this.inputLayerWeights = new double[weightsLength][];
            for (count = 0; count < weightsLength; ++count) {
                line = br.readLine();
                toks = line.split("\\t");
                weights2Length = Integer.parseInt(toks[0]);
                this.inputLayerWeights[count] = new double[weights2Length];
                weightsValue = toks[1].split(" ");
                if (weights2Length != weightsValue.length) {
                    throw new RuntimeException("weights format error");
                }
                for (i2 = 0; i2 < weights2Length; ++i2) {
                    this.inputLayerWeights[count][i2] = Double.parseDouble(weightsValue[i2]);
                }
            }
            System.err.printf("DEBUG: double[%d][] inputLayerWeights loaded%n", weightsLength);
            line = br.readLine();
            toks = line.split("\\t");
            if (!toks[0].equals("outputLayerWeights.length=")) {
                throw new RuntimeException("format error");
            }
            weightsLength = Integer.parseInt(toks[1]);
            this.outputLayerWeights = new double[weightsLength][];
            for (count = 0; count < weightsLength; ++count) {
                line = br.readLine();
                toks = line.split("\\t");
                weights2Length = Integer.parseInt(toks[0]);
                this.outputLayerWeights[count] = new double[weights2Length];
                weightsValue = toks[1].split(" ");
                if (weights2Length != weightsValue.length) {
                    throw new RuntimeException("weights format error");
                }
                for (i2 = 0; i2 < weights2Length; ++i2) {
                    this.outputLayerWeights[count][i2] = Double.parseDouble(weightsValue[i2]);
                }
            }
            System.err.printf("DEBUG: double[%d][] outputLayerWeights loaded%n", weightsLength);
        }
        if (!(featureFactoryName = (line = br.readLine()).split(" "))[0].equals("<featureFactory>") || !featureFactoryName[2].equals("</featureFactory>")) {
            throw new RuntimeException("format error");
        }
        this.featureFactory = (FeatureFactory)Class.forName(featureFactoryName[1]).newInstance();
        this.featureFactory.init(this.flags);
        this.reinit();
        line = br.readLine();
        String[] windowSizeName = line.split(" ");
        if (!windowSizeName[0].equals("<windowSize>") || !windowSizeName[2].equals("</windowSize>")) {
            throw new RuntimeException("format error");
        }
        this.windowSize = Integer.parseInt(windowSizeName[1]);
        line = br.readLine();
        toks = line.split("\\t");
        if (!toks[0].equals("weights.length=")) {
            throw new RuntimeException("format error");
        }
        int weightsLength = Integer.parseInt(toks[1]);
        this.weights = new double[weightsLength][];
        for (count = 0; count < weightsLength; ++count) {
            line = br.readLine();
            toks = line.split("\\t");
            weights2Length = Integer.parseInt(toks[0]);
            this.weights[count] = new double[weights2Length];
            weightsValue = toks[1].split(" ");
            if (weights2Length != weightsValue.length) {
                throw new RuntimeException("weights format error");
            }
            for (i2 = 0; i2 < weights2Length; ++i2) {
                this.weights[count][i2] = Double.parseDouble(weightsValue[i2]);
            }
        }
        System.err.printf("DEBUG: double[%d][] weights loaded%n", weightsLength);
        line = br.readLine();
        if (line != null) {
            throw new RuntimeException("weights format error");
        }
    }

    public void serializeTextClassifier(String serializePath) {
        System.err.print("Serializing Text classifier to " + serializePath + "...");
        try {
            int i;
            PrintWriter pw = new PrintWriter(new GZIPOutputStream(new FileOutputStream(serializePath)));
            pw.printf("labelIndices.length=\t%d%n", this.labelIndices.size());
            for (i = 0; i < this.labelIndices.size(); ++i) {
                pw.printf("labelIndices[%d].size()=\t%d%n", i, this.labelIndices.get(i).size());
                for (int j = 0; j < this.labelIndices.get(i).size(); ++j) {
                    int[] label = this.labelIndices.get(i).get(j).getLabel();
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (int l : label) {
                        list.add(l);
                    }
                    pw.printf("%d\t%s%n", j, StringUtils.join(list, " "));
                }
            }
            pw.printf("classIndex.size()=\t%d%n", this.classIndex.size());
            for (i = 0; i < this.classIndex.size(); ++i) {
                pw.printf("%d\t%s%n", i, this.classIndex.get(i));
            }
            pw.printf("featureIndex.size()=\t%d%n", this.featureIndex.size());
            for (i = 0; i < this.featureIndex.size(); ++i) {
                pw.printf("%d\t%s%n", i, this.featureIndex.get(i));
            }
            pw.println("<flags>");
            pw.print(this.flags.toString());
            pw.println("</flags>");
            if (this.flags.useEmbedding) {
                pw.printf("embeddings.size()=\t%d%n", this.embeddings.size());
                for (String word : this.embeddings.keySet()) {
                    double[] arr = this.embeddings.get(word);
                    Object[] arrUnboxed = new Double[arr.length];
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        arrUnboxed[i2] = arr[i2];
                    }
                    pw.printf("%s\t%s%n", word, StringUtils.join(arrUnboxed, " "));
                }
            }
            if (this.flags.nonLinearCRF) {
                int i3;
                pw.printf("nodeFeatureIndicesMap.size()=\t%d%n", this.nodeFeatureIndicesMap.size());
                for (i3 = 0; i3 < this.nodeFeatureIndicesMap.size(); ++i3) {
                    pw.printf("%d\t%d%n", i3, this.nodeFeatureIndicesMap.get(i3));
                }
                pw.printf("edgeFeatureIndicesMap.size()=\t%d%n", this.edgeFeatureIndicesMap.size());
                for (i3 = 0; i3 < this.edgeFeatureIndicesMap.size(); ++i3) {
                    pw.printf("%d\t%d%n", i3, this.edgeFeatureIndicesMap.get(i3));
                }
                if (this.flags.secondOrderNonLinear) {
                    pw.printf("inputLayerWeights4Edge.length=\t%d%n", this.inputLayerWeights4Edge.length);
                    for (double[] ws : this.inputLayerWeights4Edge) {
                        ArrayList<Double> list = new ArrayList<Double>();
                        for (double w : ws) {
                            list.add(w);
                        }
                        pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
                    }
                    pw.printf("outputLayerWeights4Edge.length=\t%d%n", this.outputLayerWeights4Edge.length);
                    for (double[] ws : this.outputLayerWeights4Edge) {
                        ArrayList<Double> list = new ArrayList<Double>();
                        for (double w : ws) {
                            list.add(w);
                        }
                        pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
                    }
                } else {
                    pw.printf("linearWeights.length=\t%d%n", this.linearWeights.length);
                    for (double[] ws : this.linearWeights) {
                        ArrayList<Double> list = new ArrayList<Double>();
                        for (double w : ws) {
                            list.add(w);
                        }
                        pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
                    }
                }
                pw.printf("inputLayerWeights.length=\t%d%n", this.inputLayerWeights.length);
                for (double[] ws : this.inputLayerWeights) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    for (double w : ws) {
                        list.add(w);
                    }
                    pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
                }
                pw.printf("outputLayerWeights.length=\t%d%n", this.outputLayerWeights.length);
                for (double[] ws : this.outputLayerWeights) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    for (double w : ws) {
                        list.add(w);
                    }
                    pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
                }
            }
            pw.printf("<featureFactory> %s </featureFactory>%n", this.featureFactory.getClass().getName());
            pw.printf("<windowSize> %d </windowSize>%n", this.windowSize);
            pw.printf("weights.length=\t%d%n", this.weights.length);
            for (double[] ws : this.weights) {
                ArrayList<Double> list = new ArrayList<Double>();
                for (double w : ws) {
                    list.add(w);
                }
                pw.printf("%d\t%s%n", ws.length, StringUtils.join(list, " "));
            }
            pw.close();
            System.err.println("done.");
        }
        catch (Exception e) {
            System.err.println("Failed");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serializeClassifier(String serializePath) {
        System.err.print("Serializing classifier to " + serializePath + "...");
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            this.serializeClassifier(oos);
            System.err.println("done.");
        }
        catch (Exception e) {
            System.err.println("Failed");
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.labelIndices);
            oos.writeObject(this.classIndex);
            oos.writeObject(this.featureIndex);
            oos.writeObject(this.flags);
            if (this.flags.useEmbedding) {
                oos.writeObject(this.embeddings);
            }
            if (this.flags.nonLinearCRF) {
                oos.writeObject(this.nodeFeatureIndicesMap);
                oos.writeObject(this.edgeFeatureIndicesMap);
                if (this.flags.secondOrderNonLinear) {
                    oos.writeObject(this.inputLayerWeights4Edge);
                    oos.writeObject(this.outputLayerWeights4Edge);
                } else {
                    oos.writeObject(this.linearWeights);
                }
                oos.writeObject(this.inputLayerWeights);
                oos.writeObject(this.outputLayerWeights);
            }
            oos.writeObject(this.featureFactory);
            oos.writeInt(this.windowSize);
            oos.writeObject(this.weights);
            oos.writeObject(this.knownLCWords);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void loadClassifier(ObjectInputStream ois, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        Object o = ois.readObject();
        if (o instanceof List) {
            this.labelIndices = (List)o;
        } else {
            Index[] indexArray = (Index[])o;
            this.labelIndices = new ArrayList<Index<CRFLabel>>(indexArray.length);
            for (int i = 0; i < indexArray.length; ++i) {
                this.labelIndices.add(indexArray[i]);
            }
        }
        this.classIndex = (Index)ois.readObject();
        this.featureIndex = (Index)ois.readObject();
        this.flags = (SeqClassifierFlags)ois.readObject();
        if (this.flags.useEmbedding) {
            this.embeddings = (Map)ois.readObject();
        }
        if (this.flags.nonLinearCRF) {
            this.nodeFeatureIndicesMap = (Index)ois.readObject();
            this.edgeFeatureIndicesMap = (Index)ois.readObject();
            if (this.flags.secondOrderNonLinear) {
                this.inputLayerWeights4Edge = (double[][])ois.readObject();
                this.outputLayerWeights4Edge = (double[][])ois.readObject();
            } else {
                this.linearWeights = (double[][])ois.readObject();
            }
            this.inputLayerWeights = (double[][])ois.readObject();
            this.outputLayerWeights = (double[][])ois.readObject();
        }
        this.featureFactory = (FeatureFactory)ois.readObject();
        if (props != null) {
            this.flags.setProperties(props, false);
        }
        this.reinit();
        this.windowSize = ois.readInt();
        this.weights = (double[][])ois.readObject();
        this.knownLCWords = (Set)ois.readObject();
    }

    public void loadDefaultClassifier() {
        this.loadJarClassifier(DEFAULT_CLASSIFIER, null);
    }

    public void loadTagIndex() {
        if (this.flags.useNERPriorBIO) {
            if (this.tagIndex == null) {
                this.tagIndex = new HashIndex<String>();
                for (String tag : this.classIndex.objectsList()) {
                    String[] parts = tag.split("-");
                    if (parts.length <= 1) continue;
                    this.tagIndex.add(parts[parts.length - 1]);
                }
                this.tagIndex.add(this.flags.backgroundSymbol);
            }
            if (this.entityMatrices == null) {
                this.entityMatrices = BisequenceEmpiricalNERPrior.readEntityMatrices(this.flags.entityMatrix, this.tagIndex);
            }
        }
    }

    public void loadDefaultClassifier(Properties props) {
        this.loadJarClassifier(DEFAULT_CLASSIFIER, props);
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getDefaultClassifier() {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadDefaultClassifier();
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getDefaultClassifier(Properties props) {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadDefaultClassifier(props);
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getJarClassifier(String resourceName, Properties props) {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadJarClassifier(resourceName, props);
        return crf;
    }

    public static <IN extends CoreMap> CRFClassifier<IN> getClassifier(File file) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier<IN> crf = new CRFClassifier<IN>();
        crf.loadClassifier(file);
        return crf;
    }

    public static CRFClassifier<? extends CoreMap> getClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(in);
        return crf;
    }

    public static CRFClassifier<CoreLabel> getClassifierNoExceptions(String loadPath) {
        CRFClassifier<CoreLabel> crf = new CRFClassifier<CoreLabel>();
        crf.loadClassifierNoExceptions(loadPath);
        return crf;
    }

    public static CRFClassifier<CoreLabel> getClassifier(String loadPath) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier<CoreLabel> crf = new CRFClassifier<CoreLabel>();
        crf.loadClassifier(loadPath);
        return crf;
    }

    public static CRFClassifier<? extends CoreMap> getClassifier(String loadPath, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        CRFClassifier crf = new CRFClassifier();
        crf.loadClassifier(loadPath, props);
        return crf;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<File> files;
        StringUtils.printErrInvocationString("CRFClassifier", args);
        Properties props = StringUtils.argsToProperties(args);
        CRFClassifier crf = new CRFClassifier(props);
        String testFile = crf.flags.testFile;
        String testFiles = crf.flags.testFiles;
        String textFile = crf.flags.textFile;
        String textFiles = crf.flags.textFiles;
        String loadPath = crf.flags.loadClassifier;
        String loadTextPath = crf.flags.loadTextClassifier;
        String serializeTo = crf.flags.serializeTo;
        String serializeToText = crf.flags.serializeToText;
        if (crf.flags.useEmbedding && crf.flags.embeddingWords != null && crf.flags.embeddingVectors != null) {
            System.err.println("Reading Embedding Files");
            BufferedReader br = IOUtils.readerFromString(crf.flags.embeddingWords);
            String line = null;
            ArrayList<String> wordList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                wordList.add(line.trim());
            }
            System.err.println("Found a dictionary of size " + wordList.size());
            br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(crf.flags.embeddingVectors))));
            crf.embeddings = Generics.newHashMap();
            double[] vector = null;
            int count = 0;
            while ((line = br.readLine()) != null) {
                vector = ArrayUtils.toDoubleArray(line.trim().split(" "));
                crf.embeddings.put((String)wordList.get(count++), vector);
            }
            System.err.println("Found " + count + " matching embeddings of dimension " + vector.length);
        }
        if (loadPath != null) {
            crf.loadClassifierNoExceptions(loadPath, props);
        } else if (loadTextPath != null) {
            System.err.println("Warning: this is now only tested for Chinese Segmenter");
            System.err.println("(Sun Dec 23 00:59:39 2007) (pichuan)");
            try {
                crf.loadTextClassifier(loadTextPath, props);
            }
            catch (Exception e) {
                throw new RuntimeException("error loading " + loadTextPath, e);
            }
        } else if (crf.flags.loadJarClassifier != null) {
            crf.loadJarClassifier(crf.flags.loadJarClassifier, props);
        } else if (crf.flags.trainFile != null || crf.flags.trainFileList != null) {
            crf.train();
        } else {
            crf.loadDefaultClassifier();
        }
        crf.loadTagIndex();
        if (serializeTo != null) {
            crf.serializeClassifier(serializeTo);
        }
        if (serializeToText != null) {
            crf.serializeTextClassifier(serializeToText);
        }
        if (testFile != null) {
            DocumentReaderAndWriter readerAndWriter = crf.defaultReaderAndWriter();
            if (crf.flags.searchGraphPrefix != null) {
                crf.classifyAndWriteViterbiSearchGraph(testFile, crf.flags.searchGraphPrefix, crf.makeReaderAndWriter());
            } else if (crf.flags.printFirstOrderProbs) {
                crf.printFirstOrderProbs(testFile, readerAndWriter);
            } else if (crf.flags.printFactorTable) {
                crf.printFactorTable(testFile, readerAndWriter);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile, readerAndWriter);
            } else if (crf.flags.printProbs) {
                crf.printProbs(testFile, readerAndWriter);
            } else if (crf.flags.useKBest) {
                int k = crf.flags.kBest;
                crf.classifyAndWriteAnswersKBest(testFile, k, readerAndWriter);
            } else if (crf.flags.printLabelValue) {
                crf.printLabelInformation(testFile, readerAndWriter);
            } else {
                crf.classifyAndWriteAnswers(testFile, readerAndWriter);
            }
        }
        if (testFiles != null) {
            files = new ArrayList<File>();
            for (String filename : testFiles.split(",")) {
                files.add(new File(filename));
            }
            crf.classifyFilesAndWriteAnswers(files, crf.defaultReaderAndWriter());
        }
        if (textFile != null) {
            crf.classifyAndWriteAnswers(textFile);
        }
        if (textFiles != null) {
            files = new ArrayList();
            for (String filename : textFiles.split(",")) {
                files.add(new File(filename));
            }
            crf.classifyFilesAndWriteAnswers(files);
        }
        if (crf.flags.readStdin) {
            crf.classifyStdin();
        }
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    public void writeWeights(PrintStream p) {
        for (String feature : this.featureIndex) {
            int index = this.featureIndex.indexOf(feature);
            double[] v = this.weights[index];
            Index<CRFLabel> l = this.labelIndices.get(0);
            p.println(feature + "\t\t");
            for (CRFLabel label : l) {
                p.print(label.toString(this.classIndex) + ":" + v[l.indexOf(label)] + "\t");
            }
            p.println();
        }
    }

    public Map<String, Counter<String>> topWeights() {
        HashMap<String, Counter<String>> w = new HashMap<String, Counter<String>>();
        for (String feature : this.featureIndex) {
            int index = this.featureIndex.indexOf(feature);
            double[] v = this.weights[index];
            Index<CRFLabel> l = this.labelIndices.get(0);
            for (CRFLabel label : l) {
                if (!w.containsKey(label.toString(this.classIndex))) {
                    w.put(label.toString(this.classIndex), new ClassicCounter());
                }
                ((Counter)w.get(label.toString(this.classIndex))).setCount(feature, v[l.indexOf(label)]);
            }
        }
        return w;
    }

    public static class TestSequenceModel
    implements SequenceModel {
        private final int window;
        private final int numClasses;
        private final CRFCliqueTree cliqueTree;
        private final int[] tags;
        private final int[] backgroundTag;

        public TestSequenceModel(CRFCliqueTree cliqueTree) {
            this.cliqueTree = cliqueTree;
            this.window = cliqueTree.window();
            this.numClasses = cliqueTree.getNumClasses();
            this.tags = new int[this.numClasses];
            for (int i = 0; i < this.tags.length; ++i) {
                this.tags[i] = i;
            }
            this.backgroundTag = new int[]{cliqueTree.backgroundIndex()};
        }

        @Override
        public int length() {
            return this.cliqueTree.length();
        }

        @Override
        public int leftWindow() {
            return this.window - 1;
        }

        @Override
        public int rightWindow() {
            return 0;
        }

        @Override
        public int[] getPossibleValues(int pos) {
            if (pos < this.window - 1) {
                return this.backgroundTag;
            }
            return this.tags;
        }

        @Override
        public double scoreOf(int[] tags, int pos) {
            int[] previous = new int[this.window - 1];
            int realPos = pos - this.window + 1;
            for (int i = 0; i < this.window - 1; ++i) {
                previous[i] = tags[realPos + i];
            }
            return this.cliqueTree.condLogProbGivenPrevious(realPos, tags[pos], previous);
        }

        @Override
        public double[] scoresOf(int[] tags, int pos) {
            int i;
            int realPos = pos - this.window + 1;
            double[] scores = new double[this.numClasses];
            int[] previous = new int[this.window - 1];
            for (i = 0; i < this.window - 1; ++i) {
                previous[i] = tags[realPos + i];
            }
            for (i = 0; i < this.numClasses; ++i) {
                scores[i] = this.cliqueTree.condLogProbGivenPrevious(realPos, i, previous);
            }
            return scores;
        }

        @Override
        public double scoreOf(int[] sequence) {
            throw new UnsupportedOperationException();
        }
    }
}

