/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BisequenceEmpiricalNERPrior<IN extends CoreMap> {
    private Index<String> tagIndex;
    private int backgroundSymbolIndex;
    private int numClasses;
    private int numTags;
    private int[] possibleValues;
    private int[] currSequence;
    private Index<String> classIndex;
    private List<String> wordDoc;
    private double[][] entityMatrix;
    private double[][] subEntityMatrix;
    private List<Entity> entityList;
    private SeqClassifierFlags flags;
    private boolean VERBOSE = false;
    public static List debugIndices = Arrays.asList(80, 265, 651, 760, 761);
    public static boolean DEBUG = false;

    public BisequenceEmpiricalNERPrior(String backgroundSymbol, Index<String> classIndex, Index<String> tagIndex, List<IN> doc, Pair<double[][], double[][]> matrices, SeqClassifierFlags flags) {
        this.flags = flags;
        this.classIndex = classIndex;
        this.tagIndex = tagIndex;
        this.backgroundSymbolIndex = classIndex.indexOf(backgroundSymbol);
        this.numClasses = classIndex.size();
        this.numTags = tagIndex.size();
        this.possibleValues = new int[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.possibleValues[i] = i;
        }
        this.wordDoc = new ArrayList<String>(doc.size());
        for (CoreMap w : doc) {
            this.wordDoc.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
        this.entityMatrix = matrices.first();
        this.subEntityMatrix = matrices.second();
    }

    public static Pair<double[][], double[][]> readEntityMatrices(String fileName, Index<String> tagIndex) {
        int i;
        int numTags = tagIndex.size();
        double[][] matrix = new double[numTags - 1][numTags - 1];
        for (int i2 = 0; i2 < numTags - 1; ++i2) {
            matrix[i2] = new double[numTags - 1];
        }
        double[][] subMatrix = new double[numTags - 1][numTags - 1];
        for (int i3 = 0; i3 < numTags - 1; ++i3) {
            subMatrix[i3] = new double[numTags - 1];
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fileName))));
            String line = null;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                String[] parts;
                line = line.trim();
                for (String part : parts = line.split("\t")) {
                    String[] subparts = part.split(" ");
                    String[] subsubparts = subparts[0].split(":");
                    double counts = Double.parseDouble(subparts[1]);
                    if (counts == 0.0) {
                        counts = 1.0;
                    }
                    int tagIndex1 = tagIndex.indexOf(subsubparts[0]);
                    int tagIndex2 = tagIndex.indexOf(subsubparts[1]);
                    if (lineCount < numTags - 1) {
                        matrix[tagIndex1][tagIndex2] = counts;
                        continue;
                    }
                    subMatrix[tagIndex1][tagIndex2] = counts;
                }
                ++lineCount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        for (i = 0; i < matrix.length; ++i) {
            double sum = ArrayMath.sum(matrix[i]);
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = Math.log(matrix[i][j] / sum) / 2.0;
            }
        }
        for (i = 0; i < subMatrix.length; ++i) {
            double sum = ArrayMath.sum(subMatrix[i]);
            for (int j = 0; j < subMatrix[i].length; ++j) {
                subMatrix[i][j] = Math.log(subMatrix[i][j] / sum);
            }
        }
        System.err.println("Matrix: ");
        System.err.println(ArrayUtils.toString(matrix));
        System.err.println("SubMatrix: ");
        System.err.println(ArrayUtils.toString(subMatrix));
        return new Pair<double[][], double[][]>(matrix, subMatrix);
    }

    public static List<Entity> extractEntities(int[] sequence, List<String> wordDoc, Index<String> tagIndex, Index<String> classIndex, int backgroundSymbolIndex) {
        int i;
        String rawTag = null;
        String[] parts = null;
        String currTag = "";
        ArrayList<String> currWords = new ArrayList<String>();
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (i = 0; i < sequence.length; ++i) {
            if (sequence[i] != backgroundSymbolIndex) {
                rawTag = classIndex.get(sequence[i]);
                parts = rawTag.split("-");
                if (parts[0].equals("B")) {
                    if (currWords.size() > 0) {
                        entityList.add(new Entity(i - currWords.size(), currWords, tagIndex.indexOf(currTag)));
                        currWords.clear();
                    }
                    currWords.add(wordDoc.get(i));
                    currTag = parts[1];
                    continue;
                }
                if (currWords.size() > 0 && parts[1].equals(currTag)) {
                    currWords.add(wordDoc.get(i));
                    continue;
                }
                if (currWords.size() > 0) {
                    entityList.add(new Entity(i - currWords.size(), currWords, tagIndex.indexOf(currTag)));
                    currWords.clear();
                }
                currWords.add(wordDoc.get(i));
                currTag = parts[1];
                continue;
            }
            if (currWords.size() <= 0) continue;
            entityList.add(new Entity(i - currWords.size(), currWords, tagIndex.indexOf(currTag)));
            currWords.clear();
            currTag = "";
        }
        if (currWords.size() > 0) {
            entityList.add(new Entity(sequence.length - currWords.size(), currWords, tagIndex.indexOf(currTag)));
        }
        for (i = 0; i < entityList.size(); ++i) {
            Entity curr = (Entity)entityList.get(i);
            ArrayList<Entity> exact = new ArrayList<Entity>();
            ArrayList<Entity> subMatch = new ArrayList<Entity>();
            String currStr = curr.surface;
            for (int j = 0; j < entityList.size(); ++j) {
                if (i == j) continue;
                Entity other = (Entity)entityList.get(j);
                if (other.surface.indexOf(currStr) == -1) continue;
                if (other.surface.length() == currStr.length()) {
                    if (i >= j) continue;
                    exact.add(other);
                    continue;
                }
                subMatch.add(other);
            }
            curr.exactMatch = exact;
            curr.subMatch = subMatch;
        }
        return entityList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Entity entity : this.entityList) {
            sb.append(entity.startPosition);
            sb.append("\t");
            sb.append(entity.surface);
            sb.append("\t");
            sb.append(this.tagIndex.get(entity.type));
            sb.append("\n");
        }
        return sb.toString();
    }

    static class Entity {
        public int startPosition;
        public int wordsSize;
        public String surface;
        public int type;
        public List<Entity> subMatch;
        public List<Entity> exactMatch;
        public int[] otherOccurrences;

        public Entity(int startP, List<String> words, int type) {
            this.type = type;
            this.startPosition = startP;
            this.wordsSize = words.size();
            this.surface = StringUtils.join(words, " ");
        }

        public String toString(Index<String> tagIndex) {
            StringBuffer sb = new StringBuffer();
            sb.append("\"");
            sb.append(this.surface);
            sb.append("\" start: ");
            sb.append(this.startPosition);
            sb.append(" type: ");
            sb.append(tagIndex.get(this.type));
            sb.append(" exact matches: [");
            for (Entity exact : this.exactMatch) {
                sb.append(exact.startPosition);
                sb.append(":");
                sb.append(exact.surface);
                sb.append(" ");
            }
            sb.append("],");
            sb.append(" sub matches: [");
            for (Entity sub : this.subMatch) {
                sb.append(sub.startPosition);
                sb.append(":");
                sb.append(sub.surface);
                sb.append(" ");
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

