/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.BasicDatum;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Mention
implements CoreAnnotation<Mention>,
Serializable {
    private static final long serialVersionUID = -7524485803945717057L;
    public Dictionaries.MentionType mentionType;
    public Dictionaries.Number number;
    public Dictionaries.Gender gender;
    public Dictionaries.Animacy animacy;
    public Dictionaries.Person person;
    public String headString;
    public String nerString;
    public int startIndex;
    public int endIndex;
    public int headIndex;
    public int mentionID = -1;
    public int originalRef = -1;
    public IndexedWord headIndexedWord;
    public int goldCorefClusterID = -1;
    public int corefClusterID = -1;
    public int sentNum = -1;
    public int utter = -1;
    public int paragraph = -1;
    public boolean isSubject;
    public boolean isDirectObject;
    public boolean isIndirectObject;
    public boolean isPrepositionObject;
    public IndexedWord dependingVerb;
    public boolean twinless = true;
    public boolean generic = false;
    public boolean isSingleton;
    public List<CoreLabel> sentenceWords;
    public List<CoreLabel> originalSpan;
    public Tree mentionSubTree;
    public Tree contextParseTree;
    public CoreLabel headWord;
    public SemanticGraph dependency;
    public Set<String> dependents = Generics.newHashSet();
    public List<String> preprocessedTerms;
    public Object synsets;
    public Set<Mention> appositions = null;
    public Set<Mention> predicateNominatives = null;
    public Set<Mention> relativePronouns = null;
    private static final String[] commonNESuffixes = new String[]{"Corp", "Co", "Inc", "Ltd"};

    public Mention() {
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan, Tree mentionTree) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
        this.mentionSubTree = mentionTree;
    }

    @Override
    public Class<Mention> getType() {
        return Mention.class;
    }

    public boolean isPronominal() {
        return this.mentionType == Dictionaries.MentionType.PRONOMINAL;
    }

    public String toString() {
        return this.spanToString();
    }

    public String spanToString() {
        StringBuilder os = new StringBuilder();
        for (int i = 0; i < this.originalSpan.size(); ++i) {
            if (i > 0) {
                os.append(" ");
            }
            os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
        }
        return os.toString();
    }

    public void process(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.setHeadString();
        this.setType(dict);
        this.setNERString();
        List<String> mStr = this.getMentionString();
        this.setNumber(dict, Mention.getNumberCount(dict, mStr));
        this.setGender(dict, this.getGenderCount(dict, mStr));
        this.setAnimacy(dict);
        this.setPerson(dict);
        this.setDiscourse();
        this.headIndexedWord = this.dependency.getNodeByIndexSafe(this.headWord.index());
        if (semantics != null) {
            this.setSemantics(dict, semantics, mentionExtractor);
        }
    }

    public void process(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor, LogisticClassifier<String, String> singletonPredictor) throws Exception {
        this.process(dict, semantics, mentionExtractor);
        if (singletonPredictor != null) {
            this.setSingleton(singletonPredictor, dict);
        }
    }

    private void setSingleton(LogisticClassifier<String, String> predictor, Dictionaries dict) {
        double coreference_score = predictor.probabilityOf(new BasicDatum<String, String>(this.getSingletonFeatures(dict), "1"));
        if (coreference_score < 0.2) {
            this.isSingleton = true;
        }
    }

    private ArrayList<String> getSingletonFeatures(Dictionaries dict) {
        ArrayList<String> features = new ArrayList<String>();
        features.add(this.mentionType.toString());
        features.add(this.nerString);
        features.add(this.animacy.toString());
        int personNum = 3;
        if (this.person.equals((Object)Dictionaries.Person.I) || this.person.equals((Object)Dictionaries.Person.WE)) {
            personNum = 1;
        }
        if (this.person.equals((Object)Dictionaries.Person.YOU)) {
            personNum = 2;
        }
        if (this.person.equals((Object)Dictionaries.Person.UNKNOWN)) {
            personNum = 0;
        }
        features.add(String.valueOf(personNum));
        features.add(this.number.toString());
        features.add(this.getPosition());
        features.add(this.getRelation());
        features.add(this.getQuantification(dict));
        features.add(String.valueOf(this.getModifiers(dict)));
        features.add(String.valueOf(this.getNegation(dict)));
        features.add(String.valueOf(this.getModal(dict)));
        features.add(String.valueOf(this.getReportEmbedding(dict)));
        features.add(String.valueOf(this.getCoordination()));
        return features;
    }

    private List<String> getMentionString() {
        ArrayList<String> mStr = new ArrayList<String>();
        for (CoreLabel l : this.originalSpan) {
            mStr.add(((String)l.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
            if (l != this.headWord) continue;
            break;
        }
        return mStr;
    }

    private static int[] getNumberCount(Dictionaries dict, List<String> mStr) {
        int len = mStr.size();
        if (len > 1) {
            for (int i = 0; i < len - 1; ++i) {
                if (!dict.genderNumber.containsKey(mStr.subList(i, len))) continue;
                return dict.genderNumber.get(mStr.subList(i, len));
            }
            ArrayList<String> convertedStr = new ArrayList<String>();
            convertedStr.add("!");
            convertedStr.add(mStr.get(len - 1));
            if (dict.genderNumber.containsKey(convertedStr)) {
                return dict.genderNumber.get(convertedStr);
            }
        }
        if (dict.genderNumber.containsKey(mStr.subList(len - 1, len))) {
            return dict.genderNumber.get(mStr.subList(len - 1, len));
        }
        return null;
    }

    private int[] getGenderCount(Dictionaries dict, List<String> mStr) {
        int len = mStr.size();
        char firstLetter = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).charAt(0);
        if (len > 1 && Character.isUpperCase(firstLetter) && this.nerString.startsWith("PER")) {
            int firstNameIdx = len - 2;
            String secondToLast = mStr.get(firstNameIdx);
            if (firstNameIdx > 1 && (secondToLast.length() == 1 || secondToLast.length() == 2 && secondToLast.endsWith("."))) {
                --firstNameIdx;
            }
            for (int i = 0; i <= firstNameIdx; ++i) {
                if (!dict.genderNumber.containsKey(mStr.subList(i, len))) continue;
                return dict.genderNumber.get(mStr.subList(i, len));
            }
            ArrayList<String> convertedStr = new ArrayList<String>();
            convertedStr.add(mStr.get(firstNameIdx));
            convertedStr.add("!");
            if (dict.genderNumber.containsKey(convertedStr)) {
                return dict.genderNumber.get(convertedStr);
            }
            if (dict.genderNumber.containsKey(mStr.subList(firstNameIdx, firstNameIdx + 1))) {
                return dict.genderNumber.get(mStr.subList(firstNameIdx, firstNameIdx + 1));
            }
        }
        if (dict.genderNumber.containsKey(mStr.subList(len - 1, len))) {
            return dict.genderNumber.get(mStr.subList(len - 1, len));
        }
        return null;
    }

    private void setDiscourse() {
        this.utter = (Integer)this.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        Pair<IndexedWord, String> verbDependency = Mention.findDependentVerb(this);
        String dep = verbDependency.second();
        this.dependingVerb = verbDependency.first();
        this.isSubject = false;
        this.isDirectObject = false;
        this.isIndirectObject = false;
        this.isPrepositionObject = false;
        if (dep == null) {
            return;
        }
        if (dep.equals("nsubj") || dep.equals("csubj")) {
            this.isSubject = true;
        } else if (dep.equals("dobj")) {
            this.isDirectObject = true;
        } else if (dep.equals("iobj")) {
            this.isIndirectObject = true;
        } else if (dep.equals("pobj")) {
            this.isPrepositionObject = true;
        }
    }

    private void setPerson(Dictionaries dict) {
        String spanToString;
        if (!this.isPronominal()) {
            this.person = Dictionaries.Person.UNKNOWN;
        }
        this.person = dict.firstPersonPronouns.contains(spanToString = this.spanToString().toLowerCase()) ? (this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.I : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.WE : Dictionaries.Person.UNKNOWN)) : (dict.secondPersonPronouns.contains(spanToString) ? Dictionaries.Person.YOU : (dict.thirdPersonPronouns.contains(spanToString) ? (this.gender == Dictionaries.Gender.MALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.HE : (this.gender == Dictionaries.Gender.FEMALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.SHE : ((this.gender == Dictionaries.Gender.NEUTRAL || this.animacy == Dictionaries.Animacy.INANIMATE) && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.IT : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.THEY : Dictionaries.Person.UNKNOWN)))) : Dictionaries.Person.UNKNOWN));
    }

    private void setSemantics(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.preprocessedTerms = this.preprocessSearchTerm();
        if (dict.statesAbbreviation.containsKey(this.spanToString())) {
            this.preprocessedTerms = new ArrayList<String>();
            this.preprocessedTerms.add(dict.statesAbbreviation.get(this.spanToString()));
        }
        Method meth = semantics.wordnet.getClass().getDeclaredMethod("findSynset", List.class);
        this.synsets = meth.invoke(semantics.wordnet, this.preprocessedTerms);
        if (this.isPronominal()) {
            return;
        }
    }

    private void setType(Dictionaries dict) {
        if (this.headWord.has(CoreAnnotations.EntityTypeAnnotation.class)) {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("PRO") ? Dictionaries.MentionType.PRONOMINAL : (((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        } else if (!this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            this.mentionType = Dictionaries.MentionType.NOMINAL;
            SieveCoreferenceSystem.logger.finest("no NamedEntityTagAnnotation: " + this.headWord);
        } else {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("PRP") || this.originalSpan.size() == 1 && ((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") && (dict.allPronouns.contains(this.headString) || dict.relativePronouns.contains(this.headString)) ? Dictionaries.MentionType.PRONOMINAL : (!((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") || ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        }
    }

    private void setGender(Dictionaries dict, int[] genderNumberCount) {
        this.gender = Dictionaries.Gender.UNKNOWN;
        if (this.mentionType == Dictionaries.MentionType.PRONOMINAL) {
            if (dict.malePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.MALE;
            } else if (dict.femalePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.FEMALE;
            }
        } else {
            if (this.gender == Dictionaries.Gender.UNKNOWN) {
                if (dict.maleWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.MALE;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tMale:\t" + this.headString);
                } else if (dict.femaleWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.FEMALE;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tFemale:\t" + this.headString);
                } else if (dict.neutralWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.NEUTRAL;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tNeutral:\t" + this.headString);
                }
            }
            if (genderNumberCount != null && this.number != Dictionaries.Number.PLURAL) {
                double male = genderNumberCount[0];
                double female = genderNumberCount[1];
                double neutral = genderNumberCount[2];
                if (male * 0.5 > female + neutral && male > 2.0) {
                    this.gender = Dictionaries.Gender.MALE;
                } else if (female * 0.5 > male + neutral && female > 2.0) {
                    this.gender = Dictionaries.Gender.FEMALE;
                } else if (neutral * 0.5 > male + female && neutral > 2.0) {
                    this.gender = Dictionaries.Gender.NEUTRAL;
                }
            }
        }
    }

    protected void setNumber(Dictionaries dict, int[] genderNumberCount) {
        String tag;
        this.number = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.pluralPronouns.contains(this.headString) ? Dictionaries.Number.PLURAL : (dict.singularPronouns.contains(this.headString) ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN)) : (!this.nerString.equals("O") && this.mentionType != Dictionaries.MentionType.NOMINAL ? (!this.nerString.equals("ORGANIZATION") && !this.nerString.startsWith("ORG") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN) : ((tag = (String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("N") && tag.endsWith("S") ? Dictionaries.Number.PLURAL : (tag.startsWith("N") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN)));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL) {
            if (this.number == Dictionaries.Number.UNKNOWN) {
                if (dict.singularWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.SINGULAR;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tSINGULAR:\t" + this.headString);
                } else if (dict.pluralWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.PLURAL;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tPLURAL:\t" + this.headString);
                }
            }
            String enumerationPattern = "NP < (NP=tmp $.. (/,|CC/ $.. NP))";
            TregexPattern tgrepPattern = TregexPattern.compile("NP < (NP=tmp $.. (/,|CC/ $.. NP))");
            TregexMatcher m = tgrepPattern.matcher(this.mentionSubTree);
            while (m.find()) {
                if (this.mentionSubTree != m.getNode("tmp") || !this.spanToString().toLowerCase().contains(" and ")) continue;
                this.number = Dictionaries.Number.PLURAL;
            }
        }
    }

    private void setAnimacy(Dictionaries dict) {
        this.animacy = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.animatePronouns.contains(this.headString) ? Dictionaries.Animacy.ANIMATE : (dict.inanimatePronouns.contains(this.headString) ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)) : (this.nerString.equals("PERSON") || this.nerString.startsWith("PER") ? Dictionaries.Animacy.ANIMATE : (this.nerString.equals("LOCATION") || this.nerString.startsWith("LOC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MONEY") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("NUMBER") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("PERCENT") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("DATE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("TIME") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MISC") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("VEH") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("FAC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("GPE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("WEA") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("ORG") ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)))))))))))));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL && this.animacy == Dictionaries.Animacy.UNKNOWN) {
            if (dict.animateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.ANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tANIMATE:\t" + this.headString);
            } else if (dict.inanimateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.INANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tINANIMATE:\t" + this.headString);
            }
        }
    }

    private static boolean knownSuffix(String s) {
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        for (String suff : commonNESuffixes) {
            if (!suff.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private void setHeadString() {
        this.headString = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
        if (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            int start = this.headIndex - this.startIndex;
            if (start >= this.originalSpan.size()) {
                throw new RuntimeException("Invalid start index " + start + "=" + this.headIndex + "-" + this.startIndex + ": originalSpan=[" + StringUtils.joinWords(this.originalSpan, " ") + "], head=" + this.headWord);
            }
            while (start >= 0) {
                String head = ((String)this.originalSpan.get(start).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
                if (!Mention.knownSuffix(head)) {
                    this.headString = head;
                    break;
                }
                --start;
            }
        }
    }

    private void setNERString() {
        this.nerString = this.headWord.has(CoreAnnotations.EntityTypeAnnotation.class) ? (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class) && ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O") : (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class) ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O");
    }

    public boolean sameSentence(Mention m) {
        return m.sentenceWords == this.sentenceWords;
    }

    private static boolean included(CoreLabel small, List<CoreLabel> big) {
        if (small.tag().equals("NNP")) {
            for (CoreLabel w : big) {
                if (!small.word().equals(w.word()) && (small.word().length() <= 2 || !w.word().startsWith(small.word()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean headsAgree(Mention m) {
        if (!this.nerString.equals("O") && !m.nerString.equals("O") && this.nerString.equals(m.nerString) && (Mention.included(this.headWord, m.originalSpan) || Mention.included(m.headWord, this.originalSpan))) {
            return true;
        }
        return this.headString.equals(m.headString);
    }

    public boolean numbersAgree(Mention m) {
        return this.numbersAgree(m, false);
    }

    private boolean numbersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.number == m.number;
        }
        return this.number == Dictionaries.Number.UNKNOWN || m.number == Dictionaries.Number.UNKNOWN || this.number == m.number;
    }

    public boolean gendersAgree(Mention m) {
        return this.gendersAgree(m, false);
    }

    public boolean gendersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.gender == m.gender;
        }
        return this.gender == Dictionaries.Gender.UNKNOWN || m.gender == Dictionaries.Gender.UNKNOWN || this.gender == m.gender;
    }

    public boolean animaciesAgree(Mention m) {
        return this.animaciesAgree(m, false);
    }

    public boolean animaciesAgree(Mention m, boolean strict) {
        if (strict) {
            return this.animacy == m.animacy;
        }
        return this.animacy == Dictionaries.Animacy.UNKNOWN || m.animacy == Dictionaries.Animacy.UNKNOWN || this.animacy == m.animacy;
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict) {
        return this.entityTypesAgree(m, dict, false);
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict, boolean strict) {
        if (strict) {
            return this.nerString.equals(m.nerString);
        }
        if (this.isPronominal()) {
            if (this.nerString.contains("-") || m.nerString.contains("-")) {
                if (m.nerString.equals("O")) {
                    return true;
                }
                if (m.nerString.startsWith("ORG")) {
                    return dict.organizationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("PER")) {
                    return dict.personPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("LOC")) {
                    return dict.locationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("GPE")) {
                    return dict.GPEPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("VEH") || m.nerString.startsWith("FAC") || m.nerString.startsWith("WEA")) {
                    return dict.facilityVehicleWeaponPronouns.contains(this.headString);
                }
                return false;
            }
            if (m.nerString.equals("O")) {
                return true;
            }
            if (m.nerString.equals("MISC")) {
                return true;
            }
            if (m.nerString.equals("ORGANIZATION")) {
                return dict.organizationPronouns.contains(this.headString);
            }
            if (m.nerString.equals("PERSON")) {
                return dict.personPronouns.contains(this.headString);
            }
            if (m.nerString.equals("LOCATION")) {
                return dict.locationPronouns.contains(this.headString);
            }
            if (m.nerString.equals("DATE") || m.nerString.equals("TIME")) {
                return dict.dateTimePronouns.contains(this.headString);
            }
            if (m.nerString.equals("MONEY") || m.nerString.equals("PERCENT") || m.nerString.equals("NUMBER")) {
                return dict.moneyPercentNumberPronouns.contains(this.headString);
            }
            return false;
        }
        return this.nerString.equals("O") || m.nerString.equals("O") || this.nerString.equals(m.nerString);
    }

    public boolean includedIn(Mention m) {
        if (!m.sameSentence(this)) {
            return false;
        }
        if (this.startIndex < m.startIndex || this.endIndex > m.endIndex) {
            return false;
        }
        for (Tree t : m.mentionSubTree.subTrees()) {
            if (t != this.mentionSubTree) continue;
            return true;
        }
        return false;
    }

    public boolean attributesAgree(Mention potentialAntecedent, Dictionaries dict) {
        return this.animaciesAgree(potentialAntecedent) && this.entityTypesAgree(potentialAntecedent, dict) && this.gendersAgree(potentialAntecedent) && this.numbersAgree(potentialAntecedent);
    }

    public void addApposition(Mention m) {
        if (this.appositions == null) {
            this.appositions = Generics.newHashSet();
        }
        this.appositions.add(m);
    }

    public boolean isApposition(Mention m) {
        return this.appositions != null && this.appositions.contains(m);
    }

    public void addPredicateNominatives(Mention m) {
        if (this.predicateNominatives == null) {
            this.predicateNominatives = Generics.newHashSet();
        }
        this.predicateNominatives.add(m);
    }

    public boolean isPredicateNominatives(Mention m) {
        return this.predicateNominatives != null && this.predicateNominatives.contains(m);
    }

    public void addRelativePronoun(Mention m) {
        if (this.relativePronouns == null) {
            this.relativePronouns = Generics.newHashSet();
        }
        this.relativePronouns.add(m);
    }

    public boolean appearEarlierThan(Mention m) {
        if (this.sentNum < m.sentNum) {
            return true;
        }
        if (this.sentNum > m.sentNum) {
            return false;
        }
        if (this.startIndex < m.startIndex) {
            return true;
        }
        if (this.startIndex > m.startIndex) {
            return false;
        }
        return this.endIndex > m.endIndex;
    }

    public String longestNNPEndsWithHead() {
        String pos;
        String ret = "";
        for (int i = this.headIndex; i >= this.startIndex && (pos = (String)this.sentenceWords.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP"); --i) {
            if (!ret.equals("")) {
                ret = " " + ret;
            }
            ret = (String)this.sentenceWords.get(i).get(CoreAnnotations.TextAnnotation.class) + ret;
        }
        return ret;
    }

    public String lowestNPIncludesHead() {
        String s;
        Tree head;
        String ret = "";
        Tree lowestNP = head = (Tree)this.contextParseTree.getLeaves().get(this.headIndex);
        while (true) {
            if (lowestNP == null) {
                return ret;
            }
            s = (String)((CoreLabel)lowestNP.label()).get(CoreAnnotations.ValueAnnotation.class);
            if (s.equals("NP") || s.equals("ROOT")) break;
            lowestNP = lowestNP.ancestor(1, this.contextParseTree);
        }
        if (s.equals("ROOT")) {
            lowestNP = head;
        }
        for (Tree t : lowestNP.getLeaves()) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + (String)((CoreLabel)t.label()).get(CoreAnnotations.TextAnnotation.class);
        }
        if (!this.spanToString().contains(ret)) {
            return (String)this.sentenceWords.get(this.headIndex).get(CoreAnnotations.TextAnnotation.class);
        }
        return ret;
    }

    public String stringWithoutArticle(String str) {
        String ret;
        String string = ret = str == null ? this.spanToString() : str;
        if (ret.startsWith("a ") || ret.startsWith("A ")) {
            return ret.substring(2);
        }
        if (ret.startsWith("an ") || ret.startsWith("An ")) {
            return ret.substring(3);
        }
        if (ret.startsWith("the ") || ret.startsWith("The ")) {
            return ret.substring(4);
        }
        return ret;
    }

    public List<String> preprocessSearchTerm() {
        ArrayList<String> searchTerms = new ArrayList<String>();
        String[] terms = new String[]{this.stringWithoutArticle(this.removePhraseAfterHead()), this.stringWithoutArticle(this.lowestNPIncludesHead()), this.stringWithoutArticle(this.longestNNPEndsWithHead()), this.headString};
        for (String term : terms) {
            if (term.contains("\"")) {
                term = term.replace("\"", "\\\"");
            }
            if (term.contains("(")) {
                term = term.replace("(", "\\(");
            }
            if (term.contains(")")) {
                term = term.replace(")", "\\)");
            }
            if (term.contains("!")) {
                term = term.replace("!", "\\!");
            }
            if (term.contains(":")) {
                term = term.replace(":", "\\:");
            }
            if (term.contains("+")) {
                term = term.replace("+", "\\+");
            }
            if (term.contains("-")) {
                term = term.replace("-", "\\-");
            }
            if (term.contains("~")) {
                term = term.replace("~", "\\~");
            }
            if (term.contains("*")) {
                term = term.replace("*", "\\*");
            }
            if (term.contains("[")) {
                term = term.replace("[", "\\[");
            }
            if (term.contains("]")) {
                term = term.replace("]", "\\]");
            }
            if (term.contains("^")) {
                term = term.replace("^", "\\^");
            }
            if (term.equals("") || term.equals("") || searchTerms.contains(term) || term.equals(terms[3]) && !terms[2].equals("")) continue;
            searchTerms.add(term);
        }
        return searchTerms;
    }

    public static String buildQueryText(List<String> terms) {
        String query = "";
        for (String t : terms) {
            query = query + t + " ";
        }
        return query.trim();
    }

    public String removePhraseAfterHead() {
        String removed = "";
        int posComma = -1;
        int posWH = -1;
        for (int i = 0; i < this.originalSpan.size(); ++i) {
            CoreLabel w = this.originalSpan.get(i);
            if (posComma == -1 && ((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",")) {
                posComma = this.startIndex + i;
            }
            if (posWH != -1 || !((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("W")) continue;
            posWH = this.startIndex + i;
        }
        if (posComma != -1 && this.headIndex < posComma) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posComma - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH != -1 && this.headIndex < posWH) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posWH - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH == -1) {
            removed = this.spanToString();
        }
        return removed;
    }

    public static String removeParenthesis(String text) {
        if (text.split("\\(").length > 0) {
            return text.split("\\(")[0].trim();
        }
        return "";
    }

    protected boolean isTheCommonNoun() {
        return this.mentionType == Dictionaries.MentionType.NOMINAL && this.spanToString().toLowerCase().startsWith("the ") && this.spanToString().split(" ").length == 2;
    }

    private static Pair<IndexedWord, String> findDependentVerb(Mention m) {
        Pair<IndexedWord, String> ret = new Pair<IndexedWord, String>();
        int headIndex = m.headIndex + 1;
        try {
            ArrayCoreMap w = m.dependency.getNodeByIndex(headIndex);
            if (w == null) {
                return ret;
            }
            while (true) {
                ArrayCoreMap p = null;
                for (Pair<GrammaticalRelation, IndexedWord> parent : m.dependency.parentPairs((IndexedWord)w)) {
                    if (ret.second() == null) {
                        String relation = parent.first().getShortName();
                        ret.setSecond(relation);
                    }
                    p = parent.second();
                }
                if (p == null || ((String)p.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("V")) {
                    ret.setFirst((IndexedWord)p);
                    break;
                }
                if (w == p) {
                    return ret;
                }
                w = p;
            }
        }
        catch (Exception e) {
            return ret;
        }
        return ret;
    }

    public boolean insideIn(Mention m) {
        return this.sentNum == m.sentNum && m.startIndex <= this.startIndex && this.endIndex <= m.endIndex;
    }

    public boolean moreRepresentativeThan(Mention m) {
        if (m == null) {
            return true;
        }
        if (this.mentionType != m.mentionType) {
            return this.mentionType == Dictionaries.MentionType.PROPER && m.mentionType != Dictionaries.MentionType.PROPER || this.mentionType == Dictionaries.MentionType.NOMINAL && m.mentionType == Dictionaries.MentionType.PRONOMINAL;
        }
        if (this.headIndex - this.startIndex > m.headIndex - m.startIndex) {
            return true;
        }
        return this.sentNum < m.sentNum || this.sentNum == m.sentNum && this.headIndex < m.headIndex;
    }

    public ArrayList<ArrayList<IndexedWord>> getPremodifiers() {
        ArrayList<ArrayList<IndexedWord>> premod = new ArrayList<ArrayList<IndexedWord>>();
        if (this.headIndexedWord == null) {
            return premod;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            String function = child.first().getShortName();
            if (child.second().index() >= this.headWord.index() || ((IndexedWord)child.second).tag().equals("DT") || ((IndexedWord)child.second).tag().equals("WRB") || function.endsWith("det") || function.equals("num") || function.equals("rcmod") || function.equals("infmod") || function.equals("partmod") || function.equals("punct")) continue;
            ArrayList<IndexedWord> phrase = new ArrayList<IndexedWord>(this.dependency.descendants(child.second()));
            Collections.sort(phrase);
            premod.add(phrase);
        }
        return premod;
    }

    public ArrayList<ArrayList<IndexedWord>> getPostmodifiers() {
        ArrayList<ArrayList<IndexedWord>> postmod = new ArrayList<ArrayList<IndexedWord>>();
        if (this.headIndexedWord == null) {
            return postmod;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            String function = child.first().getShortName();
            if (child.second().index() <= this.headWord.index() || function.endsWith("det") || function.equals("num") || function.equals("rcmod") || function.equals("infmod") || function.equals("partmod") || function.equals("punct") || function.equals("possessive") && this.dependency.descendants(child.second()).size() == 1) continue;
            ArrayList<IndexedWord> phrase = new ArrayList<IndexedWord>(this.dependency.descendants(child.second()));
            Collections.sort(phrase);
            postmod.add(phrase);
        }
        return postmod;
    }

    public String[] getSplitPattern() {
        ArrayList<ArrayList<IndexedWord>> premodifiers = this.getPremodifiers();
        String[] components = new String[4];
        components[0] = this.headWord.lemma();
        if (premodifiers.size() == 0) {
            components[1] = this.headWord.lemma();
            components[2] = this.headWord.lemma();
        } else if (premodifiers.size() == 1) {
            ArrayList<CoreLabel> premod = new ArrayList<CoreLabel>();
            premod.addAll((Collection)premodifiers.get(premodifiers.size() - 1));
            premod.add(this.headWord);
            components[1] = this.getPattern(premod);
            components[2] = this.getPattern(premod);
        } else {
            ArrayList<CoreLabel> premod1 = new ArrayList<CoreLabel>();
            premod1.addAll((Collection)premodifiers.get(premodifiers.size() - 1));
            premod1.add(this.headWord);
            components[1] = this.getPattern(premod1);
            ArrayList<CoreLabel> premod2 = new ArrayList<CoreLabel>();
            for (ArrayList<IndexedWord> premodifier : premodifiers) {
                premod2.addAll(premodifier);
            }
            premod2.add(this.headWord);
            components[2] = this.getPattern(premod2);
        }
        components[3] = this.getPattern();
        return components;
    }

    public String getPattern() {
        ArrayList<CoreLabel> pattern = new ArrayList<CoreLabel>();
        for (ArrayList<IndexedWord> premodifier : this.getPremodifiers()) {
            pattern.addAll(premodifier);
        }
        pattern.add(this.headWord);
        for (ArrayList<IndexedWord> postmodifier : this.getPostmodifiers()) {
            pattern.addAll(postmodifier);
        }
        return this.getPattern(pattern);
    }

    public String getPattern(List<CoreLabel> pTokens) {
        ArrayList<String> phrase_string = new ArrayList<String>();
        String ne = "";
        for (CoreLabel token : pTokens) {
            if (token.index() == this.headWord.index()) {
                phrase_string.add(token.lemma());
                ne = "";
                continue;
            }
            if ((token.lemma().equals("and") || StringUtils.isPunct(token.lemma())) && pTokens.size() > pTokens.indexOf(token) + 1 && pTokens.indexOf(token) > 0 && pTokens.get(pTokens.indexOf(token) + 1).ner().equals(pTokens.get(pTokens.indexOf(token) - 1).ner())) continue;
            if (token.index() == this.headWord.index() - 1 && token.ner().equals(this.nerString)) {
                phrase_string.add(token.lemma());
                ne = "";
                continue;
            }
            if (!token.ner().equals("O")) {
                if (token.ner().equals(ne)) continue;
                ne = token.ner();
                phrase_string.add("<" + ne + ">");
                continue;
            }
            phrase_string.add(token.lemma());
            ne = "";
        }
        return StringUtils.join(phrase_string);
    }

    public boolean isCoordinated() {
        if (this.headIndexedWord == null) {
            return false;
        }
        for (Pair<GrammaticalRelation, IndexedWord> child : this.dependency.childPairs(this.headIndexedWord)) {
            if (!child.first().getShortName().equals("cc")) continue;
            return true;
        }
        return false;
    }

    private static List<String> getContextHelper(List<? extends CoreLabel> words) {
        ArrayList namedEntities = new ArrayList();
        ArrayList<CoreLabel> ne = new ArrayList<CoreLabel>();
        String previousNEType = "";
        int previousNEIndex = -1;
        for (int i = 0; i < words.size(); ++i) {
            CoreLabel word = words.get(i);
            if (word.ner().equals("O")) continue;
            if (!word.ner().equals(previousNEType) || previousNEIndex != i - 1) {
                ne = new ArrayList();
                namedEntities.add(ne);
            }
            ne.add(word);
            previousNEType = word.ner();
            previousNEIndex = i;
        }
        ArrayList<String> neStrings = new ArrayList<String>();
        Set<String> hs = Generics.newHashSet();
        for (List list : namedEntities) {
            String ne_str = StringUtils.joinWords(list, " ");
            hs.add(ne_str);
        }
        neStrings.addAll(hs);
        return neStrings;
    }

    public List<String> getContext() {
        return Mention.getContextHelper(this.sentenceWords);
    }

    public List<String> getPremodifierContext() {
        ArrayList<String> neStrings = new ArrayList<String>();
        for (ArrayList<IndexedWord> words : this.getPremodifiers()) {
            neStrings.addAll(Mention.getContextHelper(words));
        }
        return neStrings;
    }

    public boolean isRelativePronoun(Mention m) {
        return this.relativePronouns != null && this.relativePronouns.contains(m);
    }

    public boolean isRoleAppositive(Mention m, Dictionaries dict) {
        String thisString = this.spanToString();
        if (this.isPronominal() || dict.allPronouns.contains(thisString.toLowerCase())) {
            return false;
        }
        if (!m.nerString.startsWith("PER") && !m.nerString.equals("O")) {
            return false;
        }
        if (!this.nerString.startsWith("PER") && !this.nerString.equals("O")) {
            return false;
        }
        if (!this.sameSentence(m) || !m.spanToString().startsWith(thisString)) {
            return false;
        }
        if (m.spanToString().contains("'") || m.spanToString().contains(" and ")) {
            return false;
        }
        if (!this.animaciesAgree(m) || this.animacy == Dictionaries.Animacy.INANIMATE || this.gender == Dictionaries.Gender.NEUTRAL || m.gender == Dictionaries.Gender.NEUTRAL || !this.numbersAgree(m)) {
            return false;
        }
        return !dict.demonymSet.contains(thisString.toLowerCase()) && !dict.demonymSet.contains(m.spanToString().toLowerCase());
    }

    public boolean isDemonym(Mention m, Dictionaries dict) {
        String thisString = this.spanToString().toLowerCase();
        String antString = m.spanToString().toLowerCase();
        if (thisString.startsWith("the ") || thisString.startsWith("The ")) {
            thisString = thisString.substring(4);
        }
        if (antString.startsWith("the ") || antString.startsWith("The ")) {
            antString = antString.substring(4);
        }
        if (dict.statesAbbreviation.containsKey(m.spanToString()) && dict.statesAbbreviation.get(m.spanToString()).equals(this.spanToString()) || dict.statesAbbreviation.containsKey(this.spanToString()) && dict.statesAbbreviation.get(this.spanToString()).equals(m.spanToString())) {
            return true;
        }
        return dict.demonyms.get(thisString) != null ? dict.demonyms.get(thisString).contains(antString) : dict.demonyms.get(antString) != null && dict.demonyms.get(antString).contains(thisString);
    }

    public String getPosition() {
        int size = this.sentenceWords.size();
        if (this.headIndex == 0) {
            return "first";
        }
        if (this.headIndex == size - 1) {
            return "last";
        }
        if (this.headIndex > 0 && this.headIndex < size / 3) {
            return "begin";
        }
        if (this.headIndex >= size / 3 && this.headIndex < 2 * size / 3) {
            return "middle";
        }
        if (this.headIndex >= 2 * size / 3 && this.headIndex < size - 1) {
            return "end";
        }
        return null;
    }

    public String getRelation() {
        if (this.headIndexedWord == null) {
            return null;
        }
        if (this.dependency.getRoots().isEmpty()) {
            return null;
        }
        if (this.dependency.getFirstRoot().equals(this.headIndexedWord)) {
            return "root";
        }
        if (!this.dependency.vertexSet().contains(this.dependency.getParent(this.headIndexedWord))) {
            return null;
        }
        GrammaticalRelation relation = this.dependency.reln(this.dependency.getParent(this.headIndexedWord), this.headIndexedWord);
        if (relation.toString().startsWith("prep") || relation == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT || relation == EnglishGrammaticalRelations.TEMPORAL_MODIFIER || relation == EnglishGrammaticalRelations.ADV_CLAUSE_MODIFIER || relation == EnglishGrammaticalRelations.ADVERBIAL_MODIFIER || relation == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) {
            return "adjunct";
        }
        if (relation == EnglishGrammaticalRelations.NOMINAL_SUBJECT || relation == EnglishGrammaticalRelations.CLAUSAL_SUBJECT || relation == EnglishGrammaticalRelations.CONTROLLING_SUBJECT) {
            return "subject";
        }
        if (relation == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT || relation == EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT) {
            return "subject";
        }
        if (relation == EnglishGrammaticalRelations.ADJECTIVAL_COMPLEMENT || relation == EnglishGrammaticalRelations.ATTRIBUTIVE || relation == EnglishGrammaticalRelations.CLAUSAL_COMPLEMENT || relation == EnglishGrammaticalRelations.XCLAUSAL_COMPLEMENT || relation == EnglishGrammaticalRelations.AGENT || relation == EnglishGrammaticalRelations.DIRECT_OBJECT || relation == EnglishGrammaticalRelations.INDIRECT_OBJECT) {
            return "verbArg";
        }
        if (relation == EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER || relation == EnglishGrammaticalRelations.NOUN_COMPOUND_MODIFIER || relation == EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER || relation == EnglishGrammaticalRelations.APPOSITIONAL_MODIFIER || relation == EnglishGrammaticalRelations.POSSESSION_MODIFIER) {
            return "nounArg";
        }
        return null;
    }

    public int getModifiers(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        int count = 0;
        List<Pair<GrammaticalRelation, IndexedWord>> childPairs = this.dependency.childPairs(this.headIndexedWord);
        for (Pair<GrammaticalRelation, IndexedWord> childPair : childPairs) {
            GrammaticalRelation gr = (GrammaticalRelation)childPair.first;
            IndexedWord word = (IndexedWord)childPair.second;
            if (gr == EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER || gr == EnglishGrammaticalRelations.PARTICIPIAL_MODIFIER || gr == EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER || gr == EnglishGrammaticalRelations.INFINITIVAL_MODIFIER || gr.toString().startsWith("prep_")) {
                ++count;
            }
            if (this.nerString.equals("O") && gr == EnglishGrammaticalRelations.NOUN_COMPOUND_MODIFIER) {
                ++count;
            }
            if (gr != EnglishGrammaticalRelations.POSSESSION_MODIFIER || dict.determiners.contains(word.lemma())) continue;
            ++count;
        }
        return count;
    }

    public String getQuantification(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return null;
        }
        if (!this.nerString.equals("O")) {
            return "definite";
        }
        List<IndexedWord> quant = this.dependency.getChildrenWithReln(this.headIndexedWord, EnglishGrammaticalRelations.DETERMINER);
        List<IndexedWord> poss = this.dependency.getChildrenWithReln(this.headIndexedWord, EnglishGrammaticalRelations.POSSESSION_MODIFIER);
        String det = "";
        if (!quant.isEmpty()) {
            det = quant.get(0).lemma();
            if (dict.determiners.contains(det)) {
                return "definite";
            }
        } else {
            if (!poss.isEmpty()) {
                return "definite";
            }
            quant = this.dependency.getChildrenWithReln(this.headIndexedWord, EnglishGrammaticalRelations.NUMERIC_MODIFIER);
            if (dict.quantifiers2.contains(det) || !quant.isEmpty()) {
                return "quantified";
            }
        }
        return "indefinite";
    }

    public int getNegation(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        Collection<IndexedWord> children = this.dependency.getChildren(this.headIndexedWord);
        for (IndexedWord child : children) {
            if (!dict.negations.contains(child.lemma())) continue;
            return 1;
        }
        Collection<IndexedWord> siblings = this.dependency.getSiblings(this.headIndexedWord);
        for (IndexedWord sibling : siblings) {
            if (!dict.negations.contains(sibling.lemma()) || this.dependency.hasParentWithReln(this.headIndexedWord, EnglishGrammaticalRelations.NOMINAL_SUBJECT)) continue;
            return 1;
        }
        List<Pair<GrammaticalRelation, IndexedWord>> parentPairs = this.dependency.parentPairs(this.headIndexedWord);
        if (!parentPairs.isEmpty()) {
            Pair<GrammaticalRelation, IndexedWord> parentPair = parentPairs.get(0);
            GrammaticalRelation gr = (GrammaticalRelation)parentPair.first;
            if (dict.neg_relations.contains(gr.toString())) {
                return 1;
            }
        }
        return 0;
    }

    public int getModal(Dictionaries dict) {
        List<IndexedWord> path;
        if (this.headIndexedWord == null) {
            return 0;
        }
        Collection<IndexedWord> children = this.dependency.getChildren(this.headIndexedWord);
        for (IndexedWord child : children) {
            if (!dict.modals.contains(child.lemma())) continue;
            return 1;
        }
        IndexedWord parent = this.dependency.getParent(this.headIndexedWord);
        if (parent != null) {
            IndexedWord child;
            if (dict.modals.contains(parent.lemma())) {
                return 1;
            }
            child = this.dependency.getChildWithReln(parent, EnglishGrammaticalRelations.AUX_MODIFIER);
            if (!this.dependency.hasParentWithReln(this.headIndexedWord, EnglishGrammaticalRelations.NOMINAL_SUBJECT) && child != null && dict.modals.contains(child.lemma())) {
                return 1;
            }
        }
        if ((path = this.dependency.getPathToRoot(this.headIndexedWord)) == null) {
            return 0;
        }
        for (IndexedWord word : path) {
            if (!dict.modals.contains(word.lemma())) continue;
            return 1;
        }
        return 0;
    }

    public int getReportEmbedding(Dictionaries dict) {
        if (this.headIndexedWord == null) {
            return 0;
        }
        Collection<IndexedWord> siblings = this.dependency.getSiblings(this.headIndexedWord);
        for (IndexedWord sibling : siblings) {
            IndexedWord marker;
            if (!dict.reportVerb.contains(sibling.lemma()) || !this.dependency.hasParentWithReln(sibling, EnglishGrammaticalRelations.ADV_CLAUSE_MODIFIER) || (marker = this.dependency.getChildWithReln(sibling, EnglishGrammaticalRelations.MARKER)) == null || !marker.lemma().equals("as")) continue;
            return 1;
        }
        List<IndexedWord> path = this.dependency.getPathToRoot(this.headIndexedWord);
        if (path == null) {
            return 0;
        }
        boolean isSubject = false;
        if (this.dependency.hasParentWithReln(this.headIndexedWord, EnglishGrammaticalRelations.NOMINAL_SUBJECT)) {
            isSubject = true;
        }
        for (IndexedWord word : path) {
            if (!isSubject && (dict.reportVerb.contains(word.lemma()) || dict.reportNoun.contains(word.lemma()))) {
                return 1;
            }
            isSubject = this.dependency.hasParentWithReln(word, EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        }
        return 0;
    }

    public int getCoordination() {
        if (this.headIndexedWord == null) {
            return 0;
        }
        Set<GrammaticalRelation> relations = this.dependency.childRelns(this.headIndexedWord);
        for (GrammaticalRelation rel : relations) {
            if (!rel.toString().startsWith("conj_")) continue;
            return 1;
        }
        Set<GrammaticalRelation> parent_relations = this.dependency.relns(this.headIndexedWord);
        for (GrammaticalRelation rel : parent_relations) {
            if (!rel.toString().startsWith("conj_")) continue;
            return 1;
        }
        return 0;
    }
}

