/* Generated By:JavaCC: Do not edit this line. TokenSequenceParser.java */
package edu.stanford.nlp.ling.tokensregex.parser;
// all generated classes are in this package

//imports
import edu.stanford.nlp.ling.tokensregex.types.*;
import edu.stanford.nlp.ling.tokensregex.*;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ArrayMap;
import edu.stanford.nlp.util.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.util.*;

public class TokenSequenceParser implements SequencePattern.Parser<CoreMap>, TokenSequenceParserConstants {
    public TokenSequenceParser() {}

    public CoreMapExpressionExtractor getExpressionExtractor(Env env, Reader r) throws ParseException {
        TokenSequenceParser p = new TokenSequenceParser(r);
        List<SequenceMatchRules.Rule> rules = p.RuleList(env);
        return new CoreMapExpressionExtractor(env, rules);
    }

    public void updateExpressionExtractor(CoreMapExpressionExtractor extractor, Reader r) throws ParseException {
        TokenSequenceParser p = new TokenSequenceParser(r);
        List<SequenceMatchRules.Rule> rules = p.RuleList(extractor.getEnv());
        extractor.appendRules(rules);
    }

        public SequencePattern.PatternExpr parseSequence(Env env, String s) throws ParseException {
        TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
        return p.SeqRegex(env);
        }

        public Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>> parseSequenceWithAction(Env env, String s) throws ParseException {
        TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
        return p.SeqRegexWithAction(env);
        }

        public SequencePattern.PatternExpr parseNode(Env env, String s) throws ParseException {
        TokenSequenceParser p = new TokenSequenceParser(new StringReader(s));
        NodePattern n = p.Node(env);
        return new SequencePattern.NodePatternExpr(n);
        }

    private Integer parseInteger(String str) {
      if (str.startsWith("+")) {
        return Integer.valueOf(str.substring(1));
      } else {
        return Integer.valueOf(str);
      }
    }

    private Long parseLongInteger(String str) {
      if (str.endsWith("L")) {
        str = str.substring(0, str.length()-1);
      }
      if (str.startsWith("+")) {
        return Long.valueOf(str.substring(1));
      } else {
        return Long.valueOf(str);
      }
    }

  final public List<SequenceMatchRules.Rule> RuleList(Env env) throws ParseException {
  List<SequenceMatchRules.Rule> rules = new ArrayList<SequenceMatchRules.Rule>();
  SequenceMatchRules.Rule rule;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case REGEXVAR:
      case 21:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      rule = Rule(env);
                         rules.add(rule);
    }
      {if (true) return rules;}
    throw new Error("Missing return statement in function");
  }

  final public SequenceMatchRules.Rule Rule(Env env) throws ParseException {
  SequenceMatchRules.Rule rule;
  Expressions.CompositeValue cv;
    if (jj_2_1(3)) {
      rule = ExpressionExtractorRule(env);
    } else if (jj_2_2(3)) {
      rule = AssignmentRule(env);
    } else if (jj_2_3(3)) {
      cv = CompositeFieldValue(env);
                                    rule = SequenceMatchRules.createRule(env, cv);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return rule;}
    throw new Error("Missing return statement in function");
  }

  final public SequenceMatchRules.Rule ExpressionExtractorRule(Env env) throws ParseException {
  SequencePattern.PatternExpr expr;
  String stringRegex;
  Expression result;
  Token ruleTypeToken;
    if (jj_2_4(2)) {
      jj_consume_token(21);
      stringRegex = StringRegex(env);
      jj_consume_token(22);
      result = Expression(env);
      jj_consume_token(23);
    {if (true) return SequenceMatchRules.createExtractionRule(env, null, stringRegex, result);}
    } else if (jj_2_5(2)) {
      jj_consume_token(21);
      jj_consume_token(24);
      expr = SeqRegex(env);
      jj_consume_token(25);
      jj_consume_token(22);
      result = Expression(env);
      jj_consume_token(23);
    {if (true) return SequenceMatchRules.createExtractionRule(env, null, TokenSequencePattern.compile(expr), result);}
    } else if (jj_2_6(2)) {
      jj_consume_token(21);
      jj_consume_token(26);
      jj_consume_token(24);
      expr = SeqRegex(env);
      jj_consume_token(25);
      jj_consume_token(22);
      result = Expression(env);
      jj_consume_token(23);
    {if (true) return SequenceMatchRules.createTokenPatternRule(env, expr, result);}
    } else if (jj_2_7(2)) {
      jj_consume_token(21);
      jj_consume_token(27);
      stringRegex = StringRegex(env);
      jj_consume_token(22);
      result = Expression(env);
      jj_consume_token(23);
    {if (true) return SequenceMatchRules.createTextPatternRule(env, stringRegex, result);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SequenceMatchRules.Rule AssignmentRule(Env env) throws ParseException {
  AssignableExpression var;
  Expression result;
    var = AssignableExpression(env);
    jj_consume_token(28);
    result = Expression(env);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 29:
      jj_consume_token(29);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    {if (true) return SequenceMatchRules.createAssignmentRule(env, var, result);}
    throw new Error("Missing return statement in function");
  }

  final public AssignableExpression AssignableExpression(Env env) throws ParseException {
  AssignableExpression expr;
    expr = AssignableNestedVarExpression(env);
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression Expression(Env env) throws ParseException {
  Expression expr;
    if (jj_2_8(4)) {
      expr = FunctionCallExpression(env);
    } else if (jj_2_9(4)) {
      expr = NestedVarExpression(env);
    } else if (jj_2_10(4)) {
      expr = ValueExpression(env);
    } else if (jj_2_11(4)) {
      expr = ListExpression(env);
    } else if (jj_2_12(4)) {
      expr = CaseExpression(env);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public int Index() throws ParseException {
  Token t;
    jj_consume_token(30);
    t = IntegerToken();
    jj_consume_token(31);
    {if (true) return Integer.valueOf(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public Expression FunctionCallExpression(Env env) throws ParseException {
  Token typeToken;
  Expression param;
  List<Expression> params = new ArrayList<Expression>();
    typeToken = jj_consume_token(IDENTIFIER);
    jj_consume_token(24);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case REGEXVAR:
    case REGEXGROUP:
    case REGEXMRVAR:
    case REGEXMRGROUP:
    case NONNEGINT:
    case INT:
    case LONGINT:
    case REAL:
    case REGEX:
    case STR:
    case 21:
    case 24:
    case 37:
      param = Expression(env);
                                 params.add(param);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 32:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
        jj_consume_token(32);
        param = Expression(env);
                                       params.add(param);
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    jj_consume_token(25);
    {if (true) return new Expressions.FunctionCallExpression(typeToken.image, params);}
    throw new Error("Missing return statement in function");
  }

  final public Value ValueExpression(Env env) throws ParseException {
  Value expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NONNEGINT:
    case INT:
    case LONGINT:
    case REAL:
    case REGEX:
    case STR:
    case 24:
      expr = BasicValue(env);
      break;
    case 21:
      expr = CompositeFieldValue(env);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expressions.CompositeValue CompositeFieldValue(Env env) throws ParseException {
    Map<String, Expression> attributes = new ArrayMap<String,Expression>();
    jj_consume_token(21);
    FieldValue(env, attributes);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 29:
      case 32:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 32:
        jj_consume_token(32);
        break;
      case 29:
        jj_consume_token(29);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      FieldValue(env, attributes);
    }
    jj_consume_token(23);
          {if (true) return new Expressions.CompositeValue(/*"COMPOSITE", */ attributes, false);}
    throw new Error("Missing return statement in function");
  }

  final public Map<String,Expression> FieldValue(Env env, Map<String,Expression> attributes) throws ParseException {
        String fieldname = null;
        Expression expr = null;
    fieldname = RelaxedString();
    jj_consume_token(33);
    expr = Expression(env);
              if (fieldname != null && expr != null)  {
                if (attributes.containsKey(fieldname)) {
                {if (true) throw new Error("Field already defined: " + fieldname);}
                }
                attributes.put(fieldname, expr);
              }
          {if (true) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final public Value BasicValue(Env env) throws ParseException {
        Token tok = null;
        SequencePattern.PatternExpr seqRegex = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REGEX:
      tok = jj_consume_token(REGEX);
                        {if (true) return new Expressions.RegexValue(/*"REGEX",*/ tok.image.substring(1,tok.image.length()-1));}
      break;
    case STR:
      tok = jj_consume_token(STR);
                      {if (true) return new Expressions.PrimitiveValue<String>("STRING", tok.image.substring(1,tok.image.length()-1) );}
      break;
    case NONNEGINT:
    case INT:
      tok = IntegerToken();
                               {if (true) return new Expressions.PrimitiveValue<Number>("INTEGER", parseInteger(tok.image));}
      break;
    case LONGINT:
      tok = jj_consume_token(LONGINT);
                          {if (true) return new Expressions.PrimitiveValue<Number>("INTEGER", parseLongInteger(tok.image));}
      break;
    case REAL:
      tok = jj_consume_token(REAL);
                       {if (true) return new Expressions.PrimitiveValue<Number>("REAL", Double.valueOf(tok.image));}
      break;
    case 24:
      jj_consume_token(24);
      seqRegex = SeqRegex(env);
      jj_consume_token(25);
          TokenSequencePattern seqPattern = new TokenSequencePattern(null, seqRegex);
          {if (true) return new Expressions.PrimitiveValue<TokenSequencePattern>("TOKEN_REGEX", seqPattern);}
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public AssignableExpression AssignableVar(Env env) throws ParseException {
        Token tok = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
                             {if (true) return new Expressions.VarExpression(tok.image);}
      break;
    case REGEXVAR:
      tok = jj_consume_token(REGEXVAR);
                           {if (true) return new Expressions.RegexMatchVarExpression(tok.image);}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression VarOrRegexVar(Env env) throws ParseException {
        Token tok = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      tok = jj_consume_token(IDENTIFIER);
                             {if (true) return new Expressions.VarExpression(tok.image);}
      break;
    case REGEXVAR:
      tok = jj_consume_token(REGEXVAR);
                           {if (true) return new Expressions.RegexMatchVarExpression(tok.image);}
      break;
    case REGEXGROUP:
      tok = jj_consume_token(REGEXGROUP);
                             {if (true) return new Expressions.RegexMatchVarExpression(Integer.valueOf(tok.image.substring(1)));}
      break;
    case REGEXMRVAR:
      tok = jj_consume_token(REGEXMRVAR);
                             {if (true) return new Expressions.RegexMatchResultVarExpression(tok.image.substring(1));}
      break;
    case REGEXMRGROUP:
      tok = jj_consume_token(REGEXMRGROUP);
                               {if (true) return new Expressions.RegexMatchResultVarExpression(Integer.valueOf(tok.image.substring(2)));}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression MethodCallExpression(Env env, Expression parent) throws ParseException {
  Token typeToken;
  Expression param;
  List<Expression> params = new ArrayList<Expression>();
    typeToken = jj_consume_token(IDENTIFIER);
    jj_consume_token(24);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case REGEXVAR:
    case REGEXGROUP:
    case REGEXMRVAR:
    case REGEXMRGROUP:
    case NONNEGINT:
    case INT:
    case LONGINT:
    case REAL:
    case REGEX:
    case STR:
    case 21:
    case 24:
    case 37:
      param = Expression(env);
                                 params.add(param);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 32:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_4;
        }
        jj_consume_token(32);
        param = Expression(env);
                                       params.add(param);
      }
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(25);
    {if (true) return new Expressions.MethodCallExpression(typeToken.image, parent, params);}
    throw new Error("Missing return statement in function");
  }

  final public AssignableExpression AssignableNestedVarExpression(Env env) throws ParseException {
  AssignableExpression expr;
  Expression fieldExpr;
  String s;
  Token tok;
  int i;
    expr = AssignableVar(env);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 30:
      case 34:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      if (jj_2_13(2)) {
        i = Index();
      expr = new Expressions.IndexedExpression(expr, i);
      } else if (jj_2_14(2)) {
        jj_consume_token(30);
        fieldExpr = Expression(env);
       expr = new Expressions.FieldExpression(expr, fieldExpr);
        jj_consume_token(31);
      } else if (jj_2_15(2)) {
        jj_consume_token(34);
        s = RelaxedString();
       expr = new Expressions.FieldExpression(expr, s);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression NestedVarExpression(Env env) throws ParseException {
  Expression expr;
  Expression fieldExpr;
  String s;
  Token tok;
  int i;
    expr = VarOrRegexVar(env);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 30:
      case 34:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
      if (jj_2_16(3)) {
        i = Index();
      expr = new Expressions.IndexedExpression(expr, i);
      } else if (jj_2_17(3)) {
        jj_consume_token(30);
        fieldExpr = Expression(env);
       expr = new Expressions.FieldExpression(expr, fieldExpr);
        jj_consume_token(31);
      } else if (jj_2_18(3)) {
        jj_consume_token(34);
        expr = MethodCallExpression(env, expr);
      } else if (jj_2_19(3)) {
        jj_consume_token(34);
        s = RelaxedString();
       expr = new Expressions.FieldExpression(expr, s);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression ListExpression(Env env) throws ParseException {
  List<Expression> exprs = new ArrayList<Expression>();
  Expression expr;
    jj_consume_token(24);
    expr = Expression(env);
       exprs.add(expr);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 32:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_7;
      }
      jj_consume_token(32);
      expr = Expression(env);
       exprs.add(expr);
    }
    jj_consume_token(25);
    {if (true) return new Expressions.ListExpression(Expressions.TYPE_LIST, exprs);}
    throw new Error("Missing return statement in function");
  }

  final public Expression BasicCondExpression(Env env) throws ParseException {
  Expression expr1 = null;
  Expression expr2 = null;
  Token op = null;
    if (jj_2_20(3)) {
      expr1 = NestedVarExpression(env);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMCMP:
      case STRREGEXCMP:
        op = CmpToken();
        expr2 = Expression(env);
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    if (op == null) {
      {if (true) return new Expressions.ConditionalExpression(expr1);}
    } else {
      {if (true) return new Expressions.ConditionalExpression(op.image, expr1, expr2);}
    }
    } else if (jj_2_21(3)) {
      expr1 = FunctionCallExpression(env);
      {if (true) return new Expressions.ConditionalExpression(expr1);}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Expression CondGroup(Env env) throws ParseException {
  Expression expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case REGEXVAR:
    case REGEXGROUP:
    case REGEXMRVAR:
    case REGEXMRGROUP:
      expr = BasicCondExpression(env);
      break;
    case 24:
      jj_consume_token(24);
      expr = CondExpression(env);
      jj_consume_token(25);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Expression CondExpression(Env env) throws ParseException {
  Expression child;
  List<Expression> disjChildren = new ArrayList<Expression>();
  List<Expression> conjChildren = new ArrayList<Expression>();
  Token op;
    child = CondGroup(env);
                                conjChildren.add(child);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 35:
      case 36:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 35:
        op = jj_consume_token(35);
        break;
      case 36:
        op = jj_consume_token(36);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      child = CondGroup(env);
             if ("&&".equals(op.image)) {
              conjChildren.add(child);
             } else if ("||".equals(op.image)) {
               if (conjChildren.size() > 1) {
                  disjChildren.add(new Expressions.AndExpression(conjChildren));
               } else {
                  disjChildren.add(conjChildren.get(0));
               }
               conjChildren = new ArrayList<Expression>();
               conjChildren.add(child);
             }
    }
          if (conjChildren.size() > 1) {
             disjChildren.add(new Expressions.AndExpression(conjChildren));
          } else {
             disjChildren.add(conjChildren.get(0));
          }
          if (disjChildren.size() == 1)
                {if (true) return disjChildren.get(0);}
          else
                {if (true) return new Expressions.OrExpression(disjChildren);}
    throw new Error("Missing return statement in function");
  }

  final public Expression CaseExpression(Env env) throws ParseException {
  Expression cond = null;
  Expression expr = null;
  List<Pair<Expression, Expression>> cases
    = new ArrayList<Pair<Expression, Expression>>();
  Expression elseExpr = null;
    jj_consume_token(37);
    jj_consume_token(21);
    label_9:
    while (true) {
      cond = CondExpression(env);
      jj_consume_token(22);
      expr = Expression(env);
            cases.add(new Pair<Expression, Expression>(cond, expr));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 32:
        jj_consume_token(32);
        break;
      case 29:
        jj_consume_token(29);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case REGEXVAR:
      case REGEXGROUP:
      case REGEXMRVAR:
      case REGEXMRGROUP:
      case 24:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_9;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 38:
      jj_consume_token(38);
      jj_consume_token(22);
      elseExpr = Expression(env);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(23);
     {if (true) return new Expressions.CaseExpression(cases, elseExpr);}
    throw new Error("Missing return statement in function");
  }

  final public String StringRegex(Env env) throws ParseException {
  Token tok;
    tok = jj_consume_token(REGEX);
                         {if (true) return tok.image.substring(1,tok.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegex(Env env) throws ParseException {
  SequencePattern.PatternExpr expr;
    expr = SeqRegexDisjConj(env);
                                        {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Object StringNumberValue(Env env) throws ParseException {
        Token tok = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR:
      tok = jj_consume_token(STR);
                      {if (true) return tok.image.substring(1,tok.image.length()-1);}
      break;
    case NONNEGINT:
    case INT:
      tok = IntegerToken();
                               {if (true) return parseInteger(tok.image);}
      break;
    case LONGINT:
      tok = jj_consume_token(LONGINT);
                          {if (true) return parseLongInteger(tok.image);}
      break;
    case REAL:
      tok = jj_consume_token(REAL);
                       {if (true) return Double.valueOf(tok.image);}
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegexBasic(Env env) throws ParseException {
  List<SequencePattern.PatternExpr> children = new ArrayList<SequencePattern.PatternExpr>();
  NodePattern node;
  MultiNodePattern multiNode;
  SequencePattern.PatternExpr expr;
  Object value = null;
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 30:
        node = BracketedNode(env);
                                        expr = new SequencePattern.NodePatternExpr(node);
        break;
      case IDENTIFIER:
      case REGEX:
      case STR:
        node = CoreMapWordPattern(env);
                                             expr = new SequencePattern.NodePatternExpr(node);
        break;
      case 49:
        multiNode = MultiNodePattern(env);
                                                expr = new SequencePattern.MultiNodePatternExpr(multiNode);
        break;
      case 24:
        expr = SeqRegexGroup(env);
        break;
      case REGEXVAR:
        expr = SeqVar(env);
        break;
      case BACKREF:
        expr = SeqBackRef(env);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
      case 39:
      case 40:
      case 41:
        expr = SeqRegexRepeatTimes(env, expr);
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
         children.add(expr);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
      case REGEXVAR:
      case BACKREF:
      case REGEX:
      case STR:
      case 24:
      case 30:
      case 49:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_10;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 22:
      jj_consume_token(22);
      value = Expression(env);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
          if (children.size() != 1) {
            expr = new SequencePattern.SequencePatternExpr(children);
          }
          if (value != null) {
            expr = new SequencePattern.ValuePatternExpr(expr, value);
          }
          {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegexRepeatTimes(Env env, SequencePattern.PatternExpr expr) throws ParseException {
   Token value;
   Token v2;
   int min = -1;
   int max = -1;
   boolean greedy = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 39:
      value = jj_consume_token(39);
                          min = 0; max = -1;
      break;
    case 40:
      value = jj_consume_token(40);
                          min = 0; max = 1;
      break;
    case 41:
      value = jj_consume_token(41);
                          min = 1; max = -1;
      break;
    default:
      jj_la1[27] = jj_gen;
      if (jj_2_22(3)) {
        jj_consume_token(21);
        value = jj_consume_token(NONNEGINT);
        jj_consume_token(23);
                                          min = Integer.parseInt(value.image); max = min;
      } else if (jj_2_23(4)) {
        jj_consume_token(21);
        value = jj_consume_token(NONNEGINT);
        jj_consume_token(32);
        jj_consume_token(23);
                                              min = Integer.parseInt(value.image); max = -1;
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 21:
          jj_consume_token(21);
          value = jj_consume_token(NONNEGINT);
          jj_consume_token(32);
          v2 = jj_consume_token(NONNEGINT);
          jj_consume_token(23);
                                                                min = Integer.parseInt(value.image); max = Integer.parseInt(v2.image);
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 40:
      jj_consume_token(40);
             greedy = false;
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
      {if (true) return new SequencePattern.RepeatPatternExpr(expr, min, max, greedy);}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegexDisj(Env env) throws ParseException {
  List<SequencePattern.PatternExpr> children = new ArrayList<SequencePattern.PatternExpr>();
  SequencePattern.PatternExpr expr;
    expr = SeqRegexBasic(env);
                                    children.add(expr);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 36:
      case 42:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 42:
        jj_consume_token(42);
        break;
      case 36:
        jj_consume_token(36);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = SeqRegexBasic(env);
                                                children.add(expr);
    }
            if (children.size() == 1) { {if (true) return children.get(0);} }
                else { {if (true) return new SequencePattern.OrPatternExpr(children);}  }
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegexDisjConj(Env env) throws ParseException {
        SequencePattern.PatternExpr child;
        List<SequencePattern.PatternExpr> disjChildren = new ArrayList<SequencePattern.PatternExpr>();
        List<SequencePattern.PatternExpr> conjChildren = new ArrayList<SequencePattern.PatternExpr>();
        Token op;
    child = SeqRegexBasic(env);
                                    conjChildren.add(child);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 35:
      case 36:
      case 42:
      case 43:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 43:
        op = jj_consume_token(43);
        break;
      case 42:
        op = jj_consume_token(42);
        break;
      case 35:
        op = jj_consume_token(35);
        break;
      case 36:
        op = jj_consume_token(36);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      child = SeqRegexBasic(env);
             if ("&".equals(op.image) | "&&".equals(op.image)) {
              conjChildren.add(child);
             } else if ("|".equals(op.image) | "||".equals(op.image)) {
               if (conjChildren.size() > 1) {
                  disjChildren.add(new SequencePattern.AndPatternExpr(conjChildren));
               } else {
                  disjChildren.add(conjChildren.get(0));
               }
               conjChildren = new ArrayList<SequencePattern.PatternExpr>();
               conjChildren.add(child);
             }
    }
          if (conjChildren.size() > 1) {
             disjChildren.add(new SequencePattern.AndPatternExpr(conjChildren));
          } else {
             disjChildren.add(conjChildren.get(0));
          }
          if (disjChildren.size() == 1)
                {if (true) return disjChildren.get(0);}
          else
                {if (true) return new SequencePattern.OrPatternExpr(disjChildren);}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqRegexGroup(Env env) throws ParseException {
  SequencePattern.PatternExpr expr;
  boolean capturing = true;
  String varname = null;
  Token var;
    jj_consume_token(24);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 40:
    case 44:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 44:
        jj_consume_token(44);
                capturing = false;
        break;
      case 40:
        jj_consume_token(40);
        var = jj_consume_token(REGEXVAR);
                                varname = var.image;
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    expr = SeqRegex(env);
    jj_consume_token(25);
                if (varname != null) {
                   {if (true) return new SequencePattern.GroupPatternExpr(expr, varname);}
                } else {
                   {if (true) return new SequencePattern.GroupPatternExpr(expr, capturing);}
        }
    throw new Error("Missing return statement in function");
  }

  final public NodePattern BracketedNode(Env env) throws ParseException {
  NodePattern node;
    if (jj_2_24(2)) {
      jj_consume_token(30);
      jj_consume_token(31);
              node = NodePattern.ANY_NODE;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 30:
        jj_consume_token(30);
        node = NodeDisjConj(env);
        jj_consume_token(31);
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqVar(Env env) throws ParseException {
  SequencePattern.PatternExpr expr;
  Token name;
    name = jj_consume_token(REGEXVAR);
        expr = env.getSequencePatternExpr(name.image, true);
        if (expr == null) {
            {if (true) throw new Error("Unknown sequence pattern variable " + name.image);}
        }
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public SequencePattern.PatternExpr SeqBackRef(Env env) throws ParseException {
  Token name;
    name = jj_consume_token(BACKREF);
        int v = Integer.parseInt(name.image.substring(1));
        {if (true) return new SequencePattern.BackRefPatternExpr(CoreMapNodePattern.TEXT_ATTR_EQUAL_CHECKER, v);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern Node(Env env) throws ParseException {
  NodePattern node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 30:
      node = BracketedNode(env);
      break;
    case IDENTIFIER:
    case REGEXVAR:
    case REGEX:
    case STR:
    case 21:
    case 24:
    case 45:
    case 46:
      node = NodeGroup(env);
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern NodeDisj(Env env) throws ParseException {
        List<NodePattern> children = new ArrayList<NodePattern>();
        NodePattern child;
    child = NodeGroup(env);
                                 children.add(child);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 36:
      case 42:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_13;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 42:
        jj_consume_token(42);
        break;
      case 36:
        jj_consume_token(36);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      child = NodeGroup(env);
                                               children.add(child);
    }
          if (children.size() == 1)
                {if (true) return child;}
          else
                {if (true) return new NodePattern.DisjNodePattern(children);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern NodeConj(Env env) throws ParseException {
        NodePattern child;
        List children = new ArrayList();
    child = NodeGroup(env);
                                children.add(child);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 35:
      case 43:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_14;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 43:
        jj_consume_token(43);
        break;
      case 35:
        jj_consume_token(35);
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      child = NodeGroup(env);
                                               children.add(child);
    }
          if (children.size() == 1)
                {if (true) return child;}
          else
                {if (true) return new NodePattern.ConjNodePattern(children);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern NodeDisjConj(Env env) throws ParseException {
        NodePattern child;
        List<NodePattern> disjChildren = new ArrayList<NodePattern>();
        List<NodePattern> conjChildren = new ArrayList<NodePattern>();
        Token op;
    child = NodeGroup(env);
                                conjChildren.add(child);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 35:
      case 36:
      case 42:
      case 43:
        ;
        break;
      default:
        jj_la1[42] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 43:
        op = jj_consume_token(43);
        break;
      case 42:
        op = jj_consume_token(42);
        break;
      case 35:
        op = jj_consume_token(35);
        break;
      case 36:
        op = jj_consume_token(36);
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      child = NodeGroup(env);
             if ("&".equals(op.image) || "&&".equals(op.image)) {
              conjChildren.add(child);
             } else if ("|".equals(op.image) || ("||".equals(op.image))) {
               if (conjChildren.size() > 1) {
                  disjChildren.add(new NodePattern.ConjNodePattern(conjChildren));
               } else {
                  disjChildren.add(conjChildren.get(0));
               }
               conjChildren = new ArrayList<NodePattern>();
               conjChildren.add(child);
             }
    }
          if (conjChildren.size() > 1) {
             disjChildren.add(new NodePattern.ConjNodePattern(conjChildren));
          } else {
             disjChildren.add(conjChildren.get(0));
          }
          if (disjChildren.size() == 1)
                {if (true) return disjChildren.get(0);}
          else
                {if (true) return new NodePattern.DisjNodePattern(disjChildren);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern NodeGroup(Env env) throws ParseException {
  NodePattern node;
    if (jj_2_25(2)) {
      node = NodeBasic(env);
    } else if (jj_2_26(2)) {
      jj_consume_token(24);
      node = NodeDisjConj(env);
      jj_consume_token(25);
    } else if (jj_2_27(2)) {
      jj_consume_token(45);
      jj_consume_token(24);
      node = NodeDisjConj(env);
      jj_consume_token(25);
        node = new NodePattern.NegateNodePattern(node);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern NodeBasic(Env env) throws ParseException {
        NodePattern child;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 45:
      jj_consume_token(45);
      child = CoreMapNode(env);
          {if (true) return new NodePattern.NegateNodePattern(child);}
      break;
    case IDENTIFIER:
    case REGEXVAR:
    case REGEX:
    case STR:
    case 21:
    case 46:
      child = CoreMapNode(env);
          {if (true) return child;}
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public NodePattern CoreMapNode(Env env) throws ParseException {
    Map<String, String> attributes = new ArrayMap<String,String>();
    NodePattern pat;
        Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case REGEX:
    case STR:
    case 21:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        AttrValue(env, attributes);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 29:
          case 32:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_16;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 32:
            jj_consume_token(32);
            break;
          case 29:
            jj_consume_token(29);
            break;
          default:
            jj_la1[46] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          AttrValue(env, attributes);
        }
        jj_consume_token(23);
        break;
      case IDENTIFIER:
      case REGEX:
      case STR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
        case STR:
          value = RelaxedStringToken();
          break;
        case REGEX:
          value = jj_consume_token(REGEX);
          break;
        default:
          jj_la1[47] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                        attributes.put("word", value.image);
        break;
      default:
        jj_la1[48] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
          pat = CoreMapNodePattern.valueOf(env, attributes);
          {if (true) return pat;}
      break;
    case REGEXVAR:
      pat = CoreMapVarNodePattern(env);
            {if (true) return pat;}
      break;
    case 46:
      jj_consume_token(46);
      pat = CoreMapExprNodePattern(env);
      jj_consume_token(47);
            {if (true) return pat;}
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Map<String,String> AttrValue(Env env, Map<String,String> attributes) throws ParseException {
        Token attr = null;
        Token value = null;
        Token tok = null;
        String str = null;
    attr = jj_consume_token(IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 33:
      jj_consume_token(33);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STR:
        value = jj_consume_token(STR);
        break;
      case REGEX:
        value = jj_consume_token(REGEX);
        break;
      case IDENTIFIER:
        value = jj_consume_token(IDENTIFIER);
        break;
      case REGEXVAR:
        str = CoreMapVarValue(env);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case 48:
      tok = jj_consume_token(48);
      value = jj_consume_token(IDENTIFIER);
      break;
    case NUMCMP:
      tok = jj_consume_token(NUMCMP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NONNEGINT:
      case INT:
      case REAL:
        value = NumberToken();
        break;
      case REGEXVAR:
        str = CoreMapVarValue(env);
        break;
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              if (value != null) { str = value.image; }
              if (tok != null) { str = tok.image + str; }
              if (attr != null && str != null)  {
                if (attributes.containsKey(attr.image)) {
                {if (true) throw new Error("Attribute match already defined: " + attr.image);}
                }
                attributes.put(attr.image, str);
              }
          {if (true) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern CoreMapWordPattern(Env env) throws ParseException {
    Map<String, String> attributes = new ArrayMap<String,String>();
    CoreMapNodePattern pat;
        Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR:
      value = jj_consume_token(STR);
      break;
    case REGEX:
      value = jj_consume_token(REGEX);
      break;
    case IDENTIFIER:
      value = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                  attributes.put("word", value.image);
          pat = CoreMapNodePattern.valueOf(env, attributes);
          {if (true) return pat;}
    throw new Error("Missing return statement in function");
  }

  final public MultiNodePattern MultiNodePattern(Env env) throws ParseException {
    NodePattern pat;
    MultiNodePattern mp;
    Token v1, v2;
    int min = 1, max = -1;
    jj_consume_token(49);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 21:
      if (jj_2_28(3)) {
        jj_consume_token(21);
        v1 = jj_consume_token(NONNEGINT);
        jj_consume_token(23);
       min = Integer.parseInt(v1.image);
       max = Integer.parseInt(v1.image);
      } else if (jj_2_29(4)) {
        jj_consume_token(21);
        v1 = jj_consume_token(NONNEGINT);
        jj_consume_token(32);
        jj_consume_token(23);
       min = Integer.parseInt(v1.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 21:
          jj_consume_token(21);
          v1 = jj_consume_token(NONNEGINT);
          jj_consume_token(32);
          v2 = jj_consume_token(NONNEGINT);
          jj_consume_token(23);
       min = Integer.parseInt(v1.image);
       max = Integer.parseInt(v2.image);
          break;
        default:
          jj_la1[54] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    pat = CoreMapWordPattern(env);
      mp = new MultiCoreMapNodePattern(pat);
      mp.setMinNodes(min);
      mp.setMaxNodes(max);
      {if (true) return mp;}
    throw new Error("Missing return statement in function");
  }

  final public String CoreMapVarValue(Env env) throws ParseException {
        Token value = null;
    value = jj_consume_token(REGEXVAR);
                                 {if (true) return (String) env.get(value.image);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern CoreMapVarNodePattern(Env env) throws ParseException {
        Token value = null;
    value = jj_consume_token(REGEXVAR);
                                 {if (true) return env.getNodePattern(value.image);}
    throw new Error("Missing return statement in function");
  }

  final public NodePattern CoreMapExprNodePattern(Env env) throws ParseException {
        Expression expr = null;
    expr = CondExpression(env);
                                         {if (true) return new CoreMapExpressionNodePattern(env, expr);}
    throw new Error("Missing return statement in function");
  }

  final public Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>> SeqRegexWithAction(Env env) throws ParseException {
  SequencePattern.PatternExpr expr;
  SequenceMatchAction<CoreMap> action = null;
    expr = SeqRegex(env);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 50:
      action = Action(env);
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
      {if (true) return new Pair<SequencePattern.PatternExpr, SequenceMatchAction<CoreMap>>(expr,action);}
    throw new Error("Missing return statement in function");
  }

  final public SequenceMatchAction<CoreMap> Action(Env env) throws ParseException {
   SequenceMatchAction<CoreMap> action;
    jj_consume_token(50);
    action = AnnotateAction(env);
    {if (true) return action;}
    throw new Error("Missing return statement in function");
  }

  final public SequenceMatchAction<CoreMap> AnnotateAction(Env env) throws ParseException {
  Map<String, String> attributes;
    jj_consume_token(51);
    jj_consume_token(24);
    //  group = <NONNEGINT> ","
      attributes = SetAttrValues(env);
    jj_consume_token(25);
    {if (true) return new CoreMapSequenceMatchAction.AnnotateAction<CoreMap>( /*group,*/ attributes);}
    throw new Error("Missing return statement in function");
  }

  final public Map<String,String> SetAttrValues(Env env) throws ParseException {
    Map<String, String> attributes = new ArrayMap<String,String>();
    jj_consume_token(21);
    SetAttrValue(env, attributes);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 29:
      case 32:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_17;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 32:
        jj_consume_token(32);
        break;
      case 29:
        jj_consume_token(29);
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      SetAttrValue(env, attributes);
    }
    jj_consume_token(23);
          {if (true) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final public Map<String,String> SetAttrValue(Env env, Map<String,String> attributes) throws ParseException {
        Token attr = null;
        Token value = null;
        String str = null;
    attr = jj_consume_token(IDENTIFIER);
    jj_consume_token(28);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case STR:
      value = RelaxedStringToken();
      break;
    case NONNEGINT:
    case INT:
    case REAL:
      value = NumberToken();
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
              if (value != null) { str = value.image; }
              if (attr != null && str != null)  {
                if (attributes.containsKey(attr.image)) {
                {if (true) throw new Error("Attribute already defined: " + attr.image);}
                }
                attributes.put(attr.image, str);
              }
          {if (true) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final public Token NumberToken() throws ParseException {
   Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NONNEGINT:
      value = jj_consume_token(NONNEGINT);
      break;
    case INT:
      value = jj_consume_token(INT);
      break;
    case REAL:
      value = jj_consume_token(REAL);
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Token IntegerToken() throws ParseException {
   Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NONNEGINT:
      value = jj_consume_token(NONNEGINT);
      break;
    case INT:
      value = jj_consume_token(INT);
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Token CmpToken() throws ParseException {
   Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRREGEXCMP:
      value = jj_consume_token(STRREGEXCMP);
      break;
    case NUMCMP:
      value = jj_consume_token(NUMCMP);
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Token RelaxedStringToken() throws ParseException {
   Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR:
      value = jj_consume_token(STR);
      break;
    case IDENTIFIER:
      value = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public String RelaxedString() throws ParseException {
   Token value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR:
      value = jj_consume_token(STR);
                  {if (true) return value.image.substring(1,value.image.length()-1);}
      break;
    case IDENTIFIER:
      value = jj_consume_token(IDENTIFIER);
      {if (true) return value.image;}
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
String VarName() : {
   Token value = null;
} {
  ( value = <IDENTIFIER> )
    { return value.image; }
  | ( value = <REGEXVAR> )
    { return value.image; }
  | ( value = <STR> )
    { return value.image.substring(1,value.image.length()-1); }
} */
  final public String RelaxedStringNoIdentifier() throws ParseException {
   Token value = null;
    value = jj_consume_token(STR);
                  {if (true) return value.image.substring(1,value.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_3_23() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    if (jj_scan_token(32)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(41)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(40)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_25()) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(34)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(34)) return true;
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_112()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_17() {
    if (jj_scan_token(30)) return true;
    if (jj_3R_28()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_3R_49()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_116()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(22)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_37()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_3R_34()) return true;
    if (jj_scan_token(28)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(REGEXVAR)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(27)) return true;
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_scan_token(34)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(26)) return true;
    if (jj_scan_token(24)) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(24)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(30)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_104()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(21)) return true;
    if (jj_3R_21()) return true;
    if (jj_scan_token(22)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    Token xsp;
    if (jj_3R_84()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_102()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_3R_62()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_63()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    if (jj_scan_token(32)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(BACKREF)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(49)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_106()) jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(24)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(REGEXMRGROUP)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(REGEXMRVAR)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(REGEXGROUP)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(REGEX)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(REGEXVAR)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_59()) return true;
    if (jj_scan_token(22)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(REGEXVAR)) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(REGEXVAR)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) return true;
    }
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(37)) return true;
    if (jj_scan_token(21)) return true;
    Token xsp;
    if (jj_3R_42()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(30)) return true;
    if (jj_3R_33()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_50()) return true;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(30)) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(REAL)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_96() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(LONGINT)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_43()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(STR)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(REGEX)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(40)) return true;
    if (jj_scan_token(REGEXVAR)) return true;
    return false;
  }

  private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) return true;
    }
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(44)) return true;
    return false;
  }

  private boolean jj_3R_107() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) return true;
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(46)) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(STR)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(24)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_107()) jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_3R_29()) return true;
    if (jj_scan_token(33)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) return true;
    }
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_70()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(21)) return true;
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) return true;
    }
    return false;
  }

  private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    }
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) return true;
    }
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(21)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) return true;
    }
    }
    }
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(45)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_75()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_94()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) return true;
    }
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_46()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(32)) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_scan_token(45)) return true;
    if (jj_scan_token(24)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) return true;
    }
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_52()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_20() {
    if (jj_3R_23()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_33()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(24)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_36()) jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(32)) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(40)) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_scan_token(21)) return true;
    if (jj_scan_token(NONNEGINT)) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(30)) return true;
    if (jj_3R_43()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(24)) return true;
    if (jj_3R_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_41()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(25)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public TokenSequenceParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[65];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x200180,0x20000000,0x0,0x127ef80,0x127e000,0x20000000,0x20000000,0x107e000,0x180,0xf80,0x0,0x127ef80,0x40000000,0x40000000,0x0,0x180000,0x1000f80,0x0,0x0,0x20000000,0x1000f80,0x0,0x5e000,0x41061180,0x200000,0x41061180,0x400000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x41260180,0x0,0x0,0x0,0x0,0x0,0x0,0x260180,0x20000000,0x20000000,0x60080,0x260080,0x260180,0x60180,0x16100,0x80000,0x60080,0x200000,0x200000,0x0,0x20000000,0x20000000,0x56080,0x16000,0x6000,0x180000,0x40080,0x40080,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x1,0x20,0x0,0x1,0x1,0x0,0x0,0x0,0x1,0x20,0x4,0x4,0x1,0x0,0x0,0x18,0x18,0x1,0x0,0x40,0x0,0x20000,0x380,0x20000,0x0,0x380,0x0,0x100,0x410,0x410,0xc18,0xc18,0x1100,0x1100,0x0,0x6000,0x410,0x410,0x808,0x808,0xc18,0xc18,0x6000,0x1,0x1,0x0,0x0,0x4000,0x0,0x0,0x10002,0x0,0x0,0x0,0x40000,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[29];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public TokenSequenceParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public TokenSequenceParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new TokenSequenceParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public TokenSequenceParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new TokenSequenceParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public TokenSequenceParser(TokenSequenceParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(TokenSequenceParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 65; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[52];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 65; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 52; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 29; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
