/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.ExtractionObject;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;

public class XMLOutputter {
    private static final String NAMESPACE_URI = null;
    private static final String STYLESHEET_NAME = "CoreNLP-to-HTML.xsl";

    public static void xmlPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        Document xmlDoc = XMLOutputter.annotationToDoc(annotation, pipeline);
        Serializer ser = new Serializer(os, pipeline.getEncoding());
        ser.setIndent(2);
        ser.setMaxLength(0);
        ser.write(xmlDoc);
        ser.flush();
    }

    public static Document annotationToDoc(Annotation annotation, StanfordCoreNLP pipeline) {
        Element corefInfo;
        Map corefChains;
        String docDate;
        double beam = pipeline.getBeamPrintingOption();
        TreePrint constituentTreePrinter = pipeline.getConstituentTreePrinter();
        Element root = new Element("root", NAMESPACE_URI);
        Document xmlDoc = new Document(root);
        ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", "href=\"CoreNLP-to-HTML.xsl\" type=\"text/xsl\"");
        xmlDoc.insertChild((Node)pi, 0);
        Element docElem = new Element("document", NAMESPACE_URI);
        root.appendChild((Node)docElem);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            XMLOutputter.setSingleElement(docElem, "docId", NAMESPACE_URI, docId);
        }
        if ((docDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class)) != null) {
            XMLOutputter.setSingleElement(docElem, "docDate", NAMESPACE_URI, docDate);
        }
        Element sentencesElem = new Element("sentences", NAMESPACE_URI);
        docElem.appendChild((Node)sentencesElem);
        if (annotation.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            int sentCount = 1;
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                Element sentElem = new Element("sentence", NAMESPACE_URI);
                sentElem.addAttribute(new Attribute("id", Integer.toString(sentCount)));
                ++sentCount;
                Element wordTable = new Element("tokens", NAMESPACE_URI);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                for (int j = 0; j < tokens.size(); ++j) {
                    Element wordInfo = new Element("token", NAMESPACE_URI);
                    XMLOutputter.addWordInfo(wordInfo, (CoreMap)tokens.get(j), j + 1, NAMESPACE_URI);
                    wordTable.appendChild((Node)wordInfo);
                }
                sentElem.appendChild((Node)wordTable);
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    Element parseInfo = new Element("parse", NAMESPACE_URI);
                    XMLOutputter.addConstituentTreeInfo(parseInfo, tree, constituentTreePrinter);
                    sentElem.appendChild((Node)parseInfo);
                    Element depInfo = XMLOutputter.buildDependencyTreeInfo("basic-dependencies", (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class), tokens, NAMESPACE_URI);
                    if (depInfo != null) {
                        sentElem.appendChild((Node)depInfo);
                    }
                    if ((depInfo = XMLOutputter.buildDependencyTreeInfo("collapsed-dependencies", (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), tokens, NAMESPACE_URI)) != null) {
                        sentElem.appendChild((Node)depInfo);
                    }
                    if ((depInfo = XMLOutputter.buildDependencyTreeInfo("collapsed-ccprocessed-dependencies", (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class), tokens, NAMESPACE_URI)) != null) {
                        sentElem.appendChild((Node)depInfo);
                    }
                }
                List entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
                List relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                if (entities != null && entities.size() > 0) {
                    Element mrElem = new Element("MachineReading", NAMESPACE_URI);
                    Element entElem = new Element("entities", NAMESPACE_URI);
                    XMLOutputter.addEntities(entities, entElem, NAMESPACE_URI);
                    mrElem.appendChild((Node)entElem);
                    if (relations != null) {
                        Element relElem = new Element("relations", NAMESPACE_URI);
                        XMLOutputter.addRelations(relations, relElem, NAMESPACE_URI, beam);
                        mrElem.appendChild((Node)relElem);
                    }
                    sentElem.appendChild((Node)mrElem);
                }
                sentencesElem.appendChild((Node)sentElem);
            }
        }
        if ((corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null && XMLOutputter.addCorefGraphInfo(corefInfo = new Element("coreference", NAMESPACE_URI), corefChains, NAMESPACE_URI)) {
            docElem.appendChild((Node)corefInfo);
        }
        return xmlDoc;
    }

    private static void addConstituentTreeInfo(Element treeInfo, Tree tree, TreePrint constituentTreePrinter) {
        StringWriter treeStrWriter = new StringWriter();
        constituentTreePrinter.printTree(tree, new PrintWriter((Writer)treeStrWriter, true));
        String temp = treeStrWriter.toString();
        treeInfo.appendChild(temp);
    }

    private static Element buildDependencyTreeInfo(String dependencyType, SemanticGraph graph, List<CoreLabel> tokens, String curNS) {
        if (graph != null) {
            String targetWord;
            String sourceWord;
            int target;
            int source;
            String rel;
            Element depInfo = new Element("dependencies", curNS);
            depInfo.addAttribute(new Attribute("type", dependencyType));
            for (IndexedWord root : graph.getRoots()) {
                rel = GrammaticalRelation.ROOT.getLongName();
                rel = rel.replaceAll("\\s+", "");
                source = 0;
                target = root.index();
                sourceWord = "ROOT";
                targetWord = tokens.get(target - 1).word();
                boolean isExtra = false;
                XMLOutputter.addDependencyInfo(depInfo, rel, isExtra, source, sourceWord, null, target, targetWord, null, curNS);
            }
            for (SemanticGraphEdge edge : graph.edgeListSorted()) {
                rel = edge.getRelation().toString();
                rel = rel.replaceAll("\\s+", "");
                source = edge.getSource().index();
                target = edge.getTarget().index();
                sourceWord = tokens.get(source - 1).word();
                targetWord = tokens.get(target - 1).word();
                Integer sourceCopy = (Integer)edge.getSource().get(CoreAnnotations.CopyAnnotation.class);
                Integer targetCopy = (Integer)edge.getTarget().get(CoreAnnotations.CopyAnnotation.class);
                boolean isExtra = edge.isExtra();
                XMLOutputter.addDependencyInfo(depInfo, rel, isExtra, source, sourceWord, sourceCopy, target, targetWord, targetCopy, curNS);
            }
            return depInfo;
        }
        return null;
    }

    private static void addDependencyInfo(Element depInfo, String rel, boolean isExtra, int source, String sourceWord, Integer sourceCopy, int target, String targetWord, Integer targetCopy, String curNS) {
        Element depElem = new Element("dep", curNS);
        depElem.addAttribute(new Attribute("type", rel));
        if (isExtra) {
            depElem.addAttribute(new Attribute("extra", "true"));
        }
        Element govElem = new Element("governor", curNS);
        govElem.addAttribute(new Attribute("idx", Integer.toString(source)));
        govElem.appendChild(sourceWord);
        if (sourceCopy != null) {
            govElem.addAttribute(new Attribute("copy", Integer.toString(sourceCopy)));
        }
        depElem.appendChild((Node)govElem);
        Element dependElem = new Element("dependent", curNS);
        dependElem.addAttribute(new Attribute("idx", Integer.toString(target)));
        dependElem.appendChild(targetWord);
        if (targetCopy != null) {
            dependElem.addAttribute(new Attribute("copy", Integer.toString(targetCopy)));
        }
        depElem.appendChild((Node)dependElem);
        depInfo.appendChild((Node)depElem);
    }

    private static void addEntities(List<EntityMention> entities, Element top, String curNS) {
        for (EntityMention e : entities) {
            Element ee = XMLOutputter.toXML(e, curNS);
            top.appendChild((Node)ee);
        }
    }

    private static void addRelations(List<RelationMention> relations, Element top, String curNS, double beam) {
        for (RelationMention r : relations) {
            if (!r.printableObject(beam)) continue;
            Element re = XMLOutputter.toXML(r, curNS);
            top.appendChild((Node)re);
        }
    }

    private static boolean addCorefGraphInfo(Element corefInfo, Map<Integer, CorefChain> corefChains, String curNS) {
        boolean foundCoref = false;
        for (CorefChain chain : corefChains.values()) {
            if (chain.getMentionsInTextualOrder().size() <= 1) continue;
            foundCoref = true;
            Element chainElem = new Element("coreference", curNS);
            CorefChain.CorefMention source = chain.getRepresentativeMention();
            XMLOutputter.addCorefMention(chainElem, curNS, source, true);
            for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                if (mention == source) continue;
                XMLOutputter.addCorefMention(chainElem, curNS, mention, false);
            }
            corefInfo.appendChild((Node)chainElem);
        }
        return foundCoref;
    }

    private static void addCorefMention(Element chainElem, String curNS, CorefChain.CorefMention mention, boolean representative) {
        Element mentionElem = new Element("mention", curNS);
        if (representative) {
            mentionElem.addAttribute(new Attribute("representative", "true"));
        }
        XMLOutputter.setSingleElement(mentionElem, "sentence", curNS, Integer.toString(mention.sentNum));
        XMLOutputter.setSingleElement(mentionElem, "start", curNS, Integer.toString(mention.startIndex));
        XMLOutputter.setSingleElement(mentionElem, "end", curNS, Integer.toString(mention.endIndex));
        XMLOutputter.setSingleElement(mentionElem, "head", curNS, Integer.toString(mention.headIndex));
        chainElem.appendChild((Node)mentionElem);
    }

    private static void addWordInfo(Element wordInfo, CoreMap token, int id, String curNS) {
        Element cur;
        wordInfo.addAttribute(new Attribute("id", Integer.toString(id)));
        XMLOutputter.setSingleElement(wordInfo, "word", curNS, (String)token.get(CoreAnnotations.TextAnnotation.class));
        XMLOutputter.setSingleElement(wordInfo, "lemma", curNS, (String)token.get(CoreAnnotations.LemmaAnnotation.class));
        if (token.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class) && token.containsKey(CoreAnnotations.CharacterOffsetEndAnnotation.class)) {
            XMLOutputter.setSingleElement(wordInfo, "CharacterOffsetBegin", curNS, Integer.toString((Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
            XMLOutputter.setSingleElement(wordInfo, "CharacterOffsetEnd", curNS, Integer.toString((Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        }
        if (token.containsKey(CoreAnnotations.PartOfSpeechAnnotation.class)) {
            XMLOutputter.setSingleElement(wordInfo, "POS", curNS, (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class));
        }
        if (token.containsKey(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            XMLOutputter.setSingleElement(wordInfo, "NER", curNS, (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class));
        }
        if (token.containsKey(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class)) {
            XMLOutputter.setSingleElement(wordInfo, "NormalizedNER", curNS, (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
        }
        if (token.containsKey(TimeAnnotations.TimexAnnotation.class)) {
            Timex timex = (Timex)token.get(TimeAnnotations.TimexAnnotation.class);
            Element timexElem = new Element("Timex", curNS);
            timexElem.addAttribute(new Attribute("tid", timex.tid()));
            timexElem.addAttribute(new Attribute("type", timex.timexType()));
            timexElem.appendChild(timex.value());
            wordInfo.appendChild((Node)timexElem);
        }
        if (token.containsKey(CoreAnnotations.TrueCaseAnnotation.class)) {
            cur = new Element("TrueCase", curNS);
            cur.appendChild((String)token.get(CoreAnnotations.TrueCaseAnnotation.class));
            wordInfo.appendChild((Node)cur);
        }
        if (token.containsKey(CoreAnnotations.TrueCaseTextAnnotation.class)) {
            cur = new Element("TrueCaseText", curNS);
            cur.appendChild((String)token.get(CoreAnnotations.TrueCaseTextAnnotation.class));
            wordInfo.appendChild((Node)cur);
        }
    }

    private static void setSingleElement(Element tokenElement, String elemName, String curNS, String value) {
        Element cur = new Element(elemName, curNS);
        if (value != null) {
            cur.appendChild(value);
            tokenElement.appendChild((Node)cur);
        }
    }

    private static Element toXML(EntityMention entity, String curNS) {
        Element top = new Element("entity", curNS);
        top.addAttribute(new Attribute("id", entity.getObjectId()));
        Element type = new Element("type", curNS);
        type.appendChild(entity.getType());
        top.appendChild(entity.getType());
        if (entity.getNormalizedName() != null) {
            Element nm = new Element("normalized", curNS);
            nm.appendChild(entity.getNormalizedName());
            top.appendChild((Node)nm);
        }
        if (entity.getSubType() != null) {
            Element subtype = new Element("subtype", curNS);
            subtype.appendChild(entity.getSubType());
            top.appendChild((Node)subtype);
        }
        Element span = new Element("span", curNS);
        span.addAttribute(new Attribute("start", Integer.toString(entity.getHeadTokenStart())));
        span.addAttribute(new Attribute("end", Integer.toString(entity.getHeadTokenEnd())));
        top.appendChild((Node)span);
        top.appendChild((Node)XMLOutputter.makeProbabilitiesElement(entity, curNS));
        return top;
    }

    private static Element toXML(RelationMention relation, String curNS) {
        Element top = new Element("relation", curNS);
        top.addAttribute(new Attribute("id", relation.getObjectId()));
        Element type = new Element("type", curNS);
        type.appendChild(relation.getType());
        top.appendChild(relation.getType());
        if (relation.getSubType() != null) {
            Element subtype = new Element("subtype", curNS);
            subtype.appendChild(relation.getSubType());
            top.appendChild(relation.getSubType());
        }
        List<EntityMention> ents = relation.getEntityMentionArgs();
        Element args = new Element("arguments", curNS);
        for (EntityMention e : ents) {
            args.appendChild((Node)XMLOutputter.toXML(e, curNS));
        }
        top.appendChild((Node)args);
        top.appendChild((Node)XMLOutputter.makeProbabilitiesElement(relation, curNS));
        return top;
    }

    private static Element makeProbabilitiesElement(ExtractionObject object, String curNS) {
        Element probs = new Element("probabilities", curNS);
        if (object.getTypeProbabilities() != null) {
            List<Pair<String, Double>> sorted = Counters.toDescendingMagnitudeSortedListWithCounts(object.getTypeProbabilities());
            for (Pair<String, Double> lv : sorted) {
                Element prob = new Element("probability", curNS);
                Element label = new Element("label", curNS);
                label.appendChild((String)lv.first);
                Element value = new Element("value", curNS);
                value.appendChild(((Double)lv.second).toString());
                prob.appendChild((Node)label);
                prob.appendChild((Node)value);
                probs.appendChild((Node)prob);
            }
        }
        return probs;
    }
}

