/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class POSTaggerAnnotator
implements Annotator {
    private final MaxentTagger pos;
    private int maxSentenceLength;
    private int nThreads = 1;

    public POSTaggerAnnotator() {
        this(true);
    }

    public POSTaggerAnnotator(boolean verbose) {
        this(System.getProperty("pos.model", MaxentTagger.DEFAULT_NLP_GROUP_MODEL_PATH), verbose);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose) {
        this(posLoc, verbose, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(String posLoc, boolean verbose, int maxSentenceLength) {
        this(POSTaggerAnnotator.loadModel(posLoc, verbose), maxSentenceLength);
    }

    public POSTaggerAnnotator(MaxentTagger model) {
        this(model, Integer.MAX_VALUE);
    }

    public POSTaggerAnnotator(MaxentTagger model, int maxSentenceLength) {
        this.pos = model;
        this.maxSentenceLength = maxSentenceLength;
    }

    public POSTaggerAnnotator(String annotatorName, Properties props) {
        String posLoc = props.getProperty(annotatorName + ".model");
        if (posLoc == null) {
            posLoc = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
        }
        boolean verbose = PropertiesUtils.getBool(props, annotatorName + ".verbose", false);
        this.pos = POSTaggerAnnotator.loadModel(posLoc, verbose);
        this.maxSentenceLength = PropertiesUtils.getInt(props, annotatorName + ".maxlen", Integer.MAX_VALUE);
        this.nThreads = PropertiesUtils.getInt(props, annotatorName + ".nthreads", PropertiesUtils.getInt(props, "nthreads", 1));
    }

    public void setMaxSentenceLength(int maxLen) {
        this.maxSentenceLength = maxLen;
    }

    private static MaxentTagger loadModel(String loc, boolean verbose) {
        Timing timer = null;
        if (verbose) {
            timer = new Timing();
            timer.doing("Loading POS Model [" + loc + ']');
        }
        MaxentTagger tagger = new MaxentTagger(loc);
        if (verbose) {
            timer.done();
        }
        return tagger;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.has(CoreAnnotations.SentencesAnnotation.class)) {
            if (this.nThreads == 1) {
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    this.doOneSentence(sentence);
                }
            } else {
                MulticoreWrapper<CoreMap, CoreMap> wrapper = new MulticoreWrapper<CoreMap, CoreMap>(this.nThreads, new POSTaggerProcessor());
                for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                    wrapper.put(sentence);
                    while (wrapper.peek()) {
                        wrapper.poll();
                    }
                }
                wrapper.join();
                while (wrapper.peek()) {
                    wrapper.poll();
                }
            }
        } else {
            throw new RuntimeException("unable to find words/tokens in: " + annotation);
        }
    }

    private CoreMap doOneSentence(CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<TaggedWord> tagged = this.pos.apply(tokens);
        for (int i = 0; i < tokens.size(); ++i) {
            ((CoreLabel)tokens.get(i)).set(CoreAnnotations.PartOfSpeechAnnotation.class, ((TaggedWord)tagged.get(i)).tag());
        }
        return sentence;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(POS_REQUIREMENT);
    }

    private class POSTaggerProcessor
    implements ThreadsafeProcessor<CoreMap, CoreMap> {
        private POSTaggerProcessor() {
        }

        @Override
        public CoreMap process(CoreMap sentence) {
            return POSTaggerAnnotator.this.doOneSentence(sentence);
        }

        @Override
        public ThreadsafeProcessor<CoreMap, CoreMap> newInstance() {
            return this;
        }
    }
}

