/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.BiLexPCFGParser;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BoundaryRemover;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.ExhaustiveDependencyParser;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.parser.lexparser.FastFactoredParser;
import edu.stanford.nlp.parser.lexparser.HTKLatticeReader;
import edu.stanford.nlp.parser.lexparser.IterativeCKYPCFGParser;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.NoSuchParseException;
import edu.stanford.nlp.parser.lexparser.NodePruner;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.ParserQuery;
import edu.stanford.nlp.parser.lexparser.ParserUtils;
import edu.stanford.nlp.parser.lexparser.TwinScorer;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.DeltaIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.ScoredObject;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LexicalizedParserQuery
implements ParserQuery {
    private final Options op;
    private final TreeTransformer debinarizer;
    private final TreeTransformer boundaryRemover;
    private final ExhaustivePCFGParser pparser;
    private final ExhaustiveDependencyParser dparser;
    private final KBestViterbiParser bparser;
    private final boolean fallbackToPCFG = true;
    private final TreeTransformer subcategoryStripper;
    private boolean parseSucceeded = false;
    private boolean parseSkipped = false;
    private boolean parseFallback = false;
    private boolean parseNoMemory = false;
    private boolean parseUnparsable = false;
    private String whatFailed = null;
    private List<? extends HasWord> originalSentence;
    private boolean saidMemMessage = false;

    @Override
    public boolean parseSucceeded() {
        return this.parseSucceeded;
    }

    @Override
    public boolean parseSkipped() {
        return this.parseSkipped;
    }

    @Override
    public boolean parseFallback() {
        return this.parseFallback;
    }

    @Override
    public boolean parseNoMemory() {
        return this.parseNoMemory;
    }

    @Override
    public boolean parseUnparsable() {
        return this.parseUnparsable;
    }

    @Override
    public List<? extends HasWord> originalSentence() {
        return this.originalSentence;
    }

    @Override
    public boolean saidMemMessage() {
        return this.saidMemMessage;
    }

    LexicalizedParserQuery(LexicalizedParser parser) {
        this.op = parser.getOp();
        BinaryGrammar bg = parser.bg;
        UnaryGrammar ug = parser.ug;
        Lexicon lex = parser.lex;
        DependencyGrammar dg = parser.dg;
        Index<String> stateIndex = parser.stateIndex;
        DeltaIndex<String> wordIndex = new DeltaIndex<String>(parser.wordIndex);
        Index<String> tagIndex = parser.tagIndex;
        this.debinarizer = new Debinarizer(this.op.forceCNF);
        this.boundaryRemover = new BoundaryRemover();
        this.pparser = this.op.doPCFG ? (this.op.testOptions.iterativeCKY ? new IterativeCKYPCFGParser(bg, ug, lex, this.op, stateIndex, wordIndex, tagIndex) : new ExhaustivePCFGParser(bg, ug, lex, this.op, stateIndex, wordIndex, tagIndex)) : null;
        if (this.op.doDep) {
            dg.setLexicon(lex);
            this.dparser = !this.op.testOptions.useFastFactored ? new ExhaustiveDependencyParser(dg, lex, this.op, wordIndex, tagIndex) : null;
        } else {
            this.dparser = null;
        }
        if (this.op.doDep && this.op.doPCFG) {
            if (this.op.testOptions.useFastFactored) {
                MLEDependencyGrammar mledg = (MLEDependencyGrammar)dg;
                int numToFind = 1;
                if (this.op.testOptions.printFactoredKGood > 0) {
                    numToFind = this.op.testOptions.printFactoredKGood;
                }
                this.bparser = new FastFactoredParser(this.pparser, mledg, this.op, numToFind, wordIndex, tagIndex);
            } else {
                TwinScorer scorer = new TwinScorer(this.pparser, this.dparser);
                this.bparser = this.op.testOptions.useN5 ? new BiLexPCFGParser.N5BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op, stateIndex, wordIndex, tagIndex) : new BiLexPCFGParser(scorer, this.pparser, this.dparser, bg, ug, dg, lex, this.op, stateIndex, wordIndex, tagIndex);
            }
        } else {
            this.bparser = null;
        }
        this.subcategoryStripper = this.op.tlpParams.subcategoryStripper();
    }

    @Override
    public void setConstraints(List<ParserConstraint> constraints) {
        if (this.pparser != null) {
            this.pparser.setConstraints(constraints);
        }
    }

    private boolean parseInternal(List<? extends HasWord> sentence) {
        this.parseSucceeded = false;
        this.parseNoMemory = false;
        this.parseUnparsable = false;
        this.parseSkipped = false;
        this.parseFallback = false;
        this.whatFailed = null;
        this.originalSentence = sentence;
        int length = sentence.size();
        if (length == 0) {
            this.parseSkipped = true;
            throw new UnsupportedOperationException("Can't parse a zero-length sentence!");
        }
        for (HasWord hasWord : sentence) {
            if (this.op.wordFunction == null) continue;
            hasWord.setWord(this.op.wordFunction.apply(hasWord.word()));
        }
        ArrayList<HasWord> sentenceB = new ArrayList<HasWord>(sentence);
        if (this.op.testOptions.addMissingFinalPunctuation) {
            this.addSentenceFinalPunctIfNeeded(sentenceB, length);
        }
        if (length > this.op.testOptions.maxLength) {
            this.parseSkipped = true;
            throw new UnsupportedOperationException("Sentence too long: length " + length);
        }
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        if (sentence.get(0) instanceof CoreLabel) {
            CoreLabel boundary = new CoreLabel();
            boundary.setWord(".$.");
            boundary.setValue(".$.");
            boundary.setTag(".$$.");
            boundary.setIndex(sentence.size() + 1);
            sentenceB.add(boundary);
        } else {
            sentenceB.add(new TaggedWord(".$.", ".$$."));
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("PParser output");
                treePrint.printTree(this.getBestPCFGParse(false), pwOut);
            }
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        if (this.op.doDep && !this.op.testOptions.useFastFactored) {
            if (!this.dparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("DParser output");
                treePrint.printTree(this.dparser.getBestParse(), pwOut);
            }
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        if (this.op.doPCFG && this.op.doDep) {
            if (!this.bparser.parse(sentenceB)) {
                this.restoreOriginalWords(sentence);
                return this.parseSucceeded;
            }
            this.parseSucceeded = true;
        }
        this.restoreOriginalWords(sentence);
        return true;
    }

    private <T extends HasWord> void restoreOriginalWords(List<T> sentence) {
        if (this.originalSentence == null) {
            return;
        }
        if (sentence.size() != this.originalSentence.size()) {
            throw new IllegalStateException("originalWords and sentence of different sizes");
        }
        for (int i = 0; i < sentence.size(); ++i) {
            sentence.set(i, this.originalSentence.get(i));
        }
    }

    @Override
    public void restoreOriginalWords(Tree tree) {
        if (this.originalSentence == null || tree == null) {
            return;
        }
        List leaves = tree.getLeaves();
        if (leaves.size() != this.originalSentence.size()) {
            throw new IllegalStateException("originalWords and sentence of different sizes: " + this.originalSentence.size() + " vs. " + leaves.size() + "\n Orig: " + Sentence.listToString(this.originalSentence) + "\n Pars: " + Sentence.listToString(leaves));
        }
        Iterator<? extends HasWord> wordsIterator = this.originalSentence.iterator();
        for (Tree leaf : leaves) {
            leaf.setLabel((Label)((Object)wordsIterator.next()));
        }
    }

    boolean parse(HTKLatticeReader lr) {
        TreePrint treePrint = this.getTreePrint();
        PrintWriter pwOut = this.op.tlpParams.pw();
        this.parseSucceeded = false;
        this.parseNoMemory = false;
        this.parseUnparsable = false;
        this.parseSkipped = false;
        this.parseFallback = false;
        this.whatFailed = null;
        this.originalSentence = null;
        if (lr.getNumStates() > this.op.testOptions.maxLength + 1) {
            this.parseSkipped = true;
            throw new UnsupportedOperationException("Lattice too big: " + lr.getNumStates());
        }
        if (this.op.doPCFG) {
            if (!this.pparser.parse(lr)) {
                return this.parseSucceeded;
            }
            if (this.op.testOptions.verbose) {
                pwOut.println("PParser output");
                treePrint.printTree(this.getBestPCFGParse(false), pwOut);
            }
        }
        this.parseSucceeded = true;
        return true;
    }

    @Override
    public Tree getBestParse() {
        return this.getBestParse(true);
    }

    Tree getBestParse(boolean stripSubcat) {
        if (this.parseSkipped) {
            return null;
        }
        if (this.bparser != null && this.parseSucceeded) {
            Tree binaryTree = this.bparser.getBestParse();
            Tree tree = this.debinarizer.transformTree(binaryTree);
            if (this.op.nodePrune) {
                NodePruner np = new NodePruner(this.pparser, this.debinarizer);
                tree = np.prune(tree);
            }
            if (stripSubcat) {
                tree = this.subcategoryStripper.transformTree(tree);
            }
            this.restoreOriginalWords(tree);
            return tree;
        }
        if (this.pparser != null && this.pparser.hasParse()) {
            return this.getBestPCFGParse();
        }
        if (this.dparser != null && this.dparser.hasParse()) {
            return this.getBestDependencyParse(true);
        }
        throw new NoSuchParseException();
    }

    @Override
    public List<ScoredObject<Tree>> getBestPCFGParses() {
        return this.pparser.getBestParses();
    }

    @Override
    public boolean hasFactoredParse() {
        if (this.bparser == null) {
            return false;
        }
        return !this.parseSkipped && this.parseSucceeded && this.bparser.hasParse();
    }

    @Override
    public Tree getBestFactoredParse() {
        return this.bparser.getBestParse();
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodFactoredParses(int k) {
        if (this.bparser == null || this.parseSkipped) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.bparser.getKGoodParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> tp : binaryTrees) {
            Tree t = this.debinarizer.transformTree(tp.object());
            t = this.subcategoryStripper.transformTree(t);
            this.restoreOriginalWords(t);
            trees.add(new ScoredObject<Tree>(t, tp.score()));
        }
        return trees;
    }

    @Override
    public List<ScoredObject<Tree>> getKBestPCFGParses(int k) {
        if (this.pparser == null) {
            return null;
        }
        List<ScoredObject<Tree>> binaryTrees = this.pparser.getKBestParses(k);
        if (binaryTrees == null) {
            return null;
        }
        ArrayList<ScoredObject<Tree>> trees = new ArrayList<ScoredObject<Tree>>(k);
        for (ScoredObject<Tree> p : binaryTrees) {
            Tree t = this.debinarizer.transformTree(p.object());
            t = this.subcategoryStripper.transformTree(t);
            this.restoreOriginalWords(t);
            trees.add(new ScoredObject<Tree>(t, p.score()));
        }
        return trees;
    }

    @Override
    public Tree getBestPCFGParse() {
        return this.getBestPCFGParse(true);
    }

    public Tree getBestPCFGParse(boolean stripSubcategories) {
        if (this.pparser == null || this.parseSkipped || this.parseUnparsable) {
            return null;
        }
        Tree binaryTree = this.pparser.getBestParse();
        if (binaryTree == null) {
            return null;
        }
        Tree t = this.debinarizer.transformTree(binaryTree);
        if (stripSubcategories) {
            t = this.subcategoryStripper.transformTree(t);
        }
        this.restoreOriginalWords(t);
        return t;
    }

    @Override
    public double getPCFGScore() {
        return this.pparser.getBestScore();
    }

    double getPCFGScore(String goalStr) {
        return this.pparser.getBestScore(goalStr);
    }

    void parsePCFG(List<? extends HasWord> sentence) {
        this.parseSucceeded = false;
        this.parseNoMemory = false;
        this.parseUnparsable = false;
        this.parseSkipped = false;
        this.parseFallback = false;
        this.whatFailed = null;
        this.originalSentence = sentence;
        this.pparser.parse(sentence);
    }

    public Tree getBestDependencyParse() {
        return this.getBestDependencyParse(false);
    }

    @Override
    public Tree getBestDependencyParse(boolean debinarize) {
        if (this.dparser == null || this.parseSkipped || this.parseUnparsable) {
            return null;
        }
        Tree t = this.dparser.getBestParse();
        if (t != null) {
            if (debinarize) {
                t = this.debinarizer.transformTree(t);
            }
            t = this.boundaryRemover.transformTree(t);
            this.restoreOriginalWords(t);
        }
        return t;
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        try {
            if (!this.parseInternal(sentence)) {
                if (this.pparser != null && this.pparser.hasParse()) {
                    this.parseFallback = true;
                    return true;
                }
                this.parseUnparsable = true;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError e) {
            if (this.op.testOptions.maxLength != 559038737) {
                System.err.print("NOT ENOUGH MEMORY TO PARSE SENTENCES OF LENGTH ");
                System.err.println(this.op.testOptions.maxLength);
                throw e;
            }
            if (this.pparser.hasParse()) {
                try {
                    this.whatFailed = "dependency";
                    if (this.dparser.hasParse()) {
                        this.whatFailed = "factored";
                    }
                    this.parseFallback = true;
                    return true;
                }
                catch (OutOfMemoryError oome) {
                    oome.printStackTrace();
                    this.parseNoMemory = true;
                    this.pparser.nudgeDownArraySize();
                    return false;
                }
            }
            this.parseNoMemory = true;
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            this.parseSkipped = true;
            return false;
        }
    }

    @Override
    public boolean parseAndReport(List<? extends HasWord> sentence, PrintWriter pwErr) {
        boolean result = this.parse(sentence);
        if (result) {
            if (this.whatFailed != null) {
                if (!this.saidMemMessage) {
                    ParserUtils.printOutOfMemory(pwErr);
                    this.saidMemMessage = true;
                }
                pwErr.println("Sentence too long for " + this.whatFailed + " parser.  Falling back to PCFG parse...");
            } else if (this.parseFallback) {
                pwErr.println("Sentence couldn't be parsed by grammar.... falling back to PCFG parse.");
            }
        } else if (this.parseUnparsable) {
            pwErr.println("Sentence couldn't be parsed by grammar.");
        } else if (this.parseNoMemory) {
            if (!this.saidMemMessage) {
                ParserUtils.printOutOfMemory(pwErr);
                this.saidMemMessage = true;
            }
            if (this.pparser.hasParse()) {
                pwErr.println("No memory to gather PCFG parse. Skipping...");
            } else {
                pwErr.println("Sentence has no parse using PCFG grammar (or no PCFG fallback).  Skipping...");
            }
        } else if (this.parseSkipped) {
            pwErr.println("Sentence too long (or zero words).");
        }
        return result;
    }

    public TreePrint getTreePrint() {
        return this.op.testOptions.treePrint(this.op.tlpParams);
    }

    @Override
    public KBestViterbiParser getPCFGParser() {
        return this.pparser;
    }

    @Override
    public KBestViterbiParser getDependencyParser() {
        return this.dparser;
    }

    @Override
    public KBestViterbiParser getFactoredParser() {
        return this.bparser;
    }

    void addSentenceFinalPunctIfNeeded(List<HasWord> sentence, int length) {
        String[] sfpWords;
        int start = length - 3;
        if (start < 0) {
            start = 0;
        }
        TreebankLanguagePack tlp = this.op.tlpParams.treebankLanguagePack();
        for (int i = length - 1; i >= start; --i) {
            String str;
            HasWord item = sentence.get(i);
            String tag = null;
            if (item instanceof HasTag) {
                tag = ((HasTag)((Object)item)).tag();
            }
            if (!(tag != null && !"".equals(tag) ? tlp.isSentenceFinalPunctuationTag(tag) : (item instanceof HasWord ? tlp.isPunctuationWord(str = item.word()) : tlp.isPunctuationWord(str = item.toString())))) continue;
            return;
        }
        if (this.op.testOptions.verbose) {
            System.err.println("Adding missing final punctuation to sentence.");
        }
        if ((sfpWords = tlp.sentenceFinalPunctuationWords()).length > 0) {
            sentence.add(new Word(sfpWords[0]));
        }
    }
}

