/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.BasicSequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;

public class SequenceMatcher<T>
extends BasicSequenceMatchResult<T> {
    private static final Logger logger = Logger.getLogger(SequenceMatcher.class.getName());
    SequencePattern pattern;
    boolean matchingCompleted = false;
    boolean matched = false;
    boolean matchWithResult = false;
    int nextMatchStart = 0;
    int regionStart = 0;
    int regionEnd = -1;
    FindType findType = FindType.FIND_NONOVERLAPPING;
    Iterator<Integer> curMatchIter = null;
    MatchedStates<T> curMatchStates = null;

    protected SequenceMatcher(SequencePattern pattern, List<? extends T> elements) {
        this.pattern = pattern;
        this.elements = elements;
        if (elements == null) {
            throw new IllegalArgumentException("Cannot match against null elements");
        }
        this.regionEnd = elements.size();
        this.score = pattern.priority;
        this.varGroupBindings = pattern.varGroupBindings;
        this.matchedGroups = new BasicSequenceMatchResult.MatchedGroup[pattern.totalGroups];
    }

    public List<T> replaceAllExtended(List<MatchReplacement<T>> replacement) {
        ArrayList res = new ArrayList();
        FindType oldFindType = this.findType;
        this.findType = FindType.FIND_NONOVERLAPPING;
        int index = 0;
        while (this.find()) {
            res.addAll(this.elements().subList(index, this.start()));
            for (MatchReplacement<T> r : replacement) {
                r.append(this, res);
            }
            index = this.end();
        }
        res.addAll(this.elements().subList(index, this.elements().size()));
        this.findType = oldFindType;
        return res;
    }

    public List<T> replaceFirstExtended(List<MatchReplacement<T>> replacement) {
        ArrayList res = new ArrayList();
        FindType oldFindType = this.findType;
        this.findType = FindType.FIND_NONOVERLAPPING;
        int index = 0;
        if (this.find()) {
            res.addAll(this.elements().subList(index, this.start()));
            for (MatchReplacement<T> r : replacement) {
                r.append(this, res);
            }
            index = this.end();
        }
        res.addAll(this.elements().subList(index, this.elements().size()));
        this.findType = oldFindType;
        return res;
    }

    public List<T> replaceAll(List<T> replacement) {
        ArrayList res = new ArrayList();
        FindType oldFindType = this.findType;
        this.findType = FindType.FIND_NONOVERLAPPING;
        int index = 0;
        while (this.find()) {
            res.addAll(this.elements().subList(index, this.start()));
            res.addAll(replacement);
            index = this.end();
        }
        res.addAll(this.elements().subList(index, this.elements().size()));
        this.findType = oldFindType;
        return res;
    }

    public List<T> replaceFirst(List<T> replacement) {
        ArrayList res = new ArrayList();
        FindType oldFindType = this.findType;
        this.findType = FindType.FIND_NONOVERLAPPING;
        int index = 0;
        if (this.find()) {
            res.addAll(this.elements().subList(index, this.start()));
            res.addAll(replacement);
            index = this.end();
        }
        res.addAll(this.elements().subList(index, this.elements().size()));
        this.findType = oldFindType;
        return res;
    }

    public FindType getFindType() {
        return this.findType;
    }

    public void setFindType(FindType findType) {
        this.findType = findType;
    }

    public boolean isMatchWithResult() {
        return this.matchWithResult;
    }

    public void setMatchWithResult(boolean matchWithResult) {
        this.matchWithResult = matchWithResult;
    }

    public boolean find(int start) {
        if (start < 0 || start > this.elements.size()) {
            throw new IndexOutOfBoundsException("Invalid region start=" + start + ", need to be between 0 and " + this.elements.size());
        }
        this.reset();
        return this.find(start, false);
    }

    protected boolean find(int start, boolean matchStart) {
        boolean match = false;
        this.matched = false;
        this.matchingCompleted = false;
        if (matchStart) {
            match = this.findMatchStart(start, false);
        } else {
            for (int i = start; i < this.regionEnd && !(match = this.findMatchStart(i, false)); ++i) {
            }
        }
        this.matched = match;
        this.matchingCompleted = true;
        this.nextMatchStart = this.matched ? (this.findType == FindType.FIND_NONOVERLAPPING ? this.end() : this.start() + 1) : -1;
        return match;
    }

    private boolean findNextNonOverlapping() {
        if (this.nextMatchStart < 0) {
            return false;
        }
        return this.find(this.nextMatchStart, false);
    }

    private boolean findNextAll() {
        if (this.curMatchIter != null && this.curMatchIter.hasNext()) {
            int next = this.curMatchIter.next();
            ((MatchedStates)this.curMatchStates).setMatchedGroups(next);
            return true;
        }
        if (this.nextMatchStart < 0) {
            return false;
        }
        boolean matched = this.find(this.nextMatchStart, false);
        if (matched) {
            Collection matchedBranches = ((MatchedStates)this.curMatchStates).getMatchIndices();
            this.curMatchIter = matchedBranches.iterator();
            int next = this.curMatchIter.next();
            ((MatchedStates)this.curMatchStates).setMatchedGroups(next);
        }
        return matched;
    }

    public boolean find() {
        switch (this.findType) {
            case FIND_NONOVERLAPPING: {
                return this.findNextNonOverlapping();
            }
            case FIND_ALL: {
                return this.findNextAll();
            }
        }
        throw new UnsupportedOperationException("Unsupported findType " + (Object)((Object)this.findType));
    }

    protected boolean findMatchStart(int start, boolean matchAllTokens) {
        switch (this.findType) {
            case FIND_NONOVERLAPPING: {
                return this.findMatchStartBacktracking(start, matchAllTokens);
            }
            case FIND_ALL: {
                return this.findMatchStartNoBacktracking(start, matchAllTokens);
            }
        }
        throw new UnsupportedOperationException("Unsupported findType " + (Object)((Object)this.findType));
    }

    protected boolean findMatchStartNoBacktracking(int start, boolean matchAllTokens) {
        boolean matchAll = true;
        MatchedStates<T> cStates = this.getStartStates();
        this.curMatchStates = cStates;
        for (int i = start; i < this.regionEnd; ++i) {
            boolean match = ((MatchedStates)cStates).match(i);
            if (cStates == null || cStates.size() == 0) break;
            if (matchAllTokens || (!matchAll || !((MatchedStates)cStates).isAllMatch()) && (matchAll || !((MatchedStates)cStates).isMatch())) continue;
            ((MatchedStates)cStates).completeMatch();
            return true;
        }
        ((MatchedStates)cStates).completeMatch();
        return ((MatchedStates)cStates).isMatch();
    }

    protected boolean findMatchStartBacktracking(int start, boolean matchAllTokens) {
        boolean matchAll = true;
        int branchLimit = 2;
        Stack<MatchedStates> todo = new Stack<MatchedStates>();
        MatchedStates cStates = this.getStartStates();
        cStates.curPosition = start - 1;
        todo.push(cStates);
        while (!todo.empty()) {
            int s;
            cStates = (MatchedStates)todo.pop();
            for (int i = s = cStates.curPosition + 1; i < this.regionEnd; ++i) {
                boolean match = cStates.match(i);
                if (cStates == null || cStates.size() == 0) break;
                if (!matchAllTokens && (matchAll && cStates.isAllMatch() || !matchAll && cStates.isMatch())) {
                    cStates.completeMatch();
                    return true;
                }
                if (branchLimit < 0 || cStates.branchSize() <= branchLimit) continue;
                MatchedStates s2 = cStates.split(branchLimit);
                todo.push(s2);
            }
            if (cStates.isMatch()) {
                cStates.completeMatch();
                return true;
            }
            cStates.clean();
        }
        return false;
    }

    public boolean matches() {
        this.matched = false;
        this.matchingCompleted = false;
        boolean status = this.findMatchStart(0, true);
        if (status) {
            status = this.matchedGroups[0].matchBegin == this.regionStart && this.matchedGroups[0].matchEnd == this.regionEnd;
        }
        this.matchingCompleted = true;
        this.matched = status;
        return status;
    }

    private void clearMatched() {
        int i;
        for (i = 0; i < this.matchedGroups.length; ++i) {
            this.matchedGroups[i] = null;
        }
        if (this.matchedResults != null) {
            for (i = 0; i < this.matchedResults.length; ++i) {
                this.matchedResults[i] = null;
            }
        }
    }

    private String getStateMessage() {
        if (!this.matchingCompleted) {
            return "Matching not completed";
        }
        if (!this.matched) {
            return "No match found";
        }
        return "Match successful";
    }

    public void region(int start, int end) {
        if (start < 0 || start > this.elements.size()) {
            throw new IndexOutOfBoundsException("Invalid region start=" + start + ", need to be between 0 and " + this.elements.size());
        }
        if (end < 0 || end > this.elements.size()) {
            throw new IndexOutOfBoundsException("Invalid region end=" + end + ", need to be between 0 and " + this.elements.size());
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("Invalid region end=" + end + ", need to be larger then start=" + start);
        }
        this.regionStart = start;
        this.nextMatchStart = start;
        this.regionEnd = end;
    }

    public int regionEnd() {
        return this.regionEnd;
    }

    public int regionStart() {
        return this.regionStart;
    }

    @Override
    public BasicSequenceMatchResult<T> toBasicSequenceMatchResult() {
        if (this.matchingCompleted && this.matched) {
            return super.toBasicSequenceMatchResult();
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public int start(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.start(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public int end(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.end(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public List<? extends T> groupNodes(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.groupNodes(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public Object groupValue(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.groupValue(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public SequenceMatchResult.MatchedGroupInfo<T> groupInfo(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.groupInfo(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public List<Object> groupMatchResults(int group) {
        if (this.matchingCompleted && this.matched) {
            return super.groupMatchResults(group);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public Object groupMatchResult(int group, int index) {
        if (this.matchingCompleted && this.matched) {
            return super.groupMatchResult(group, index);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    @Override
    public Object nodeMatchResult(int index) {
        if (this.matchingCompleted && this.matched) {
            return super.nodeMatchResult(index);
        }
        String message = this.getStateMessage();
        throw new IllegalStateException(message);
    }

    public void reset() {
        this.regionStart = 0;
        this.regionEnd = this.elements.size();
        this.nextMatchStart = 0;
        this.matchingCompleted = false;
        this.matched = false;
        this.clearMatched();
    }

    public T get(int i) {
        return (T)this.elements.get(i);
    }

    private MatchedStates<T> getStartStates() {
        return new MatchedStates(this, this.pattern.root);
    }

    static class MatchedStates<T> {
        SequenceMatcher<T> matcher;
        BranchStates branchStates;
        List<State> oldStates;
        List<State> states;
        int curPosition = -1;

        protected MatchedStates(SequenceMatcher<T> matcher, SequencePattern.State state) {
            this(matcher, new BranchStates());
            int bid = this.branchStates.newBid(-1, 0);
            this.states.add(new State(bid, state));
        }

        private MatchedStates(SequenceMatcher<T> matcher, BranchStates branchStates) {
            this.matcher = matcher;
            this.states = new ArrayList<State>();
            this.oldStates = new ArrayList<State>();
            this.branchStates = branchStates;
            branchStates.link(this);
        }

        protected BranchStates getBranchStates() {
            return this.branchStates;
        }

        protected MatchedStates split(int branchLimit) {
            Set<Integer> curBidSet = Generics.newHashSet();
            for (State state : this.states) {
                curBidSet.add(state.bid);
            }
            ArrayList bids = new ArrayList(curBidSet);
            Collections.sort(bids, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    int res = MatchedStates.this.compareMatches(o1, o2);
                    return res;
                }
            });
            MatchedStates<T> newStates = new MatchedStates<T>(this.matcher, this.branchStates);
            int v = Math.min(branchLimit, (bids.size() + 1) / 2);
            Set keepBidSet = Generics.newHashSet();
            keepBidSet.addAll(bids.subList(0, v));
            this.swapAndClear();
            for (State s : this.oldStates) {
                if (keepBidSet.contains(s.bid)) {
                    this.states.add(s);
                    continue;
                }
                newStates.states.add(s);
            }
            newStates.curPosition = this.curPosition;
            this.branchStates.condense();
            return newStates;
        }

        protected List<? extends T> elements() {
            return this.matcher.elements;
        }

        protected T get() {
            return this.matcher.get(this.curPosition);
        }

        protected int size() {
            return this.states.size();
        }

        protected int branchSize() {
            return this.branchStates.size();
        }

        private void swap() {
            List<State> tmpStates = this.oldStates;
            this.oldStates = this.states;
            this.states = tmpStates;
        }

        private void swapAndClear() {
            this.swap();
            this.states.clear();
        }

        private boolean match(int position) {
            this.curPosition = position;
            boolean matched = false;
            this.swapAndClear();
            for (State state : this.oldStates) {
                if (!state.tstate.match(state.bid, this)) continue;
                matched = true;
            }
            boolean done = false;
            while (!done) {
                this.swapAndClear();
                boolean matched0 = false;
                for (State state : this.oldStates) {
                    if (!state.tstate.match0(state.bid, this)) continue;
                    matched0 = true;
                }
                done = !matched0;
            }
            this.branchStates.condense();
            return matched;
        }

        protected int compareMatches(int bid1, int bid2) {
            if (bid1 == bid2) {
                return 0;
            }
            List p1 = this.branchStates.getParents(bid1);
            p1.add(bid1);
            List p2 = this.branchStates.getParents(bid2);
            p2.add(bid2);
            int n = Math.min(p1.size(), p2.size());
            for (int i = 0; i < n; ++i) {
                if ((Integer)p1.get(i) < (Integer)p2.get(i)) {
                    return -1;
                }
                if ((Integer)p1.get(i) <= (Integer)p2.get(i)) continue;
                return 1;
            }
            if (p1.size() < p2.size()) {
                return -1;
            }
            if (p1.size() > p2.size()) {
                return 1;
            }
            return 0;
        }

        private int getMatchIndex() {
            for (int i = 0; i < this.states.size(); ++i) {
                State state = this.states.get(i);
                if (!state.tstate.equals(SequencePattern.MATCH_STATE)) continue;
                return i;
            }
            return -1;
        }

        private Collection<Integer> getMatchIndices() {
            Set<Integer> allMatchIndices = Generics.newHashSet();
            for (int i = 0; i < this.states.size(); ++i) {
                State state = this.states.get(i);
                if (!state.tstate.equals(SequencePattern.MATCH_STATE)) continue;
                allMatchIndices.add(i);
            }
            return allMatchIndices;
        }

        private int selectMatchIndex() {
            int best = -1;
            int bestbid = -1;
            for (int i = 0; i < this.states.size(); ++i) {
                State state = this.states.get(i);
                if (!state.tstate.equals(SequencePattern.MATCH_STATE)) continue;
                if (best < 0) {
                    best = i;
                    bestbid = state.bid;
                    continue;
                }
                int bid = state.bid;
                if (this.compareMatches(bestbid, bid) <= 0) continue;
                bestbid = bid;
                best = i;
            }
            return best;
        }

        private void completeMatch() {
            int matchStateIndex = this.selectMatchIndex();
            this.setMatchedGroups(matchStateIndex);
        }

        private void setMatchedGroups(int matchStateIndex) {
            ((SequenceMatcher)this.matcher).clearMatched();
            if (matchStateIndex >= 0) {
                State state = this.states.get(matchStateIndex);
                int bid = state.bid;
                BranchState bs = this.branchStates.getBranchState(bid);
                if (bs != null) {
                    Map<Integer, Object> matchedResults;
                    this.branchStates.mergeBranchStates(bs);
                    Map<Integer, BasicSequenceMatchResult.MatchedGroup> matchedGroups = bs.matchedGroups;
                    if (matchedGroups != null) {
                        for (int group : matchedGroups.keySet()) {
                            this.matcher.matchedGroups[group] = matchedGroups.get(group);
                        }
                    }
                    if ((matchedResults = bs.matchedResults) != null) {
                        if (this.matcher.matchedResults == null) {
                            this.matcher.matchedResults = new Object[this.matcher.elements().size()];
                        }
                        for (int index : matchedResults.keySet()) {
                            this.matcher.matchedResults[index] = matchedResults.get(index);
                        }
                    }
                }
            }
        }

        private boolean isAllMatch() {
            boolean allMatch = true;
            if (this.states.size() > 0) {
                for (State state : this.states) {
                    if (state.tstate.equals(SequencePattern.MATCH_STATE)) continue;
                    allMatch = false;
                    break;
                }
            } else {
                allMatch = false;
            }
            return allMatch;
        }

        private boolean isMatch() {
            int matchStateIndex = this.getMatchIndex();
            return matchStateIndex >= 0;
        }

        protected void addStates(int bid, Collection<SequencePattern.State> newStates) {
            int i = 0;
            for (SequencePattern.State s : newStates) {
                int id = this.branchStates.getBranchId(bid, ++i, newStates.size());
                this.states.add(new State(id, s));
            }
        }

        protected void addState(int bid, SequencePattern.State state) {
            this.states.add(new State(bid, state));
        }

        private void clean() {
            this.branchStates.unlink(this);
            this.branchStates = null;
        }

        protected void setGroupStart(int bid, int captureGroupId) {
            this.branchStates.setGroupStart(bid, captureGroupId, this.curPosition);
        }

        protected void setGroupEnd(int bid, int captureGroupId, Object value) {
            this.branchStates.setGroupEnd(bid, captureGroupId, this.curPosition, value);
        }

        protected void clearGroupStart(int bid, int captureGroupId) {
            this.branchStates.clearGroupStart(bid, captureGroupId);
        }
    }

    static class BranchStates {
        Index<Pair<Integer, Integer>> bidIndex = new HashIndex<Pair<Integer, Integer>>();
        Map<Integer, BranchState> branchStates = Generics.newHashMap();
        Set<MatchedStates> activeMatchedStates = Generics.newHashSet();

        BranchStates() {
        }

        private void link(MatchedStates s) {
            this.activeMatchedStates.add(s);
        }

        private void unlink(MatchedStates s) {
            this.activeMatchedStates.remove(s);
        }

        protected int getBid(int parent, int child) {
            return this.bidIndex.indexOf(new Pair<Integer, Integer>(parent, child));
        }

        protected int newBid(int parent, int child) {
            return this.bidIndex.indexOf(new Pair<Integer, Integer>(parent, child), true);
        }

        protected int size() {
            return this.branchStates.size();
        }

        private void condense() {
            Set<Integer> curBidSet = Generics.newHashSet();
            Set<Integer> keepBidStates = Generics.newHashSet();
            for (MatchedStates ms : this.activeMatchedStates) {
                List<State> states = ms.states;
                logger.finest("Condense matched state: curPosition=" + ms.curPosition + ", totalTokens=" + ms.matcher.elements.size() + ", nStates=" + states.size());
                for (State state : states) {
                    curBidSet.add(state.bid);
                    keepBidStates.add(state.bid);
                }
            }
            Iterator<MatchedStates<Object>> i$ = curBidSet.iterator();
            while (i$.hasNext()) {
                int bid = (Integer)((Object)i$.next());
                BranchState bs = this.getBranchState(bid);
                if (bs == null) continue;
                keepBidStates.add(bs.bid);
                bs.updateKeepBids(keepBidStates);
                if (bs.bidsToCollapse == null) continue;
                this.mergeBranchStates(bs);
            }
            ArrayList<Integer> curBidStates = new ArrayList<Integer>(this.branchStates.keySet());
            Iterator i$2 = curBidStates.iterator();
            while (i$2.hasNext()) {
                int bid = (Integer)i$2.next();
                if (keepBidStates.contains(bid)) continue;
                logger.finest("Remove state for bid=" + bid);
                this.branchStates.remove(bid);
            }
            logger.finest("Condense matched state: oldBidStates=" + curBidStates.size() + ", newBidStates=" + this.branchStates.size() + ", curBidSet=" + curBidSet.size());
        }

        private List<Integer> getParents(int bid) {
            ArrayList<Integer> pids = new ArrayList<Integer>();
            Pair<Integer, Integer> p = this.bidIndex.get(bid);
            while (p != null && p.first() >= 0) {
                pids.add(p.first());
                p = this.bidIndex.get(p.first());
            }
            Collections.reverse(pids);
            return pids;
        }

        protected BranchState getBranchState(int bid) {
            BranchState bs = this.branchStates.get(bid);
            if (bs == null) {
                BranchState pbs = null;
                int id = bid;
                while (pbs == null && id >= 0) {
                    Pair<Integer, Integer> p = this.bidIndex.get(id);
                    id = (Integer)p.first;
                    pbs = this.branchStates.get(id);
                }
                bs = pbs;
            }
            return bs;
        }

        protected BranchState getBranchState(int bid, boolean add) {
            BranchState bs = this.getBranchState(bid);
            if (add) {
                if (bs == null) {
                    bs = new BranchState(bid);
                } else if (bs.bid != bid) {
                    bs = new BranchState(bid, bs);
                }
                this.branchStates.put(bid, bs);
            }
            return bs;
        }

        protected Map<Integer, BasicSequenceMatchResult.MatchedGroup> getMatchedGroups(int bid, boolean add) {
            BranchState bs = this.getBranchState(bid, add);
            if (bs == null) {
                return null;
            }
            if (add && bs.matchedGroups == null) {
                bs.matchedGroups = new LinkedHashMap<Integer, BasicSequenceMatchResult.MatchedGroup>();
            }
            return bs.matchedGroups;
        }

        protected BasicSequenceMatchResult.MatchedGroup getMatchedGroup(int bid, int groupId) {
            Map<Integer, BasicSequenceMatchResult.MatchedGroup> map = this.getMatchedGroups(bid, false);
            if (map != null) {
                return map.get(groupId);
            }
            return null;
        }

        protected void setGroupStart(int bid, int captureGroupId, int curPosition) {
            if (captureGroupId >= 0) {
                Map<Integer, BasicSequenceMatchResult.MatchedGroup> matchedGroups = this.getMatchedGroups(bid, true);
                BasicSequenceMatchResult.MatchedGroup mg = matchedGroups.get(captureGroupId);
                if (mg != null) {
                    logger.fine("Setting matchBegin=" + curPosition + ": Capture group " + captureGroupId + " already exists: " + mg);
                }
                matchedGroups.put(captureGroupId, new BasicSequenceMatchResult.MatchedGroup(curPosition, -1, null));
            }
        }

        protected void setGroupEnd(int bid, int captureGroupId, int curPosition, Object value) {
            if (captureGroupId >= 0) {
                Map<Integer, BasicSequenceMatchResult.MatchedGroup> matchedGroups = this.getMatchedGroups(bid, true);
                BasicSequenceMatchResult.MatchedGroup mg = matchedGroups.get(captureGroupId);
                int end = curPosition + 1;
                if (mg != null) {
                    if (mg.matchEnd == -1) {
                        matchedGroups.put(captureGroupId, new BasicSequenceMatchResult.MatchedGroup(mg.matchBegin, end, value));
                    } else if (mg.matchEnd != end) {
                        logger.warning("Cannot set matchEnd=" + end + ": Capture group " + captureGroupId + " already ended: " + mg);
                    }
                } else {
                    logger.warning("Cannot set matchEnd=" + end + ": Capture group " + captureGroupId + " is null");
                }
            }
        }

        protected void clearGroupStart(int bid, int captureGroupId) {
            Map<Integer, BasicSequenceMatchResult.MatchedGroup> matchedGroups;
            if (captureGroupId >= 0 && (matchedGroups = this.getMatchedGroups(bid, false)) != null) {
                matchedGroups.remove(captureGroupId);
            }
        }

        protected Map<Integer, Object> getMatchedResults(int bid, boolean add) {
            BranchState bs = this.getBranchState(bid, add);
            if (bs == null) {
                return null;
            }
            if (add && bs.matchedResults == null) {
                bs.matchedResults = new LinkedHashMap<Integer, Object>();
            }
            return bs.matchedResults;
        }

        protected Object getMatchedResult(int bid, int index) {
            Map<Integer, Object> map = this.getMatchedResults(bid, false);
            if (map != null) {
                return map.get(index);
            }
            return null;
        }

        protected void setMatchedResult(int bid, int index, Object obj) {
            if (index >= 0) {
                Map<Integer, Object> matchedResults = this.getMatchedResults(bid, true);
                Object oldObj = matchedResults.get(index);
                if (oldObj != null) {
                    logger.warning("Setting matchedResult=" + obj + ": index " + index + " already exists: " + oldObj);
                }
                matchedResults.put(index, obj);
            }
        }

        protected int getBranchId(int bid, int nextBranchIndex, int nextTotal) {
            if (nextBranchIndex <= 0 || nextBranchIndex > nextTotal) {
                throw new IllegalArgumentException("Invalid nextBranchIndex=" + nextBranchIndex + ", nextTotal=" + nextTotal);
            }
            if (nextTotal == 1) {
                return bid;
            }
            Pair<Integer, Integer> p = new Pair<Integer, Integer>(bid, nextBranchIndex);
            int i = this.bidIndex.indexOf(p);
            if (i < 0) {
                for (int j = 0; j < nextTotal; ++j) {
                    this.bidIndex.add(new Pair<Integer, Integer>(bid, j + 1));
                }
                i = this.bidIndex.indexOf(p);
            }
            return i;
        }

        protected Map<SequencePattern.State, Object> getMatchStateInfo(int bid, boolean add) {
            BranchState bs = this.getBranchState(bid, add);
            if (bs == null) {
                return null;
            }
            if (add && bs.matchStateInfo == null) {
                bs.matchStateInfo = new LinkedHashMap<SequencePattern.State, Object>();
            }
            return bs.matchStateInfo;
        }

        protected Object getMatchStateInfo(int bid, SequencePattern.State node) {
            Map<SequencePattern.State, Object> matchStateInfo = this.getMatchStateInfo(bid, false);
            return matchStateInfo != null ? matchStateInfo.get(node) : null;
        }

        protected void removeMatchStateInfo(int bid, SequencePattern.State node) {
            Object obj = this.getMatchStateInfo(bid, node);
            if (obj != null) {
                Map<SequencePattern.State, Object> matchStateInfo = this.getMatchStateInfo(bid, true);
                matchStateInfo.remove(node);
            }
        }

        protected void setMatchStateInfo(int bid, SequencePattern.State node, Object obj) {
            Map<SequencePattern.State, Object> matchStateInfo = this.getMatchStateInfo(bid, true);
            matchStateInfo.put(node, obj);
        }

        protected void startMatchedCountInc(int bid, SequencePattern.State node) {
            Map<SequencePattern.State, Object> matchStateCount = this.getMatchStateInfo(bid, true);
            Pair p = (Pair)matchStateCount.get(node);
            if (p == null) {
                matchStateCount.put(node, new Pair<Integer, Boolean>(1, false));
            } else {
                matchStateCount.put(node, new Pair<Integer, Boolean>((Integer)p.first() + 1, false));
            }
        }

        protected int endMatchedCountInc(int bid, SequencePattern.State node) {
            Map<SequencePattern.State, Object> matchStateCount = this.getMatchStateInfo(bid, false);
            if (matchStateCount == null) {
                return 0;
            }
            matchStateCount = this.getMatchStateInfo(bid, true);
            Pair p = (Pair)matchStateCount.get(node);
            if (p != null) {
                int v = (Integer)p.first();
                matchStateCount.put(node, new Pair<Integer, Boolean>(v, true));
                return v;
            }
            return 0;
        }

        protected void clearMatchedCount(int bid, SequencePattern.State node) {
            this.removeMatchStateInfo(bid, node);
        }

        protected void setMatchedInterval(int bid, SequencePattern.State node, Interval<Integer> interval) {
            Map<SequencePattern.State, Object> matchStateInfo = this.getMatchStateInfo(bid, true);
            Interval p = (Interval)matchStateInfo.get(node);
            if (p == null) {
                matchStateInfo.put(node, interval);
            } else {
                logger.warning("Interval already exists for bid=" + bid);
            }
        }

        protected Interval<Integer> getMatchedInterval(int bid, SequencePattern.State node) {
            Map<SequencePattern.State, Object> matchStateInfo = this.getMatchStateInfo(bid, true);
            Interval p = (Interval)matchStateInfo.get(node);
            return p;
        }

        protected void addBidsToCollapse(int bid, int[] bids) {
            BranchState bs = this.getBranchState(bid, true);
            bs.addBidsToCollapse(bids);
        }

        private void mergeBranchStates(BranchState bs) {
            if (bs.bidsToCollapse != null && bs.bidsToCollapse.size() > 0) {
                for (int cbid : bs.bidsToCollapse) {
                    if (cbid == bs.bid) continue;
                    BranchState cbs = this.getBranchState(cbid);
                    if (cbs != null) {
                        bs.addMatchedGroups(cbs.matchedGroups);
                        bs.addMatchedResults(cbs.matchedResults);
                        continue;
                    }
                    logger.finest("Unable to find state info for bid=" + cbid);
                }
                if (bs.collapsedBids == null) {
                    bs.collapsedBids = bs.bidsToCollapse;
                } else {
                    bs.collapsedBids.addAll(bs.bidsToCollapse);
                }
                bs.bidsToCollapse = null;
            }
        }
    }

    private static class State {
        int bid;
        SequencePattern.State tstate;

        public State(int bid, SequencePattern.State tstate) {
            this.bid = bid;
            this.tstate = tstate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            if (this.bid != state.bid) {
                return false;
            }
            return !(this.tstate != null ? !this.tstate.equals(state.tstate) : state.tstate != null);
        }

        public int hashCode() {
            int result = this.bid;
            result = 31 * result + (this.tstate != null ? this.tstate.hashCode() : 0);
            return result;
        }
    }

    private static class BranchState {
        int bid;
        BranchState parent;
        Map<Integer, BasicSequenceMatchResult.MatchedGroup> matchedGroups;
        Map<Integer, Object> matchedResults;
        Map<SequencePattern.State, Object> matchStateInfo;
        Set<Integer> bidsToCollapse;
        Set<Integer> collapsedBids;

        public BranchState(int bid) {
            this(bid, null);
        }

        public BranchState(int bid, BranchState parent) {
            this.bid = bid;
            this.parent = parent;
            if (parent != null) {
                if (parent.matchedGroups != null) {
                    this.matchedGroups = new LinkedHashMap<Integer, BasicSequenceMatchResult.MatchedGroup>(parent.matchedGroups);
                }
                if (parent.matchedResults != null) {
                    this.matchedResults = new LinkedHashMap<Integer, Object>(parent.matchedResults);
                }
                if (parent.matchStateInfo != null) {
                    this.matchStateInfo = new LinkedHashMap<SequencePattern.State, Object>(parent.matchStateInfo);
                }
                if (parent.bidsToCollapse != null) {
                    this.bidsToCollapse = new ArraySet<Integer>(parent.bidsToCollapse.size());
                    this.bidsToCollapse.addAll(parent.bidsToCollapse);
                }
                if (parent.collapsedBids != null) {
                    this.collapsedBids = new ArraySet<Integer>(parent.collapsedBids.size());
                    this.collapsedBids.addAll(parent.collapsedBids);
                }
            }
        }

        private void updateKeepBids(Set<Integer> bids) {
            if (this.matchStateInfo != null) {
                for (SequencePattern.State s : this.matchStateInfo.keySet()) {
                    if (!(s instanceof SequencePattern.ConjStartState)) continue;
                    SequencePattern.ConjMatchStateInfo info = (SequencePattern.ConjMatchStateInfo)this.matchStateInfo.get(s);
                    info.updateKeepBids(bids);
                }
            }
        }

        private void addBidsToCollapse(int[] bids) {
            if (this.bidsToCollapse == null) {
                this.bidsToCollapse = new ArraySet<Integer>(bids.length);
            }
            for (int b : bids) {
                if (b == this.bid) continue;
                this.bidsToCollapse.add(b);
            }
        }

        private void addMatchedGroups(Map<Integer, BasicSequenceMatchResult.MatchedGroup> g) {
            for (Integer k : g.keySet()) {
                if (this.matchedGroups.containsKey(k)) continue;
                this.matchedGroups.put(k, g.get(k));
            }
        }

        private void addMatchedResults(Map<Integer, Object> res) {
            if (res != null) {
                for (Integer k : res.keySet()) {
                    if (this.matchedResults.containsKey(k)) continue;
                    this.matchedResults.put(k, res.get(k));
                }
            }
        }
    }

    public static class GroupMatchReplacement<T>
    implements MatchReplacement<T> {
        int group;

        public GroupMatchReplacement(int group) {
            this.group = group;
        }

        @Override
        public void append(SequenceMatchResult<T> match, List list) {
            list.addAll(match.groupNodes(this.group));
        }
    }

    public static class NamedGroupMatchReplacement<T>
    implements MatchReplacement<T> {
        String groupName;

        public NamedGroupMatchReplacement(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public void append(SequenceMatchResult<T> match, List list) {
            list.addAll(match.groupNodes(this.groupName));
        }
    }

    public static class BasicMatchReplacement<T>
    implements MatchReplacement<T> {
        List<T> replacement;

        public BasicMatchReplacement(T ... replacement) {
            this.replacement = Arrays.asList(replacement);
        }

        public BasicMatchReplacement(List<T> replacement) {
            this.replacement = replacement;
        }

        @Override
        public void append(SequenceMatchResult<T> match, List list) {
            list.addAll(this.replacement);
        }
    }

    public static interface MatchReplacement<T> {
        public void append(SequenceMatchResult<T> var1, List var2);
    }

    public static enum FindType {
        FIND_NONOVERLAPPING,
        FIND_ALL;

    }
}

