/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.structure;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ExtractionObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String objectId;
    protected CoreMap sentence;
    protected String type;
    protected final String subType;
    protected Span extentTokenSpan;
    protected CoreMap attributeMap;
    protected Counter<String> typeProbabilities;
    private static final String TYPE_SEP = "/";

    public ExtractionObject(String objectId, CoreMap sentence, Span span, String type, String subtype) {
        this.objectId = objectId;
        this.sentence = sentence;
        this.extentTokenSpan = span;
        this.type = type.intern();
        this.subType = subtype != null ? subtype.intern() : null;
        this.attributeMap = null;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getDocumentId() {
        return (String)this.sentence.get(CoreAnnotations.DocIDAnnotation.class);
    }

    public CoreMap getSentence() {
        return this.sentence;
    }

    public void setSentence(CoreMap sent) {
        this.sentence = sent;
    }

    public int getExtentTokenStart() {
        return this.extentTokenSpan.start();
    }

    public int getExtentTokenEnd() {
        return this.extentTokenSpan.end();
    }

    public Span getExtent() {
        return this.extentTokenSpan;
    }

    public void setExtent(Span s) {
        this.extentTokenSpan = s;
    }

    public String getExtentString() {
        List tokens = (List)this.sentence.get(CoreAnnotations.TokensAnnotation.class);
        StringBuilder sb = new StringBuilder();
        for (int i = this.extentTokenSpan.start(); i < this.extentTokenSpan.end(); ++i) {
            CoreLabel token = (CoreLabel)tokens.get(i);
            if (i > this.extentTokenSpan.start()) {
                sb.append(" ");
            }
            sb.append(token.word());
        }
        return sb.toString();
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExtractionObject)) {
            return false;
        }
        ExtractionObject o = (ExtractionObject)other;
        return o.objectId.equals(this.objectId) && o.sentence == this.sentence;
    }

    public static void sortByExtent(List<ExtractionObject> objects) {
        Collections.sort(objects, new CompByExtent());
    }

    public static Span getSpan(ExtractionObject ... objs) {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i].getExtentTokenStart() < left) {
                left = objs[i].getExtentTokenStart();
            }
            if (objs[i].getExtentTokenEnd() <= right) continue;
            right = objs[i].getExtentTokenEnd();
        }
        assert (left < Integer.MAX_VALUE);
        assert (right > Integer.MIN_VALUE);
        return new Span(left, right);
    }

    public String getValue() {
        return this.getFullValue();
    }

    public final String getFullValue() {
        List tokens = (List)this.sentence.get(CoreAnnotations.TokensAnnotation.class);
        StringBuilder sb = new StringBuilder();
        if (tokens != null && this.extentTokenSpan != null) {
            for (int i = this.extentTokenSpan.start(); i < this.extentTokenSpan.end(); ++i) {
                if (i > this.extentTokenSpan.start()) {
                    sb.append(" ");
                }
                sb.append(((CoreLabel)tokens.get(i)).word());
            }
        }
        return sb.toString();
    }

    public void setType(String t) {
        this.type = t;
    }

    public static String concatenateTypes(String t1, String t2) {
        String[] t1Toks = t1.split(TYPE_SEP);
        String[] t2Toks = t2.split(TYPE_SEP);
        Set<String> uniqueTypes = Generics.newHashSet();
        for (String t : t1Toks) {
            uniqueTypes.add(t);
        }
        for (String t : t2Toks) {
            uniqueTypes.add(t);
        }
        Object[] types = new String[uniqueTypes.size()];
        uniqueTypes.toArray(types);
        Arrays.sort(types);
        StringBuffer os = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                os.append(TYPE_SEP);
            }
            os.append((String)types[i]);
        }
        return os.toString();
    }

    public CoreMap attributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayCoreMap();
        }
        return this.attributeMap;
    }

    public void setTypeProbabilities(Counter<String> probs) {
        this.typeProbabilities = probs;
    }

    public Counter<String> getTypeProbabilities() {
        return this.typeProbabilities;
    }

    String probsToString() {
        List<Pair<String, Double>> sorted = Counters.toDescendingMagnitudeSortedListWithCounts(this.typeProbabilities);
        StringBuffer os = new StringBuffer();
        os.append("{");
        boolean first = true;
        for (Pair<String, Double> lv : sorted) {
            if (!first) {
                os.append("; ");
            }
            os.append((String)lv.first + ", " + lv.second);
            first = false;
        }
        os.append("}");
        return os.toString();
    }

    public boolean printableObject(double beam, String nilLabel) {
        List<Pair<String, Double>> sorted = Counters.toDescendingMagnitudeSortedListWithCounts(this.typeProbabilities);
        if (sorted.size() > 0 && !((String)sorted.get((int)0).first).equals(nilLabel)) {
            return true;
        }
        return sorted.size() > 1 && ((String)sorted.get((int)0).first).equals(nilLabel) && beam > 0.0 && 100.0 * ((Double)sorted.get((int)0).second - (Double)sorted.get((int)1).second) < beam;
    }

    static class CompByExtent
    implements Comparator<ExtractionObject> {
        CompByExtent() {
        }

        @Override
        public int compare(ExtractionObject o1, ExtractionObject o2) {
            if (o1.getExtentTokenStart() < o2.getExtentTokenStart()) {
                return -1;
            }
            if (o1.getExtentTokenStart() > o2.getExtentTokenStart()) {
                return 1;
            }
            if (o1.getExtentTokenEnd() < o2.getExtentTokenEnd()) {
                return -1;
            }
            if (o1.getExtentTokenEnd() > o2.getExtentTokenEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

