/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MUCMentionExtractor
extends MentionExtractor {
    private TokenizerFactory<CoreLabel> tokenizerFactory;
    private String fileContents;
    private int currentOffset;

    public MUCMentionExtractor(Dictionaries dict, Properties props, Semantics semantics) throws Exception {
        super(dict, semantics);
        String fileName = props.getProperty("dcoref.muc");
        this.fileContents = IOUtils.slurpFile(fileName);
        this.currentOffset = 0;
        this.tokenizerFactory = PTBTokenizer.factory(new CoreLabelTokenFactory(false), "");
        this.stanfordProcessor = MUCMentionExtractor.loadStanfordProcessor(props);
    }

    public MUCMentionExtractor(Dictionaries dict, Properties props, Semantics semantics, LogisticClassifier<String, String> singletonModel) throws Exception {
        this(dict, props, semantics);
        this.singletonPredictor = singletonModel;
    }

    @Override
    public void resetDocs() {
        super.resetDocs();
        this.currentOffset = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document nextDoc() throws Exception {
        ArrayList<List<CoreLabel>> allWords = new ArrayList<List<CoreLabel>>();
        ArrayList<Tree> allTrees = new ArrayList<Tree>();
        ArrayList<List<Mention>> allGoldMentions = new ArrayList<List<Mention>>();
        ArrayList<Annotation> allSentences = new ArrayList<Annotation>();
        Annotation docAnno = new Annotation("");
        Pattern docPattern = Pattern.compile("<DOC>(.*?)</DOC>", 34);
        Pattern sentencePattern = Pattern.compile("(<s>|<hl>|<dd>|<DATELINE>)(.*?)(</s>|</hl>|</dd>|</DATELINE>)", 34);
        Matcher docMatcher = docPattern.matcher(this.fileContents);
        if (!docMatcher.find(this.currentOffset)) {
            return null;
        }
        this.currentOffset = docMatcher.end();
        String doc = docMatcher.group(1);
        Matcher sentenceMatcher = sentencePattern.matcher(doc);
        String ner = null;
        Pattern docIDPattern = Pattern.compile("<DOCNO>(.*?)</DOCNO>", 34);
        Matcher docIDMatcher = docIDPattern.matcher(doc);
        this.currentDocumentID = docIDMatcher.find() ? docIDMatcher.group(1) : "documentAfter " + this.currentDocumentID;
        while (sentenceMatcher.find()) {
            Object w;
            void var17_19;
            String sentenceString = sentenceMatcher.group(2);
            List<CoreLabel> words = this.tokenizerFactory.getTokenizer(new StringReader(sentenceString)).tokenize();
            boolean bl = false;
            while (var17_19 < words.size()) {
                CoreLabel w2 = words.get((int)var17_19);
                if (var17_19 > 0 && w2.word().equals("$")) {
                    if (words.get((int)(var17_19 - true)).word().endsWith("PRP") || words.get((int)(var17_19 - true)).word().endsWith("WP")) {
                        words.get((int)(var17_19 - true)).set(CoreAnnotations.TextAnnotation.class, words.get((int)(var17_19 - true)).word() + "$");
                        words.remove((int)var17_19);
                        --var17_19;
                    }
                } else if (w2.word().equals("\\/") && !words.get((int)(var17_19 - true)).word().equals("</COREF>")) {
                    w2.set(CoreAnnotations.TextAnnotation.class, words.get((int)(var17_19 - true)).word() + "\\/" + words.get((int)(var17_19 + true)).word());
                    words.remove((int)(var17_19 + true));
                    words.remove((int)(var17_19 - true));
                }
                ++var17_19;
            }
            ArrayList<CoreLabel> arrayList = new ArrayList<CoreLabel>();
            Stack<Mention> stack = new Stack<Mention>();
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            allWords.add(arrayList);
            allGoldMentions.add(mentions);
            for (CoreLabel word : words) {
                Matcher m;
                w = (String)word.get(CoreAnnotations.TextAnnotation.class);
                if (!((String)w).startsWith("<") && ((String)w).contains("\\/") && ((String)w).lastIndexOf("\\/") != ((String)w).length() - 2) {
                    int i = ((String)w).lastIndexOf("\\/");
                    String w1 = ((String)w).substring(0, i);
                    word.set(CoreAnnotations.TextAnnotation.class, w1);
                    word.remove(CoreAnnotations.OriginalTextAnnotation.class);
                    arrayList.add(word);
                    continue;
                }
                if (((String)w).startsWith("<") && !((String)w).startsWith("<COREF") && !((String)w).startsWith("</")) {
                    Pattern nerPattern = Pattern.compile("<(.*?)>");
                    m = nerPattern.matcher((CharSequence)w);
                    m.find();
                    ner = m.group(1);
                    continue;
                }
                if (((String)w).startsWith("</") && !((String)w).startsWith("</COREF")) {
                    Pattern nerPattern = Pattern.compile("</(.*?)>");
                    m = nerPattern.matcher((CharSequence)w);
                    m.find();
                    String ner1 = m.group(1);
                    if (ner != null && !ner.equals(ner1)) {
                        throw new RuntimeException("Unmatched NE labels in MUC file: " + ner + " v. " + ner1);
                    }
                    ner = null;
                    continue;
                }
                if (((String)w).startsWith("<COREF")) {
                    Mention mention = new Mention();
                    mention.startIndex = arrayList.size();
                    Pattern idPattern = Pattern.compile("ID=\"(.*?)\"");
                    Pattern refPattern = Pattern.compile("REF=\"(.*?)\"");
                    Matcher m2 = idPattern.matcher((CharSequence)w);
                    m2.find();
                    mention.mentionID = Integer.valueOf(m2.group(1));
                    m2 = refPattern.matcher((CharSequence)w);
                    if (m2.find()) {
                        mention.originalRef = Integer.valueOf(m2.group(1));
                    }
                    stack.push(mention);
                    continue;
                }
                if (((String)w).equals("</COREF>")) {
                    Mention mention = (Mention)stack.pop();
                    mention.endIndex = arrayList.size();
                    mentions.add(mention);
                    continue;
                }
                word.remove(CoreAnnotations.OriginalTextAnnotation.class);
                arrayList.add(word);
            }
            StringBuilder textContent = new StringBuilder();
            for (int i = 0; i < arrayList.size(); ++i) {
                w = (CoreLabel)arrayList.get(i);
                ((ArrayCoreMap)w).set(CoreAnnotations.IndexAnnotation.class, i + 1);
                ((ArrayCoreMap)w).set(CoreAnnotations.UtteranceAnnotation.class, 0);
                if (i > 0) {
                    textContent.append(" ");
                }
                textContent.append(((CoreLabel)w).getString(CoreAnnotations.TextAnnotation.class));
            }
            Annotation sentCoreMap = new Annotation(textContent.toString());
            allSentences.add(sentCoreMap);
            sentCoreMap.set(CoreAnnotations.TokensAnnotation.class, arrayList);
        }
        Map<Integer, Mention> idMention = Generics.newHashMap();
        for (List list : allGoldMentions) {
            for (Mention m : list) {
                idMention.put(m.mentionID, m);
            }
        }
        for (List list : allGoldMentions) {
            block7: for (Mention m : list) {
                if (m.goldCorefClusterID != -1) continue;
                if (m.originalRef == -1) {
                    m.goldCorefClusterID = m.mentionID;
                    continue;
                }
                int ref = m.originalRef;
                while (true) {
                    Mention m2 = (Mention)idMention.get(ref);
                    if (m2.goldCorefClusterID != -1) {
                        m.goldCorefClusterID = m2.goldCorefClusterID;
                        continue block7;
                    }
                    if (m2.originalRef == -1) {
                        m.goldCorefClusterID = m2.goldCorefClusterID = m2.mentionID;
                        continue block7;
                    }
                    ref = m2.originalRef;
                }
            }
        }
        docAnno.set(CoreAnnotations.SentencesAnnotation.class, allSentences);
        this.stanfordProcessor.annotate(docAnno);
        if (allSentences.size() != allWords.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < allSentences.size(); ++i) {
            List list = (List)((CoreMap)allSentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            List unannotatedSent = (List)allWords.get(i);
            List mentionInSent = (List)allGoldMentions.get(i);
            for (Mention m : mentionInSent) {
                m.dependency = (SemanticGraph)((CoreMap)allSentences.get(i)).get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
            }
            if (list.size() != unannotatedSent.size()) {
                throw new RuntimeException();
            }
            int k = 0;
            int j = 0;
            while (j < list.size()) {
                CoreLabel annotatedWord = (CoreLabel)list.get(j);
                CoreLabel unannotatedWord = (CoreLabel)unannotatedSent.get(k);
                if (!((String)annotatedWord.get(CoreAnnotations.TextAnnotation.class)).equals(unannotatedWord.get(CoreAnnotations.TextAnnotation.class))) {
                    throw new RuntimeException();
                }
                ++j;
                ++k;
            }
            allWords.set(i, list);
            allTrees.add((Tree)((CoreMap)allSentences.get(i)).get(TreeCoreAnnotations.TreeAnnotation.class));
        }
        List<List<Mention>> allPredictedMentions = this.mentionFinder.extractPredictedMentions(docAnno, this.maxID, this.dictionaries);
        return this.arrange(docAnno, allWords, allTrees, allPredictedMentions, allGoldMentions, true);
    }
}

