/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class CHTBLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0007\u0001\u0002\u0001\u0006\u0001\u0006\u0001\u0005\u0012\u0000\u0001\u0007\u0007\u0000\u0001\u0004\u0001\u0004\u0005\u0000\u0001\u0014\f\u0000\u0001\u0001\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0011\u0001\u0017\u0001\n\u0001\b\u0001\u000e\u0003\u0000\u0001\u0010\u0003\u0000\u0001\u0012\u0001\u000f\u0001\t\u0001\r\u0001\u0000\u0001\u0016\u0001\u0015\u0001\u000b\u0004\u0000\u0001\f\u0005\u0000\u0001\u0013%\u0000\u0001\u0006\u1fa2\u0000\u0001\u0006\u0001\u0006\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = CHTBLexer.zzUnpackCMap("\t\u0000\u0001\u0007\u0001\u0002\u0001\u0006\u0001\u0006\u0001\u0005\u0012\u0000\u0001\u0007\u0007\u0000\u0001\u0004\u0001\u0004\u0005\u0000\u0001\u0014\f\u0000\u0001\u0001\u0001\u0000\u0001\u0003\u0002\u0000\u0001\u0011\u0001\u0017\u0001\n\u0001\b\u0001\u000e\u0003\u0000\u0001\u0010\u0003\u0000\u0001\u0012\u0001\u000f\u0001\t\u0001\r\u0001\u0000\u0001\u0016\u0001\u0015\u0001\u000b\u0004\u0000\u0001\f\u0005\u0000\u0001\u0013%\u0000\u0001\u0006\u1fa2\u0000\u0001\u0006\u0001\u0006\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = CHTBLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\u0002\u0001\u0001\u0002\u0002\u0001\u0001\u0001\u0000\u0004\u0001\u0002\u0003\u0011\u0001\u0001\u0003\u0001\u0000\u0003\u0001\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0000\u0001\u0001\u0001\u0000\u0004\u0001\u0004\u0000\u0005\u0001\u0005\u0000\u0004\u0001\u0004\u0000\u0006\u0001\u0006\u0000\u0003\u0001\u0003\u0000\u0001\u0001\u0001\u0000";
    private static final int[] ZZ_ROWMAP = CHTBLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0018\u00000\u0000H\u0000H\u0000`\u0000x\u0000\u0090\u0000\u00a8\u0000\u00c0\u0000\u00d8\u0000\u00f0\u0000\u0108\u0000\u0018\u0000H\u0000\u0120\u0000\u0138\u0000\u0150\u0000\u0168\u0000\u0180\u0000\u0198\u0000\u01b0\u0000\u01c8\u0000\u01e0\u0000\u01f8\u0000\u0210\u0000\u0228\u0000\u0240\u0000\u0258\u0000\u0270\u0000\u0288\u0000\u02a0\u0000\u02b8\u0000\u02d0\u0000\u02e8\u0000\u0300\u0000\u0318\u0000\u0330\u0000\u0348\u0000\u0360\u0000\u0378\u0000\u0390\u0000\u03a8\u0000\u03a8\u0000\u03c0\u0000\u03d8\u0000\u03f0\u0000\u0408\u0000\u0420\u0000\u0438\u0000\u0450\u0000\u0468\u0000\u0480\u0000\u0498\u0000\u04b0\u0000\u04c8\u0000\u04e0\u0000\u04f8\u0000\u0510\u0000\u0528\u0000\u0540\u0000\u0558\u0000\u0570\u0000\u0588\u0000\u05a0\u0000\u05b8\u0000\u05d0\u0000\u05e8\u0000\u0600\u0000\u0618\u0000\u0630\u0000\u0648\u0000\u0660\u0000\u0678\u0000\u0690\u0000\u06a8\u0000\u06c0\u0000\u06d8\u0000\u06f0\u0000\u0708\u0000\u0720\u0000\u0738\u0000\u0750\u0000\u0768\u0000\u0780\u0000\u0798\u0000\u07b0\u0000\u07c8\u0000\u07e0\u0000\u07f8\u0000\u0810\u0000\u0828";
    private static final int[] ZZ_TRANS = CHTBLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0002\u0001\u0005\u0001\u0006\u0001\u0004\u0001\u0007\u0012\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0010\u0002\u0002\b\u0001\u0000\u0001\u0002\u0001\t\u0001\u0000\u0002\t\u0001\n\u0001\b\u0001\u000b\u0003\b\u0001\f\u0006\b\u0001\r\u0002\b\u001a\u0000\u0001\u0004\u001c\u0000\u0001\u0007\u0010\u0000\u0002\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0010\b\u0002\t\u0001\u0000\u0001\u000f\u0001\t\u0001\u0000\u0012\t\u0002\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0001\b\u0001\u0010\u0007\b\u0001\u0011\b\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0003\b\u0001\u0012\u000e\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0007\b\u0001\u0013\n\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u000e\b\u0001\u0014\u0003\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0002\b\u0001\u0015\u000f\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0003\b\u0001\u0016\u000e\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u000f\b\u0001\u0017\u0002\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0001\u0018\u0011\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0002\b\u0001\u0017\u000f\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0003\b\u0001\u0019\u0003\b\u0001\u001a\u0001\u001b\t\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0006\b\u0001\u001c\u000b\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\b\b\u0001\u001b\t\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0003\b\u0001\u001d\u0007\b\u0001\u001e\u0006\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0004\b\u0001\u001f\r\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0001\b\u0001 \u0010\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0001 \u0011\b\u0001\u0000\u0001!\u0001\t\u0001\u0000\u0001\t\u0001\"\u0003\b\u0001\u001d\u0007\b\u0002\u001e\u0005\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\b\b\u0001#\t\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0003\b\u0001\u001d\u000e\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0005\b\u0001$\f\b\u0001\u0000\u0001!\u0001\t\u0001\u0000\u0001\t\u0001\"\u0010\b\u0001%\u0001\u0002\u0001&\u0001%\u0004&\u0010%\u0002'\u0001(\u0001\u000f\u0001'\u0001(\u0012'\u0002\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\n\b\u0001$\u0007\b\u0001\u0000\u0001\u000e\u0001\t\u0001\u0000\u0002\t\u0006\b\u0001 \t\b\u0001%\u0001)\u0001&\u0001%\u0004&\u0010%\u0001&\u0001*\u0016&\u0002'\u0001(\u0001+\u0001'\u0001(\u0012'\u0003(\u0001,\u0014(\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\f\u0002\u0001-\u0003\u0002\u0014\u0000\u0001.\u0003\u0000\u0001&\u0001\u0000\u0016&\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001/\u0001\u0002\u00010\u0003\u0002\u00011\u0006\u0002\u00012\u0002\u0002\b\u0000\u00013\u0001\u0000\u00014\u0003\u0000\u00015\u0006\u0000\u00016\u0002\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001\u0002\u00017\u0007\u0002\u00018\b\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0003\u0002\u00019\u000e\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0007\u0002\u0001:\n\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u000e\u0002\u0001;\u0001\u0002\t\u0000\u0001<\u0007\u0000\u0001=\u0011\u0000\u0001>\u001b\u0000\u0001?\u001e\u0000\u0001@\u0001\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0002\u0002\u0001A\u000f\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0003\u0002\u0001B\u000e\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u000f\u0002\u0001C\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001D\u0011\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0002\u0002\u0001C\r\u0002\n\u0000\u0001E\u0018\u0000\u0001F#\u0000\u0001G\b\u0000\u0001H\u0019\u0000\u0001G\r\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0003\u0002\u0001I\u0003\u0002\u0001J\u0001K\t\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0006\u0002\u0001L\u000b\u0002\u0001\u0000\u0001\u0002\u0004\u0000\b\u0002\u0001K\t\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0003\u0002\u0001M\u0007\u0002\u0001N\u0004\u0002\u000b\u0000\u0001O\u0003\u0000\u0001P\u0001Q\u0015\u0000\u0001R\u0019\u0000\u0001Q\u0012\u0000\u0001S\u0007\u0000\u0001T\u0004\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0004\u0002\u0001U\r\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001\u0002\u0001V\u0010\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0001V\u0011\u0002\u0001\u0000\u0001\u000e\u0004\u0000\u0003\u0002\u0001M\u0007\u0002\u0002N\u0005\u0002\u0001\u0000\u0001\u0002\u0004\u0000\b\u0002\u0001W\t\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0003\u0002\u0001M\f\u0002\f\u0000\u0001X\u0014\u0000\u0001Y\u0016\u0000\u0001Y\u0012\u0000\u0001\u000f\u0007\u0000\u0001S\u0007\u0000\u0002T\u0013\u0000\u0001Z\u0012\u0000\u0001S\f\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0005\u0002\u0001[\f\u0002\u0001\u0000\u0001\u000e\u0004\u0000\u0012\u0002\u0001\u0000\u0001\u0002\u0004\u0000\n\u0002\u0001[\u0005\u0002\r\u0000\u0001\\\r\u0000\u0001\u000f&\u0000\u0001\\\u0005\u0000\u0002\u0002\u0001\u0000\u0001\u0002\u0004\u0000\u0006\u0002\u0001V\t\u0002\u000e\u0000\u0001Y\t\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CHTBLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0002\u0001\u0002\t\u0003\u0001\u0001\u0000\u0005\u0001\u0001\t\u0012\u0001\u0001\u0000\u0003\u0001\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0004\u0001\u0004\u0000\u0005\u0001\u0005\u0000\u0004\u0001\u0004\u0000\u0006\u0001\u0006\u0000\u0003\u0001\u0003\u0000\u0001\u0001\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private static final boolean DBG = false;
    public static final int IGNORE = 0;
    public static final int ACCEPT = 1;

    private static int[] zzUnpackAction() {
        int[] result = new int[92];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[92];
        int offset = 0;
        offset = CHTBLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[2112];
        int offset = 0;
        offset = CHTBLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[92];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public String match() {
        return this.yytext();
    }

    private static void reportError(String yytext) {
        try {
            PrintWriter p = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "utf-8"), true);
            p.println("chtbl.flex tokenization error: \"" + yytext + "\"");
            if (yytext.length() >= 1) {
                p.println("First character is: " + yytext.charAt(0));
                if (yytext.length() >= 2) {
                    p.println("Second character is: " + yytext.charAt(1));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("chtbl.flex tokenization and encoding present error");
        }
    }

    CHTBLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 120) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block8: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return 1;
                }
                case 4: {
                    continue block8;
                }
                case 2: {
                    return 0;
                }
                case 5: {
                    continue block8;
                }
                case 3: {
                    return 0;
                }
                case 6: {
                    continue block8;
                }
            }
            this.zzScanError(1);
        }
    }
}

