/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;

public class MetaClass {
    private String classname;
    private static final HashMap<Class, MetaClass> abstractToConcreteCollectionMap = new HashMap();

    public MetaClass(String classname) {
        this.classname = classname;
    }

    public MetaClass(Class<?> classname) {
        this.classname = classname.getName();
    }

    public <E> ClassFactory<E> createFactory(Class<?> ... classes) {
        try {
            return new ClassFactory(this.classname, (Class[])classes);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> ClassFactory<E> createFactory(String ... classes) {
        try {
            return new ClassFactory(this.classname, classes);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> ClassFactory<E> createFactory(Object ... objects) {
        try {
            return new ClassFactory(this.classname, objects);
        }
        catch (ClassCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassCreationException(e);
        }
    }

    public <E> E createInstance(Object ... objects) {
        ClassFactory<E> fact = this.createFactory(objects);
        return fact.createInstance(objects);
    }

    public <E, F extends E> F createInstance(Class<E> type, Object ... params) {
        E obj = this.createInstance(params);
        if (type.isInstance(obj)) {
            return (F)obj;
        }
        throw new ClassCreationException("Cannot cast " + this.classname + " into " + type.getName());
    }

    public boolean checkConstructor(Object ... params) {
        try {
            this.createInstance(params);
            return true;
        }
        catch (ConstructorNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.classname;
    }

    public boolean equals(Object o) {
        if (o instanceof MetaClass) {
            return ((MetaClass)o).classname.equals(this.classname);
        }
        return false;
    }

    public int hashCode() {
        return this.classname.hashCode();
    }

    public static MetaClass create(String classname) {
        return new MetaClass(classname);
    }

    public static MetaClass create(Class<?> clazz) {
        return new MetaClass(clazz);
    }

    private static Class<?> type2class(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return MetaClass.type2class(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return MetaClass.type2class(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return MetaClass.type2class(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Cannot convert type to class: " + type);
    }

    public static <E> E cast(String value, Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            throw new IllegalArgumentException("Cannot cast to type (unhandled type): " + type);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (E)value;
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            if ("1".equals(value)) {
                return (E)Boolean.TRUE;
            }
            return (E)Boolean.valueOf(Boolean.parseBoolean(value));
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            try {
                return (E)new Integer(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                return (E)new Integer((int)Double.parseDouble(value));
            }
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)BigInteger.ZERO;
            }
            return (E)new BigInteger(value);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            try {
                return (E)new Long(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return (E)new Long((long)Double.parseDouble(value));
            }
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)new Float(Float.NaN);
            }
            return (E)new Float(Float.parseFloat(value));
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)new Double(Double.NaN);
            }
            return (E)new Double(Double.parseDouble(value));
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            if (value == null) {
                return (E)BigDecimal.ZERO;
            }
            return (E)new BigDecimal(value);
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            try {
                return (E)new Short(Short.parseShort(value));
            }
            catch (NumberFormatException e) {
                return (E)new Short((short)Double.parseDouble(value));
            }
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            try {
                return (E)new Byte(Byte.parseByte(value));
            }
            catch (NumberFormatException e) {
                return (E)new Byte((byte)Double.parseDouble(value));
            }
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            return (E)new Character((char)Integer.parseInt(value));
        }
        if (Lazy.class.isAssignableFrom(clazz)) {
            String v = value;
            return (E)Lazy.of(() -> MetaClass.castWithoutKnowingType(v));
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return (E)(value == null || "null".equals(value.toLowerCase()) || "empty".equals(value.toLowerCase()) || "none".equals(value.toLowerCase()) ? Optional.empty() : Optional.of(value));
        }
        if (Date.class.isAssignableFrom(clazz)) {
            try {
                return (E)new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            try {
                Date d = new Date(Long.parseLong(value));
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                return (E)cal;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (FileWriter.class.isAssignableFrom(clazz)) {
            try {
                return (E)new FileWriter(new File(value));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        if (BufferedReader.class.isAssignableFrom(clazz)) {
            try {
                return (E)IOUtils.getBufferedReaderFromClasspathOrFileSystem(value);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        if (FileReader.class.isAssignableFrom(clazz)) {
            try {
                return (E)new FileReader(new File(value));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        if (File.class.isAssignableFrom(clazz)) {
            return (E)new File(value);
        }
        if (Class.class.isAssignableFrom(clazz)) {
            try {
                return (E)Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (clazz.isArray()) {
            if (value == null) {
                return null;
            }
            Class<?> subType = clazz.getComponentType();
            String[] strings = StringUtils.decodeArray(value);
            Object[] array = (Object[])Array.newInstance(clazz.getComponentType(), strings.length);
            for (int i = 0; i < strings.length; ++i) {
                array[i] = MetaClass.cast(strings[i], subType);
            }
            return (E)array;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return (E)StringUtils.decodeMap(value);
        }
        if (clazz.isEnum()) {
            Class c = clazz;
            if (value == null) {
                return null;
            }
            if (value.charAt(0) == '\"') {
                value = value.substring(1);
            }
            if (value.charAt(value.length() - 1) == '\"') {
                value = value.substring(0, value.length() - 1);
            }
            try {
                return (E)Enum.valueOf(c, value);
            }
            catch (Exception e) {
                try {
                    return (E)Enum.valueOf(c, value.toLowerCase());
                }
                catch (Exception e2) {
                    try {
                        return (E)Enum.valueOf(c, value.toUpperCase());
                    }
                    catch (Exception e3) {
                        return (E)Enum.valueOf(c, (Character.isUpperCase(value.charAt(0)) ? Character.toLowerCase(value.charAt(0)) : Character.toUpperCase(value.charAt(0))) + value.substring(1));
                    }
                }
            }
        }
        if (ObjectOutputStream.class.isAssignableFrom(clazz)) {
            try {
                return (E)new ObjectOutputStream((OutputStream)MetaClass.cast(value, OutputStream.class));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (ObjectInputStream.class.isAssignableFrom(clazz)) {
            try {
                return (E)new ObjectInputStream((InputStream)MetaClass.cast(value, InputStream.class));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (PrintStream.class.isAssignableFrom(clazz)) {
            if (value.equalsIgnoreCase("stdout") || value.equalsIgnoreCase("out")) {
                return (E)System.out;
            }
            if (value.equalsIgnoreCase("stderr") || value.equalsIgnoreCase("err")) {
                return (E)System.err;
            }
            try {
                return (E)new PrintStream(new FileOutputStream(value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (PrintWriter.class.isAssignableFrom(clazz)) {
            if (value.equalsIgnoreCase("stdout") || value.equalsIgnoreCase("out")) {
                return (E)new PrintWriter(System.out);
            }
            if (value.equalsIgnoreCase("stderr") || value.equalsIgnoreCase("err")) {
                return (E)new PrintWriter(System.err);
            }
            try {
                return (E)IOUtils.getPrintWriter(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (OutputStream.class.isAssignableFrom(clazz)) {
            if (value.equalsIgnoreCase("stdout") || value.equalsIgnoreCase("out")) {
                return (E)System.out;
            }
            if (value.equalsIgnoreCase("stderr") || value.equalsIgnoreCase("err")) {
                return (E)System.err;
            }
            File toWriteTo = (File)MetaClass.cast(value, File.class);
            try {
                if (!toWriteTo.exists() && !toWriteTo.createNewFile()) {
                    throw new IllegalStateException("Could not create output stream (cannot write file): " + value);
                }
                return (E)IOUtils.getFileOutputStream(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            if (value.equalsIgnoreCase("stdin") || value.equalsIgnoreCase("in")) {
                return (E)System.in;
            }
            try {
                return (E)IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Method decode = clazz.getMethod("fromString", String.class);
            return (E)decode.invoke((Object)MetaClass.create(clazz), value);
        }
        catch (NoSuchMethodException decode) {
        }
        catch (InvocationTargetException decode) {
        }
        catch (IllegalAccessException decode) {
        }
        catch (ClassCastException decode) {
            // empty catch block
        }
        if (Tree.class.isAssignableFrom(clazz)) {
            try {
                return (E)new PennTreeReader(new StringReader(value), new LabeledScoredTreeFactory(CoreLabel.factory())).readTree();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            String[] strings;
            Collection rtn = Modifier.isAbstract(clazz.getModifiers()) ? (Collection)abstractToConcreteCollectionMap.get(clazz).createInstance(new Object[0]) : (Collection)MetaClass.create(clazz).createInstance(new Object[0]);
            Class<?> subType = clazz.getComponentType();
            for (String string : strings = StringUtils.decodeArray(value)) {
                if (subType == null) {
                    rtn.add(MetaClass.castWithoutKnowingType(string));
                    continue;
                }
                rtn.add(MetaClass.cast(string, subType));
            }
            return (E)rtn;
        }
        return null;
    }

    public static <E> E castWithoutKnowingType(String value) {
        Class[] typesToTry;
        for (Class toTry : typesToTry = new Class[]{Integer.class, Double.class, File.class, Date.class, List.class, Set.class, Queue.class, Integer[].class, Double[].class, Character[].class, String.class}) {
            if (Collection.class.isAssignableFrom(toTry) && !value.contains(",") || value.contains(" ")) continue;
            try {
                E rtn = MetaClass.cast(value, toTry);
                if (rtn == null || File.class.isAssignableFrom(rtn.getClass()) && !((File)rtn).exists()) continue;
                return (E)ErasureUtils.uncheckedCast(rtn);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <E> E argmin(E[] elems, int[] scores, int atLeast) {
        int argmin = MetaClass.argmin(scores, atLeast);
        return argmin >= 0 ? (E)elems[argmin] : null;
    }

    private static int argmin(int[] scores, int atLeast) {
        int min = Integer.MAX_VALUE;
        int argmin = -1;
        for (int i = 0; i < scores.length; ++i) {
            if (scores[i] >= min || scores[i] < atLeast) continue;
            min = scores[i];
            argmin = i;
        }
        return argmin;
    }

    static {
        abstractToConcreteCollectionMap.put(Collection.class, MetaClass.create(ArrayList.class));
        abstractToConcreteCollectionMap.put(List.class, MetaClass.create(ArrayList.class));
        abstractToConcreteCollectionMap.put(Set.class, MetaClass.create(HashSet.class));
        abstractToConcreteCollectionMap.put(Queue.class, MetaClass.create(LinkedList.class));
        abstractToConcreteCollectionMap.put(Deque.class, MetaClass.create(LinkedList.class));
    }

    public static final class ClassFactory<T> {
        private Class<?>[] classParams;
        private Class<T> cl;
        private Constructor<T> constructor;

        private static boolean samePrimitive(Class<?> a, Class<?> b) {
            if (!a.isPrimitive() && !b.isPrimitive()) {
                return false;
            }
            if (a.isPrimitive()) {
                try {
                    Class type = (Class)b.getField("TYPE").get(null);
                    return type.equals(a);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (b.isPrimitive()) {
                try {
                    Class type = (Class)a.getField("TYPE").get(null);
                    return type.equals(b);
                }
                catch (Exception e) {
                    return false;
                }
            }
            throw new IllegalStateException("Impossible case");
        }

        private static int superDistance(Class<?> candidate, Class<?> target) {
            if (candidate == null) {
                return Integer.MIN_VALUE;
            }
            if (candidate.equals(target)) {
                return 0;
            }
            if (ClassFactory.samePrimitive(candidate, target)) {
                return 0;
            }
            Class<?> directSuper = candidate.getSuperclass();
            int superDist = ClassFactory.superDistance(directSuper, target);
            if (superDist >= 0) {
                return superDist + 1;
            }
            Class<?>[] interfaces = candidate.getInterfaces();
            int minDist = Integer.MAX_VALUE;
            for (Class<?> i : interfaces) {
                superDist = ClassFactory.superDistance(i, target);
                if (superDist < 0) continue;
                minDist = Math.min(minDist, superDist);
            }
            if (minDist != Integer.MAX_VALUE) {
                return minDist + 1;
            }
            return -1;
        }

        private void construct(String classname, Class<?> ... params) throws ClassNotFoundException, NoSuchMethodException {
            this.classParams = params;
            try {
                this.cl = Class.forName(classname);
            }
            catch (ClassCastException e) {
                throw new ClassCreationException("Class " + classname + " could not be cast to the correct type");
            }
            Constructor<?>[] constructors = this.cl.getDeclaredConstructors();
            Object[] potentials = new Constructor[constructors.length];
            Class[][] constructorParams = new Class[constructors.length][];
            int[] distances = new int[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                constructorParams[i] = constructors[i].getParameterTypes();
                if (params.length == constructorParams[i].length) {
                    potentials[i] = constructors[i];
                    distances[i] = 0;
                    continue;
                }
                potentials[i] = null;
                distances[i] = -1;
            }
            for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
                Class<?> clazz = params[paramIndex];
                for (int conIndex = 0; conIndex < potentials.length; ++conIndex) {
                    if (potentials[conIndex] == null) continue;
                    Class cand = constructorParams[conIndex][paramIndex];
                    int dist = ClassFactory.superDistance(clazz, cand);
                    if (dist >= 0) {
                        int n = conIndex;
                        distances[n] = distances[n] + dist;
                        continue;
                    }
                    potentials[conIndex] = null;
                    distances[conIndex] = -1;
                }
            }
            this.constructor = (Constructor)MetaClass.argmin(potentials, distances, 0);
            if (this.constructor == null) {
                StringBuilder b = new StringBuilder();
                b.append(classname).append("(");
                for (Class<?> c : params) {
                    b.append(c.getName()).append(", ");
                }
                String string = b.substring(0, params.length == 0 ? b.length() : b.length() - 2) + ")";
                throw new ConstructorNotFoundException("No constructor found to match: " + string);
            }
        }

        private ClassFactory(String classname, Class<?> ... params) throws ClassNotFoundException, NoSuchMethodException {
            this.construct(classname, params);
        }

        private ClassFactory(String classname, Object ... params) throws ClassNotFoundException, NoSuchMethodException {
            Class[] classParams = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) {
                    throw new ClassCreationException("Argument " + i + " to class constructor is null");
                }
                classParams[i] = params[i].getClass();
            }
            this.construct(classname, classParams);
        }

        private ClassFactory(String classname, String ... params) throws ClassNotFoundException, NoSuchMethodException {
            Class[] classParams = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classParams[i] = Class.forName(params[i]);
            }
            this.construct(classname, classParams);
        }

        public T createInstance(Object ... params) {
            try {
                boolean accessible = true;
                if (!this.constructor.isAccessible()) {
                    accessible = false;
                    this.constructor.setAccessible(true);
                }
                T rtn = this.constructor.newInstance(params);
                if (!accessible) {
                    this.constructor.setAccessible(false);
                }
                return rtn;
            }
            catch (Exception e) {
                throw new ClassCreationException("MetaClass couldn't create " + this.constructor + " with args " + Arrays.toString(params), e);
            }
        }

        public String getName() {
            return this.cl.getName();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.cl.getName()).append("(");
            for (Class<?> cl : this.classParams) {
                b.append(" ").append(cl.getName()).append(",");
            }
            b.replace(b.length() - 1, b.length(), " ");
            b.append(")");
            return b.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassFactory) {
                ClassFactory other = (ClassFactory)o;
                if (!this.cl.equals(other.cl)) {
                    return false;
                }
                for (int i = 0; i < this.classParams.length; ++i) {
                    if (this.classParams[i].equals(other.classParams[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.cl.hashCode();
        }
    }

    public static final class ConstructorNotFoundException
    extends ClassCreationException {
        private static final long serialVersionUID = -5980065992461870357L;

        private ConstructorNotFoundException() {
        }

        private ConstructorNotFoundException(String msg) {
            super(msg);
        }

        private ConstructorNotFoundException(Throwable cause) {
            super(cause);
        }

        private ConstructorNotFoundException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class ClassCreationException
    extends RuntimeException {
        private static final long serialVersionUID = -5980065992461870357L;

        private ClassCreationException() {
        }

        private ClassCreationException(String msg) {
            super(msg);
        }

        private ClassCreationException(Throwable cause) {
            super(cause);
        }

        private ClassCreationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

