/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.classify;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.RVFClassifier;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Pair;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class NaiveBayesClassifier<L, F>
implements Classifier<L, F>,
RVFClassifier<L, F> {
    private static final long serialVersionUID = 1544820342684024068L;
    private Counter<Pair<Pair<L, F>, Number>> weights;
    private Counter<L> priors;
    private Set<F> features;
    private boolean addZeroValued;
    private Counter<L> priorZero;
    private Set<L> labels;
    private final Integer zero = 0;

    @Override
    public Collection<L> labels() {
        return this.labels;
    }

    @Override
    public L classOf(RVFDatum<L, F> example) {
        Counter scores = this.scoresOf((RVFDatum)example);
        return (L)Counters.argmax(scores);
    }

    @Override
    public ClassicCounter<L> scoresOf(RVFDatum<L, F> example) {
        ClassicCounter<L> scores = new ClassicCounter<L>();
        Counters.addInPlace(scores, this.priors);
        if (this.addZeroValued) {
            Counters.addInPlace(scores, this.priorZero);
        }
        for (L l : this.labels) {
            double score = 0.0;
            Counter<F> features = example.asFeaturesCounter();
            for (F f : features.keySet()) {
                int value = (int)features.getCount(f);
                score += this.weight(l, f, value);
                if (!this.addZeroValued) continue;
                score -= this.weight(l, f, this.zero);
            }
            scores.incrementCount(l, score);
        }
        return scores;
    }

    @Override
    public L classOf(Datum<L, F> example) {
        RVFDatum<L, F> rvf = new RVFDatum<L, F>(example);
        return this.classOf(rvf);
    }

    @Override
    public ClassicCounter<L> scoresOf(Datum<L, F> example) {
        RVFDatum<L, F> rvf = new RVFDatum<L, F>(example);
        return this.scoresOf((RVFDatum)rvf);
    }

    public NaiveBayesClassifier(Counter<Pair<Pair<L, F>, Number>> weights, Counter<L> priors, Set<L> labels, Set<F> features, boolean addZero) {
        this.weights = weights;
        this.features = features;
        this.priors = priors;
        this.labels = labels;
        this.addZeroValued = addZero;
        if (this.addZeroValued) {
            this.initZeros();
        }
    }

    public float accuracy(Iterator<RVFDatum<L, F>> exampleIterator) {
        int correct = 0;
        int total = 0;
        while (exampleIterator.hasNext()) {
            RVFDatum<L, F> next = exampleIterator.next();
            L guess = this.classOf(next);
            if (guess.equals(next.label())) {
                ++correct;
            }
            ++total;
        }
        System.err.println("correct " + correct + " out of " + total);
        return (float)correct / (float)total;
    }

    public void print(PrintStream pw) {
        pw.println("priors ");
        pw.println(this.priors.toString());
        pw.println("weights ");
        pw.println(this.weights.toString());
    }

    public void print() {
        this.print(System.out);
    }

    private double weight(L label, F feature, Number val) {
        Pair<Pair<L, F>, Number> p = new Pair<Pair<L, F>, Number>(new Pair<L, F>(label, feature), val);
        double v = this.weights.getCount(p);
        return v;
    }

    public NaiveBayesClassifier(Counter<Pair<Pair<L, F>, Number>> weights, Counter<L> priors, Set<L> labels) {
        this(weights, priors, labels, null, false);
    }

    private void initZeros() {
        this.priorZero = new ClassicCounter<L>();
        for (L label : this.labels) {
            double score = 0.0;
            for (F feature : this.features) {
                score += this.weight(label, feature, this.zero);
            }
            this.priorZero.setCount(label, score);
        }
    }
}

